/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResTokenTable;

public class Token
extends TResTokenTable {
    public static TokenCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new TokenCursor(dBConnection, hashtable, vector);
    }

    public Token() {
        this.clear();
    }

    public Token(int n, Timestamp timestamp, String string, String string2, String string3, Timestamp timestamp2) {
        this.clear();
        this.m_TokenId = n;
        this.m_Tstamp = timestamp;
        this.m_ResType = string;
        this.m_ResId = string2;
        this.m_UserId = string3;
        this.m_InitialTstamp = timestamp2;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_TokenId != Integer.MIN_VALUE) {
            hashtable.put(Token.getColumnInfo("TOKEN_ID"), String.valueOf(this.m_TokenId));
        }
        if (this.m_Tstamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(Token.getColumnInfo("TSTAMP"), this.m_Tstamp);
        }
        if (this.m_UserId != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Token.getColumnInfo("USER_ID"), this.m_UserId);
        }
        if (this.m_InitialTstamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(Token.getColumnInfo("INITIAL_TSTAMP"), this.m_InitialTstamp);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_ResId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key RES_ID not found");
        }
        this.htColsAndValues.put(Token.getColumnInfo("RES_ID"), this.m_ResId);
        if (this.m_ResType == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key RES_TYPE not found");
        }
        this.htColsAndValues.put(Token.getColumnInfo("RES_TYPE"), this.m_ResType);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_TOKEN", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Token.getColumnInfo("RES_ID")) == null) {
            throw new SQLException(" ERROR: key RES_ID not found");
        }
        if (hashtable.get(Token.getColumnInfo("RES_TYPE")) == null) {
            throw new SQLException(" ERROR: key RES_TYPE not found");
        }
        return DBQueryAssistant.performInsert("T_RES_TOKEN", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_ResId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key RES_ID not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_ID"), this.m_ResId);
        if (this.m_ResType == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key RES_TYPE not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_TYPE"), this.m_ResType);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TOKEN", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Token.getColumnInfo("RES_ID")) == null) {
            throw new SQLException(" ERROR: key RES_ID not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_ID"), hashtable.get(Token.getColumnInfo("RES_ID")));
        if (hashtable.get(Token.getColumnInfo("RES_TYPE")) == null) {
            throw new SQLException(" ERROR: key RES_TYPE not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_TYPE"), hashtable.get(Token.getColumnInfo("RES_TYPE")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TOKEN", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ResId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key RES_ID not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_ID"), this.m_ResId);
        if (this.m_ResType == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key RES_TYPE not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_TYPE"), this.m_ResType);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TOKEN", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Token.getColumnInfo("RES_ID")) == null) {
            throw new SQLException(" ERROR: key RES_ID not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_ID"), hashtable.get(Token.getColumnInfo("RES_ID")));
        if (hashtable.get(Token.getColumnInfo("RES_TYPE")) == null) {
            throw new SQLException(" ERROR: key RES_TYPE not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_TYPE"), hashtable.get(Token.getColumnInfo("RES_TYPE")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TOKEN", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ResId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key RES_ID not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_ID"), this.m_ResId);
        if (this.m_ResType == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key RES_TYPE not found");
        }
        this.htWhereClause.put(Token.getColumnInfo("RES_TYPE"), this.m_ResType);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_TOKEN", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static Token retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        Token token = null;
        if (hashtable.get(Token.getColumnInfo("RES_ID")) == null) {
            throw new SQLException(" ERROR: key RES_ID not found");
        }
        hashtable2.put(Token.getColumnInfo("RES_ID"), hashtable.get(Token.getColumnInfo("RES_ID")));
        if (hashtable.get(Token.getColumnInfo("RES_TYPE")) == null) {
            throw new SQLException(" ERROR: key RES_TYPE not found");
        }
        hashtable2.put(Token.getColumnInfo("RES_TYPE"), hashtable.get(Token.getColumnInfo("RES_TYPE")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_TOKEN", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                token = new Token();
                token.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return token;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_TOKEN", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_TOKEN", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setTokenId(dBResultSet.getInt("TOKEN_ID"));
        this.setTstamp(dBResultSet.getTimestamp("TSTAMP"));
        this.setResType(dBResultSet.getString("RES_TYPE"));
        this.setResId(dBResultSet.getString("RES_ID"));
        this.setUserId(dBResultSet.getString("USER_ID"));
        this.setInitialTstamp(dBResultSet.getTimestamp("INITIAL_TSTAMP"));
    }

    public static class TokenCursor
    extends DBCursor {
        private Token element = new Token();
        private DBConnection con;

        public TokenCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_TOKEN", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public Token getObject() throws SQLException {
            Token token = null;
            if (this.DBrs != null) {
                token = new Token();
                token.setFields(this.con, this.DBrs);
            }
            return token;
        }

        public Token getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

