/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.detectability;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

class InFlightScan {
    private String scanId;
    private String scanType;
    private int scannerClass;
    private int systemId;
    private int systemType = -1;
    private HashSet tableList;
    private boolean inUpdate;
    private Timestamp scanTime;
    private boolean isNew;
    private String processID;
    private static ILogger traceLogger = null;
    private static String className = DetectabilityService.class.getName();
    private static boolean TRACE = false;

    static {
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
    }

    InFlightScan(String string, int n, int n2) {
        String string2 = "InFlightScan";
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " scanner id " + string + " systemId " + n);
        }
        this.scanId = string;
        this.systemId = n;
        this.systemType = n2;
        this.scanType = DetectabilityService.getTypeFromScanId(string);
        this.processID = "x" + string + Long.toString(System.currentTimeMillis());
        this.tableList = new HashSet();
        this.isNew = true;
        this.setLock();
    }

    public boolean isLocked() {
        return this.inUpdate;
    }

    public synchronized void setLock() {
        String string = "setLock";
        this.inUpdate = true;
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, String.valueOf(string) + " setting lock for scanner " + this.scanId);
        }
    }

    public synchronized void resetLock() {
        String string = "resetLock";
        this.inUpdate = false;
        this.isNew = true;
        if (true) {
            this.isNew = false;
        }
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, String.valueOf(string) + " resetting lock for scanner " + this.scanId);
        }
    }

    public int getScannerClass() {
        return this.scannerClass;
    }

    public void setScannerClass(int n) {
        String string = "setScannerClass";
        this.scannerClass = n;
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, String.valueOf(string) + " setting scanner " + n + " for scanner " + this.scanId);
        }
    }

    public String getScanId() {
        return this.scanId;
    }

    public Timestamp getScanTime() {
        return this.scanTime;
    }

    public void setScanTime() throws SQLException {
        String string = "setScanTime";
        DBConnPoolDataSource dBConnPoolDataSource = null;
        DBConnection dBConnection = null;
        try {
            dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
            dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
            this.scanTime = CurrentTime.getTimestamp(dBConnection);
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, String.valueOf(string) + " Connection succeeded - " + dBConnection);
            }
        }
        finally {
            if (dBConnection != null) {
                dBConnection.close();
            }
        }
    }

    public int getScanSystemID() {
        return this.systemId;
    }

    public String getProcessID() {
        return this.processID;
    }

    public void setProcessID(String string) {
        this.processID = string;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void addTable(String string) {
        this.tableList.add(string);
    }

    public void clearTables() {
        this.tableList.clear();
    }

    public HashSet getList() {
        return this.tableList;
    }

    public void replaceList(HashSet hashSet) {
        this.tableList = hashSet;
    }

    public String getScanType() {
        return this.scanType;
    }

    public void setScanType(String string) {
        this.scanType = string;
    }

    public int getSystemType() {
        return this.systemType;
    }
}

