/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.io.InvalidClassException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.aperi.build.DbGenerateClasses;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ClassHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBTable;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService;
import org.eclipse.aperi.infrastructure.mapping.AttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.DataConverter;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class AbstractDBAttributeMapper
extends AttributeMapper
implements IDBAttributeMapper {
    protected Hashtable m_htAttribToMapperInfo;
    protected DataConverter m_dataConverter;
    protected ILogger myLogger = null;
    protected boolean useLogger = true;
    protected String myClassname = "org.eclipse.aperi.infrastructure.mapping.AbstractDBAttributeMapper.java";

    protected void logEntry(String string, String string2, Object[] objectArray) {
        if (this.useLogger && this.myLogger.isLogging()) {
            this.myLogger.entry(IRecordType.TYPE_ENTRY, (Object)string, string2, objectArray);
        } else {
            System.out.println(String.valueOf(string) + "." + string2 + ":  entry");
            int n = 0;
            while (n < objectArray.length) {
                System.out.println("\t" + objectArray[n]);
                ++n;
            }
        }
    }

    protected void logExit(String string, String string2, Object object) {
        if (this.useLogger && this.myLogger.isLogging()) {
            this.myLogger.exit(IRecordType.TYPE_EXIT, (Object)string, string2, object);
        } else {
            System.out.println(String.valueOf(string) + "." + string2 + ":  return code: " + object);
        }
    }

    protected void logWarning(String string, String string2, String string3) {
        if (this.useLogger && this.myLogger.isLogging()) {
            this.myLogger.text(IRecordType.TYPE_WARNING, string, string2, string3);
        } else {
            System.out.println(String.valueOf(string) + "." + string2 + ":  " + string3);
        }
    }

    protected void logException(String string, String string2, Exception exception, String string3) {
        if (this.useLogger && this.myLogger.isLogging()) {
            this.myLogger.exception(IRecordType.TYPE_ERROR_EXC, string, string2, exception, string3);
        } else {
            System.out.println(String.valueOf(string) + "." + string2 + ":  " + string3);
            System.out.println(exception.toString());
        }
    }

    protected void logInfo(String string, String string2, String string3) {
        if (this.useLogger && this.myLogger.isLogging()) {
            this.myLogger.text(IRecordType.TYPE_INFO, string, string2, string3);
        } else {
            System.out.println(String.valueOf(string) + "." + string2 + ":  " + string3);
        }
    }

    public void init() {
        this.m_htAttribToMapperInfo = new Hashtable();
        this.m_dataConverter = new DataConverter();
        this.myClassname = this.getClass().getName();
        if (this.useLogger) {
            this.myLogger = DBConstants.getLogger();
        }
    }

    private void printMapperResultTablesAndColumns(MapperResult mapperResult, String string) {
        Hashtable hashtable = mapperResult.getAllRows();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable2 = (Hashtable)hashtable.get(enumeration.nextElement());
            Enumeration enumeration2 = hashtable2.keys();
            while (enumeration2.hasMoreElements()) {
                ColumnInfo columnInfo = (ColumnInfo)enumeration2.nextElement();
                this.logInfo(this.myClassname, string, "\tTable:" + columnInfo.getTableName() + "\tColumn:" + columnInfo.getName());
            }
        }
    }

    public MapperResult persist(DBConnection dBConnection, IDBAttributeMapper iDBAttributeMapper, Hashtable hashtable, IDBAttributeMapper iDBAttributeMapper2, Hashtable hashtable2, String string) throws SQLException {
        TableAndCols tableAndCols;
        Hashtable hashtable3;
        ColumnInfo columnInfo;
        ColumnInfo columnInfo2;
        Object object;
        String string22;
        Object object2;
        String string3 = "persist(DBConnection conn, AbstractDBAttributeMapper entity1, Hashtable entity1_htValues, AbstractDBAttributeMapper entity2, Hashtable entity2_htValues, String scanID)";
        Object[] objectArray = new Object[]{dBConnection, iDBAttributeMapper, hashtable, iDBAttributeMapper2, hashtable2, string};
        this.logEntry(this.myClassname, string3, objectArray);
        if (dBConnection == null) {
            throw new SQLException("Mapper layer persist function was passed a null object for the DBConnection");
        }
        if (dBConnection.isClosed()) {
            throw new SQLException("Mapper layer persist function was passed a closed DBConnection object.");
        }
        if (dBConnection.isReadOnly()) {
            throw new SQLException("Mapper layer persist function was passed a read-only DBConnection object.");
        }
        MapperResult mapperResult = new MapperResult();
        MapperResult mapperResult2 = iDBAttributeMapper.persist(dBConnection, hashtable, string);
        MapperResult mapperResult3 = iDBAttributeMapper2.persist(dBConnection, hashtable2, string);
        Hashtable hashtable4 = mapperResult2.getAllRows();
        Hashtable hashtable5 = mapperResult3.getAllRows();
        if (hashtable4.isEmpty()) {
            throw new SQLException("Entity mapper, " + iDBAttributeMapper.getClass().getName() + ", did not return any information -- an error scenario.  Relationship information can not be persisted.");
        }
        if (hashtable5.isEmpty()) {
            throw new SQLException("Entity mapper, " + iDBAttributeMapper2.getClass().getName() + ", did not return any information -- an error scenario.  Relationship information can not be persisted.");
        }
        mapperResult.addMapperResult(mapperResult2);
        mapperResult.addMapperResult(mapperResult3);
        this.logInfo(this.myClassname, string3, "Tables referenced by: " + iDBAttributeMapper.getClass().getName());
        this.printMapperResultTablesAndColumns(mapperResult2, string3);
        this.logInfo(this.myClassname, string3, "Tables referenced by: " + iDBAttributeMapper2.getClass().getName());
        this.printMapperResultTablesAndColumns(mapperResult3, string3);
        TreeMap<String, TableAndCols> treeMap = new TreeMap<String, TableAndCols>();
        Hashtable hashtable6 = new Hashtable();
        hashtable6.putAll(hashtable4);
        hashtable6.putAll(hashtable5);
        if (hashtable6.size() == hashtable4.size()) {
            object2 = this.m_htAttribToMapperInfo.keys();
            boolean bl = true;
            while (object2.hasMoreElements()) {
                string22 = (String)object2.nextElement();
                object = (MapperInfo)this.m_htAttribToMapperInfo.get(string22);
                if (object == null) continue;
                columnInfo2 = ((MapperInfo)object).getTargetColInfo();
                columnInfo = columnInfo2.getReferencedColumn();
                hashtable3 = bl ? (Hashtable)hashtable4.get(columnInfo.getTableName()) : (Hashtable)hashtable5.get(columnInfo.getTableName());
                tableAndCols = (TableAndCols)treeMap.get(columnInfo2.getTableName());
                if (tableAndCols == null) {
                    tableAndCols = new TableAndCols(columnInfo2.getTableName(), new Hashtable());
                    treeMap.put(columnInfo2.getTableName(), tableAndCols);
                }
                tableAndCols.put(columnInfo2, hashtable3.get(columnInfo));
                if (((MapperInfo)object).getDerivedColumn() != null) {
                    tableAndCols.put(((MapperInfo)object).getDerivedColumn(), new String("-1"));
                }
                if (columnInfo.isPrimaryKey()) {
                    Hashtable hashtable7;
                    if (bl) {
                        hashtable7 = (Hashtable)hashtable5.get(columnInfo.getTableName());
                        tableAndCols.put(columnInfo, hashtable7.get(columnInfo));
                    } else {
                        hashtable7 = (Hashtable)hashtable4.get(columnInfo.getTableName());
                        tableAndCols.put(columnInfo, hashtable7.get(columnInfo));
                    }
                }
                bl = !bl;
            }
        } else {
            object2 = this.m_htAttribToMapperInfo.keys();
            while (object2.hasMoreElements()) {
                string22 = (String)object2.nextElement();
                MapperInfo mapperInfo = (MapperInfo)this.m_htAttribToMapperInfo.get(string22);
                if (mapperInfo == null) continue;
                columnInfo2 = mapperInfo.getTargetColInfo();
                columnInfo = columnInfo2.getReferencedColumn();
                object = (Hashtable)hashtable4.get(columnInfo.getTableName());
                if (object == null) {
                    hashtable3 = (Hashtable)hashtable5.get(columnInfo.getTableName());
                    if (hashtable3 == null) {
                        return mapperResult;
                    }
                    tableAndCols = (TableAndCols)treeMap.get(columnInfo2.getTableName());
                    if (tableAndCols == null) {
                        tableAndCols = new TableAndCols(columnInfo2.getTableName(), new Hashtable());
                        treeMap.put(columnInfo2.getTableName(), tableAndCols);
                    }
                    tableAndCols.put(columnInfo2, hashtable3.get(columnInfo));
                    if ((columnInfo.isPrimaryKey() || columnInfo.isAutoGenerated()) && columnInfo.getTableName().equals(columnInfo2.getTableName())) {
                        tableAndCols.putPrimaryKey(columnInfo, hashtable3.get(columnInfo));
                    }
                    if (mapperInfo.getDerivedColumn() == null) continue;
                    tableAndCols.put(mapperInfo.getDerivedColumn(), new String("-1"));
                    continue;
                }
                tableAndCols = (TableAndCols)treeMap.get(columnInfo2.getTableName());
                if (tableAndCols == null) {
                    tableAndCols = new TableAndCols(columnInfo2.getTableName(), new Hashtable());
                    treeMap.put(columnInfo2.getTableName(), tableAndCols);
                }
                tableAndCols.put(columnInfo2, ((Hashtable)object).get(columnInfo));
                if ((columnInfo.isPrimaryKey() || columnInfo.isAutoGenerated()) && columnInfo.getTableName().equals(columnInfo2.getTableName())) {
                    tableAndCols.putPrimaryKey(columnInfo, ((Hashtable)object).get(columnInfo));
                }
                if (mapperInfo.getDerivedColumn() == null) continue;
                tableAndCols.put(mapperInfo.getDerivedColumn(), new String("-1"));
            }
        }
        for (String string22 : treeMap.keySet()) {
            TableAndCols tableAndCols2 = (TableAndCols)treeMap.get(string22);
            object = tableAndCols2.getDBHelper();
            if (tableAndCols2.getPrimaryKeys().size() > 0) {
                boolean bl;
                block25: {
                    bl = false;
                    try {
                        bl = ((DBTable)object).retrieve(dBConnection);
                    }
                    catch (SQLException sQLException) {
                        this.logInfo(this.myClassname, string3, "Unable to find existing row for helper, " + object.getClass().getName() + ", exception was: " + sQLException.getMessage() + ".");
                        if (!SQLExceptionHelper.isDeadlock(dBConnection, sQLException)) break block25;
                        this.logInfo(this.myClassname, string3, "Above exception was a deadlock exception, throwing back to caller to handle as appropriate.");
                        throw sQLException;
                    }
                }
                if (bl) {
                    this.performUpdate(tableAndCols2, mapperResult, dBConnection, string);
                    return mapperResult;
                }
                this.logInfo(this.myClassname, string3, "Unable to find existing row for helper, " + object.getClass().getName() + ".  Will attempt an insert.");
            }
            this.performInsert(tableAndCols2, mapperResult, dBConnection, string);
        }
        this.logExit(this.myClassname, string3, mapperResult);
        return mapperResult;
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        return this.persist(dBConnection, this.m_htAttribToMapperInfo, hashtable, string);
    }

    private void performSEPhase1(Hashtable hashtable, TreeMap treeMap, Hashtable hashtable2) {
        String string = "performSEPhase1(Hashtable htValues, TreeMap distinctTables, Hashtable htAttribToMapInfo)";
        Object[] objectArray = new Object[]{hashtable, treeMap, hashtable2};
        this.logEntry(this.myClassname, string, objectArray);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = string2.toLowerCase();
            MapperInfo mapperInfo = this.getMapperInfo(hashtable2, string3);
            if (mapperInfo == null) continue;
            TableAndCols tableAndCols = (TableAndCols)treeMap.get(mapperInfo.getTargetColInfo().getTableName());
            if (tableAndCols == null) {
                tableAndCols = new TableAndCols(mapperInfo.getTargetColInfo().getTableName(), new Hashtable());
                treeMap.put(mapperInfo.getTargetColInfo().getTableName(), tableAndCols);
            }
            tableAndCols.put(mapperInfo.getTargetColInfo(), hashtable.get(string2));
            if (mapperInfo.getDerivedColumn() != null) {
                tableAndCols.put(mapperInfo.getDerivedColumn(), new String("-1"));
            }
            if (!mapperInfo.getTargetColInfo().getForeignKeyConstraint() || mapperInfo.getForeignKeyColInfo() == null) continue;
            ColumnInfo[] columnInfoArray = mapperInfo.getForeignKeyColInfo();
            int n = 0;
            while (n < columnInfoArray.length) {
                TableAndCols tableAndCols2 = (TableAndCols)treeMap.get(columnInfoArray[n].getTableName());
                if (mapperInfo.getDerivedColumn() != null) {
                    columnInfoArray[n].setReferencedColumn(mapperInfo.getDerivedColumn());
                } else {
                    columnInfoArray[n].setReferencedColumn(mapperInfo.getTargetColInfo());
                }
                if (tableAndCols2 == null) {
                    tableAndCols2 = new TableAndCols(columnInfoArray[n].getTableName(), new Hashtable());
                    treeMap.put(tableAndCols2.getTableName(), tableAndCols2);
                }
                if (tableAndCols.getDependentTables().get(tableAndCols2.getTableName()) == null) {
                    tableAndCols2.setIsDependentTable(true);
                    tableAndCols.getDependentTables().put(tableAndCols2.getTableName(), tableAndCols2);
                }
                tableAndCols2.put(columnInfoArray[n], new String("-1"));
                ++n;
            }
        }
        this.logExit(this.myClassname, string, null);
    }

    private void performSEPhase2(TreeMap treeMap, MapperResult mapperResult, String string, DBConnection dBConnection) throws SQLException {
        String string2 = "performSEPhase2(TreeMap distinctTables, MapperResult mr, String scanID, DBConnection conn)";
        Object[] objectArray = new Object[]{treeMap, mapperResult, string, dBConnection};
        this.logEntry(this.myClassname, string2, objectArray);
        for (String string3 : treeMap.keySet()) {
            Object object;
            TableAndCols tableAndCols = (TableAndCols)treeMap.get(string3);
            if (tableAndCols.isDependentTable()) continue;
            int n = -1;
            if (tableAndCols.getPrimaryKeys().size() > 0) {
                boolean bl;
                block14: {
                    object = tableAndCols.getDBHelper();
                    bl = false;
                    try {
                        bl = ((DBTable)object).retrieve(dBConnection);
                    }
                    catch (SQLException sQLException) {
                        this.logInfo(this.myClassname, string2, "Unable to find existing row for helper, " + object.getClass().getName() + ", exception was: " + sQLException.getMessage() + ".");
                        if (!SQLExceptionHelper.isDeadlock(dBConnection, sQLException)) break block14;
                        this.logInfo(this.myClassname, string2, "Above exception was a deadlock exception, throwing back to caller to handle as appropriate.");
                        throw sQLException;
                    }
                }
                if (bl) {
                    n = this.performUpdate(tableAndCols, mapperResult, dBConnection, string);
                } else {
                    this.logInfo(this.myClassname, string2, "Unable to find existing row for helper, " + object.getClass().getName() + ".  Will attempt an insert.");
                }
            }
            if (n <= 0) {
                try {
                    this.performInsert(tableAndCols, mapperResult, dBConnection, string);
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == -803) {
                        this.logWarning(this.myClassname, string2, "Get a dublicate row exception inserting new row into " + tableAndCols.getTableName() + ".  Will attempt an update instead of insert.");
                        n = this.performUpdate(tableAndCols, mapperResult, dBConnection, string);
                    }
                    throw sQLException;
                }
            }
            if ((object = tableAndCols.getDependentTables()) == null || ((Hashtable)object).size() <= 0) continue;
            for (String string4 : ((Hashtable)object).keySet()) {
                boolean bl;
                Object object22;
                Vector<Object> vector = new Vector<Object>();
                Vector<ColumnInfo> vector2 = new Vector<ColumnInfo>();
                TableAndCols tableAndCols2 = (TableAndCols)((Hashtable)object).get(string4);
                Hashtable hashtable = tableAndCols2.getAllColsAndValues();
                for (Object object22 : hashtable.keySet()) {
                    if (((ColumnInfo)object22).getReferencedColumn() == null || !((ColumnInfo)object22).getReferencedColumn().getTableName().equals(string3)) continue;
                    if (n <= 0 && ((ColumnInfo)object22).getReferencedColumn().isAutoGenerated()) {
                        Object object3 = tableAndCols.get(((ColumnInfo)object22).getReferencedColumn());
                        if (object3 == null) continue;
                        tableAndCols2.put((ColumnInfo)object22, object3.toString());
                        continue;
                    }
                    vector.add(object22);
                    vector2.add(((ColumnInfo)object22).getReferencedColumn());
                }
                if (vector.size() <= 0 || !(bl = ((DBTable)(object22 = tableAndCols.getDBHelper())).retrieve(dBConnection))) continue;
                int n2 = 0;
                while (n2 < vector2.size()) {
                    ColumnInfo columnInfo = (ColumnInfo)vector2.elementAt(n2);
                    ColumnInfo columnInfo2 = (ColumnInfo)vector.elementAt(n2);
                    tableAndCols2.put(columnInfo2, tableAndCols.get(columnInfo).toString());
                    ++n2;
                }
            }
        }
        this.logExit(this.myClassname, string2, mapperResult);
    }

    private void performSEPhase3(TreeMap treeMap, MapperResult mapperResult, String string, DBConnection dBConnection) throws SQLException {
        String string2 = "performSEPhase3(TreeMap distinctTables, MapperResult mr, String scanID, DBConnection conn)";
        Object[] objectArray = new Object[]{treeMap, mapperResult, string, dBConnection};
        this.logEntry(this.myClassname, string2, objectArray);
        for (String string3 : treeMap.keySet()) {
            TableAndCols tableAndCols = (TableAndCols)treeMap.get(string3);
            if (!tableAndCols.isDependentTable()) continue;
            int n = -1;
            if (tableAndCols.getPrimaryKeys().size() > 0) {
                DBTable dBTable = tableAndCols.getDBHelper();
                boolean bl = dBTable.retrieve(dBConnection);
                if (bl) {
                    n = this.performUpdate(tableAndCols, mapperResult, dBConnection, string);
                } else {
                    this.logInfo(this.myClassname, string2, "Unable to find existing row for helper, " + dBTable.getClass().getName() + ".  Will attempt an insert.");
                }
            }
            if (n > 0) continue;
            try {
                this.performInsert(tableAndCols, mapperResult, dBConnection, string);
            }
            catch (SQLException sQLException) {
                this.logException(this.myClassname, string2, sQLException, "Thrown by performInsert for table: " + string3);
            }
        }
        this.logExit(this.myClassname, string2, mapperResult);
    }

    protected MapperResult persist(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2, String string) throws SQLException {
        String string2 = "persist(DBConnection conn, Hashtable htAttribToMapInfo, Hashtable htValues, String scanID)";
        Object[] objectArray = new Object[]{dBConnection, hashtable, hashtable2, string};
        this.logEntry(this.myClassname, string2, objectArray);
        if (dBConnection == null) {
            throw new SQLException("Mapper layer persist function was passed a null object for the DBConnection");
        }
        if (dBConnection.isClosed()) {
            throw new SQLException("Mapper layer persist function was passed a closed DBConnection object.");
        }
        if (dBConnection.isReadOnly()) {
            throw new SQLException("Mapper layer persist function was passed a read-only DBConnection object.");
        }
        this.m_dataConverter.performDataConversion(hashtable2);
        if (hashtable2.isEmpty()) {
            throw new SQLException("After performing data conversion, there was no information for the " + this.myClassname + " to persist!");
        }
        MapperResult mapperResult = new MapperResult();
        TreeMap treeMap = new TreeMap();
        this.performSEPhase1(hashtable2, treeMap, hashtable);
        this.performSEPhase2(treeMap, mapperResult, string, dBConnection);
        this.performSEPhase3(treeMap, mapperResult, string, dBConnection);
        this.logExit(this.myClassname, string2, mapperResult);
        return mapperResult;
    }

    private int performUpdate(TableAndCols tableAndCols, MapperResult mapperResult, DBConnection dBConnection, String string) throws SQLException {
        String string2 = "performUpdate( TableAndCols target, MapperResult mr, DBConnection conn, String scanID )";
        Object[] objectArray = new Object[]{tableAndCols, mapperResult, dBConnection, string};
        this.logEntry(this.myClassname, string2, objectArray);
        DBTable dBTable = tableAndCols.getDBHelper();
        Hashtable hashtable = tableAndCols.getNonAutoGeneratedColsAndValues();
        this.addDetectable(dBTable, hashtable);
        this.addUpdateTimestamp(dBTable, hashtable, this.getCurrentTime(dBConnection));
        int n = dBTable.update(dBConnection, hashtable);
        Hashtable hashtable2 = tableAndCols.getAllColsAndValues();
        for (ColumnInfo columnInfo : hashtable2.keySet()) {
            short s;
            String string3;
            if (columnInfo.isAutoGenerated()) {
                string3 = tableAndCols.get(columnInfo).toString();
                tableAndCols.put(columnInfo, string3);
                continue;
            }
            if (columnInfo.getDataType() != 5) continue;
            if (columnInfo.getName().equals("SYSTEM_CREATION_CLASS_NAME_ID")) {
                string3 = hashtable2.get(columnInfo).toString();
                s = Normalizer.SystemCreationClassNameGetID(dBConnection, string3);
                if (s <= 0) continue;
                tableAndCols.put(columnInfo, String.valueOf(s));
                continue;
            }
            if (columnInfo.getName().equals("CREATION_CLASS_NAME_ID")) {
                string3 = hashtable2.get(columnInfo).toString();
                s = Normalizer.CreationClassNameGetID(dBConnection, string3);
                if (s <= 0) continue;
                tableAndCols.put(columnInfo, String.valueOf(s));
                continue;
            }
            if (columnInfo.getName().equals("CLASS_NAME_ID")) {
                string3 = hashtable2.get(columnInfo).toString();
                s = Normalizer.ClassNameGetID(dBConnection, string3);
                if (s <= 0) continue;
                tableAndCols.put(columnInfo, String.valueOf(s));
                continue;
            }
            if (columnInfo.getName().equals("SYSTEM_NAMES_ID")) {
                string3 = hashtable2.get(columnInfo).toString();
                s = Normalizer.SystemNamesGetID(dBConnection, string3);
                if (s <= 0) continue;
                tableAndCols.put(columnInfo, String.valueOf(s));
                continue;
            }
            if (columnInfo.getName().equals("VENDOR_ID")) {
                string3 = hashtable2.get(columnInfo).toString();
                s = Normalizer.VendorGetID(dBConnection, string3);
                if (s <= 0) continue;
                tableAndCols.put(columnInfo, String.valueOf(s));
                continue;
            }
            if (!columnInfo.getName().equals("MODEL_ID") || (s = Normalizer.ModelGetID(dBConnection, string3 = hashtable2.get(columnInfo).toString())) <= 0) continue;
            tableAndCols.put(columnInfo, String.valueOf(s));
        }
        if (n > 0) {
            mapperResult.addUpdatedRow(tableAndCols.getTableName(), tableAndCols.getAllColsAndValues());
        } else {
            mapperResult.addNonModifiedRow(tableAndCols.getTableName(), tableAndCols.getAllColsAndValues());
            n = 1;
        }
        dBConnection.commit();
        try {
            DetectabilityService.tableUpdated(string, tableAndCols.getTableName(), tableAndCols.getAutoGeneratedColsAndValues());
        }
        catch (Exception exception) {
            this.logException(this.myClassname, string2, exception, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
        }
        this.logExit(this.myClassname, string2, new Integer(n));
        return n;
    }

    private void performInsert(TableAndCols tableAndCols, MapperResult mapperResult, DBConnection dBConnection, String string) throws SQLException {
        Object object2;
        String string2 = "performInsert( TableAndCols target, MapperResult mr, DBConnection conn, String scanID )";
        Object[] objectArray = new Object[]{tableAndCols, mapperResult, dBConnection, string};
        this.logEntry(this.myClassname, string2, objectArray);
        Vector<Object> vector = new Vector<Object>();
        if (tableAndCols.getAllColsAndValues().size() > 0) {
            Hashtable hashtable = tableAndCols.getAllColsAndValues();
            for (Object object2 : hashtable.keySet()) {
                if (!((ColumnInfo)object2).isAutoGenerated()) continue;
                vector.add(object2);
            }
        }
        int n = -1;
        if (vector.size() > 0) {
            n = AutoIdentifier.getIdentifier(1, vector.size());
            int n2 = 0;
            while (n2 < vector.size()) {
                object2 = (ColumnInfo)vector.get(n2);
                tableAndCols.put((ColumnInfo)object2, String.valueOf(n++));
                ++n2;
            }
        }
        DBTable dBTable = tableAndCols.getDBHelper();
        object2 = tableAndCols.getAllColsAndValues();
        this.addDetectable(dBTable, (Hashtable)object2);
        Timestamp timestamp = this.getCurrentTime(dBConnection);
        this.addUpdateTimestamp(dBTable, (Hashtable)object2, timestamp);
        this.addDiscoveredTimestamp(dBTable, (Hashtable)object2, timestamp);
        for (ColumnInfo columnInfo : ((Hashtable)object2).keySet()) {
            String string3 = ((Hashtable)object2).get(columnInfo).toString();
            this.logInfo(this.myClassname, string2, "key=" + columnInfo.getName() + " value=" + string3);
        }
        dBTable.insert(dBConnection, (Hashtable)object2);
        dBConnection.commit();
        try {
            DetectabilityService.tableUpdated(string, tableAndCols.getTableName(), tableAndCols.getAutoGeneratedColsAndValues());
        }
        catch (Exception exception) {
            this.logException(this.myClassname, string2, exception, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
        }
        mapperResult.addInsertedRow(tableAndCols.getTableName(), tableAndCols.getAllColsAndValues());
        this.logExit(this.myClassname, string2, new Boolean(true));
    }

    private boolean addDetectable(DBTable dBTable, Hashtable hashtable) {
        Object[] objectArray = null;
        Method method = null;
        ColumnInfo columnInfo = null;
        try {
            Class[] classArray = new Class[]{String.class};
            method = dBTable.getClass().getMethod("getColumnInfo", classArray);
            objectArray = new Object[method.getParameterTypes().length];
            objectArray[0] = new String("DETECTABLE");
            columnInfo = (ColumnInfo)method.invoke((Object)dBTable, objectArray);
        }
        catch (Exception exception) {
            return false;
        }
        if (columnInfo == null) {
            return false;
        }
        hashtable.put(columnInfo, "1");
        return true;
    }

    private Timestamp getCurrentTime(DBConnection dBConnection) throws SQLException {
        return CurrentTime.getTimestamp(dBConnection);
    }

    private boolean addUpdateTimestamp(DBTable dBTable, Hashtable hashtable, Timestamp timestamp) throws SQLException {
        Object[] objectArray = null;
        Method method = null;
        ColumnInfo columnInfo = null;
        try {
            Class[] classArray = new Class[]{String.class};
            method = dBTable.getClass().getMethod("getColumnInfo", classArray);
            objectArray = new Object[method.getParameterTypes().length];
            objectArray[0] = new String("UPDATE_TIMESTAMP");
            columnInfo = (ColumnInfo)method.invoke((Object)dBTable, objectArray);
        }
        catch (Exception exception) {
            return false;
        }
        if (columnInfo == null) {
            return false;
        }
        hashtable.put(columnInfo, timestamp);
        return true;
    }

    private boolean addDiscoveredTimestamp(DBTable dBTable, Hashtable hashtable, Timestamp timestamp) throws SQLException {
        Object[] objectArray = null;
        Method method = null;
        ColumnInfo columnInfo = null;
        try {
            Class[] classArray = new Class[]{String.class};
            method = dBTable.getClass().getMethod("getColumnInfo", classArray);
            objectArray = new Object[method.getParameterTypes().length];
            objectArray[0] = new String("DISCOVERED_TIME");
            columnInfo = (ColumnInfo)method.invoke((Object)dBTable, objectArray);
        }
        catch (Exception exception) {
            return false;
        }
        if (columnInfo == null) {
            return false;
        }
        hashtable.put(columnInfo, timestamp);
        return true;
    }

    public static abstract class AbstractRegistrationData {
        protected String mName;

        public abstract CapabilityHandler getCapabilityHandler();

        public String getName() {
            return this.mName;
        }
    }

    public static abstract class CapabilityHandler {
        public abstract boolean registerMapper(Class var1) throws InvalidClassException, IllegalArgumentException;

        public abstract Class findBestMatch(String var1, Map var2);
    }

    class TableAndCols {
        String m_tableName;
        DBTable m_dbHelper;
        Hashtable m_colsAndValues;
        Hashtable m_primaryKeyColsAndValues;
        Hashtable m_derivedCols;
        Hashtable m_nonAutoGeneratedKeys;
        Hashtable m_allKvPairs;
        boolean m_isDependentTable;
        Hashtable m_depTables;

        public TableAndCols(String string, Hashtable hashtable) {
            this.m_tableName = string;
            this.m_colsAndValues = hashtable;
            this.m_allKvPairs = new Hashtable();
            this.m_depTables = new Hashtable();
            this.m_primaryKeyColsAndValues = new Hashtable();
            this.m_derivedCols = new Hashtable();
            this.m_nonAutoGeneratedKeys = new Hashtable();
            this.m_isDependentTable = false;
            this.m_dbHelper = ClassHelper.getObject(string);
        }

        public String getTableName() {
            return this.m_tableName;
        }

        public DBTable getDBHelper() {
            return this.m_dbHelper;
        }

        public boolean isDependentTable() {
            return this.m_isDependentTable;
        }

        public void setIsDependentTable(boolean bl) {
            this.m_isDependentTable = bl;
        }

        public void addDependentTable(TableAndCols tableAndCols) {
            this.m_depTables.put(tableAndCols.getTableName(), tableAndCols);
        }

        public Hashtable getDependentTables() {
            return this.m_depTables;
        }

        public Hashtable getTargetColsAndValues() {
            return this.m_colsAndValues;
        }

        public Hashtable getPrimaryKeys() {
            return this.m_primaryKeyColsAndValues;
        }

        public Hashtable getNonAutoGeneratedColsAndValues() {
            return this.m_nonAutoGeneratedKeys;
        }

        public Hashtable getAutoGeneratedColsAndValues() {
            return this.m_derivedCols;
        }

        public Hashtable getAllColsAndValues() {
            return this.m_allKvPairs;
        }

        public Object get(ColumnInfo columnInfo) {
            try {
                Method method = this.getMethod("get", DbGenerateClasses.columnNameToMemberName(columnInfo.getName()), columnInfo, new Class[0]);
                return method.invoke((Object)this.m_dbHelper, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {}
            return null;
        }

        public void putPrimaryKey(ColumnInfo columnInfo, Object object) {
            this.m_allKvPairs.put(columnInfo, object.toString());
            this.m_primaryKeyColsAndValues.put(columnInfo, object);
            if (columnInfo.isAutoGenerated()) {
                this.m_derivedCols.put(columnInfo, object);
            }
        }

        public void put(ColumnInfo columnInfo, Object object) {
            this.m_allKvPairs.put(columnInfo, object.toString());
            if (columnInfo.isPrimaryKey()) {
                this.m_primaryKeyColsAndValues.put(columnInfo, object);
                this.m_nonAutoGeneratedKeys.put(columnInfo, object);
            } else if (columnInfo.isAutoGenerated()) {
                this.m_derivedCols.put(columnInfo, object);
            } else {
                this.m_colsAndValues.put(columnInfo, object);
                this.m_nonAutoGeneratedKeys.put(columnInfo, object);
            }
            this.setHelperValue(columnInfo, object);
        }

        private Method getMethod(String string, String string2, ColumnInfo columnInfo, Class[] classArray) throws NoSuchMethodException {
            String string3 = new String(String.valueOf(string) + string2);
            Class<?> clazz = this.m_dbHelper.getClass();
            Method method = null;
            try {
                method = clazz.getDeclaredMethod(string3, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = clazz.getSuperclass().getDeclaredMethod(string3, classArray);
            }
            return method;
        }

        private void setHelperValue(ColumnInfo columnInfo, Object object) {
            String string = String.valueOf(AbstractDBAttributeMapper.this.myClassname) + ".TableAndCols";
            String string2 = "setHelperValue(ColumnInfo c, Object val)";
            String string3 = DbGenerateClasses.columnNameToMemberName(columnInfo.getName());
            try {
                Object object2;
                Class[] classArray = new Class[]{object.getClass()};
                Object[] objectArray = new Object[]{object};
                switch (columnInfo.getDataType()) {
                    case -1: 
                    case 1: 
                    case 12: {
                        objectArray[0] = object.toString();
                        classArray[0] = String.class;
                        break;
                    }
                    case 3: {
                        objectArray[0] = new Double((String)object);
                        classArray[0] = Double.TYPE;
                        break;
                    }
                    case 8: {
                        objectArray[0] = new Double((String)object);
                        classArray[0] = Double.TYPE;
                        break;
                    }
                    case 6: {
                        objectArray[0] = new Float((String)object);
                        classArray[0] = Float.TYPE;
                        break;
                    }
                    case 4: {
                        try {
                            objectArray[0] = new Integer((String)object);
                        }
                        catch (ClassCastException classCastException) {
                            objectArray[0] = object;
                        }
                        classArray[0] = Integer.TYPE;
                        break;
                    }
                    case 2: {
                        AbstractDBAttributeMapper.this.logWarning(string, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + columnInfo.getName() + " which is of unsupported type Numeric.");
                        break;
                    }
                    case 7: {
                        objectArray[0] = new Float((String)object);
                        classArray[0] = Float.TYPE;
                        break;
                    }
                    case 5: {
                        classArray[0] = Short.TYPE;
                        if (!(object instanceof String)) break;
                        try {
                            objectArray[0] = new Short((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (string3.endsWith("SystemNamesId") || string3.endsWith("CreationClassNameId") || string3.endsWith("ClassNameId") || string3.endsWith("SystemCreationClassNameId") || string3.endsWith("VendorId") || string3.endsWith("ModelId")) {
                                string3 = string3.substring(0, string3.length() - 2);
                                classArray[0] = String.class;
                                break;
                            }
                            AbstractDBAttributeMapper.this.logInfo(string, string2, "Attempt to set a field, " + string3 + ", of type SHORT with a string value not representing a short, will try to find a normalizing function in helper class.");
                            if (!string3.endsWith("Id")) break;
                            string3 = string3.substring(0, string3.length() - 2);
                            classArray[0] = String.class;
                        }
                        break;
                    }
                    case 16: {
                        object2 = (String)object;
                        short s = ((String)object2).equalsIgnoreCase("true") ? (short)1 : 0;
                        objectArray[0] = new Short(s);
                        classArray[0] = Short.TYPE;
                        break;
                    }
                    case -6: {
                        AbstractDBAttributeMapper.this.logWarning(string, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + columnInfo.getName() + " which is of unsupported type TINYINT.");
                        break;
                    }
                    case 93: {
                        objectArray[0] = Timestamp.valueOf((String)object);
                        classArray[0] = Timestamp.class;
                        break;
                    }
                    case 2003: {
                        AbstractDBAttributeMapper.this.logWarning(string, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + columnInfo.getName() + " which is of unsupported type ARRAY.");
                        break;
                    }
                    case 2005: {
                        AbstractDBAttributeMapper.this.logWarning(string, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + columnInfo.getName() + " which is of unsupported type CLOB.");
                        break;
                    }
                    case 2004: {
                        AbstractDBAttributeMapper.this.logWarning(string, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + columnInfo.getName() + " which is of unsupported type BLOB.");
                        break;
                    }
                    case -7: {
                        AbstractDBAttributeMapper.this.logWarning(string, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + columnInfo.getName() + " which is of unsupported type BIT.");
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        objectArray[0] = object.toString().getBytes();
                        classArray[0] = byte[].class;
                        break;
                    }
                    case 70: {
                        AbstractDBAttributeMapper.this.logWarning(string, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + columnInfo.getName() + " which is of unsupported type DATALINK.");
                        break;
                    }
                    case 91: 
                    case 92: {
                        objectArray[0] = object;
                        break;
                    }
                    case -5: {
                        if (object instanceof BigInteger) {
                            objectArray[0] = new BigInteger((String)object);
                            classArray[0] = BigInteger.class;
                            break;
                        }
                        if (object instanceof Long) {
                            objectArray[0] = new Long((String)object);
                            classArray[0] = Long.TYPE;
                            break;
                        }
                        if (object instanceof String) {
                            objectArray[0] = new Long((String)object);
                            classArray[0] = Long.TYPE;
                            break;
                        }
                        AbstractDBAttributeMapper.this.logWarning(string, string2, "Unable to convert " + object.getClass() + " to a Java long.");
                        break;
                    }
                    default: {
                        AbstractDBAttributeMapper.this.logWarning(string, string2, "Warning: Attempt to set value for column: " + columnInfo.getName() + " which is of an unknown type: " + columnInfo.getDataType());
                    }
                }
                object2 = this.getMethod("set", string3, columnInfo, classArray);
                ((Method)object2).invoke((Object)this.m_dbHelper, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                AbstractDBAttributeMapper.this.logException(string, string2, noSuchMethodException, "Could not find set method for column, " + columnInfo.getName() + ", and member, " + string3 + " in helper: " + this.m_dbHelper.getClass().getSuperclass().getName());
            }
            catch (InvocationTargetException invocationTargetException) {
                AbstractDBAttributeMapper.this.logException(string, string2, invocationTargetException, "");
            }
            catch (IllegalAccessException illegalAccessException) {
                AbstractDBAttributeMapper.this.logException(string, string2, illegalAccessException, "");
            }
            catch (NumberFormatException numberFormatException) {
                AbstractDBAttributeMapper.this.logException(string, string2, numberFormatException, "Number Format exception on " + object + " and field " + columnInfo.getName());
            }
        }
    }
}

