/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.report.bulk;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.aperi.util.SRMCrypto;

public class BulkDefinitions {
    public static final String NAME = "name";
    public static final String PATH = "path";
    public static final String TITLE = "title";
    public static final String ROLES = "roles";
    public static final String DESCRIPTION = "description";
    public static final String CREATOR = "creator";
    public static final String CREATION_DATE = "creation_date";
    public static final String EDITOR = "editor";
    public static final String EDIT_DATE = "edit_date";
    public static final int BUFFER_SIZE = 4096;
    public static byte[] data = new byte[4096];
    public static final String QUERY_BY_NAME = "SELECT NAME, PATH, TITLE, ROLES, DESCRIPTION, CREATOR, CREATION_DATE, EDITOR, EDIT_DATE from T_BIRT_DESCR where NAME=? and PATH=?";
    public static final String INSERT_REPORT = "INSERT into T_BIRT_DESCR (NAME, PATH, TITLE, ROLES, DESCRIPTION, CREATOR, CREATION_DATE, EDITOR, EDIT_DATE) values (?,?,?,?,?,?,?,?,?)";
    public static final String DELETE_REPORTS = "DELETE FROM T_BIRT_DESCR";
    public static final String DIR_FILTER = "documents";
    public static final String FILE_FILTER = ".*\\.rptdesign";
    public static String repository;
    public static String zip;
    public static String jdbcDriver;
    public static String jdbcUrl;
    public static String jdbcUser;
    public static String jdbcPassword;
    public static int reportsProcessed;
    public static int bytesProcessed;

    static {
        reportsProcessed = 0;
        bytesProcessed = 0;
    }

    public static void processArgs(String string, String[] stringArray) throws Exception {
        System.out.println("Aperi Bulk Report Processor: " + string);
        repository = stringArray[0];
        System.out.println("repository directory = " + repository);
        zip = stringArray[1];
        System.out.println("zip file             = " + zip);
        jdbcDriver = stringArray[2];
        System.out.println("jdbcDriver           = " + jdbcDriver);
        jdbcUrl = stringArray[3];
        System.out.println("jdbcUrl              = " + jdbcUrl);
        jdbcUser = stringArray[4];
        System.out.println("jdbcUser             = " + jdbcUser);
        jdbcPassword = SRMCrypto.decrypt(stringArray[5]);
    }

    public static void postProcessing() {
        System.out.println("Processed " + reportsProcessed + " reports summing to approximately " + bytesProcessed + " bytes");
    }

    public static void setSchema(String string, Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string2 = databaseMetaData.getDatabaseProductName();
        Statement statement = connection.createStatement();
        if (string2.startsWith("DB2")) {
            statement.executeUpdate("set current schema = " + string);
            statement.close();
        } else if (string2.startsWith("Oracle")) {
            statement.executeUpdate("alter session set current_schema=" + string);
            statement.close();
        }
    }
}

