/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.data;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.objects.AuthRoles;
import org.eclipse.aperi.sanmgmt.middleware.data.GroupData;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleData;

public final class Roles {
    private static Roles instance;
    private static boolean passthrough;
    private static Hashtable roleMap;
    private static Hashtable baseMap;
    public static final int INVALID_USER = -1;
    public static final int INVALID_PASSWORD = -2;
    private static String UPDATE_BY_ROLE_ID;
    private static String INSERT_BY_ROLE_ID;
    private static String DELETE_BY_ROLE_ID;
    public static final int API_ERROR = -2;
    public static final int RIGHTS_ALREADY_ENABLED = 0;
    public static final int RIGHTS_NOT_ENABLED = 1;
    public static final int SUCCESS = 2;
    public static final String SE_SERVICE_LOGON_NAME = "SeServiceLogonRight";

    static {
        try {
            System.loadLibrary("Common");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            System.out.println(unsatisfiedLinkError.getMessage());
            unsatisfiedLinkError.printStackTrace(System.out);
        }
        instance = null;
        passthrough = false;
        if (System.getProperty("tpc.roles.check.passthrough") != null) {
            passthrough = true;
        }
        roleMap = new Hashtable();
        baseMap = new Hashtable();
        baseMap.put(new Integer(RoleChecker.SUPERUSER), new RoleData(RoleChecker.SUPERUSER, null));
        baseMap.put(new Integer(RoleChecker.APERI_ADMIN), new RoleData(RoleChecker.APERI_ADMIN, null));
        baseMap.put(new Integer(RoleChecker.DISK_ADMIN), new RoleData(RoleChecker.DISK_ADMIN, null));
        baseMap.put(new Integer(RoleChecker.DISK_VIEWER), new RoleData(RoleChecker.DISK_VIEWER, null));
        baseMap.put(new Integer(RoleChecker.FABRIC_ADMIN), new RoleData(RoleChecker.FABRIC_ADMIN, null));
        baseMap.put(new Integer(RoleChecker.FABRIC_VIEWER), new RoleData(RoleChecker.FABRIC_VIEWER, null));
        baseMap.put(new Integer(RoleChecker.DATA_ADMIN), new RoleData(RoleChecker.DATA_ADMIN, null));
        baseMap.put(new Integer(RoleChecker.DATA_VIEWER), new RoleData(RoleChecker.DATA_VIEWER, null));
        baseMap.put(new Integer(RoleChecker.TAPE_ADMIN), new RoleData(RoleChecker.TAPE_ADMIN, null));
        baseMap.put(new Integer(RoleChecker.TAPE_VIEWER), new RoleData(RoleChecker.TAPE_VIEWER, null));
        UPDATE_BY_ROLE_ID = "UPDATE t_res_auth_roles SET role_name=?, group_name=?, group_type=? where role_id=?";
        INSERT_BY_ROLE_ID = "INSERT into t_res_auth_roles (role_name, group_name, group_type, role_id) values (?,?,?,?)";
        DELETE_BY_ROLE_ID = "DELETE from t_res_auth_roles where role_id=?";
    }

    private static native int isValidUser(String var0, String var1, boolean var2);

    private static native boolean isGroupMember(String var0, String var1, int var2);

    private static native boolean isValidGroup(String var0, int var1);

    private static native int getGroupType(String var0);

    private static native int checkAccountRights(String var0, String[] var1, boolean var2);

    private static native String localAdminGroup();

    private static native String retrieveNativeLog();

    private Roles() {
    }

    public static Roles getInstance() throws SQLException {
        if (instance == null) {
            try {
                instance = new Roles();
                Roles.refresh();
            }
            catch (SQLException sQLException) {
                instance = null;
                throw sQLException;
            }
        }
        return instance;
    }

    public static boolean getPassthrough() {
        return passthrough;
    }

    public static void refresh() throws SQLException {
        DBConnection dBConnection = null;
        DBCursor dBCursor = null;
        try {
            DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
            dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
            roleMap.clear();
            dBCursor = AuthRoles.getCursor(dBConnection, null, null);
            if (dBCursor != null) {
                AuthRoles authRoles = null;
                while (dBCursor.next()) {
                    authRoles = ((AuthRoles.AuthRolesCursor)dBCursor).getObject();
                    if (authRoles == null) continue;
                    Integer n = new Integer(authRoles.getRoleId());
                    RoleData roleData = new RoleData(authRoles.getRoleName(), authRoles.getGroupName(), (int)authRoles.getGroupType());
                    roleMap.put(n, roleData);
                }
            }
        }
        finally {
            try {
                if (dBCursor != null) {
                    dBCursor.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean update(RoleData[] roleDataArray) throws SQLException {
        DBConnection dBConnection = null;
        DBPreparedStatement dBPreparedStatement = null;
        DBPreparedStatement dBPreparedStatement2 = null;
        DBPreparedStatement dBPreparedStatement3 = null;
        boolean bl = false;
        int n = 0;
        while (n < roleDataArray.length) {
            if (roleDataArray[n] == null || roleDataArray[n].getGroupName() != null && !this.isValidRoleData(roleDataArray[n])) {
                return bl;
            }
            ++n;
        }
        try {
            try {
                DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
                dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
                dBPreparedStatement = dBConnection.prepareStatement(DELETE_BY_ROLE_ID);
                dBPreparedStatement2 = dBConnection.prepareStatement(INSERT_BY_ROLE_ID);
                dBPreparedStatement3 = dBConnection.prepareStatement(UPDATE_BY_ROLE_ID);
                int n2 = 0;
                while (n2 < roleDataArray.length) {
                    int n3 = RoleChecker.getRoleID(roleDataArray[n2].getRoleName());
                    String string = roleDataArray[n2].getRoleName();
                    String string2 = roleDataArray[n2].getGroupName();
                    int n4 = roleDataArray[n2].getGroupType();
                    RoleData roleData = (RoleData)roleMap.get(new Integer(n3));
                    if (string2 == null) {
                        if (roleData != null) {
                            dBPreparedStatement.setInt(1, n3);
                            dBPreparedStatement.executeUpdate();
                        }
                    } else if (roleData == null) {
                        dBPreparedStatement2.setString(1, string);
                        dBPreparedStatement2.setString(2, string2);
                        dBPreparedStatement2.setInt(3, n4);
                        dBPreparedStatement2.setInt(4, n3);
                        dBPreparedStatement2.executeUpdate();
                    } else if (string2.compareTo(roleData.getGroupName()) != 0) {
                        dBPreparedStatement3.setString(1, string);
                        dBPreparedStatement3.setString(2, string2);
                        dBPreparedStatement3.setInt(3, n4);
                        dBPreparedStatement3.setInt(4, n3);
                        dBPreparedStatement3.executeUpdate();
                    }
                    ++n2;
                }
                dBConnection.commit();
                Roles.refresh();
                bl = true;
            }
            catch (SQLException sQLException) {
                try {
                    if (dBConnection != null) {
                        dBConnection.rollback();
                    }
                }
                catch (SQLException sQLException2) {
                    sQLException2.printStackTrace();
                }
                sQLException.printStackTrace();
                throw sQLException;
            }
        }
        finally {
            if (dBPreparedStatement != null) {
                try {
                    dBPreparedStatement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                dBPreparedStatement = null;
            }
            if (dBPreparedStatement2 != null) {
                try {
                    dBPreparedStatement2.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                dBPreparedStatement2 = null;
            }
            if (dBPreparedStatement3 != null) {
                try {
                    dBPreparedStatement3.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                dBPreparedStatement3 = null;
            }
            try {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public int getUserRoles(String string) {
        int n;
        block8: {
            n = 0;
            try {
                Object object;
                if (passthrough) {
                    n = RoleChecker.SUPERUSER;
                } else if (roleMap.get(RoleChecker.SUPERUSER) == null) {
                    object = null;
                    object = System.getProperty("os.name").startsWith("Win") ? "Administrators" : "adm";
                    if (Roles.isGroupMember(string, (String)object, GroupData.LOCAL_GROUP)) {
                        n = RoleChecker.SUPERUSER;
                    }
                }
                if (n != RoleChecker.NO_ROLE) break block8;
                object = roleMap.keys();
                while (object.hasMoreElements()) {
                    int n2;
                    Object k = object.nextElement();
                    RoleData roleData = (RoleData)roleMap.get(k);
                    String string2 = roleData.getGroupName();
                    if (string2 == null || !Roles.isGroupMember(string, string2, n2 = roleData.getGroupType())) continue;
                    int n3 = (Integer)k;
                    if (n3 == RoleChecker.SUPERUSER) {
                        n = n3;
                        break;
                    }
                    n |= n3;
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
            }
        }
        return n;
    }

    public boolean setGroupType(RoleData roleData) {
        boolean bl = false;
        int n = 0;
        try {
            if (roleData.getGroupName() != null) {
                if (Roles.checkLocalGroup(roleData.getGroupName())) {
                    n = GroupData.LOCAL_GROUP;
                } else if (Roles.checkLocalGroup(roleData.getGroupName(), GroupData.DOMAIN_GROUP)) {
                    n = GroupData.DOMAIN_GROUP;
                }
            }
            if (n > 0) {
                roleData.setGroupType(n);
                bl = true;
            } else {
                bl = false;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        return bl;
    }

    public boolean isValidRoleData(RoleData roleData) {
        String string;
        boolean bl = false;
        if (roleData != null && RoleChecker.getRoleID(roleData.getRoleName()) > 0 && (string = roleData.getGroupName()) != null) {
            bl = this.setGroupType(roleData);
        }
        return bl;
    }

    public Hashtable getRoleMap() {
        return roleMap;
    }

    public Hashtable getFullRoleMap() {
        Hashtable hashtable = new Hashtable(baseMap);
        hashtable.putAll(roleMap);
        return hashtable;
    }

    public static boolean checkLocalGroup(String string) {
        return Roles.checkLocalGroup(string, GroupData.LOCAL_GROUP);
    }

    public static boolean checkLocalGroup(String string, int n) {
        boolean bl = false;
        try {
            bl = Roles.isValidGroup(string, n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        return bl;
    }

    public static int validateLocalLogin(String string, String string2) {
        int n = -1;
        try {
            n = string != null ? (string2 != null ? Roles.isValidUser(string, string2, false) : -2) : -1;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        return n;
    }

    public static int validateDomainLogin(String string, String string2) {
        int n = -1;
        try {
            n = string != null ? (string2 != null ? Roles.isValidUser(string, string2, true) : -2) : -1;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        return n;
    }

    public static int validateAccountRights(String string, String[] stringArray, boolean bl) {
        int n = -1;
        try {
            if (string != null) {
                n = Roles.checkAccountRights(string, stringArray, bl);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        return n;
    }

    public static String nativeLog() {
        String string = "";
        boolean bl = false;
        if (bl && System.getProperty("os.name").startsWith("Win")) {
            try {
                string = Roles.retrieveNativeLog();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
            }
        }
        return string;
    }

    public static String administratorsGroup() {
        String string = "";
        if (System.getProperty("os.name").startsWith("Win")) {
            try {
                string = Roles.localAdminGroup();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
            }
        }
        return string;
    }

    public static boolean validateUserMembership(String string, String string2, int n) {
        boolean bl = false;
        try {
            bl = Roles.isGroupMember(string, string2, n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        return bl;
    }
}

