/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelStorageL0;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerEntityPopulator;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSanL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;

public class ViewerStorageL0
extends ViewerSanL1 {
    ViewerEntityPopulator populator = new ViewerEntityPopulator();
    public static boolean debug = false;
    public static String SELECT_SUBSYSTEM = "SELECT \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3 FROM \tT_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on \tT_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on \tT_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID ";
    public static String SELECT_TAPES = "SELECT \t\tT_RES_TAPE_LIBRARY.PREFIX_ID, \t\tT_RES_TAPE_LIBRARY.TAPE_LIBRARY_ID TAPE_LIBRARY_ID, \t\tCASE WHEN T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME)\t\t!= '' THEN T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME \t\t\t WHEN T_RES_TAPE_LIBRARY.DISPLAY_NAME IS NOT NULL THEN T_RES_TAPE_LIBRARY.DISPLAY_NAME \t\t\t ELSE T_RES_TAPE_LIBRARY.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_TAPE_LIBRARY.FIRMWARE_VERSION FIRMWARE_VERSION, \t\tT_RES_TAPE_LIBRARY.MAX_CARTRIDGES MAX_CARTRIDGES, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_TAPE_LIBRARY.SERIAL_NUMBER SERIAL_NUMBER, \t\tT_RES_TAPE_LIBRARY.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_TAPE_LIBRARY.DETECTABLE DETECTABLE, \t\tT_RES_TAPE_LIBRARY.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_TAPE_LIBRARY.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_TAPE_LIBRARY.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_TAPE_LIBRARY.TOTAL_DRIVES, \t\tT_RES_TAPE_LIBRARY.TOTAL_CARTRIDGES, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB3 USER_ATTRIB3 FROM \tT_VIEW_VTAPE_LIBRARY T_RES_TAPE_LIBRARY left outer join T_RES_VENDOR VENDOR on \tT_RES_TAPE_LIBRARY.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on \tT_RES_TAPE_LIBRARY.MODEL_ID = MODEL.MODEL_ID ";
    public static String SELECT_SANS_FROM_ARRAY = "SELECT     SUBSYSTEM2FABRIC.FABRIC_ID,     SUBSYSTEM2FABRIC.PREFIX_ID, \t SUBSYSTEM2FABRIC.SUBSYSTEM_ID FROM T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC";
    public static String SELECT_SANS_FROM_TAPE = "SELECT     TAPE2FABRIC.FABRIC_ID FABRIC_ID,     TAPE2FABRIC.PREFIX_ID, \t TAPE2FABRIC.TAPE_LIBRARY_ID TAPE_LIBRARY_ID FROM T_VIEW_VTAPE2FABRIC TAPE2FABRIC";

    public void getSubsystems(Connection connection, GraphModel graphModel, HashMap hashMap) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerStorageL0.class.getName(), "getSubsystems", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("subsystem...");
        }
        GraphSubsystem graphSubsystem = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_SUBSYSTEM);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    String string = (String)resultSet.getObject("PREFIX_ID");
                    Integer n = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                    if (n == null) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystems", "SUBSYSTEM_ID is NULL");
                        continue;
                    }
                    String string2 = String.valueOf(string) + n;
                    if (hashMap == null || hashMap.get(string2) == null) {
                        graphSubsystem = new GraphSubsystem(string2);
                        this.populator.populateSubsystem(resultSet, graphSubsystem);
                        if (graphModel != null) {
                            graphModel.put(graphSubsystem);
                        }
                        if (hashMap == null) continue;
                        hashMap.put(string2, graphSubsystem);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystems", "Duplicated Host entry:" + string2);
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystems", exception);
                }
            }
        }
        finally {
            block25: {
                block24: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block24;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystems", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block25;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystems", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("subsystem totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerStorageL0.class.getName(), "getHosts", "");
        }
    }

    public void getTapes(Connection connection, GraphModel graphModel, HashMap hashMap) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerStorageL0.class.getName(), "getTapes", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("tape...");
        }
        GraphTapeLibrary graphTapeLibrary = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_TAPES);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("PREFIX_ID");
                Integer n = (Integer)resultSet.getObject("TAPE_LIBRARY_ID");
                if (n == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getTapes", "SUBSYSTEM_ID is NULL");
                    continue;
                }
                String string2 = String.valueOf(string) + n;
                if (hashMap == null || hashMap.get(string2) == null) {
                    graphTapeLibrary = new GraphTapeLibrary(string2);
                    this.populator.populateTapeLibrary(resultSet, graphTapeLibrary);
                    if (graphModel != null) {
                        graphModel.put(graphTapeLibrary);
                    }
                    if (hashMap == null) continue;
                    hashMap.put(string2, graphTapeLibrary);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getTapes", "Duplicated Host entry:" + string2);
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getTapes", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getTapes", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("tape totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerStorageL0.class.getName(), "getTapes", "");
        }
    }

    public void getSansFromSubsystem(Connection connection, GraphModel graphModel, HashMap hashMap) throws SQLException {
        this.getSansFromSubsystem(connection, graphModel, hashMap, null, SELECT_SANS_FROM_ARRAY);
    }

    public void getSansFromTape(Connection connection, GraphModel graphModel, HashMap hashMap) throws SQLException {
        this.getSansFromTape(connection, graphModel, hashMap, null, SELECT_SANS_FROM_TAPE);
    }

    public void commit(Connection connection) {
        block2: {
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", sQLException);
            }
        }
    }

    public void getView(Connection connection, ViewerRequest viewerRequest, ViewerResponse viewerResponse) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerStorageL0.class.getName(), "getView", "");
        }
        HashMap hashMap = new HashMap();
        Timestamp timestamp = viewerRequest.getTimestamp();
        Timestamp timestamp2 = null;
        if (timestamp2 == null || timestamp == null || timestamp2.after(timestamp)) {
            GraphModelStorageL0 graphModelStorageL0 = new GraphModelStorageL0((GraphModelStorageL0.ID)viewerRequest.getModelID());
            this.getSubsystems(connection, graphModelStorageL0, hashMap);
            this.getTapes(connection, graphModelStorageL0, hashMap);
            graphModelStorageL0.setWithZoneData(true);
            this.commit(connection);
            viewerResponse.addResponse(0, graphModelStorageL0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerStorageL0.class.getName(), "getView", "");
        }
    }

    public void main(String[] stringArray) {
    }
}

