/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL0;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerEntityPopulator;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSanL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;

public class ViewerSwitchL0
extends ViewerSanL1 {
    protected ViewerEntityPopulator populator = new ViewerEntityPopulator();
    public static boolean debug = false;
    public static String SELECT_SWITCH = "SELECT \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3 FROM \tT_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_MODEL MODEL on\tT_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on \tT_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID ";
    public static final String SELECT_SANS_FOR_SWITCH = "SELECT distinct \t SWITCH2FABRIC.PREFIX_ID, \t SWITCH2FABRIC.SWITCH_ID SWITCH_ID, \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3  FROM     T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN, T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC WHERE     T_RES_FABRIC.FABRIC_ID = SWITCH2FABRIC.FABRIC_ID ";

    public void getSwitches(Connection connection, GraphModel graphModel, HashMap hashMap) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSwitchL0.class.getName(), "getSwitches", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("switch...");
        }
        GraphSwitch graphSwitch = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("PREFIX_ID");
                Integer n = (Integer)resultSet.getObject("SWITCH_ID");
                if (n == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL0.class.getName(), "getSwitches", "SWITCH_ID is NULL");
                    continue;
                }
                String string2 = String.valueOf(string) + n;
                if (hashMap == null || hashMap.get(string2) == null) {
                    graphSwitch = new GraphSwitch(string2);
                    this.populator.populateSwitch(resultSet, graphSwitch, true);
                    if (graphModel != null) {
                        graphModel.put(graphSwitch);
                    }
                    if (hashMap == null) continue;
                    hashMap.put(string2, graphSwitch);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSwitchL0.class.getName(), "getSwitches", "Duplicated Switch entry:" + string2);
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerSwitchL0.class.getName(), "getSwitches", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerSwitchL0.class.getName(), "getSwitches", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("switch totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSwitchL0.class.getName(), "getSwitches", "");
        }
    }

    public void getSansFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, Object[] objectArray, String string) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSwitchL0.class.getName(), "getSansFromSwitch", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        l = System.currentTimeMillis();
        if (debug) {
            System.out.println("san2switch...");
        }
        try {
            preparedStatement = connection.prepareStatement(string);
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    preparedStatement.setObject(n + 1, objectArray[n]);
                    ++n;
                }
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = (String)resultSet.getObject("PREFIX_ID");
                Integer n = (Integer)resultSet.getObject("SWITCH_ID");
                Integer n2 = (Integer)resultSet.getObject("FABRIC_ID");
                GraphSwitch graphSwitch = (GraphSwitch)hashMap.get(String.valueOf(string2) + n);
                GraphFabric graphFabric = new GraphFabric("fabric:" + n2);
                this.populator.populateSan(resultSet, graphFabric);
                GraphFabric2Switch graphFabric2Switch = new GraphFabric2Switch("fabric2switch:" + n2 + ',' + n);
                graphFabric2Switch.setFabricID((GraphFabric.ID)graphFabric.getEntityID());
                graphFabric2Switch.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                graphModel.put(graphFabric);
                graphModel.put(graphFabric2Switch);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSwitchL0.class.getName(), "getSansFromSwitch", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSwitchL0.class.getName(), "getSansFromSwitch", exception);
                }
            }
        }
        if (debug) {
            System.out.println("san2switch totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSwitchL0.class.getName(), "getSansFromSwitch", "");
        }
    }

    public void getSansFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap) throws SQLException {
        this.getSansFromSwitch(connection, graphModel, hashMap, null, SELECT_SANS_FOR_SWITCH);
    }

    public void commit(Connection connection) {
        block2: {
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", sQLException);
            }
        }
    }

    public void getView(Connection connection, ViewerRequest viewerRequest, ViewerResponse viewerResponse) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSwitchL0.class.getName(), "getView", "");
        }
        HashMap hashMap = new HashMap();
        Timestamp timestamp = viewerRequest.getTimestamp();
        Timestamp timestamp2 = null;
        if (timestamp2 == null || timestamp == null || timestamp2.after(timestamp)) {
            GraphModelSwitchL0 graphModelSwitchL0 = new GraphModelSwitchL0((GraphModelSwitchL0.ID)viewerRequest.getModelID());
            this.getSwitches(connection, graphModelSwitchL0, hashMap);
            this.getSansFromSwitch(connection, graphModelSwitchL0, hashMap);
            viewerResponse.addResponse(0, graphModelSwitchL0);
            graphModelSwitchL0.setWithZoneData(true);
            this.commit(connection);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSwitchL0.class.getName(), "getView", "");
        }
    }

    public void main(String[] stringArray) {
    }
}

