/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.xmsg;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.xmsg.MessageTextRenderer;
import org.eclipse.aperi.xmsg.TextRendererProvider;

public class MessageRegistry {
    private static ProviderChain commonProviders = new ProviderChain();
    private static Map<ClassLoader, ProviderChain> byClassLoaderMap = new HashMap<ClassLoader, ProviderChain>();

    public static void registerProvider(TextRendererProvider textRendererProvider) {
        commonProviders.add(textRendererProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProvider(ClassLoader classLoader, TextRendererProvider textRendererProvider) {
        ProviderChain providerChain;
        Map<ClassLoader, ProviderChain> map = byClassLoaderMap;
        synchronized (map) {
            providerChain = byClassLoaderMap.get(classLoader);
            if (providerChain == null) {
                providerChain = new ProviderChain();
                byClassLoaderMap.put(classLoader, providerChain);
            }
        }
        providerChain.add(textRendererProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MessageTextRenderer lookUpRenderer(ClassLoader classLoader, String string) {
        MessageTextRenderer messageTextRenderer = null;
        if (classLoader != null) {
            ProviderChain providerChain;
            Map<ClassLoader, ProviderChain> map = byClassLoaderMap;
            synchronized (map) {
                providerChain = byClassLoaderMap.get(classLoader);
            }
            if (providerChain != null) {
                messageTextRenderer = providerChain.lookUp(string);
            }
        }
        if (messageTextRenderer == null) {
            messageTextRenderer = commonProviders.lookUp(string);
        }
        return messageTextRenderer;
    }

    private static class ProviderChain {
        public TextRendererProvider head = null;
        public TextRendererProvider tail = null;

        public synchronized void add(TextRendererProvider textRendererProvider) {
            textRendererProvider.nextProvider = null;
            if (this.tail == null) {
                this.head = textRendererProvider;
            } else {
                this.tail.nextProvider = textRendererProvider;
            }
            this.tail = textRendererProvider;
        }

        public MessageTextRenderer lookUp(String string) {
            MessageTextRenderer messageTextRenderer = null;
            TextRendererProvider textRendererProvider = this.head;
            while (messageTextRenderer == null && textRendererProvider != null) {
                messageTextRenderer = textRendererProvider.lookUpRenderer(string);
                textRendererProvider = textRendererProvider.nextProvider;
            }
            return messageTextRenderer;
        }
    }
}

