/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.tape;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.disk.monitor.DiskEventQueue;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.TapeDrive;
import org.eclipse.aperi.infrastructure.database.objects.TapeFrame;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.TapeMediaChanger;
import org.eclipse.aperi.monitor.dataservernotification.Notifier;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.tape.TapeActivator;
import org.eclipse.aperi.tape.TapeManagerConstants;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt16;

public class TapeMonitor
extends Thread
implements TapeManagerConstants {
    private static IConfigService configServiceProxy;
    private AlertDefinition cAlertDef = null;
    private int[] PERSEV2OPSTAT;
    private String[] PERSEV2STRING;
    protected static String className;
    protected static ILogger msgLogger;
    protected static ILogger traceLogger;
    private DiskEventQueue cEventQueue;
    private boolean cShutdown;
    private int cTapeAlertNotificationLevel;
    private static HashMap ibmExtDescMap;

    static {
        Class<?> clazz;
        configServiceProxy = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.tape.TapeMonitor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        msgLogger = null;
        traceLogger = null;
        ibmExtDescMap = new HashMap();
        msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.TapeManager");
        traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.TapeManager");
        msgLogger.setMessageFile("org.eclipse.aperi.tape.api.resources.TapeManagerMsgs");
        ibmExtDescMap.put("ibm3584MIBGroupDrvSN", "Drive Serial Number");
        ibmExtDescMap.put("ibm3584MIBGroupEA", "Element Address");
        ibmExtDescMap.put("ibm3584MIBGroupFFFD", "Failing Frame, Failing Drive");
        ibmExtDescMap.put("ibm3584MIBGroupFSC", "Fault Symptom Code");
        ibmExtDescMap.put("ibm3584MIBGroupHECHECQ", "Hardware Error Code");
        ibmExtDescMap.put("ibm3584MIBGroupLL", "Logical Library");
        ibmExtDescMap.put("ibm3584MIBGroupSCD", "Drive Single Character Display");
        ibmExtDescMap.put("ibm3584MIBGroupSKASCASCQ", "Sense Key, ASC, ASCQ");
        ibmExtDescMap.put("ibm3584MIBGroupURC", "URC");
        ibmExtDescMap.put("ibm3584MIBGroupVOLSER", "Cartridge Volume Serial Number");
        ibmExtDescMap.put("ibm3584MIBObjectsTA", "TapeAlert Flag");
    }

    public TapeMonitor(DiskEventQueue diskEventQueue) {
        super("TapeMonitor");
        String string;
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 3;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        this.PERSEV2OPSTAT = nArray;
        this.PERSEV2STRING = new String[]{"Unknown", "Other", "Information", "Degraded/Warning", "Minor", "Major", "Critical", "Fatal/NonRecoverable"};
        this.cTapeAlertNotificationLevel = 0;
        this.cEventQueue = diskEventQueue;
        IConfigService iConfigService = this.getConfigServiceProxy();
        if (iConfigService != null && (string = iConfigService.getProperty("TapeAlertNotificationLevel", "TapeManager")) != null) {
            this.cTapeAlertNotificationLevel = Integer.parseInt(string);
        }
    }

    public void run() {
        String string = "run";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        while (!this.cShutdown) {
            try {
                CIMIndicationEvent cIMIndicationEvent = this.cEventQueue.remove();
                if (cIMIndicationEvent == null) continue;
                this.processIndication(cIMIndicationEvent);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processIndication(CIMIndicationEvent cIMIndicationEvent) {
        String string;
        int n;
        TapeLibrary tapeLibrary;
        String string2;
        block27: {
            int n2;
            CIMInstance cIMInstance;
            block29: {
                block30: {
                    block28: {
                        string2 = "processIndication";
                        if (traceLogger.isLogging()) {
                            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
                        }
                        cIMInstance = cIMIndicationEvent.getCIMInstance();
                        String string3 = this.getStringProperty(cIMInstance, "SystemName", "UnknownSystem");
                        if (Configuration.debug) {
                            System.out.println("TapeMonitor: Received indication! SystemName: " + string3);
                        }
                        if ((tapeLibrary = !string3.equals("UnknownSystem") ? this.getLibForName(string3) : null) == null) {
                            if (!traceLogger.isLogging()) return;
                            traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string2, "No tape library found for SystemName \"" + string3 + "\", ignoring");
                            return;
                        }
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_ENTRY, (Object)className, string2, "Found tape library for " + string3);
                        }
                        if ((n = this.getUInt16Property(cIMInstance, "PerceivedSeverity", new UnsignedInt16(0)).intValue()) >= 8) break block28;
                        n2 = this.PERSEV2OPSTAT[n];
                        String string4 = this.getStringProperty(cIMInstance, "EventID", "");
                        if (!string4.equals("408")) break block29;
                        break block30;
                    }
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERR, (Object)className, string2, "Invalid value of PerceivedSeverity: " + n + ", can't update status");
                    }
                    this.sendToDataServer(cIMIndicationEvent, tapeLibrary, n, null);
                    return;
                }
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "Identified indication as test trap, not updating status");
                }
                if (Configuration.debug) {
                    System.out.println("TapeMonitor: Identified indication as test trap, not updating status");
                }
                this.sendToDataServer(cIMIndicationEvent, tapeLibrary, n, null);
                return;
            }
            UnsignedInt16 unsignedInt16 = this.getUInt16Property(cIMInstance, "AlertingElementFormat", new UnsignedInt16(0));
            if (unsignedInt16.intValue() != 2) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string2, "AlertingManagedElement not in CIMObjectPath format, can't update status");
                }
                this.sendToDataServer(cIMIndicationEvent, tapeLibrary, n, null);
                return;
            }
            String string5 = this.getStringProperty(cIMInstance, "AlertingManagedElement", "");
            CIMObjectPath cIMObjectPath = null;
            try {
                cIMObjectPath = this.parseToCOP(string5);
            }
            catch (Exception exception) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception, "Exception from parseToCOP");
                }
                this.sendToDataServer(cIMIndicationEvent, tapeLibrary, n, null);
                return;
            }
            if (cIMObjectPath == null) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, (Object)className, string2, "Error while parsing AlertingManagedElement as CIMObjectPath, can't update status");
                }
                this.sendToDataServer(cIMIndicationEvent, tapeLibrary, n, null);
                return;
            }
            CIMInstance cIMInstance2 = new CIMInstance(cIMObjectPath);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERR, (Object)className, string2, "Found CIMInstance for AlertingManagedElement:\n" + cIMInstance2);
            }
            DBConnection dBConnection = ServiceUtils.getConnection();
            string = "";
            try {
                try {
                    string = this.updateElementOpStatus(dBConnection, cIMInstance2, n2, tapeLibrary);
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "updateElementOpStatus returned: " + string);
                    }
                }
                catch (SQLException sQLException) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)sQLException, "Exception in updateElementOpStatus");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                if (dBConnection == null) throw throwable;
                try {
                    dBConnection.commit();
                    dBConnection.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)sQLException);
                    }
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
                }
            }
            {
                Object var16_19 = null;
                if (dBConnection == null) break block27;
            }
            try {}
            catch (SQLException sQLException) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)sQLException);
                }
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
            }
            dBConnection.commit();
            dBConnection.close();
        }
        this.sendToDataServer(cIMIndicationEvent, tapeLibrary, n, string);
        if (!traceLogger.isLogging()) return;
        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
    }

    private String getStringProperty(CIMInstance cIMInstance, String string, String string2) {
        CIMValue cIMValue;
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        String string3 = cIMProperty != null ? ((cIMValue = cIMProperty.getValue()) != null ? (String)cIMValue.getValue() : string2) : string2;
        return string3;
    }

    private UnsignedInt16 getUInt16Property(CIMInstance cIMInstance, String string, UnsignedInt16 unsignedInt16) {
        CIMValue cIMValue;
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        UnsignedInt16 unsignedInt162 = cIMProperty != null ? ((cIMValue = cIMProperty.getValue()) != null ? (UnsignedInt16)cIMProperty.getValue().getValue() : unsignedInt16) : unsignedInt16;
        return unsignedInt162;
    }

    private String updateElementOpStatus(DBConnection dBConnection, CIMInstance cIMInstance, int n, TapeLibrary tapeLibrary) throws SQLException {
        String string = "updateElementOpStatus";
        String string2 = "";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        boolean bl = false;
        String string3 = cIMInstance.getClassName();
        short s = Short.parseShort(DBConstants.getValueFromKey((String)"Operational2ConsolidatedStatus", (String)Integer.toString(n)));
        Vector<String> vector = new Vector<String>();
        vector.add(new Integer(n).toString());
        String string4 = DBConstants.convertOperationalstatusArrayToBitValue(vector);
        int n2 = Integer.parseInt(string4);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_ENTRY, (Object)className, string, "Class name of AlertingManagedElement: " + string3);
        }
        if (string3.equalsIgnoreCase("IBMTSSML3584_TapeDrive") || string3.equalsIgnoreCase("CIM_MediaAccessDevice")) {
            TapeDrive tapeDrive = null;
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            String string5 = this.getStringProperty(cIMInstance, "DeviceID", "unknown");
            if (!string5.equals("unknown")) {
                hashtable.put(TapeDrive.getColumnInfo((String)"TAPE_LIBRARY_ID"), new Integer(tapeLibrary.getTapeLibraryId()).toString());
                hashtable.put(TapeDrive.getColumnInfo((String)"DEVICE_ID"), string5);
                TapeDrive.TapeDriveCursor tapeDriveCursor = TapeDrive.getCursor((DBConnection)dBConnection, hashtable, null);
                if (tapeDriveCursor.next()) {
                    tapeDrive = tapeDriveCursor.getObject();
                }
                tapeDriveCursor.close();
                dBConnection.commit();
            }
            if (tapeDrive != null) {
                if (n2 > tapeDrive.getOperationalStatus()) {
                    tapeDrive.setOperationalStatus(n2);
                    tapeDrive.setConsolidatedStatus(s);
                    bl = tapeDrive.update(dBConnection) > 0;
                }
                string2 = tapeDrive.getDisplayName();
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string, "No matching drive found in database for devId: " + string5 + ", libId: " + tapeLibrary.getTapeLibraryId());
            }
        } else if (string3.equalsIgnoreCase("IBMTSSML3584_ChangerDevice") || string3.equalsIgnoreCase("CIM_ChangerDevice")) {
            TapeMediaChanger tapeMediaChanger = null;
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            String string6 = this.getStringProperty(cIMInstance, "DeviceID", "unknown");
            if (!string6.equals("unknown")) {
                hashtable.put(TapeMediaChanger.getColumnInfo((String)"SYSTEM_NAMES_ID"), new Integer(tapeLibrary.getTapeLibraryId()).toString());
                hashtable.put(TapeMediaChanger.getColumnInfo((String)"DEVICE_ID"), string6);
                TapeMediaChanger.TapeMediaChangerCursor tapeMediaChangerCursor = TapeMediaChanger.getCursor((DBConnection)dBConnection, hashtable, null);
                if (tapeMediaChangerCursor.next()) {
                    tapeMediaChanger = tapeMediaChangerCursor.getObject();
                }
                tapeMediaChangerCursor.close();
                dBConnection.commit();
            }
            if (tapeMediaChanger != null) {
                if (n2 > tapeMediaChanger.getOperationalStatus()) {
                    tapeMediaChanger.setOperationalStatus(n2);
                    tapeMediaChanger.setConsolidatedStatus(s);
                    bl = tapeMediaChanger.update(dBConnection) > 0;
                }
                string2 = tapeMediaChanger.getDisplayName();
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string, "No matching media changer found in database for devId: " + string6 + ", libId: " + tapeLibrary.getTapeLibraryId());
            }
        } else if (string3.equalsIgnoreCase("IBMTSSML3584_TapeLibrary") || string3.equalsIgnoreCase("CIM_ComputerSystem")) {
            if (n2 > tapeLibrary.getOperationalStatus()) {
                tapeLibrary.setOperationalStatus(n2);
                tapeLibrary.setConsolidatedStatus(s);
                bl = tapeLibrary.update(dBConnection) > 0;
            }
            string2 = tapeLibrary.getDisplayName();
        } else {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string, "Alert came from unknown element \"" + string3 + "\"");
            }
            return string2;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, bl);
        }
        return string2;
    }

    private CIMObjectPath parseToCOP(String string) {
        String[] stringArray = string.split(":", 2);
        if (stringArray.length < 2) {
            return null;
        }
        String string2 = stringArray[0];
        string = stringArray[1];
        stringArray = string.split("\\.", 2);
        String string3 = stringArray[0];
        string = stringArray[1];
        stringArray = string.split(",");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = stringArray[n].split("=");
            CIMProperty cIMProperty = new CIMProperty(stringArray2[0]);
            cIMProperty.setValue(new CIMValue((Object)stringArray2[1].replaceAll("^\"|\"$", ""), new CIMDataType(8)));
            vector.add(cIMProperty);
            ++n;
        }
        CIMObjectPath cIMObjectPath = new CIMObjectPath(string3, string2);
        if (cIMObjectPath != null) {
            cIMObjectPath.setKeys(vector);
        }
        return cIMObjectPath;
    }

    private void sendToDataServer(CIMIndicationEvent cIMIndicationEvent, TapeLibrary tapeLibrary, int n, String string) {
        String string2 = "updateElementOpStatus";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        boolean bl = true;
        if (n >= this.cTapeAlertNotificationLevel) {
            int n2;
            Notifier notifier;
            Alert alert;
            Object[] objectArray;
            CIMInstance cIMInstance = cIMIndicationEvent.getCIMInstance();
            String string3 = this.getStringProperty(cIMInstance, "ProbableCauseDescription", "Cause unknown");
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(string3) + "\n");
            if (string != null && string.length() > 0) {
                arrayList.add("Affected Element: " + string);
            }
            if (n >= 0 && n <= 7) {
                arrayList.add("Perceived Severity: " + n + " (" + this.PERSEV2STRING[n] + ")");
            } else {
                arrayList.add("Perceived Severity: " + n);
            }
            String string4 = this.getStringProperty(cIMInstance, "EventID", "not specified");
            arrayList.add("Event ID: " + string4 + "\n");
            CIMProperty cIMProperty = cIMInstance.getProperty("ExtraInfoDescriptions");
            CIMProperty cIMProperty2 = cIMInstance.getProperty("ExtraInfoValues");
            int n3 = -1;
            int n4 = -1;
            if (cIMProperty != null && cIMProperty2 != null) {
                n3 = arrayList.size();
                objectArray = (Vector)cIMProperty.getValue().getValue();
                Vector vector = (Vector)cIMProperty2.getValue().getValue();
                alert = objectArray.elements();
                notifier = vector.elements();
                while (alert.hasMoreElements()) {
                    String string5 = (String)alert.nextElement();
                    if (!notifier.hasMoreElements()) continue;
                    String string6 = (String)notifier.nextElement();
                    String string7 = (String)ibmExtDescMap.get(string5);
                    if (string7 != null) {
                        if (string5.equals("ibm3584MIBObjectsTA") && string6.equals("0")) {
                            arrayList.add(String.valueOf(string7) + ": None");
                            continue;
                        }
                        arrayList.add(String.valueOf(string7) + ": " + string6);
                        continue;
                    }
                    arrayList.add(String.valueOf(string5) + ": " + string6);
                }
                n4 = arrayList.size();
            }
            objectArray = arrayList.toArray(new String[0]);
            if (n3 > -1 && n4 > -1) {
                Arrays.sort(objectArray, n3, n4);
            }
            int n5 = n2 = tapeLibrary != null ? tapeLibrary.getTapeLibraryId() : -1;
            if (this.cAlertDef == null) {
                this.cAlertDef = new AlertDefinition();
                this.cAlertDef.aldAlertID = this.getAlertDefID();
            }
            alert = new Alert(-1, n2, 134, this.cAlertDef, (String[])objectArray, 0, null, null);
            notifier = new Notifier();
            bl = notifier.sendAlert(alert);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "Alert " + (bl ? "successfully " : "couldn't be ") + "sent to Data Server");
            }
            if (Configuration.debug) {
                System.out.println("Alert " + (bl ? "successfully " : "couldn't be ") + "sent to Data Server");
            }
        } else {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "PerceivedSeverity of indication lower than TapeAlertNotificationLevel (" + n + " < " + this.cTapeAlertNotificationLevel + "), " + "not sending to data server");
            }
            if (Configuration.debug) {
                System.out.println("PerceivedSeverity of indication lower than TapeAlertNotificationLevel (" + n + " < " + this.cTapeAlertNotificationLevel + "), " + "not sending to data server");
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, bl);
        }
    }

    /*
     * Exception decompiling
     */
    private int getAlertDefID() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 215->218)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TapeLibrary getLibForName(String string) {
        TapeLibrary tapeLibrary;
        String string2 = "getLibForName";
        DBConnection dBConnection = ServiceUtils.getConnection();
        TapeLibrary.TapeLibraryCursor tapeLibraryCursor = null;
        TapeFrame.TapeFrameCursor tapeFrameCursor = null;
        try {
            try {
                TapeLibrary tapeLibrary2 = null;
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(TapeLibrary.getColumnInfo((String)"NAME"), string);
                tapeLibraryCursor = TapeLibrary.getCursor((DBConnection)dBConnection, hashtable, null);
                if (tapeLibraryCursor.next()) {
                    tapeLibrary2 = tapeLibraryCursor.getObject();
                }
                if (tapeLibrary2 == null) {
                    String[] stringArray = string.split(" ");
                    String string3 = stringArray[stringArray.length - 1].replaceFirst("^\\+", "");
                    if (Configuration.debug) {
                        System.out.println("Library not found for SystemName " + string);
                        System.out.println("Trying to locate via Frame for serial " + string3);
                    }
                    TapeFrame tapeFrame = null;
                    hashtable.clear();
                    hashtable.put(TapeFrame.getColumnInfo((String)"SERIAL_NUMBER"), string3);
                    tapeFrameCursor = TapeFrame.getCursor((DBConnection)dBConnection, hashtable, null);
                    if (tapeFrameCursor.next()) {
                        tapeFrame = tapeFrameCursor.getAttributes();
                    }
                    if (tapeFrame != null) {
                        hashtable.clear();
                        hashtable.put(TapeLibrary.getColumnInfo((String)"TAPE_LIBRARY_ID"), new Integer(tapeFrame.getTapeLibraryId()).toString());
                        tapeLibraryCursor = TapeLibrary.getCursor((DBConnection)dBConnection, hashtable, null);
                        if (tapeLibraryCursor.next()) {
                            tapeLibrary2 = tapeLibraryCursor.getObject();
                        }
                    }
                    if (Configuration.debug) {
                        System.out.println("Library " + (tapeLibrary2 != null ? "" : "not") + " found via Frame");
                    }
                }
                tapeLibrary = tapeLibrary2;
                Object var11_13 = null;
                if (dBConnection == null) return tapeLibrary;
            }
            catch (SQLException sQLException) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)sQLException);
                }
                Object var11_14 = null;
                if (dBConnection == null) return null;
                try {
                    if (tapeLibraryCursor != null) {
                        tapeLibraryCursor.close();
                    }
                    if (tapeFrameCursor != null) {
                        tapeFrameCursor.close();
                    }
                    dBConnection.commit();
                    dBConnection.close();
                    return null;
                }
                catch (SQLException sQLException3) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)sQLException3);
                    }
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException3.getMessage()}));
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (dBConnection == null) throw throwable;
            try {}
            catch (SQLException sQLException2) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)sQLException2);
                }
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException2.getMessage()}));
            }
            if (tapeLibraryCursor != null) {
                tapeLibraryCursor.close();
            }
            if (tapeFrameCursor != null) {
                tapeFrameCursor.close();
            }
            dBConnection.commit();
            dBConnection.close();
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)sQLException);
            }
            throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{sQLException.getMessage()}));
        }
        if (tapeLibraryCursor != null) {
            tapeLibraryCursor.close();
        }
        if (tapeFrameCursor != null) {
            tapeFrameCursor.close();
        }
        dBConnection.commit();
        dBConnection.close();
        return tapeLibrary;
    }

    public void shutdown() {
        String string = "shutdown";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        if (Configuration.debug) {
            System.out.println("TapeMonitor shutting down");
        }
        this.cShutdown = true;
        this.cEventQueue.add(null);
        Thread thread = Thread.currentThread();
        if (thread != null) {
            try {
                thread.interrupt();
                thread.join(30000L);
            }
            catch (Exception exception) {}
        }
        thread = null;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public IConfigService getConfigServiceProxy() {
        if (configServiceProxy == null) {
            configServiceProxy = (IConfigService)TapeActivator._serviceHelper.bindLocal("ConfigService");
        }
        return configServiceProxy;
    }
}

