/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.tape.collection;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.Discover;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.CIMOMSelector;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.interfaces.ParameterException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.tape.TapeReportingService;

public class TapeProbeDispatcher
extends DiscoverProcess {
    public TapeProbeDispatcher(String string, boolean bl) {
        Class<?> clazz;
        Class<?> clazz2;
        String[] stringArray = new String[2];
        try {
            clazz2 = Class.forName("[Ljava.lang.String;");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[0] = clazz2.getName();
        try {
            clazz = Class.forName("java.lang.Integer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[1] = clazz.getName();
        super(string, bl, new String[]{"TAPELIBRARY", "COLLTYPE"}, stringArray);
    }

    public Result process(Request request, Map map) throws ParameterException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Request)request, (Object)((Object)this), (String)"process", (Object[])new Object[]{request, map});
        ILogger iLogger = request.getJobLogger();
        String[] stringArray = (String[])map.get("TAPELIBRARY");
        Integer n = (Integer)map.get("COLLTYPE");
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            block5: {
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("TAPELIBRARY", stringArray[n3]);
                hashtable.put("COLLTYPE", n);
                TapeReportingService tapeReportingService = new TapeReportingService();
                HashMap hashMap = tapeReportingService.getTapeLibraryAttributes(new String[]{stringArray[n3]}, new String[]{"TAPE_LIBRARY_ID", "CREATION_CLASS_NAME_ID", "NAME", "NAME_FORMAT"})[0];
                hashtable.put("DEVICEID", ((Integer)hashMap.get("TAPE_LIBRARY_ID")).toString());
                CIMOMSelector.TapeLibraryConnectionData tapeLibraryConnectionData = null;
                try {
                    tapeLibraryConnectionData = CIMOMSelector.getSelector().getCimomForTapeLibrary(((Integer)hashMap.get("TAPE_LIBRARY_ID")).intValue());
                    hashtable.put("CIMOM", new String[]{tapeLibraryConnectionData.getCimom().getServiceUrl(), tapeLibraryConnectionData.getCimNamespace(), tapeLibraryConnectionData.getCimom().getUserId(), tapeLibraryConnectionData.getCimom().getPassword()});
                }
                catch (CIMOMSelector.NoCimomAvailableException noCimomAvailableException) {
                    logTraceHelper.traceWarning("CIMOM not available for tape lib " + stringArray[n3]);
                    if (Configuration.debug) {
                        System.err.println("CIMOM not available for tape lib " + stringArray[n3]);
                    }
                    if (iLogger != null) {
                        iLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)((Object)((Object)this)).getClass().getName(), "process", (Throwable)noCimomAvailableException);
                    }
                    n2 = 1;
                    break block5;
                }
                HashMap<String, Object[]> hashMap2 = new HashMap<String, Object[]>();
                hashMap2.put("Request", new Object[]{"collectDataFromSingleTapeLibrary", hashtable});
                this.getDiscoverRouterService().perform(Discover.frontEndProcessHandler, hashMap2, Integer.toString(request.getId()));
                logTraceHelper.traceInfo("frontEndProcessHandler called with: " + hashMap2);
            }
            ++n3;
        }
        Result result = new Result(n2);
        logTraceHelper.exit((Object)result);
        return result;
    }
}

