/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.report.engine.adapter.ModelDteApiAdapter;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.data.dte.DteResultSet;
import org.eclipse.birt.report.engine.data.dte.NativeRowObject;
import org.eclipse.birt.report.engine.data.dte.ReportQueryBuilder;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.mozilla.javascript.Scriptable;

public abstract class AbstractDataEngine
implements IDataEngine {
    protected DataEngine dteEngine;
    protected ExecutionContext context;
    protected HashMap queryIDMap = new HashMap();
    protected String reportArchName = null;
    protected static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractDataEngine(ExecutionContext context) {
        this.context = context;
        try {
            Scriptable scope = context.getScope();
            context.registerBean("row", new NativeRowObject(scope, context));
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "can't register row object", ex);
            ex.printStackTrace();
        }
    }

    public void defineDataSet(DataSetHandle dataSet) {
        DataSourceHandle dataSource = dataSet.getDataSource();
        ModelDteApiAdapter adaptor = new ModelDteApiAdapter(this.context, this.context.getSharedScope());
        try {
            if (dataSource != null) {
                this.doDefineDataSource(adaptor, dataSource);
            }
            this.doDefineDataSet(adaptor, dataSet);
        }
        catch (BirtException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
    }

    protected void doDefineDataSource(ModelDteApiAdapter adaptor, DataSourceHandle dataSource) throws BirtException {
        this.dteEngine.defineDataSource(adaptor.createDataSourceDesign(dataSource));
    }

    protected void doDefineDataSet(ModelDteApiAdapter adaptor, DataSetHandle dataSet) throws BirtException {
        if (dataSet instanceof JointDataSetHandle) {
            JointDataSetHandle jointDataSet = (JointDataSetHandle)dataSet;
            List dataSetNames = jointDataSet.getDataSetNames();
            ModuleHandle report = dataSet.getModuleHandle();
            Iterator iter = dataSetNames.iterator();
            while (iter.hasNext()) {
                String dataSetName = (String)iter.next();
                DataSetHandle childDataSet = report.findDataSet(dataSetName);
                if (childDataSet == null) continue;
                DataSourceHandle childDataSource = childDataSet.getDataSource();
                if (childDataSource != null) {
                    this.doDefineDataSource(adaptor, childDataSource);
                }
                this.doDefineDataSet(adaptor, childDataSet);
            }
        }
        this.dteEngine.defineDataSet(adaptor.createDataSetDesign(dataSet));
    }

    public void prepare(Report report, Map appContext) {
        ReportDesignHandle rptHandle = report.getReportDesign();
        ModelDteApiAdapter adaptor = new ModelDteApiAdapter(this.context, this.context.getSharedScope());
        List dataSourceList = rptHandle.getAllDataSources();
        for (int i = 0; i < dataSourceList.size(); ++i) {
            DataSourceHandle dataSource = (DataSourceHandle)dataSourceList.get(i);
            try {
                this.dteEngine.defineDataSource(adaptor.createDataSourceDesign(dataSource));
                continue;
            }
            catch (BirtException be) {
                logger.log(Level.SEVERE, be.getMessage(), be);
                this.context.addException((DesignElementHandle)dataSource, be);
            }
        }
        List dataSetList = rptHandle.getAllDataSets();
        for (int i = 0; i < dataSetList.size(); ++i) {
            DataSetHandle dataset = (DataSetHandle)dataSetList.get(i);
            try {
                this.dteEngine.defineDataSet(adaptor.createDataSetDesign(dataset));
                continue;
            }
            catch (BirtException be) {
                logger.log(Level.SEVERE, be.getMessage(), be);
                this.context.addException((DesignElementHandle)dataset, be);
            }
        }
        new ReportQueryBuilder().build(report, this.context);
        this.doPrepareQuery(report, appContext);
    }

    protected abstract void doPrepareQuery(Report var1, Map var2);

    public IResultSet execute(IBaseQueryDefinition query) {
        return this.execute(null, query);
    }

    public IResultSet execute(IResultSet parent, IBaseQueryDefinition query) {
        if (query instanceof IQueryDefinition) {
            return this.doExecuteQuery((DteResultSet)parent, (IQueryDefinition)query);
        }
        if (query instanceof ISubqueryDefinition) {
            return this.doExecuteSubQuery((DteResultSet)parent, query);
        }
        return null;
    }

    protected abstract IResultSet doExecuteQuery(DteResultSet var1, IQueryDefinition var2);

    protected IResultSet doExecuteSubQuery(DteResultSet parent, IBaseQueryDefinition query) {
        if (!$assertionsDisabled && !(query instanceof ISubqueryDefinition)) {
            throw new AssertionError();
        }
        try {
            ISubqueryDefinition subQuery = (ISubqueryDefinition)query;
            String subQueryName = subQuery.getName();
            IResultIterator parentRI = parent.getResultIterator();
            IResultIterator ri = parentRI.getSecondaryIterator(subQueryName, this.context.getSharedScope());
            if (!$assertionsDisabled && ri == null) {
                throw new AssertionError();
            }
            DteResultSet resultSet = new DteResultSet(parent, subQuery, ri);
            return resultSet;
        }
        catch (BirtException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            this.context.addException(e);
            return null;
        }
    }

    public void close(IResultSet rs) {
    }

    public void shutdown() {
        this.dteEngine.shutdown();
    }

    public Object evaluate(IBaseExpression expr) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof IScriptExpression) {
            return this.context.evaluate(((IScriptExpression)expr).getText());
        }
        if (expr instanceof IConditionalExpression) {
            return this.context.evaluateCondExpr((IConditionalExpression)expr);
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public Object evaluate(String expr) {
        return this.context.evaluate(expr);
    }

    public DataEngine getDataEngine() {
        return this.dteEngine;
    }

    public DataEngine getDTEEngine() {
        return this.dteEngine;
    }

    protected String getTempDir(ExecutionContext context) {
        EngineConfig config;
        IReportEngine engine = context.getEngine();
        if (engine != null && (config = engine.getConfig()) != null) {
            return config.getTempDir();
        }
        return null;
    }

    static {
        $assertionsDisabled = !AbstractDataEngine.class.desiredAssertionStatus();
        logger = Logger.getLogger(IDataEngine.class.getName());
    }
}

