/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.executor.CellExecutor;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.internal.util.HTMLUtil;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.script.internal.RowScriptExecutor;

public class RowExecutor
extends QueryItemExecutor {
    int rowId;
    int currentCell;

    protected RowExecutor(ExecutorManager manager) {
        super(manager);
    }

    public void reset() {
        super.reset();
        this.rowId = 0;
    }

    void setRowId(int rowId) {
        this.rowId = rowId;
    }

    int getRowId() {
        return this.rowId;
    }

    public IContent execute() {
        RowDesign rowDesign = (RowDesign)this.getDesign();
        IRowContent rowContent = this.report.createRowContent();
        this.setContent(rowContent);
        this.executeQuery();
        this.initializeContent(rowDesign, rowContent);
        this.processAction(rowDesign, rowContent);
        this.processBookmark(rowDesign, rowContent);
        this.processStyle(rowDesign, rowContent);
        this.processVisibility(rowDesign, rowContent);
        rowContent.setRowID(this.rowId);
        this.setGroupId(rowContent);
        if (this.context.isInFactory()) {
            RowScriptExecutor.handleOnCreate(rowContent, this.context);
        }
        this.startTOCEntry(rowContent);
        if (this.emitter != null) {
            this.emitter.startRow(rowContent);
        }
        this.currentCell = 0;
        return rowContent;
    }

    private void setGroupId(IRowContent rowContent) {
        int groupLevel = HTMLUtil.getGroupLevel(rowContent);
        IResultSet resultSet = this.getParentResultSet();
        if (groupLevel >= 0 && resultSet != null) {
            rowContent.setGroupId(resultSet.getGroupId(groupLevel));
        }
    }

    public void close() {
        IRowContent rowContent = (IRowContent)this.getContent();
        if (this.emitter != null) {
            this.emitter.endRow(rowContent);
        }
        this.finishTOCEntry();
        this.closeQuery();
        this.manager.releaseExecutor(13, this);
    }

    public boolean hasNextChild() {
        RowDesign rowDesign = (RowDesign)this.design;
        return this.currentCell < rowDesign.getCellCount();
    }

    public IReportItemExecutor getNextChild() {
        RowDesign rowDesign = (RowDesign)this.design;
        if (this.currentCell < rowDesign.getCellCount()) {
            CellDesign cellDesign = rowDesign.getCell(this.currentCell++);
            CellExecutor executor = (CellExecutor)this.manager.createExecutor(this, cellDesign);
            return executor;
        }
        return null;
    }
}

