/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.TextItemExecutor;
import org.eclipse.birt.report.engine.ir.TemplateDesign;

public class TemplateExecutor
extends TextItemExecutor {
    public TemplateExecutor(ExecutorManager manager) {
        super(manager);
    }

    public IContent execute() {
        TemplateDesign templateDesign = (TemplateDesign)this.design;
        IForeignContent textContent = this.report.createForeignContent();
        this.setContent(textContent);
        textContent.setRawType("text/html");
        IStyle style = textContent.getStyle();
        style.setProperty(21, IStyle.GRAY_VALUE);
        style.setProperty(10, IStyle.SOLID_VALUE);
        style.setProperty(15, IStyle.THIN_VALUE);
        style.setProperty(24, IStyle.GRAY_VALUE);
        style.setProperty(13, IStyle.SOLID_VALUE);
        style.setProperty(19, IStyle.THIN_VALUE);
        style.setProperty(22, IStyle.GRAY_VALUE);
        style.setProperty(11, IStyle.SOLID_VALUE);
        style.setProperty(17, IStyle.THIN_VALUE);
        style.setProperty(23, IStyle.GRAY_VALUE);
        style.setProperty(12, IStyle.SOLID_VALUE);
        style.setProperty(18, IStyle.THIN_VALUE);
        style.setProperty(26, IStyle.CENTER_VALUE);
        style.setProperty(30, IStyle.MIDDLE_VALUE);
        this.initializeContent(templateDesign, textContent);
        String promptText = templateDesign.getPromptText();
        if (promptText == null || promptText.trim().length() == 0) {
            promptText = "<br/>";
        }
        textContent.setRawValue(promptText);
        textContent.setRawKey(templateDesign.getPromptTextKey());
        this.processVisibility(templateDesign, textContent);
        if (this.emitter != null) {
            this.emitter.startForeign(textContent);
        }
        return textContent;
    }

    public void close() {
        this.manager.releaseExecutor(9, this);
    }
}

