/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.area.impl;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.dom.AreaStyle;
import org.eclipse.birt.report.engine.css.dom.ComputedStyle;
import org.eclipse.birt.report.engine.css.engine.BIRTCSSEngine;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public abstract class AbstractArea
implements IArea {
    protected IStyle style;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected IContent content;
    protected float scale = 1.0f;

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    AbstractArea(IContent content) {
        this.content = content;
        this.style = content != null ? new AreaStyle((ComputedStyle)content.getComputedStyle()) : new AreaStyle(new BIRTCSSEngine());
    }

    AbstractArea(IReportContent report) {
        this.style = report != null ? new AreaStyle(report.getCSSEngine()) : new AreaStyle(new BIRTCSSEngine());
    }

    public void setAllocatedPosition(int ax, int ay) {
        this.x = ax + PropertyUtil.getDimensionValue(this.style.getProperty(31));
        this.y = ay + PropertyUtil.getDimensionValue(this.style.getProperty(53));
    }

    public void setAllocatedHeight(int aHeight) {
        this.height = aHeight - PropertyUtil.getDimensionValue(this.style.getProperty(53)) - PropertyUtil.getDimensionValue(this.style.getProperty(52));
    }

    public void setAllocatedWidth(int aWidth) {
        int totalMarginWidth = PropertyUtil.getDimensionValue(this.style.getProperty(31)) + PropertyUtil.getDimensionValue(this.style.getProperty(32));
        if (totalMarginWidth >= aWidth) {
            this.style.setProperty(31, IStyle.NUMBER_0);
            this.style.setProperty(32, IStyle.NUMBER_0);
            this.width = aWidth;
        } else {
            this.width = aWidth - totalMarginWidth;
        }
    }

    public void setContentHeight(int cHeight) {
        this.height = cHeight + PropertyUtil.getDimensionValue(this.style.getProperty(15)) + PropertyUtil.getDimensionValue(this.style.getProperty(19)) + PropertyUtil.getDimensionValue(this.style.getProperty(56)) + PropertyUtil.getDimensionValue(this.style.getProperty(55));
    }

    public void setContentWidth(int cWidth) {
        this.width = cWidth + PropertyUtil.getDimensionValue(this.style.getProperty(17)) + PropertyUtil.getDimensionValue(this.style.getProperty(18)) + PropertyUtil.getDimensionValue(this.style.getProperty(36)) + PropertyUtil.getDimensionValue(this.style.getProperty(37));
    }

    public int getAllocatedX() {
        return this.x - PropertyUtil.getDimensionValue(this.style.getProperty(31));
    }

    public int getAllocatedY() {
        return this.y - PropertyUtil.getDimensionValue(this.style.getProperty(53));
    }

    public int getContentWidth() {
        int totalPaddngWidth = PropertyUtil.getDimensionValue(this.style.getProperty(36)) + PropertyUtil.getDimensionValue(this.style.getProperty(37));
        int totalBorderWidth = PropertyUtil.getDimensionValue(this.style.getProperty(17)) + PropertyUtil.getDimensionValue(this.style.getProperty(18));
        if (this.width <= totalPaddngWidth) {
            this.style.setProperty(36, IStyle.NUMBER_0);
            this.style.setProperty(37, IStyle.NUMBER_0);
            return this.width - totalBorderWidth;
        }
        return this.width - totalPaddngWidth - totalBorderWidth;
    }

    public int getContentHeight() {
        return this.height - PropertyUtil.getDimensionValue(this.style.getProperty(15)) - PropertyUtil.getDimensionValue(this.style.getProperty(19)) - PropertyUtil.getDimensionValue(this.style.getProperty(56)) - PropertyUtil.getDimensionValue(this.style.getProperty(55));
    }

    public int getAllocatedWidth() {
        return this.width + PropertyUtil.getDimensionValue(this.style.getProperty(31)) + PropertyUtil.getDimensionValue(this.style.getProperty(32));
    }

    public int getAllocatedHeight() {
        return this.height + PropertyUtil.getDimensionValue(this.style.getProperty(53)) + PropertyUtil.getDimensionValue(this.style.getProperty(52));
    }

    public IStyle getStyle() {
        return this.style;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public IContent getContent() {
        return this.content;
    }

    protected void removeMargin() {
        this.style.setProperty(31, IStyle.NUMBER_0);
        this.style.setProperty(32, IStyle.NUMBER_0);
        this.style.setProperty(53, IStyle.NUMBER_0);
        this.style.setProperty(52, IStyle.NUMBER_0);
    }

    protected void removeBorder() {
        this.style.setProperty(15, IStyle.NUMBER_0);
        this.style.setProperty(19, IStyle.NUMBER_0);
        this.style.setProperty(17, IStyle.NUMBER_0);
        this.style.setProperty(18, IStyle.NUMBER_0);
    }

    protected void removePadding() {
        this.style.setProperty(36, IStyle.NUMBER_0);
        this.style.setProperty(37, IStyle.NUMBER_0);
        this.style.setProperty(56, IStyle.NUMBER_0);
        this.style.setProperty(55, IStyle.NUMBER_0);
    }
}

