/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.content.ListContainerExecutor;
import org.eclipse.birt.report.engine.layout.pdf.PDFGroupLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFRegionLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public class PDFListGroupLM
extends PDFGroupLM
implements IBlockStackingLayoutManager {
    public PDFListGroupLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
    }

    protected IListBandContent getHeader() {
        return (IListBandContent)((IGroupContent)this.content).getHeader();
    }

    protected IReportItemExecutor createExecutor() {
        return new ListContainerExecutor(this.content, this.executor);
    }

    protected void repeatHeader() {
        if (this.isFirst) {
            this.isFirst = false;
            return;
        }
        if (!this.isRepeatHeader()) {
            return;
        }
        IListBandContent band = this.getHeader();
        if (band == null) {
            return;
        }
        DOMReportItemExecutor headerExecutor = new DOMReportItemExecutor(band);
        headerExecutor.execute();
        ContainerArea headerArea = (ContainerArea)AreaFactory.createLogicContainer(this.content.getReportContent());
        headerArea.setAllocatedWidth(this.parent.getMaxAvaWidth());
        PDFRegionLM regionLM = new PDFRegionLM(this.context, headerArea, (IContent)band, (IReportItemExecutor)headerExecutor);
        boolean allowPB = this.context.allowPageBreak();
        this.context.setAllowPageBreak(false);
        regionLM.layout();
        this.context.setAllowPageBreak(allowPB);
        if (headerArea.getAllocatedHeight() + this.currentBP < this.parent.getMaxAvaHeight()) {
            this.addArea(headerArea);
            ++this.repeatCount;
        }
    }

    protected void createRoot() {
        this.root = (ContainerArea)AreaFactory.createBlockContainer(this.content);
    }

    protected void newContext() {
        super.newContext();
        this.repeatCount = 0;
    }
}

