/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.pdf.ISplitter;
import org.eclipse.birt.report.engine.layout.pdf.font.FontHandler;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;

public class FontSplitter
implements ISplitter {
    public static final char MISSING_CHAR = '?';
    private FontHandler fh = null;
    private int baseLevel = 0;
    private int runDirection = -2;
    private int baseOffset = 0;
    private char[] chunkText = null;
    private int chunkStartPos = 0;
    private int currentPos = -1;
    private FontInfo lastFontInfo = null;
    private boolean encounteredReturn = false;

    public FontSplitter(Chunk inputChunk, ITextContent textContent) {
        this.chunkText = inputChunk.getText().toCharArray();
        this.baseOffset = inputChunk.getOffset();
        this.baseLevel = inputChunk.getBaseLevel();
        this.runDirection = inputChunk.getRunDirection();
        this.createFontHandler(textContent);
    }

    private void createFontHandler(ITextContent textContent) {
        this.fh = new FontHandler(textContent);
    }

    private Chunk buildChunk() {
        if (this.encounteredReturn) {
            this.encounteredReturn = false;
            ++this.chunkStartPos;
            return Chunk.HARD_LINE_BREAK;
        }
        while (++this.currentPos < this.chunkText.length) {
            if (this.chunkText[this.currentPos] == '\n') {
                if (null == this.lastFontInfo) {
                    this.chunkStartPos = this.currentPos + 1;
                    return Chunk.HARD_LINE_BREAK;
                }
                this.encounteredReturn = true;
                Chunk c = new Chunk(new String(this.chunkText, this.chunkStartPos, this.currentPos - this.chunkStartPos), this.baseOffset + this.chunkStartPos, this.baseLevel, this.runDirection, this.lastFontInfo);
                this.chunkStartPos = this.currentPos;
                return c;
            }
            if (!this.fh.selectFont(this.chunkText[this.currentPos])) {
                this.chunkText[this.currentPos] = 63;
            }
            if (!this.fh.isFontChanged()) continue;
            if (null == this.lastFontInfo) {
                this.lastFontInfo = this.fh.getFontInfo();
                continue;
            }
            Chunk c = new Chunk(new String(this.chunkText, this.chunkStartPos, this.currentPos - this.chunkStartPos), this.baseOffset + this.chunkStartPos, this.baseLevel, this.runDirection, this.lastFontInfo);
            this.chunkStartPos = this.currentPos;
            this.lastFontInfo = this.fh.getFontInfo();
            return c;
        }
        if (this.currentPos >= this.chunkText.length - 1) {
            Chunk c = new Chunk(new String(this.chunkText, this.chunkStartPos, this.chunkText.length - this.chunkStartPos), this.baseOffset + this.chunkStartPos, this.baseLevel, this.runDirection, this.lastFontInfo);
            this.chunkStartPos = this.currentPos + 1;
            return c;
        }
        return null;
    }

    public boolean hasMore() {
        return this.chunkText.length > this.chunkStartPos;
    }

    public Chunk getNext() {
        return this.buildChunk();
    }
}

