/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import org.eclipse.birt.report.engine.api.IPageHandler;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.ReportExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.presentation.HTMLPaginationEmitter;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.IPaginationBuilder;

public class HTMLPaginationBuilder
implements IPaginationBuilder {
    protected ExecutionContext context;
    protected HTMLPaginationEmitter layoutEmitter;
    protected IPageHandler pageHandler;
    protected IContentEmitter outputEmitter;

    public HTMLPaginationBuilder(ExecutionContext context) {
        this.context = context;
        this.layoutEmitter = new HTMLPaginationEmitter(this);
    }

    public IContentEmitter getInputEmitter() {
        return this.layoutEmitter;
    }

    public void setOutputEmitter(IContentEmitter emitter) {
        this.layoutEmitter.setOutputEmitter(emitter);
    }

    public void setLayoutPageHandler(ILayoutPageHandler pageHandler) {
        this.layoutEmitter.setPageHandler(pageHandler);
    }

    public IPageHint getPageHint() {
        return this.layoutEmitter.getPageHint();
    }

    public IPageContent buildPageContent(long pageNumber, String masterPage) {
        IReportExecutor executor = this.context.getExecutor();
        IReportContent reportContent = this.context.getReportContent();
        PageSetupDesign pageSetup = reportContent.getDesign().getPageSetup();
        MasterPageDesign pageDesign = null;
        if (masterPage != null) {
            pageDesign = pageSetup.findMasterPage(masterPage);
        }
        if (pageDesign == null) {
            pageDesign = pageSetup.getMasterPage(0);
        }
        if (pageDesign != null) {
            return ((ReportExecutor)executor).executeMasterPage((int)pageNumber, pageDesign);
        }
        return null;
    }
}

