/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import com.ibm.icu.text.MessageFormat;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.executor.ExecutionContext;

public class ReportContextImpl
implements IReportContext {
    private ExecutionContext context;

    public ReportContextImpl(ExecutionContext context) {
        this.context = context;
    }

    public IReportRunnable getReportRunnable() {
        return this.context.getRunnable();
    }

    public Map getAppContext() {
        return this.context.getAppContext();
    }

    public void setAppContext(Map appContext) {
        this.context.setAppContext(appContext);
    }

    public void setGlobalVariable(String name, Object obj) {
        this.context.registerBean(name, obj);
    }

    public void deleteGlobalVariable(String name) {
        this.context.registerBean(name, null);
    }

    public Object getGlobalVariable(String name) {
        return this.context.getBeans().get(name);
    }

    public void setPersistentGlobalVariable(String name, Serializable obj) {
        this.context.registerGlobalBean(name, obj);
    }

    public void deletePersistentGlobalVariable(String name) {
        this.context.unregisterGlobalBean(name);
    }

    public Object getPersistentGlobalVariable(String name) {
        return this.context.getGlobalBeans().get(name);
    }

    public void setRegisteredPersistantObjects(Map persistantMap) {
        this.context.registerBeans(persistantMap);
    }

    public Object getParameterValue(String name) {
        return this.context.getParameterValue(name);
    }

    public void setParameterValue(String name, Object value) {
        this.context.setParameterValue(name, value);
    }

    public Object getConfigVariableValue(String varName) {
        return this.context.getConfigs().get(varName);
    }

    public Locale getLocale() {
        return this.context.getLocale();
    }

    public String getOutputFormat() {
        return this.context.getOutputFormat();
    }

    public Object getHttpServletRequest() {
        return this.getAppContext().get("BIRT_VIEWER_HTTPSERVET_REQUEST");
    }

    public String getMessage(String key) {
        return this.context.getDesign().getMessage(key);
    }

    public String getMessage(String key, Locale locale) {
        return this.context.getDesign().getMessage(key, locale);
    }

    public String getMessage(String key, Object[] params) {
        String msg = this.context.getDesign().getMessage(key);
        if (msg == null) {
            return "";
        }
        return MessageFormat.format((String)msg, (Object[])params);
    }

    public String getMessage(String key, Locale locale, Object[] params) {
        String msg = this.context.getDesign().getMessage(key, locale);
        if (msg == null) {
            return "";
        }
        return MessageFormat.format((String)msg, (Object[])params);
    }

    public String getParameterDisplayText(String name) {
        return this.context.getParameterDisplayText(name);
    }

    public void setParameterDisplayText(String name, String displayText) {
        this.context.setParameterDisplayText(name, displayText);
    }
}

