/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal.element;

import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.element.IDesignElement;
import org.eclipse.birt.report.engine.api.script.element.IScriptStyleDesign;
import org.eclipse.birt.report.engine.script.internal.ElementUtil;
import org.eclipse.birt.report.engine.script.internal.element.StyleDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.UserPropertyDefnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.UserPropertyException;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public class DesignElement
implements IDesignElement {
    protected DesignElementHandle handle;

    public DesignElement(DesignElementHandle handle) {
        this.handle = handle;
    }

    public IScriptStyleDesign getStyle() {
        return new StyleDesign(this.handle.getPrivateStyle());
    }

    public String getName() {
        return this.handle.getName();
    }

    public String getQualifiedName() {
        return this.handle.getQualifiedName();
    }

    public void setName(String name) throws ScriptException {
        try {
            this.handle.setName(name);
        }
        catch (NameException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public String getNamedExpression(String name) {
        UserPropertyDefnHandle propDefn = this.handle.getUserPropertyDefnHandle(name);
        Object userProp = this.getUserProperty(name);
        if (propDefn == null || userProp == null || propDefn.getType() != 7) {
            return null;
        }
        return userProp.toString();
    }

    public void setNamedExpression(String name, String exp) throws ScriptException {
        UserPropertyDefnHandle propDefn = this.handle.getUserPropertyDefnHandle(name);
        if (propDefn == null) {
            this.addUserProperty(name, "expression");
        } else if (propDefn.getType() != 7) {
            return;
        }
        this.setUserProperty(name, exp);
    }

    public Object getUserProperty(String name) {
        return this.handle.getProperty(name);
    }

    public void setUserProperty(String name, String value) throws ScriptException {
        if (this.handle.getUserPropertyDefnHandle(name) == null) {
            this.addUserProperty(name, "string");
        }
        try {
            this.handle.setProperty(name, (Object)value);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setUserProperty(String name, Object value, String type) throws ScriptException {
        if (this.handle.getUserPropertyDefnHandle(name) == null) {
            this.addUserProperty(name, type);
        }
        try {
            this.handle.setProperty(name, value);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public IDesignElement getParent() {
        return ElementUtil.getElement(this.handle.getContainer());
    }

    private void addUserProperty(String name, String type) throws ScriptException {
        UserPropertyDefn newProp = new UserPropertyDefn();
        newProp.setName(name);
        newProp.setType(MetaDataDictionary.getInstance().getPropertyType(type));
        try {
            this.handle.addUserPropertyDefn(newProp);
        }
        catch (UserPropertyException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }
}

