/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.toc.TOCEntry;
import org.eclipse.birt.report.engine.toc.TOCTree;
import org.eclipse.birt.report.engine.toc.TOCTreeNode;

public class TOCBuilder {
    private TOCTree tocTree;
    private TOCEntry rootEntry;
    private static final String VERSION = "__Version : 1.0";
    public static final String TOC_PREFIX = "__TOC";

    public TOCBuilder(TOCTree tocTree) {
        this.tocTree = tocTree;
        TOCTreeNode root = tocTree.getTOCRoot();
        this.rootEntry = new TOCEntry(null, root, root);
    }

    public TOCEntry startGroupEntry(TOCEntry parent, Object tocValue, String bookmark, String hiddenFormats) {
        return this.startEntry(parent, tocValue, bookmark, hiddenFormats, true);
    }

    private String mergeHideFormats(TOCEntry parent, String hiddenFormats) {
        String parentHiddenFormats = parent.getHideFormats();
        if (hiddenFormats == null) {
            return parentHiddenFormats;
        }
        if (parentHiddenFormats == null) {
            return hiddenFormats;
        }
        return hiddenFormats + ", " + parentHiddenFormats;
    }

    public void closeGroupEntry(TOCEntry group) {
    }

    public TOCEntry startEntry(TOCEntry parent, Object tocValue, String bookmark, String hiddenFormats) {
        return this.startEntry(parent, tocValue, bookmark, hiddenFormats, false);
    }

    public TOCEntry startEntry(TOCEntry parent, Object tocValue, String bookmark, String hiddenFormats, boolean isGroupRoot) {
        if (parent == null) {
            parent = this.rootEntry;
        }
        TOCTreeNode parentNode = parent.node;
        TOCTreeNode node = new TOCTreeNode();
        String id = parentNode.getNodeID();
        if (id == null) {
            id = TOC_PREFIX;
        }
        id = id + "_" + parentNode.getChildren().size();
        String formats = this.mergeHideFormats(parent, hiddenFormats);
        node.setNodeID(id);
        node.setBookmark(bookmark == null ? id : bookmark);
        node.setParent(parentNode);
        node.setHideFormats(formats);
        node.setIsGroupRoot(isGroupRoot);
        node.setTOCValue(tocValue);
        parentNode.getChildren().add(node);
        TOCEntry entry = new TOCEntry(parent, parent.getRoot(), node);
        entry.setHideFormats(formats);
        return entry;
    }

    public TOCEntry startEntry(TOCEntry parent, Object tocValue, String bookmark) {
        return this.startEntry(parent, tocValue, bookmark, null);
    }

    public TOCEntry startDummyEntry(TOCEntry parent, String hiddenFormats) {
        if (parent == null) {
            parent = this.rootEntry;
        }
        TOCEntry entry = new TOCEntry(parent, parent.getRoot(), parent.getNode());
        entry.setHideFormats(this.mergeHideFormats(parent, hiddenFormats));
        return entry;
    }

    public TOCEntry createEntry(TOCEntry parent, Object tocValue, String bookmark) {
        TOCEntry entry = this.startEntry(parent, tocValue, bookmark, null);
        this.closeEntry(entry);
        return entry;
    }

    public void closeEntry(TOCEntry entry) {
    }

    public TOCEntry getTOCEntry() {
        return this.rootEntry;
    }

    public TOCTree getTOCTree() {
        return this.tocTree;
    }

    public static void write(TOCTree tree, DataOutputStream out) throws IOException {
        IOUtil.writeString((DataOutputStream)out, (String)VERSION);
        TOCBuilder.writeTOC(tree.getTOCRoot(), out);
    }

    private static void writeTOC(TOCTreeNode root, DataOutputStream out) throws IOException {
        IOUtil.writeString((DataOutputStream)out, (String)root.getNodeID());
        IOUtil.writeString((DataOutputStream)out, (String)root.getDisplayString());
        IOUtil.writeString((DataOutputStream)out, (String)root.getBookmark());
        IOUtil.writeString((DataOutputStream)out, (String)root.getHiddenFormats());
        IOUtil.writeBool((OutputStream)out, (boolean)root.isGroupRoot());
        IOUtil.writeObject((DataOutputStream)out, (Object)root.getTOCValue());
        List children = root.getChildren();
        IOUtil.writeInt((OutputStream)out, (int)children.size());
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            TOCTreeNode child = (TOCTreeNode)iter.next();
            TOCBuilder.writeTOC(child, out);
        }
        out.flush();
    }

    public static void read(TOCTree tree, DataInputStream input) throws IOException {
        TOCTreeNode node = tree.getTOCRoot();
        String head = IOUtil.readString((DataInputStream)input);
        if (head == null || !VERSION.equals(head)) {
            TOCBuilder.readV0(node, input, head, true);
        } else {
            TOCBuilder.readV1(node, input);
        }
    }

    public static void readV0(TOCTreeNode node, DataInputStream input, String nodeId, boolean isRoot) throws IOException {
        if (!isRoot) {
            nodeId = IOUtil.readString((DataInputStream)input);
        }
        String displayString = IOUtil.readString((DataInputStream)input);
        String bookmark = IOUtil.readString((DataInputStream)input);
        node.setNodeID(nodeId);
        node.setDisplayString(displayString);
        node.setBookmark(bookmark);
        int size = IOUtil.readInt((InputStream)input);
        for (int i = 0; i < size; ++i) {
            TOCTreeNode child = new TOCTreeNode();
            TOCBuilder.readV0(child, input, null, false);
            child.setParent(node);
            node.getChildren().add(child);
        }
    }

    public static void readV1(TOCTreeNode node, DataInputStream input) throws IOException {
        String nodeId = IOUtil.readString((DataInputStream)input);
        String displayString = IOUtil.readString((DataInputStream)input);
        String bookmark = IOUtil.readString((DataInputStream)input);
        String hiddenFormats = IOUtil.readString((DataInputStream)input);
        boolean isGroupRoot = IOUtil.readBool((InputStream)input);
        Object tocValue = IOUtil.readObject((DataInputStream)input);
        node.setNodeID(nodeId);
        node.setDisplayString(displayString);
        node.setBookmark(bookmark);
        node.setHideFormats(hiddenFormats);
        node.setIsGroupRoot(isGroupRoot);
        node.setTOCValue(tocValue);
        int size = IOUtil.readInt((InputStream)input);
        for (int i = 0; i < size; ++i) {
            TOCTreeNode child = new TOCTreeNode();
            TOCBuilder.readV1(child, input);
            child.setParent(node);
            node.getChildren().add(child);
        }
    }
}

