/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.table;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.birt.report.model.api.elements.table.LayoutCell;
import org.eclipse.birt.report.model.api.elements.table.LayoutRow;
import org.eclipse.birt.report.model.api.elements.table.LayoutSlot;
import org.eclipse.birt.report.model.api.elements.table.LayoutTable;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;

public class FillCellsStrategy {
    private LayoutTable layoutTable;
    private boolean fillsEmptyCells;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FillCellsStrategy(LayoutTable layoutTable, boolean fillsEmptyCells) {
        this.layoutTable = layoutTable;
        this.fillsEmptyCells = fillsEmptyCells;
    }

    public void applyStrategy() {
        this.fillsEmptyCellsForTable();
    }

    private void fillsEmptyCellsForTable() {
        TableGroup group;
        int i;
        int columnCount = this.layoutTable.getColumnCount();
        TableItem table = this.layoutTable.table;
        this.fillsEmptyCellsForSlot(table.getSlot(0), this.layoutTable.getHeader(), columnCount);
        ContainerSlot groups = table.getSlot(1);
        int groupCount = groups.getCount();
        for (i = 0; i < groupCount; ++i) {
            group = (TableGroup)groups.getContent(i);
            this.fillsEmptyCellsForSlot(group.getSlot(0), this.layoutTable.getGroupHeaders().getLayoutSlot(i), columnCount);
        }
        this.fillsEmptyCellsForSlot(table.getSlot(2), this.layoutTable.getDetail(), columnCount);
        for (i = groupCount - 1; i >= 0; --i) {
            group = (TableGroup)groups.getContent(groupCount - i - 1);
            this.fillsEmptyCellsForSlot(group.getSlot(1), this.layoutTable.getGroupFooters().getLayoutSlot(i), columnCount);
        }
        this.fillsEmptyCellsForSlot(table.getSlot(3), this.layoutTable.getFooter(), columnCount);
    }

    private void fillsEmptyCellsForSlot(ContainerSlot slot, LayoutSlot layoutSlot, int columnCount) {
        for (int i = 0; i < slot.getCount(); ++i) {
            TableRow row = (TableRow)slot.getContent(i);
            LayoutRow layoutRow = layoutSlot.getLayoutRow(i);
            this.fillsEmptyCellsForRow(row, layoutRow, columnCount);
        }
    }

    private void fillsEmptyCellsForRow(TableRow row, LayoutRow layoutRow, int columnCount) {
        int colPos = 0;
        Iterator iter = layoutRow.layoutCellsIterator();
        while (iter.hasNext()) {
            ++colPos;
            iter.next();
        }
        if (colPos < columnCount) {
            this.doFillLayoutCells(layoutRow, columnCount - colPos);
        }
        int[] positionsToAddCells = new int[columnCount];
        int[] positionsToFillLayoutCells = new int[columnCount];
        Arrays.fill(positionsToAddCells, -1);
        Arrays.fill(positionsToFillLayoutCells, -1);
        boolean isFillsNecessary = false;
        Iterator iter2 = layoutRow.layoutCellsIterator();
        colPos = 1;
        int passedCells = 0;
        int toAddCellsIndex = 0;
        while (iter2.hasNext()) {
            LayoutCell layoutCell = (LayoutCell)iter2.next();
            if (layoutCell.isUsed() && layoutCell.isCellStartPosition()) {
                ++passedCells;
            }
            if (!layoutCell.isUsed() && colPos <= columnCount) {
                positionsToAddCells[toAddCellsIndex] = passedCells + toAddCellsIndex;
                positionsToFillLayoutCells[toAddCellsIndex++] = colPos - 1;
                isFillsNecessary = true;
            }
            ++colPos;
        }
        if (this.fillsEmptyCells && isFillsNecessary) {
            this.doFillCells(row, positionsToAddCells, layoutRow, positionsToFillLayoutCells);
        }
    }

    private void doFillLayoutCells(LayoutRow row, int numToAdd) {
        for (int i = 0; i < numToAdd; ++i) {
            row.addCell(LayoutCell.EMPTY_CELL);
        }
    }

    private void doFillCells(TableRow row, int[] positionsToAddCells, LayoutRow layoutRow, int[] positionsToFillLayoutCells) {
        if (!$assertionsDisabled && row == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && positionsToAddCells == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && positionsToAddCells.length != positionsToFillLayoutCells.length) {
            throw new AssertionError();
        }
        for (int i = 0; i < positionsToAddCells.length; ++i) {
            int posn = positionsToAddCells[i];
            if (posn < 0) continue;
            Cell cell = new Cell();
            cell.setContainer(row, 0);
            row.getSlot(0).insert(cell, posn);
            layoutRow.fillCells(this.layoutTable.getNextCellId(), positionsToFillLayoutCells[i], 1, 0, cell, false);
        }
    }

    static {
        $assertionsDisabled = !FillCellsStrategy.class.desiredAssertionStatus();
    }
}

