/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.CircularExtendsException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.InvalidParentException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.command.WrongTypeException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.PropertyMask;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IObjectDefn;
import org.eclipse.birt.report.model.api.metadata.ISlotDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.SimpleListValidator;
import org.eclipse.birt.report.model.api.validators.StructureListValidator;
import org.eclipse.birt.report.model.api.validators.UnsupportedElementValidator;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.IPropertySet;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.MultiElementSlot;
import org.eclipse.birt.report.model.core.PropertySearchStrategy;
import org.eclipse.birt.report.model.core.ReferencableStructure;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.core.SingleElementSlot;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TemplateElement;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.interfaces.IDesignElementModel;
import org.eclipse.birt.report.model.elements.strategy.CopyForPastePolicy;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.BooleanPropertyType;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefPropertyType;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.metadata.StructRefPropertyType;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;
import org.eclipse.birt.report.model.validators.ValidationExecutor;

public abstract class DesignElement
implements IDesignElement,
IPropertySet,
IDesignElementModel {
    public static final long NO_BASE_ID = -1L;
    public static final long NO_ID = 0L;
    private static final int MAX_DISPLAY_LABEL_LEN = 30;
    protected String name = null;
    protected DesignElement container = null;
    protected int containerSlotID = -1;
    protected ArrayList listeners = null;
    protected Map propValues = new HashMap();
    protected HashMap userProperties = null;
    protected ElementRefValue extendsRef = null;
    protected ArrayList derived = null;
    protected long id = 0L;
    protected IElementDefn cachedDefn = null;
    protected boolean isValid = true;
    protected DesignElementHandle handle = null;
    protected List errors;
    protected ContainerSlot[] slots = null;
    protected long baseId = -1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DesignElement() {
    }

    public DesignElement(String theName) {
        this.name = theName;
    }

    public void addListener(Listener obj) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (obj != null && !this.listeners.contains(obj)) {
            this.listeners.add(obj);
        }
    }

    public void removeListener(Listener obj) {
        if (this.listeners == null) {
            return;
        }
        int posn = this.listeners.indexOf(obj);
        if (posn != -1) {
            this.listeners.remove(posn);
        }
    }

    public void clearListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
        this.listeners = null;
    }

    public void sendEvent(NotificationEvent ev) {
        ev.setDeliveryPath(0);
        this.broadcast(ev);
    }

    public Module getRoot() {
        DesignElement element = this;
        while (element.getContainer() != null) {
            element = element.getContainer();
        }
        if (!(element instanceof Module)) {
            return null;
        }
        return (Module)element;
    }

    public final void broadcast(NotificationEvent ev) {
        if (this instanceof Module || this.getContainer() != null) {
            this.broadcast(ev, this.getRoot());
        }
    }

    public void broadcast(NotificationEvent ev, Module module) {
        if (this.listeners != null) {
            ArrayList tmpListeners = new ArrayList(this.listeners);
            Iterator iter = tmpListeners.iterator();
            while (iter.hasNext()) {
                ((Listener)iter.next()).elementChanged(this.getHandle(module), ev);
            }
        }
        if (this.derived != null) {
            if (ev.getDeliveryPath() == 4) {
                return;
            }
            if (ev.getDeliveryPath() != 2) {
                ev.setDeliveryPath(1);
            }
            Iterator iter = this.derived.iterator();
            while (iter.hasNext()) {
                ((DesignElement)iter.next()).broadcast(ev, module);
            }
        }
    }

    public final boolean isVirtualElement() {
        return this.baseId != -1L;
    }

    public DesignElement getVirtualParent() {
        if (!this.isVirtualElement()) {
            return null;
        }
        DesignElement parent = null;
        for (DesignElement cur = this; cur != null; cur = cur.getContainer()) {
            DesignElement extendsElement = cur.getExtendsElement();
            if (extendsElement == null) continue;
            parent = extendsElement;
            break;
        }
        if (parent == null) {
            return null;
        }
        if (!$assertionsDisabled && !(parent.getContainer() instanceof Module)) {
            throw new AssertionError();
        }
        return parent.getRoot().getElementByID(this.baseId);
    }

    public Object getProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        return this.getProperty(module, prop);
    }

    public Object getProperty(Module module, ElementPropertyDefn prop) {
        Object value = this.getStrategy().getPropertyExceptRomDefault(module, this, prop);
        if (value != null) {
            return value;
        }
        return prop.getDefault();
    }

    public PropertySearchStrategy getStrategy() {
        return PropertySearchStrategy.getInstance();
    }

    public String getSelector(int slotID) {
        ElementDefn defn = (ElementDefn)this.getDefn();
        SlotDefn slotDefn = (SlotDefn)defn.getSlot(slotID);
        if (slotDefn == null) {
            return null;
        }
        String slotSelector = slotDefn.getSelector();
        if (StringUtil.isBlank(slotSelector)) {
            return null;
        }
        return slotSelector;
    }

    public Object getProperty(Module module, PropertyDefn prop) {
        return this.getProperty(module, (ElementPropertyDefn)prop);
    }

    public boolean isStyle() {
        return false;
    }

    public Object getLocalProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        return this.getLocalProperty(module, prop);
    }

    public Object getLocalProperty(Module module, ElementPropertyDefn prop) {
        if (prop.isIntrinsic()) {
            return this.getIntrinsicProperty(prop.getName());
        }
        switch (prop.getTypeCode()) {
            case 15: {
                return this.resolveElementReference(module, prop);
            }
            case 19: {
                return this.resolveStructReference(module, prop);
            }
            case 20: {
                if (prop.getSubTypeCode() != 15) break;
                return this.resolveElementReferenceList(module, prop);
            }
        }
        return this.propValues.get(prop.getName());
    }

    protected Object getIntrinsicProperty(String propName) {
        if ("name".equals(propName)) {
            return this.name;
        }
        if ("extends".equals(propName)) {
            if (this.extendsRef != null && !this.extendsRef.isResolved()) {
                this.resolveExtends(this.getRoot());
            }
            return this.extendsRef;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    protected void setIntrinsicProperty(String propName, Object value) {
        if (propName.equals("name")) {
            this.setName((String)value);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void setProperty(String propName, Object value) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        this.setProperty(prop, value);
    }

    public void setProperty(ElementPropertyDefn prop, Object value) {
        ReferenceValue oldRef;
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        String propName = prop.getName();
        if (prop.isIntrinsic()) {
            this.setIntrinsicProperty(propName, value);
            return;
        }
        if (prop.getTypeCode() == 15) {
            oldRef = (ElementRefValue)this.propValues.get(propName);
            this.updateReference((ElementRefValue)oldRef, (ElementRefValue)value, prop);
        }
        if (prop.getTypeCode() == 19) {
            oldRef = (StructRefValue)this.propValues.get(propName);
            this.updateReference((StructRefValue)oldRef, (StructRefValue)value, prop);
        }
        if (value == null) {
            this.propValues.remove(propName);
        } else {
            this.propValues.put(propName, value);
        }
    }

    public String getPropertyMask(Module module, String propName) {
        DesignElement e = this;
        do {
            ArrayList masks;
            if ((masks = (ArrayList)e.getLocalProperty(module, "propertyMasks")) == null) continue;
            for (int i = 0; i < masks.size(); ++i) {
                PropertyMask mask = (PropertyMask)masks.get(i);
                if (!propName.equals(mask.getName())) continue;
                return mask.getMask();
            }
        } while ((e = e.getExtendsElement()) != null);
        return null;
    }

    protected void updateReference(ElementRefValue oldRef, ElementRefValue newRef, ElementPropertyDefn prop) {
        ReferenceableElement target;
        if (oldRef != null && (target = oldRef.getTargetElement()) != null) {
            target.dropClient(this);
        }
        if (newRef != null && (target = newRef.getTargetElement()) != null) {
            target.addClient(this, prop.getName());
        }
    }

    protected void updateReference(StructRefValue oldRef, StructRefValue newRef, ElementPropertyDefn prop) {
        ReferencableStructure target;
        if (oldRef != null && (target = oldRef.getTargetStructure()) != null) {
            target.dropClient(this);
        }
        if (newRef != null && (target = newRef.getTargetStructure()) != null) {
            target.addClient(this, prop.getName());
        }
    }

    public void setProperty(PropertyDefn prop, Object value) {
        this.setProperty((ElementPropertyDefn)prop, value);
    }

    public void clearProperty(String propName) {
        this.setProperty(propName, null);
    }

    public IElementDefn getDefn() {
        if (this.cachedDefn == null) {
            this.cachedDefn = MetaDataDictionary.getInstance().getElement(this.getElementName());
            if (!$assertionsDisabled && this.cachedDefn == null) {
                throw new AssertionError();
            }
        }
        return this.cachedDefn;
    }

    public void addUserPropertyDefn(UserPropertyDefn userProp) {
        if (!$assertionsDisabled && !this.getDefn().allowsUserProperties()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && userProp == null) {
            throw new AssertionError();
        }
        String propName = userProp.getName();
        if (!$assertionsDisabled && this.getUserPropertyDefn(propName) != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getDefn().getProperty(propName) != null) {
            throw new AssertionError();
        }
        if (this.userProperties == null) {
            this.userProperties = new LinkedHashMap();
        }
        this.userProperties.put(propName, userProp);
    }

    public void dropUserPropertyDefn(UserPropertyDefn prop) {
        if (!$assertionsDisabled && !this.getDefn().allowsUserProperties()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.userProperties == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.userProperties.get(prop.getName()) != prop) {
            throw new AssertionError();
        }
        this.userProperties.remove(prop.getName());
    }

    public UserPropertyDefn getLocalUserPropertyDefn(String propName) {
        if (this.userProperties == null) {
            return null;
        }
        return (UserPropertyDefn)this.userProperties.get(propName);
    }

    public UserPropertyDefn getUserPropertyDefn(String propName) {
        for (DesignElement e = this; e != null; e = e.getExtendsElement()) {
            UserPropertyDefn p = e.getLocalUserPropertyDefn(propName);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public DesignElement getExtendsElement() {
        if (this.extendsRef == null) {
            return null;
        }
        if (!this.extendsRef.isResolved()) {
            this.resolveExtends(this.getRoot());
        }
        return this.extendsRef.getElement();
    }

    public void resolveExtends(Module module) {
        if (this.extendsRef == null || module == null) {
            return;
        }
        if (this.extendsRef.isResolved()) {
            return;
        }
        ElementDefn metaData = (ElementDefn)this.getDefn();
        PropertyDefn propDefn = (PropertyDefn)((Object)metaData.getProperty("extends"));
        int ns = metaData.getNameSpaceID();
        DesignElement resolvedParent = module.resolveElement(ReferenceValueUtil.needTheNamespacePrefix(this.extendsRef, module), ns, propDefn);
        if (resolvedParent != null && this.isExtendsValid(resolvedParent)) {
            this.extendsRef.resolve(resolvedParent);
            resolvedParent.addDerived(this);
        }
    }

    public String getExtendsName() {
        if (this.extendsRef == null) {
            return null;
        }
        return StringUtil.buildQualifiedReference(this.extendsRef.getLibraryNamespace(), this.extendsRef.getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public DesignElement getContainer() {
        return this.container;
    }

    public void setContainer(DesignElement obj, int slot) {
        this.container = obj;
        this.containerSlotID = slot;
    }

    public ElementPropertyDefn getPropertyDefn(String propName) {
        ElementPropertyDefn prop = (ElementPropertyDefn)this.getDefn().getProperty(propName);
        if (prop == null) {
            prop = this.getUserPropertyDefn(propName);
        }
        return prop;
    }

    void validatePropertyName(String propName) throws PropertyNameException {
        if (this.getPropertyDefn(propName) == null) {
            throw new PropertyNameException(this, propName);
        }
    }

    public Object validatePropertyValue(Module module, String propName, Object value) throws PropertyNameException, PropertyValueException {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            throw new PropertyNameException(this, propName);
        }
        try {
            return prop.validateValue(module, value);
        }
        catch (PropertyValueException e) {
            e.setElement(this);
            e.setPropertyName(propName);
            throw e;
        }
    }

    public StyleElement getStyle(Module module) {
        return null;
    }

    public StyleElement getStyle() {
        return null;
    }

    protected void addDerived(DesignElement child) {
        if (this.derived == null) {
            this.derived = new ArrayList();
        }
        if (!$assertionsDisabled && child == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && child.getExtendsElement() != this) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.derived.contains(child)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && child.getDefn() != this.getDefn()) {
            throw new AssertionError();
        }
        this.derived.add(child);
    }

    public void dropDerived(DesignElement child) {
        if (!$assertionsDisabled && this.derived == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && child == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && child.getExtendsElement() != this) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.derived.contains(child)) {
            throw new AssertionError();
        }
        this.derived.remove(child);
    }

    public void setExtendsElement(DesignElement base) {
        DesignElement oldExtends = this.getExtendsElement();
        if (base == oldExtends && base != null) {
            return;
        }
        if (oldExtends != null) {
            oldExtends.dropDerived(this);
        }
        if (base == null) {
            this.extendsRef = null;
        } else {
            if (!$assertionsDisabled && base.getDefn() != this.getDefn()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && base.getName() == null) {
                throw new AssertionError();
            }
            String namespace = null;
            Module root = base.getRoot();
            if (root instanceof Library) {
                namespace = ((Library)root).getNamespace();
            }
            this.extendsRef = new ElementRefValue(namespace, base);
            base.addDerived(this);
        }
    }

    public TemplateParameterDefinition getTemplateParameterElement(Module module) {
        ElementRefValue templateParam = (ElementRefValue)this.getProperty(module, "refTemplateParameter");
        if (templateParam == null) {
            return null;
        }
        return (TemplateParameterDefinition)templateParam.getElement();
    }

    public List getDescendents() {
        ArrayList list = new ArrayList();
        this.gatherDescendents(list);
        return list;
    }

    public void gatherDescendents(ArrayList list) {
        if (this.derived == null) {
            return;
        }
        for (int i = 0; i < this.derived.size(); ++i) {
            DesignElement child = (DesignElement)this.derived.get(i);
            list.add(child);
            child.gatherDescendents(list);
        }
    }

    public boolean hasUserProperties() {
        return this.userProperties != null && !this.userProperties.isEmpty();
    }

    public boolean hasLocalPropertyValues() {
        return !this.propValues.isEmpty();
    }

    public Iterator propertyWithLocalValueIterator() {
        return this.propValues.keySet().iterator();
    }

    public ContainerSlot getSlot(int slot) {
        return null;
    }

    public List getUserProperties() {
        ArrayList props = new ArrayList();
        for (DesignElement e = this; e != null; e = e.getExtendsElement()) {
            List prop = e.getLocalUserProperties();
            if (prop == null) continue;
            props.addAll(prop);
        }
        return props;
    }

    public List getLocalUserProperties() {
        if (this.userProperties == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(this.userProperties.values());
    }

    public boolean isKindOf(DesignElement element) {
        for (DesignElement e = this; e != null; e = e.getExtendsElement()) {
            if (e != element) continue;
            return true;
        }
        return false;
    }

    public boolean hasDerived() {
        return this.derived != null && this.derived.size() > 0;
    }

    public String getDisplayName() {
        return (String)this.getLocalProperty(null, "displayName");
    }

    public String getDisplayNameID() {
        return (String)this.getLocalProperty(null, "displayNameID");
    }

    public void setID(long newID) {
        this.id = newID;
    }

    public long getID() {
        return this.id;
    }

    public boolean isContentOf(DesignElement element) {
        DesignElement e = this;
        while (e != null) {
            if (e == element) {
                return true;
            }
            e = e.container;
        }
        return false;
    }

    public BigDecimal getNumberProperty(Module module, String propName) {
        Object value = this.getProperty(module, propName);
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        PropertyType type = MetaDataDictionary.getInstance().getPropertyType(prop.getTypeCode());
        return type.toNumber(module, value);
    }

    public abstract void apply(ElementVisitor var1);

    public String getStringProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        Object value = this.getProperty(module, prop);
        if (value == null) {
            return null;
        }
        return prop.getStringValue(module, value);
    }

    public String getDisplayProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        return this.getDisplayProperty(module, prop);
    }

    public String getDisplayProperty(Module module, PropertyDefn prop) {
        Object value = this.getProperty(module, prop);
        if (value == null) {
            return null;
        }
        return prop.getDisplayValue(module, value);
    }

    public void setExtendsName(String name) {
        this.setExtendsElement(null);
        name = StringUtil.trimString(name);
        if (name == null) {
            return;
        }
        String namespace = StringUtil.extractNamespace(name);
        name = StringUtil.extractName(name);
        this.extendsRef = new ElementRefValue(namespace, name);
    }

    public final List validateWithContents(Module module) {
        ElementDefn elementDefn = (ElementDefn)this.getDefn();
        List validatorList = ValidationExecutor.getValidationNodes(this, elementDefn.getTriggerDefnSet(), true);
        ValidationExecutor executor = module.getValidationExecutor();
        this.errors = executor.perform(this, validatorList);
        ArrayList list = new ArrayList(this.errors);
        int count = this.getDefn().getSlotCount();
        for (int i = 0; i < count; ++i) {
            Iterator iter = this.getSlot(i).iterator();
            while (iter.hasNext()) {
                list.addAll(((DesignElement)iter.next()).validateWithContents(module));
            }
        }
        return list;
    }

    public List validate(Module module) {
        this.errors = new ArrayList();
        this.errors.addAll(UnsupportedElementValidator.getInstance().validate(module, this));
        ArrayList propMasks = (ArrayList)this.getLocalProperty(module, "propertyMasks");
        if (propMasks != null) {
            ListIterator masks = propMasks.listIterator();
            while (masks.hasNext()) {
                PropertyMask mask = (PropertyMask)masks.next();
                this.errors.addAll(mask.validate(module, this));
            }
        }
        return this.errors;
    }

    protected List validateStructureList(Module module, String propName) {
        return StructureListValidator.getInstance().validate(module, this, propName);
    }

    public void checkStructureList(Module module, PropertyDefn propDefn, List list, IStructure toAdd) throws PropertyValueException {
        List errorList = StructureListValidator.getInstance().validateForAdding(this.getHandle(module), propDefn, list, toAdd);
        if (errorList.size() > 0) {
            throw (PropertyValueException)((Object)errorList.get(0));
        }
    }

    private boolean isExtendsValid(DesignElement parent) {
        try {
            this.checkExtends(parent);
        }
        catch (ExtendsException e) {
            return false;
        }
        return true;
    }

    public void checkExtends(DesignElement parent) throws ExtendsException {
        String extendsName = this.getExtendsName();
        IElementDefn defn = this.getDefn();
        if (parent == null) {
            throw new InvalidParentException(this, extendsName, "Error.InvalidParentException.PARENT_NOT_FOUND");
        }
        if (parent.getDefn() != defn) {
            throw new WrongTypeException(this, parent, "Error.WrongTypeException.WRONG_TYPE");
        }
        if (parent == this) {
            throw new CircularExtendsException(this, extendsName, "Error.CircularExtendsException.SELF_EXTEND");
        }
        if (parent.isKindOf(this)) {
            throw new CircularExtendsException(this, parent, "Error.CircularExtendsException.CIRCULAR");
        }
    }

    public int getIntProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return 0;
        }
        PropertyType type = MetaDataDictionary.getInstance().getPropertyType(prop.getTypeCode());
        Object value = this.getProperty(module, propName);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return type.toInteger(module, value);
    }

    public double getFloatProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return 0.0;
        }
        PropertyType type = MetaDataDictionary.getInstance().getPropertyType(prop.getTypeCode());
        Object value = this.getProperty(module, propName);
        if (value instanceof Double) {
            return (Double)value;
        }
        return type.toDouble(module, value);
    }

    public boolean getBooleanProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return false;
        }
        PropertyType type = MetaDataDictionary.getInstance().getPropertyType(prop.getTypeCode());
        Object value = this.getProperty(module, propName);
        return ((BooleanPropertyType)type).toBoolean(module, value);
    }

    public List getListProperty(Module module, String propName) {
        Object value = this.getProperty(module, propName);
        if (value == null) {
            return null;
        }
        if (value instanceof ArrayList) {
            return (ArrayList)value;
        }
        return null;
    }

    public List getPropertyDefns() {
        List list = this.getDefn().getProperties();
        for (DesignElement e = this; e != null; e = e.getExtendsElement()) {
            if (e.userProperties == null) continue;
            list.addAll(e.userProperties.values());
        }
        return list;
    }

    public abstract String getElementName();

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof DesignElementHandle) {
            return ((DesignElementHandle)obj).getElement() == this;
        }
        return false;
    }

    public int findSlotOf(DesignElement content) {
        if (content == null || content.getContainer() != this) {
            return -1;
        }
        return content.getContainerSlot();
    }

    public boolean canEdit() {
        return !this.isRootIncludedByModule();
    }

    public boolean canDrop() {
        List clients;
        if (this.isRootIncludedByModule()) {
            return false;
        }
        if (this.isVirtualElement()) {
            return false;
        }
        if (this.container instanceof TemplateParameterDefinition) {
            if (!$assertionsDisabled && this.containerSlotID != 0) {
                throw new AssertionError();
            }
            return false;
        }
        DesignElement element = this;
        return !(element instanceof TemplateParameterDefinition) || (clients = ((TemplateParameterDefinition)element).getClientList()).size() == 0;
    }

    public final boolean canContain(Module module, int slotId, DesignElement element) {
        List errors = this.checkContainmentContext(module, slotId, element);
        return errors.isEmpty();
    }

    public final List checkContainmentContext(Module module, int slotId, DesignElement element) {
        boolean retValue = this.canContainInRom(slotId, element.getDefn());
        ContentException e = new ContentException(this, slotId, element, "Error.ContentException.INVALID_CONTEXT_CONTAINMENT");
        List<ContentException> errors = new ArrayList<ContentException>();
        if (!retValue) {
            errors.add(e);
            return errors;
        }
        if (!this.canContainTemplateElement(module, slotId, element)) {
            errors.add(e);
            return errors;
        }
        if (this.isRootIncludedByModule()) {
            errors.add(e);
            return errors;
        }
        if (this.isVirtualElement() || this.getExtendsName() != null) {
            errors.add(e);
            return errors;
        }
        for (DesignElement tmpContainer = this; tmpContainer != null; tmpContainer = tmpContainer.getContainer()) {
            if (tmpContainer == element) {
                errors.add(e);
                return errors;
            }
            if (!(tmpContainer instanceof ListingElement) && !(tmpContainer instanceof Theme) && !(tmpContainer instanceof MasterPage)) continue;
            errors = tmpContainer.checkContent(module, this, slotId, element);
            return errors;
        }
        return Collections.EMPTY_LIST;
    }

    private boolean isRootIncludedByModule() {
        Module tmpContainer = this.getRoot();
        return tmpContainer instanceof Library && ((Library)tmpContainer).getHost() != null;
    }

    public final boolean canContain(Module module, int slotId, IElementDefn defn) {
        if (!$assertionsDisabled && defn == null) {
            throw new AssertionError();
        }
        boolean retValue = this.canContainInRom(slotId, defn);
        if (!retValue) {
            return false;
        }
        if (this.isRootIncludedByModule()) {
            return false;
        }
        if (!this.canContainTemplateElement(module, slotId, defn)) {
            return false;
        }
        if (this.isVirtualElement() || this.getExtendsName() != null) {
            return false;
        }
        for (DesignElement tmpContainer = this; tmpContainer != null; tmpContainer = tmpContainer.getContainer()) {
            if (!(tmpContainer instanceof ListingElement) && !(tmpContainer instanceof MasterPage)) continue;
            List errors = tmpContainer.checkContent(module, this, slotId, defn);
            return errors.isEmpty();
        }
        return retValue;
    }

    private boolean canContainInRom(int slotId, IElementDefn defn) {
        if (slotId < 0 || slotId >= this.getDefn().getSlotCount()) {
            return false;
        }
        ISlotDefn slotDefn = this.getDefn().getSlot(slotId);
        if (!$assertionsDisabled && slotDefn == null) {
            throw new AssertionError();
        }
        if (!slotDefn.canContain(defn)) {
            return false;
        }
        String name = defn.getName();
        if ("TemplateDataSet".equals(name) || "TemplateReportItem".equals(name) || "TemplateElement".equals(name)) {
            return true;
        }
        return this.getSlot(slotId).getCount() <= 0 || slotDefn.isMultipleCardinality();
    }

    private boolean canContainTemplateElement(Module module, int slotID, DesignElement element) {
        IElementDefn defn = MetaDataDictionary.getInstance().getElement("TemplateElement");
        if (element instanceof TemplateElement) {
            return this.canContainTemplateElement(module, slotID, defn);
        }
        ContentIterator contents = new ContentIterator(element);
        while (contents.hasNext()) {
            DesignElement content = (DesignElement)contents.next();
            if (!(content instanceof TemplateElement)) continue;
            return this.canContainTemplateElement(module, slotID, defn);
        }
        return true;
    }

    private boolean canContainTemplateElement(Module module, int slotID, IElementDefn defn) {
        if (defn != null && defn.isKindOf(MetaDataDictionary.getInstance().getElement("TemplateElement"))) {
            int slot = slotID;
            for (DesignElement container = this; container != null; container = container.getContainer()) {
                if (container instanceof Module && slot == 5 || container instanceof Library) {
                    return false;
                }
                slot = container.getContainerSlot();
            }
            if (module instanceof Library) {
                return false;
            }
        }
        return true;
    }

    protected List checkContent(Module module, DesignElement container, int slotId, DesignElement content) {
        return new ArrayList();
    }

    protected List checkContent(Module module, DesignElement container, int slotId, IElementDefn defn) {
        return new ArrayList();
    }

    public int getContainerSlot() {
        return this.containerSlotID;
    }

    public IObjectDefn getObjectDefn() {
        return this.getDefn();
    }

    public DesignElement getReferenceProperty(Module module, String propName) {
        ElementRefValue ref = (ElementRefValue)this.getProperty(module, propName);
        if (ref == null) {
            return null;
        }
        return ref.getElement();
    }

    public boolean hasReferences() {
        return false;
    }

    public Object getFactoryProperty(Module module, ElementPropertyDefn prop) {
        if (!$assertionsDisabled && prop.isStyleProperty()) {
            throw new AssertionError();
        }
        return this.getProperty(module, prop);
    }

    public Object getFactoryProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        return this.getFactoryProperty(module, prop);
    }

    public ElementRefValue resolveElementReference(Module module, ElementPropertyDefn prop) {
        Object value = this.propValues.get(prop.getName());
        if (!$assertionsDisabled && value != null && !(value instanceof ElementRefValue)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && prop.getTypeCode() != 15) {
            throw new AssertionError();
        }
        return this.resolveElementReference(module, prop, (ElementRefValue)value);
    }

    public StructRefValue resolveStructReference(Module module, ElementPropertyDefn prop) {
        Object value = this.propValues.get(prop.getName());
        if (!$assertionsDisabled && value != null && !(value instanceof StructRefValue)) {
            throw new AssertionError();
        }
        if (value == null || module == null) {
            return (StructRefValue)value;
        }
        StructRefValue ref = (StructRefValue)value;
        if (ref.isResolved()) {
            return ref;
        }
        StructRefPropertyType refType = (StructRefPropertyType)prop.getType();
        refType.resolve(module, prop, ref);
        if (ref.isResolved()) {
            ref.getTargetStructure().addClient(this, prop.getName());
        }
        return ref;
    }

    public List getDerived() {
        if (this.derived != null) {
            return new ArrayList(this.derived);
        }
        return new ArrayList();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public String getDisplayLabel(Module module, int level) {
        String displayLabel = ModelUtil.searchForExternalizedValue(this, "displayNameID", ThreadResources.getLocale());
        if (StringUtil.isBlank(displayLabel)) {
            displayLabel = this.getDisplayName();
        }
        if (StringUtil.isBlank(displayLabel)) {
            displayLabel = this.getNameForDisplayLabel();
        }
        if (level == 0) {
            return displayLabel;
        }
        MetaDataDictionary dictionary = MetaDataDictionary.getInstance();
        IElementDefn elementDefn = dictionary.getElement(this.getElementName());
        if (StringUtil.isBlank(displayLabel)) {
            displayLabel = elementDefn.getDisplayName();
        }
        if (StringUtil.isBlank(displayLabel)) {
            displayLabel = elementDefn.getName();
        }
        return displayLabel;
    }

    protected String getNameForDisplayLabel() {
        return this.getName();
    }

    protected String limitStringLength(String displayLabel) {
        if (displayLabel == null) {
            return null;
        }
        if (displayLabel.length() > 30) {
            int pos = (displayLabel = displayLabel.substring(0, 30)).lastIndexOf(" ");
            if (pos != -1) {
                displayLabel = displayLabel.substring(0, pos);
            }
            return displayLabel + "...";
        }
        return displayLabel;
    }

    public final Object clone() throws CloneNotSupportedException {
        return this.doClone(CopyForPastePolicy.getInstance());
    }

    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        int slotCount;
        DesignElement element = (DesignElement)this.baseClone();
        if (policy != null) {
            policy.execute(this, element);
        }
        if ((slotCount = this.getDefn().getSlotCount()) > 0) {
            element.slots = new ContainerSlot[slotCount];
            for (int i = 0; i < slotCount; ++i) {
                element.slots[i] = this.slots[i].copy(element, i, policy);
            }
        }
        return element;
    }

    protected final void initSlots() {
        int slotCount = this.getDefn().getSlotCount();
        if (slotCount == 0) {
            return;
        }
        this.slots = new ContainerSlot[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            SlotDefn slot = (SlotDefn)this.getDefn().getSlot(i);
            this.slots[i] = slot.isMultipleCardinality() ? new MultiElementSlot() : new SingleElementSlot();
        }
    }

    public List getErrors() {
        if (this.errors == null) {
            return new ArrayList();
        }
        return this.errors;
    }

    public String getIdentifier() {
        if (this.getName() != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getDefn().getDisplayName());
            sb.append("(\"");
            sb.append(this.getName());
            sb.append("\")");
            return sb.toString();
        }
        if (this instanceof ReportDesign) {
            return "report";
        }
        if (this instanceof Library) {
            return "library";
        }
        if (this.getContainer() == null) {
            return this.getDefn().getName();
        }
        ContainerSlot slot = this.getContainer().getSlot(this.getContainerSlot());
        ISlotDefn slotDefn = this.getContainer().getDefn().getSlot(this.getContainerSlot());
        StringBuffer sb = new StringBuffer();
        sb.append(this.getContainer().getIdentifier());
        sb.append(".");
        sb.append(slotDefn.getDisplayName());
        sb.append("[");
        sb.append(slot.findPosn(this));
        sb.append("]");
        return sb.toString();
    }

    public void setBaseId(long baseId) {
        this.baseId = baseId;
    }

    public long getBaseId() {
        return this.baseId;
    }

    public void clearAllProperties() {
        this.name = null;
        this.extendsRef = null;
        this.propValues.clear();
    }

    public boolean isManagedByNameSpace(int slotID) {
        if (this.getRoot() == null) {
            return false;
        }
        int slot = slotID;
        for (DesignElement containerObj = this; containerObj != null; containerObj = containerObj.getContainer()) {
            ElementDefn defn = (ElementDefn)containerObj.getDefn();
            SlotDefn slotInfo = (SlotDefn)defn.getSlot(slot);
            if (slotInfo != null && !slotInfo.isManagedByNameSpace()) {
                return false;
            }
            slot = containerObj.getContainerSlot();
        }
        return true;
    }

    public boolean isManagedByNameSpace() {
        if (this.getContainer() == null) {
            return false;
        }
        return this.getContainer().isManagedByNameSpace(this.getContainerSlot());
    }

    public final boolean canTransformToTemplate(Module module) {
        if (!ModelUtil.isTemplateSupported(this) || !this.canDrop()) {
            return false;
        }
        IElementDefn templateReportItem = MetaDataDictionary.getInstance().getElement("TemplateReportItem");
        IElementDefn templateDataSet = MetaDataDictionary.getInstance().getElement("TemplateDataSet");
        if (this.container != null) {
            return this.container.canContain(module, this.containerSlotID, templateReportItem) || this.container.canContain(module, this.containerSlotID, templateDataSet);
        }
        return true;
    }

    public boolean isTemplateParameterValue(Module module) {
        return this.getTemplateParameterElement(module) != null;
    }

    public List resolveElementReferenceList(Module module, ElementPropertyDefn prop) {
        Object value = this.propValues.get(prop.getName());
        if (!$assertionsDisabled && value != null && !(value instanceof List)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || prop.getTypeCode() == 20 && prop.getSubTypeCode() == 15)) {
            throw new AssertionError();
        }
        if (value == null) {
            return null;
        }
        List valueList = (List)value;
        for (int i = 0; i < valueList.size(); ++i) {
            ElementRefValue item = (ElementRefValue)valueList.get(i);
            this.resolveElementReference(module, prop, item);
        }
        return valueList;
    }

    public ElementRefValue resolveElementReference(Module module, ElementPropertyDefn prop, ElementRefValue value) {
        if (value == null || module == null) {
            return value;
        }
        ElementRefValue ref = value;
        if (ref.isResolved()) {
            return ref;
        }
        if (!$assertionsDisabled && prop.getTypeCode() != 15 && prop.getSubTypeCode() != 15) {
            throw new AssertionError();
        }
        ElementRefPropertyType refType = null;
        refType = prop.getTypeCode() == 15 ? (ElementRefPropertyType)prop.getType() : (ElementRefPropertyType)prop.getSubType();
        refType.resolve(module, prop, ref);
        if (ref.isResolved()) {
            ref.getTargetElement().addClient(this, prop.getName());
        }
        return ref;
    }

    public void checkSimpleList(Module module, PropertyDefn propDefn, List list, Object toAdd) throws PropertyValueException {
        List errorList = SimpleListValidator.getInstance().validateForAdding(this.getHandle(module), propDefn, list, toAdd);
        if (errorList.size() > 0) {
            throw (PropertyValueException)((Object)errorList.get(0));
        }
    }

    private final Object baseClone() throws CloneNotSupportedException {
        String key;
        DesignElement element = (DesignElement)super.clone();
        element.container = null;
        element.listeners = null;
        element.derived = null;
        element.cachedDefn = null;
        element.handle = null;
        element.propValues = new HashMap();
        if (this.extendsRef != null) {
            element.extendsRef = (ElementRefValue)this.extendsRef.copy();
        }
        Iterator iter = null;
        if (!this.isVirtualElement() && this.userProperties != null) {
            element.userProperties = new LinkedHashMap();
            iter = this.userProperties.keySet().iterator();
            while (iter.hasNext()) {
                key = iter.next();
                UserPropertyDefn uDefn = (UserPropertyDefn)this.userProperties.get(key);
                element.userProperties.put(key, uDefn.copy());
            }
        }
        iter = this.propValues.keySet().iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            ElementPropertyDefn propDefn = this.getPropertyDefn(key);
            Object value = this.propValues.get(key);
            element.propValues.put(key, ModelUtil.copyValue(propDefn, value));
        }
        return element;
    }

    static {
        $assertionsDisabled = !DesignElement.class.desiredAssertionStatus();
    }
}

