/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public abstract class PropertyStructure
extends Structure {
    protected HashMap propValues = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public Object getLocalProperty(Module module, PropertyDefn propDefn) {
        if (propDefn.isIntrinsic()) {
            return this.getIntrinsicProperty(propDefn.getName());
        }
        return this.propValues.get(propDefn.getName());
    }

    public Object getLocalProperty(Module module, String memberName) {
        PropertyDefn prop = (PropertyDefn)this.getDefn().getMember(memberName);
        if (prop == null) {
            return null;
        }
        return this.getLocalProperty(module, prop);
    }

    public final void setProperty(PropertyDefn prop, Object value) {
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        if (prop.isIntrinsic()) {
            this.setIntrinsicProperty(prop.getName(), value);
        } else if (value == null) {
            this.propValues.remove(prop.getName());
        } else {
            this.propValues.put(prop.getName(), value);
        }
    }

    protected Object getIntrinsicProperty(String propName) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    protected void setIntrinsicProperty(String propName, Object value) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PropertyStructure clone = (PropertyStructure)super.clone();
        clone.propValues = new HashMap();
        Iterator iter = this.propValues.keySet().iterator();
        while (iter.hasNext()) {
            String memberName = (String)iter.next();
            IPropertyDefn memberDefn = this.getDefn().getMember(memberName);
            Cloneable value = null;
            value = memberDefn.getTypeCode() == 16 ? (memberDefn.isList() ? this.cloneStructList((ArrayList)this.propValues.get(memberName)) : ((Structure)this.propValues.get(memberName)).copy()) : (Cloneable)this.propValues.get(memberName);
            clone.propValues.put(memberName, value);
        }
        return clone;
    }

    private ArrayList cloneStructList(ArrayList list) {
        if (list == null) {
            return null;
        }
        ArrayList<IStructure> returnList = new ArrayList<IStructure>();
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            if (item instanceof Structure) {
                returnList.add(((Structure)item).copy());
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        return returnList;
    }

    static {
        $assertionsDisabled = !PropertyStructure.class.desiredAssertionStatus();
    }
}

