/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.elements.structures.IncludeScript;
import org.eclipse.birt.report.model.api.validators.MasterPageRequiredValidator;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.interfaces.IReportDesignModel;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.writer.DesignWriter;
import org.eclipse.birt.report.model.writer.ModuleWriter;

public class ReportDesign
extends Module
implements IReportDesignModel {
    static final /* synthetic */ boolean $assertionsDisabled;

    public ReportDesign() {
        super((DesignSession)null);
        this.initSlots();
        this.onCreate();
    }

    public ReportDesign(DesignSession session) {
        super(session);
        this.initSlots();
        this.onCreate();
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitReportDesign(this);
    }

    public List validate(Module module) {
        List list = super.validate(module);
        list.addAll(MasterPageRequiredValidator.getInstance().validate(this, this));
        list.addAll(this.validateStructureList(module, "images"));
        list.addAll(this.validateStructureList(module, "colorPalette"));
        list.addAll(this.validateStructureList(module, "includeScripts"));
        list.addAll(this.validateStructureList(module, "libraries"));
        list.addAll(this.validateStructureList(module, "propertyBindings"));
        return list;
    }

    public String getElementName() {
        return "ReportDesign";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle();
    }

    public ReportDesignHandle handle() {
        if (this.handle == null) {
            this.handle = new ReportDesignHandle(this);
        }
        return (ReportDesignHandle)this.handle;
    }

    public IncludeScript findIncludeScript(String fileName) {
        ArrayList list = (ArrayList)this.getLocalProperty(null, "includeScripts");
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            IncludeScript script = (IncludeScript)list.get(i);
            if (script.getFileName() == null || !script.getFileName().equals(fileName)) continue;
            return script;
        }
        return null;
    }

    protected int getSlotCount() {
        return 9;
    }

    public ModuleWriter getWriter() {
        return new DesignWriter(this);
    }

    public List collectPropValues(int slotId, String propName) {
        ArrayList<String> rtnList = new ArrayList<String>();
        ContentIterator contents = new ContentIterator(this, slotId);
        while (contents.hasNext()) {
            DesignElement ele = (DesignElement)contents.next();
            String str = ele.getStringProperty(this, propName);
            if (str == null) continue;
            rtnList.add(str);
        }
        return rtnList;
    }

    public byte[] getThumbnail() {
        String data = this.getStringProperty(this, "thumbnail");
        if (data == null) {
            return null;
        }
        try {
            return data.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    public ModuleOption getOptions() {
        return this.options;
    }

    static {
        $assertionsDisabled = !ReportDesign.class.desiredAssertionStatus();
    }
}

