/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.scanner;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.subagent.scanner.interfaces.IScanner;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneCapabilities;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneConstants;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces.ZoneControlAgent;
import org.eclipse.aperi.sanmgmt.util.InterpResolver;

public class InbandZoneControl
extends ZoneControlAgent {
    static final String className;
    private boolean is_library_opened = false;
    private IScanner scanner = null;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.agent.scanner.InbandZoneControl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        msgLogger = ZoneConstants.zcAgentMsgLogger;
        traceLogger = ZoneConstants.zcAgentTraceLogger;
        String string = System.getProperty("os.name");
        String string2 = null;
        string2 = InterpResolver.isWindows((String)string) ? "sniahbaapi" : "hbaapi";
        if (!InterpResolver.isAIX((String)string)) {
            System.loadLibrary(string2);
        }
        System.loadLibrary("GS3ZoneControl");
    }

    private static native int EstablishSession(String var0);

    private static native int CloseSession(int var0);

    private static native int SetCreateZoneSetBuffer(int var0, String var1, int var2, char[] var3);

    private static native int AddZoneToCreateZoneSetBuffer(int var0, char[] var1, String var2, int var3, int var4, char[][] var5, short[] var6);

    private static native int CreateZoneSetFromBuffer(int var0, char[] var1, int var2, int var3, String var4);

    private static native int DeleteZoneSet(int var0, String var1, String var2);

    private static native int DeactivateZoneSet(int var0, String var1, String var2);

    private static native int ActivateZoneSet(int var0, String var1, String var2);

    private static native int ping(String var0, int var1);

    private static native int OpenLibrary();

    private static native void CloseLibrary();

    private static native String GetCurrentZoningInfo(int var0);

    private static native int sendCommand(int var0, String var1, char[] var2, int var3, char[] var4, int var5);

    private static native int isFullZoneDBSupported(int var0);

    private static native int getDomainPortCapability(int var0);

    private static native int isCiscoADZSWorkaroundNeeded(int var0);

    private static native int AddZoneToZoneSet(int var0, String var1, String var2, String var3);

    private static native int AddMembersToRemoveZoneMembersBuffer(int var0, char[] var1, String var2, int var3, char[][] var4, short[] var5);

    private static native int RemoveMembersFromBuffer(int var0, char[] var1, int var2, String var3);

    private static native int isCNTRZMWorkaroundNeeded(int var0);

    private static native void GetSwitchVendorIds(int var0, String[] var1);

    private static native int CreateZoneAlias(int var0, String var1, int var2, char[][] var3, short[] var4);

    private static native int DeleteZoneAlias(int var0, String var1);

    private static native int AddZoneAliasToZone(int var0, String var1, String var2);

    private static native int AddZoneMemberToZoneAlias(int var0, String var1, String var2);

    private static native int AddZoneMemberDomainPortToZoneAlias(int var0, long var1, long var3, String var5);

    private static native int RemoveZoneAliasFromZone(int var0, String var1, String var2);

    private static native int RemoveZoneMemberFromZoneAlias(int var0, String var1, String var2);

    private static native int RemoveZoneMemberDomainPortFromZoneAlias(int var0, long var1, long var3, String var5);

    private static native int DeleteZoneMember(int var0, String var1);

    private static native int DeleteZoneMemberDomainPort(int var0, long var1, long var3);

    private static native int AddZoneToZoneSet(int var0, String var1, String var2);

    private static native int AddZoneMemberToZone(int var0, String var1, String var2);

    private static native int AddZoneMemberDomainPortToZone(int var0, long var1, long var3, String var5);

    private static native int RemoveZoneFromZoneSet(int var0, String var1, String var2);

    private static native int RemoveZoneMemberFromZone(int var0, String var1, String var2);

    private static native int RemoveZoneMemberDomainPortFromZone(int var0, long var1, long var3, String var5);

    private static native int ActivateTransaction(int var0);

    private static native int CommitTransaction(int var0);

    private static native int RollbackTransaction(int var0);

    private static native int DeleteZone(int var0, String var1);

    public InbandZoneControl() {
        String string = "InbandZoneControl";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
        }
        this.is_library_opened = this.openLibraryGS3() == 0;
    }

    public ZoneCapabilities getCapabilities(String string) {
        String string2 = "getCapabilities";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        try {
            ZoneCapabilities zoneCapabilities = new ZoneCapabilities();
            zoneCapabilities.setSupportsNodeWWN(false);
            zoneCapabilities.setSupportsAliases(false);
            zoneCapabilities.setAllowsNumericNameStart(false);
            zoneCapabilities.setMaxMembersInAlias(-1);
            zoneCapabilities.setMaxMembersInZone(-1);
            zoneCapabilities.setMaxNameLength(64);
            zoneCapabilities.setMaxZones(-1);
            zoneCapabilities.setMaxZoneSets(-1);
            zoneCapabilities.setMaxZonesInSet(-1);
            zoneCapabilities.setSupportsEmptyZoneAliases(false);
            zoneCapabilities.setSupportsEmptyZones(true);
            zoneCapabilities.setSupportsEmptyZoneSets(false);
            zoneCapabilities.setMaxZoneAliases(0);
            zoneCapabilities.setMaxZoneMembers(-1);
            int n = this.getDomainPortCapabilityGS3((Integer)this.SANtoHandle.get(string));
            if (n == 1) {
                zoneCapabilities.setSupportsDomainPort(true);
            } else {
                zoneCapabilities.setSupportsDomainPort(false);
            }
            int n2 = this.isFullZoneDBSupportedGS3((Integer)this.SANtoHandle.get(string));
            if (n2 == 1) {
                zoneCapabilities.setSupportsFullZoneDB(true);
                zoneCapabilities.setSupportsFCID(true);
                zoneCapabilities.setZcAgentType(1);
            } else {
                zoneCapabilities.setMaxZoneSets(1);
                zoneCapabilities.setSupportsFullZoneDB(false);
                zoneCapabilities.setSupportsFCID(false);
                zoneCapabilities.setZcAgentType(2);
            }
            zoneCapabilities.setSupportsOrphanZoneAliases(false);
            zoneCapabilities.setSupportsOrphanZones(false);
            zoneCapabilities.setSupportsSpecialCharacters(true);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Capabilities of SAN " + string + " are " + zoneCapabilities.toString());
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
            }
            return zoneCapabilities;
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string2, (Throwable)exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
            }
            return null;
        }
    }

    public int ping(String string, String[] stringArray) {
        int n;
        String string2;
        block8: {
            string2 = "ping";
            n = 1111;
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
            }
            if (this.is_library_opened) break block8;
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
            }
            return 221997;
        }
        try {
            int n2 = (Integer)this.SANtoHandle.get(string);
            n = this.pingGS3(string, n2);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Pinged SAN " + string + ". Return code " + n + ".");
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string2, (Throwable)exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
            }
            n = 221111;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n;
    }

    public int lock(String string, String[] stringArray) {
        int n;
        String string2;
        block9: {
            block8: {
                string2 = "lock";
                n = -1;
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
                }
                if (this.is_library_opened) break block8;
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
                }
                return 1;
            }
            try {
                n = this.establishSessionGS3(string);
                if (n > 0 && this.SANtoHandle.get(string) == null) {
                    this.SANtoHandle.put(string, Integer.valueOf(Integer.toString(n)));
                }
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Locked resource: " + string + ".");
                }
            }
            catch (Exception exception) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string2, (Throwable)exception);
                if (!traceLogger.isLogging()) break block9;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n > 0 ? 0 : 1;
    }

    public int startTransaction(String string) {
        String string2;
        block7: {
            string2 = "startTransaction";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
            }
            this.activateOnCommit = false;
            try {
                if (this.is_library_opened) break block7;
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
                }
                return 11997;
            }
            catch (Exception exception) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string2, (Throwable)exception);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
                }
                return 11111;
            }
        }
        this.SANtoCommands.remove(string);
        this.SANtoCommands.put(string, new ArrayList());
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return 0;
    }

    public int rollbackTransaction(String string) {
        int n = 0;
        String string2 = "rollbackTransaction";
        try {
            ArrayList arrayList;
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
            }
            if ((arrayList = (ArrayList)this.SANtoCommands.remove(string)) != null) {
                arrayList.clear();
                this.SANtoCommands.put(string, arrayList);
            }
            Integer n2 = (Integer)this.SANtoHandle.get(string);
            ZoneDefinition zoneDefinition = (ZoneDefinition)this.SANtoZoneDef.get(string);
            if (n2 != null && zoneDefinition != null) {
                ZoneDefinition zoneDefinition2 = (ZoneDefinition)this.SANtoZoneDef.get(string);
                ZoneDefinition zoneDefinition3 = new ZoneDefinition();
                n = this.readCurrentZoneDefinition(string, zoneDefinition3);
                n = n == 0 ? this.sendCommandsToSwitch(string, zoneDefinition2, zoneDefinition3, 1) : 21999;
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string2, (Throwable)exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
            }
            n = 21111;
        }
        if (n != 0 && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string2, "Failed to rollback transaction on SAN " + string + ".  Err = " + n);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n;
    }

    private int addZonesToZoneSet(int n, String string, String string2, Zone[] zoneArray) {
        int n2 = 0;
        String string3 = "addZonesToZoneSet";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
        }
        int n3 = 0;
        while (n3 < zoneArray.length) {
            Zone cfr_ignored_0 = zoneArray[n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < zoneArray.length) {
            n2 = this.addZoneToZoneSetGS3(n, string2, zoneArray[n3].getName(), string);
            if (n2 != 0) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string3, "Unable to add zone " + zoneArray[n3].getName() + " to ZoneSet " + string2 + " on SAN " + string + ".  Err = " + n2);
                }
                return n2;
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "Added zone " + zoneArray[n3].getName() + " to ZoneSet: " + string2 + ", SAN: " + string);
            }
            ++n3;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        return n2;
    }

    private int createZoneSet(String string, String string2, ZoneDefinition zoneDefinition, Zone[] zoneArray, boolean bl) {
        int n = 0;
        String string3 = "createZoneSet";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < zoneArray.length) {
            Zone zone = zoneArray[n3];
            n2 += 72;
            ZoneMember[] zoneMemberArray = zoneDefinition.getMembers(zone);
            n2 += 12 * zoneMemberArray.length;
            ++n3;
        }
        n2 += 88;
        char[] cArray = new char[n2 /= 2];
        int n4 = (Integer)this.SANtoHandle.get(string);
        int n5 = this.setCreateZoneSetBufferGS3(n4, string2, zoneArray.length, cArray);
        int n6 = 0;
        while (n6 < zoneArray.length) {
            ZoneMember[] zoneMemberArray = zoneDefinition.getMembers(zoneArray[n6]);
            String[] stringArray = new String[zoneMemberArray.length];
            short[] sArray = new short[zoneMemberArray.length];
            int n7 = 0;
            while (n7 < zoneMemberArray.length) {
                stringArray[n7] = zoneMemberArray[n7].getName();
                sArray[n7] = zoneMemberArray[n7].getType();
                ++n7;
            }
            n5 = this.addZoneToCreateZoneSetBufferGS3(n4, string, cArray, zoneArray[n6].getName(), n5, zoneMemberArray.length, stringArray, sArray);
            ++n6;
        }
        n6 = 0;
        if (bl) {
            n6 = 1;
        }
        if ((n = this.createZoneSetFromBufferGS3(n4, cArray, n6, n5, string)) != 0) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string3, "Unable to create ZoneSet " + string2 + " on SAN " + string + ".  Err = " + n);
            }
            msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string3, "ZoneControl_ErrGS3CreateZoneSet", (Object)string2, (Object)string);
            return n;
        }
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "Created ZoneSet: " + string2 + ", SAN: " + string);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        return n;
    }

    protected int sendCommandsToSwitch(String string, ZoneDefinition zoneDefinition, ZoneDefinition zoneDefinition2, int n) {
        String string2 = "sendCommandsToSwitch";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        int n2 = 0;
        int n3 = (Integer)this.SANtoHandle.get(string);
        n2 = this.checkIfNonStdMembersExist(zoneDefinition2, string);
        if (n2 != 0) {
            return n2;
        }
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        this.findSameZoneEntities(zoneDefinition2, zoneDefinition, hashMap, null, hashMap2);
        n2 = this.deactivateIfNecessary(zoneDefinition2, zoneDefinition, n, string, n3);
        if (n2 == 0) {
            n2 = this.deleteUnneededZoneSets(zoneDefinition2, zoneDefinition, n, string, n3);
        }
        if (n2 == 0) {
            n2 = this.createNewZoneSets(hashMap, zoneDefinition, string);
        }
        if (n2 == 0) {
            n2 = this.ciscoADZSWorkaroundIfNecessary(hashMap, zoneDefinition, string, n3);
        }
        if (n2 == 0) {
            n2 = this.CNTRZMWorkaroundIfNecessary(zoneDefinition, zoneDefinition2, string, n3, hashMap2);
        }
        if (n2 == 0) {
            n2 = this.activateIfNecessary(zoneDefinition, n, string, n3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n2;
    }

    private int checkIfNonStdMembersExist(ZoneDefinition zoneDefinition, String string) {
        String string2 = "checkIfNonStdMembersExist";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        int n = 0;
        ZoneMember[] zoneMemberArray = zoneDefinition.getMembers();
        int n2 = 0;
        while (n2 < zoneMemberArray.length) {
            if (zoneMemberArray[n2].getType() != 11 && zoneMemberArray[n2].getType() != 12 && zoneMemberArray[n2].getType() != 13 && zoneMemberArray[n2].getType() != 14) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string2, "Unable to make changes to SAN " + string + "since old definition has a non-standard zone member type " + zoneMemberArray[n2].getType() + " for member " + zoneMemberArray[n2].getName());
                }
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string2, "ZoneControl_ErrNonStandardZoneMembersPresent", (Object)string);
                return 281112;
            }
            ++n2;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n;
    }

    private int ciscoADZSWorkaroundIfNecessary(HashMap hashMap, ZoneDefinition zoneDefinition, String string, int n) {
        String string2 = "ciscoADZSWorkaroundIfNecessary";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        int n2 = 0;
        int n3 = this.isCiscoADZSWorkaroundNeededGS3(n);
        if (n3 == 1) {
            ZoneSet[] zoneSetArray = zoneDefinition.getZoneSets();
            int n4 = 0;
            while (n4 < zoneSetArray.length) {
                Zone[] zoneArray = zoneDefinition.getZones(zoneSetArray[n4]);
                String[] stringArray = new String[zoneArray.length];
                int n5 = 0;
                while (n5 < zoneArray.length) {
                    stringArray[n5] = zoneArray[n5].getName();
                    ++n5;
                }
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Adding zones to zoneset " + zoneSetArray[n4].getName() + " on SAN " + string + " due to the Cisco ADZS issue");
                }
                if ((n2 = this.addZonesToZoneSet(n, string, zoneSetArray[n4].getName(), zoneArray)) != 0) {
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string2, "Unable to add zonest to ZoneSet (Cisco ADZS workaround)" + zoneSetArray[n4].getName() + " on SAN " + string + ".  Err = " + n2);
                    }
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string2, "ZoneControl_ErrGS3CreateZoneSet", (Object)zoneSetArray[n4].getName(), (Object)string);
                    return n2;
                }
                ++n4;
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n2;
    }

    private int CNTRZMWorkaroundIfNecessary(ZoneDefinition zoneDefinition, ZoneDefinition zoneDefinition2, String string, int n, HashMap hashMap) {
        String string2 = "CNTRZMWorkaroundIfNecessary";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        int n2 = 0;
        int n3 = this.isCNTRZMWorkaroundNeededGS3(n);
        if (n3 == 1) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "CNT RZM workaround is needed on SAN " + string);
            }
        } else if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "CNT RZM workaround is not needed on SAN " + string);
        }
        if (n3 == 1) {
            Zone[] zoneArray = zoneDefinition.getZones();
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Number of zones in new definition is " + zoneArray.length + " for SAN " + string);
            }
            int n4 = 0;
            while (n4 < zoneArray.length) {
                String string3 = zoneArray[n4].getName();
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Checking if any members need to be removed for zone " + string3 + " for SAN " + string);
                }
                if (hashMap.containsKey(string3)) {
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "zone " + string3 + " in like zone map " + " for SAN " + string);
                    }
                } else {
                    Zone zone = zoneDefinition2.getZone(string3);
                    if (zone == null) {
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "zone " + string3 + " is not in old zone definition " + " for SAN " + string);
                        }
                    } else {
                        int n5;
                        ZoneMember[] zoneMemberArray = zoneDefinition2.getMembers(zone);
                        Zone zone2 = zoneDefinition.getZone(string3);
                        ZoneMember[] zoneMemberArray2 = zoneDefinition.getMembers(zone2);
                        String[] stringArray = new String[zoneMemberArray.length];
                        short[] sArray = new short[zoneMemberArray.length];
                        int n6 = 0;
                        int n7 = 0;
                        while (n7 < zoneMemberArray.length) {
                            String string4 = zoneMemberArray[n7].getName();
                            short s = zoneMemberArray[n7].getType();
                            boolean bl = true;
                            n5 = 0;
                            while (n5 < zoneMemberArray2.length) {
                                String string5 = zoneMemberArray2[n5].getName();
                                short s2 = zoneMemberArray2[n5].getType();
                                if (string4.equals(string5) && s == s2) {
                                    bl = false;
                                    break;
                                }
                                ++n5;
                            }
                            if (bl) {
                                if (traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "zone " + string3 + " member  " + string4 + " is only in old def and needs to be removed " + " for SAN " + string);
                                }
                                stringArray[n6] = string4;
                                sArray[n6] = s;
                                ++n6;
                            }
                            ++n7;
                        }
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, " number of members to be removed for zone " + string3 + "is " + n6 + " for SAN " + string);
                        }
                        String[] stringArray2 = new String[n6];
                        short[] sArray2 = new short[n6];
                        n5 = 0;
                        while (n5 < n6) {
                            stringArray2[n5] = stringArray[n5];
                            sArray2[n5] = sArray[n5];
                            ++n5;
                        }
                        if (n6 > 0) {
                            if (traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Removing members in old def for zone " + string3 + " on SAN " + string + " due to the CNT RZM issue");
                            }
                            n5 = 0;
                            n5 += 84;
                            n5 += 12 * n6;
                            char[] cArray = new char[n5 /= 2];
                            int n8 = this.AddMembersToRemoveZoneMembersBufferGS3(n, string, cArray, string3, n6, stringArray2, sArray2);
                            if (traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, " buffer index in response buffer  for removing members in old def for zone " + string3 + " on SAN " + string + " due to the CNT RZM issue" + " is " + n8);
                            }
                            if ((n2 = this.RemoveMembersFromBufferGS3(n, cArray, n8, string)) != 0) {
                                if (traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string2, "Unable to remove members for zone (CNT RZM workaround)" + string3 + " on SAN " + string + ".  Err = " + n2);
                                }
                                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string2, "ZoneControl_ErrGS3CreateZoneSet", (Object)string3, (Object)string);
                                return n2;
                            }
                        }
                    }
                }
                ++n4;
            }
        } else if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "No CNT RZM workaround needed on SAN " + string);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n2;
    }

    private int activateIfNecessary(ZoneDefinition zoneDefinition, int n, String string, int n2) {
        boolean bl;
        String string2 = "activateIfNecessary";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        int n3 = 0;
        boolean bl2 = n == 2 || n == 1;
        ZoneSet zoneSet = zoneDefinition.getActiveZoneSet();
        boolean bl3 = bl = zoneSet != null && zoneSet.getName() != null;
        if (bl && this.getCapabilities(string).isSupportsFullZoneDB() && bl2 && n3 == 0) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "activating zoneset " + zoneSet.getName() + " on SAN " + string + " since there is new active zoneset in new def or active zoneset needs to be reactivated");
            }
            if ((n3 = this.activateZoneSetGS3(n2, zoneSet.getName(), string)) != 0) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string2, "Unable to activate ZoneSet" + zoneSet.getName() + " on SAN " + string + ".  Err = " + n3);
                }
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string2, "ZoneControl_ErrGS3activateZoneSet", (Object)zoneSet.getName(), (Object)string);
                return n3;
            }
        } else if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "will not activate zoneset  on SAN " + string + " since zone_db_code is " + n + " and there is possibly no active zoneset in new def " + " or full zone db is not supported by SAN ");
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n3;
    }

    private int createNewZoneSets(HashMap hashMap, ZoneDefinition zoneDefinition, String string) {
        String string2 = "createNewZoneSets";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        int n = 0;
        ZoneSet[] zoneSetArray = zoneDefinition.getZoneSets();
        int n2 = 0;
        while (n2 < zoneSetArray.length) {
            if (hashMap.get(zoneSetArray[n2].getName()) == null && n == 0) {
                Zone[] zoneArray = zoneDefinition.getZones(zoneSetArray[n2]);
                String[] stringArray = new String[zoneArray.length];
                int n3 = 0;
                while (n3 < zoneArray.length) {
                    stringArray[n3] = zoneArray[n3].getName();
                    ++n3;
                }
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Creating zoneset " + zoneSetArray[n2].getName() + " on SAN " + string + " since it exists in new def");
                }
                if ((n = this.createZoneSet(string, zoneSetArray[n2].getName(), zoneDefinition, zoneArray, false)) != 0) {
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string2, "Unable to create ZoneSet" + zoneSetArray[n2].getName() + " on SAN " + string + ".  Err = " + n);
                    }
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string2, "ZoneControl_ErrGS3CreateZoneSet", (Object)zoneSetArray[n2].getName(), (Object)string);
                    return n;
                }
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "zoneset " + zoneSetArray[n2].getName() + " on SAN " + string + " exists in likeZoneSetsMap will not be created");
            }
            ++n2;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n;
    }

    private int deleteUnneededZoneSets(ZoneDefinition zoneDefinition, ZoneDefinition zoneDefinition2, int n, String string, int n2) {
        String string2 = "deleteUnneededZoneSets";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        int n3 = 0;
        if (this.getCapabilities(string).isSupportsFullZoneDB()) {
            ZoneSet[] zoneSetArray = zoneDefinition.getZoneSets();
            int n4 = 0;
            while (n4 < zoneSetArray.length) {
                if (zoneDefinition2.getZoneSet(zoneSetArray[n4].getName()) == null && n3 == 0) {
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Deleting zoneset " + zoneSetArray[n4].getName() + " on SAN " + string + " since it is not in new def");
                    }
                    if ((n3 = this.deleteZoneSetGS3(n2, zoneSetArray[n4].getName(), string)) != 0) {
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string2, "Unable to delete ZoneSet" + zoneSetArray[n4].getName() + " on SAN " + string + ".  Err = " + n3);
                        }
                        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string2, "ZoneControl_ErrGS3DeleteZoneSet", (Object)zoneSetArray[n4].getName(), (Object)string);
                        return n3;
                    }
                }
                ++n4;
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n3;
    }

    private int deactivateIfNecessary(ZoneDefinition zoneDefinition, ZoneDefinition zoneDefinition2, int n, String string, int n2) {
        String string2 = "deactivateIfNecessary";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        int n3 = 0;
        boolean bl = n == 2 || n == 1;
        ZoneSet zoneSet = zoneDefinition.getActiveZoneSet();
        ZoneSet zoneSet2 = zoneDefinition2.getActiveZoneSet();
        if (zoneSet != null && zoneSet2 == null && bl) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Deactivating zoneset " + zoneSet.getName() + " on SAN " + string + " since there is no active zoneset in new def");
            }
            if ((n3 = this.deactivateZoneSetGS3(n2, zoneSet.getName(), string)) != 0) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string2, "Unable to deactivate ZoneSet" + zoneSet.getName() + " on SAN " + string + ".  Err = " + n3);
                }
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string2, "ZoneControl_ErrGS3DeactivateZoneSet", (Object)zoneSet.getName(), (Object)string);
                return n3;
            }
        } else if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "No zoneset needs to be deactivated  on SAN " + string + " since active zoneset exists in new def or no active zoneset in old def " + " full zone db cap is " + this.getCapabilities(string).isSupportsFullZoneDB() + " zone_db_code is " + n);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n3;
    }

    private int getGS3Err(int n) {
        int n2 = n;
        n2 = n2 == -4 ? Math.abs(n2) + 100 : Math.abs(n2);
        return n2;
    }

    public void finalize() {
        block4: {
            String string = "finalize";
            try {
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
                }
                this.closeLibraryGS3();
                this.is_library_opened = false;
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
                }
            }
            catch (Exception exception) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                if (!traceLogger.isLogging()) break block4;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
    }

    private int establishSessionGS3(String string) {
        String string2 = "establishSessionGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "san = " + string);
        }
        int n = InbandZoneControl.EstablishSession(string);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n;
    }

    protected int closeSessionNative(int n) {
        int n2;
        String string = "closeSessionNative";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if ((n2 = InbandZoneControl.CloseSession(n)) != 0) {
            n2 = this.getGS3Err(n2) + 240000;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return n2;
    }

    private int setCreateZoneSetBufferGS3(int n, String string, int n2, char[] cArray) {
        String string2 = "setCreateZoneSetBufferGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "zoneSetName = " + string + ". numZones = " + n2);
        }
        int n3 = InbandZoneControl.SetCreateZoneSetBuffer(n, string, n2, cArray);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n3;
    }

    private int addZoneToCreateZoneSetBufferGS3(int n, String string, char[] cArray, String string2, int n2, int n3, String[] stringArray, short[] sArray) {
        String string3 = "addZoneToCreateZoneSetBufferGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "zoneName = " + string2 + ". bufferIndex " + n2 + ". numMembers = " + n3);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "ZoneMembers: ");
            if (stringArray.length == sArray.length) {
                int n4 = 0;
                while (n4 < stringArray.length) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, String.valueOf(stringArray[n4]) + " , " + sArray[n4]);
                    ++n4;
                }
            }
        }
        char[][] cArray2 = new char[stringArray.length][this.getCapabilities(string).getMaxNameLength()];
        int n5 = 0;
        while (n5 < stringArray.length) {
            char[] cArray3 = new char[this.getCapabilities(string).getMaxNameLength()];
            cArray3 = stringArray[n5].toCharArray();
            int n6 = 0;
            while (n6 < stringArray[n5].length()) {
                cArray2[n5][n6] = cArray3[n6];
                ++n6;
            }
            cArray2[n5][n6] = '\u0000';
            ++n5;
        }
        n2 = InbandZoneControl.AddZoneToCreateZoneSetBuffer(n, cArray, string2, n2, n3, cArray2, sArray);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        return n2;
    }

    private int createZoneSetFromBufferGS3(int n, char[] cArray, int n2, int n3, String string) {
        int n4;
        String string2 = "createZoneSetFromBufferGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "activateZoneSet = " + n2 + ". bufferIndex " + n3);
        }
        if ((n4 = InbandZoneControl.CreateZoneSetFromBuffer(n, cArray, n2, n3, string)) != 0) {
            n4 = this.getGS3Err(n4) + 40000;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n4;
    }

    private int deleteZoneSetGS3(int n, String string, String string2) {
        int n2;
        String string3 = "deleteZoneSetGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "zoneSetName = " + string);
        }
        if ((n2 = InbandZoneControl.DeleteZoneSet(n, string, string2)) != 0) {
            n2 = this.getGS3Err(n2) + 180000;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        return n2;
    }

    private int deactivateZoneSetGS3(int n, String string, String string2) {
        int n2;
        String string3 = "deactivateZoneSetGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "zoneSetName = " + string);
        }
        if ((n2 = InbandZoneControl.DeactivateZoneSet(n, string, string2)) != 0) {
            n2 = this.getGS3Err(n2) + 210000;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        return n2;
    }

    private int activateZoneSetGS3(int n, String string, String string2) {
        int n2;
        String string3 = "activateZoneSetGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "zoneSetName = " + string);
        }
        if ((n2 = InbandZoneControl.ActivateZoneSet(n, string, string2)) != 0) {
            n2 = this.getGS3Err(n2) + 200000;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        return n2;
    }

    private int pingGS3(String string, int n) {
        int n2;
        String string2 = "pingGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "san = " + string);
        }
        if ((n2 = InbandZoneControl.ping(string, n)) != 0) {
            n2 = this.getGS3Err(n2) + 220000;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n2;
    }

    private int openLibraryGS3() {
        String string = "openLibraryGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = InbandZoneControl.OpenLibrary();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return n;
    }

    private void closeLibraryGS3() {
        String string = "closeLibraryGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        InbandZoneControl.CloseLibrary();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    protected String getCurrentZoningInfoNative(int n) {
        String string = "getCurrentZoningInfoNative";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        String string2 = InbandZoneControl.GetCurrentZoningInfo(n);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return string2;
    }

    private int isFullZoneDBSupportedGS3(int n) {
        int n2;
        String string = "isFullZoneSupportedGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if ((n2 = InbandZoneControl.isFullZoneDBSupported(n)) == 0 || n2 == 1) {
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return n2;
        }
        return 261111;
    }

    private void getSwitchVendorIdsGS3(int n, String[] stringArray) {
        String string = "getSwitchVendorIdsGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        InbandZoneControl.GetSwitchVendorIds(n, stringArray);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private int getDomainPortCapabilityGS3(int n) {
        int n2;
        String string = "getDomainPortCapabilityGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if ((n2 = InbandZoneControl.getDomainPortCapability(n)) == 0 || n2 == 1) {
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return n2;
        }
        return 261111;
    }

    private int isCiscoADZSWorkaroundNeededGS3(int n) {
        int n2;
        String string = "isCiscoADZSWorkaroundNeededGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if ((n2 = InbandZoneControl.isCiscoADZSWorkaroundNeeded(n)) == 1 || n2 == 0) {
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return n2;
        }
        return 81111;
    }

    private int addZoneToZoneSetGS3(int n, String string, String string2, String string3) {
        int n2;
        String string4 = "addZoneToZoneSetGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string4);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string4, "zoneName = " + string2 + "zoneSetName = " + string);
        }
        if ((n2 = InbandZoneControl.AddZoneToZoneSet(n, string, string2, string3)) != 0) {
            n2 = this.getGS3Err(n2) + 80000;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
        return n2;
    }

    private int AddMembersToRemoveZoneMembersBufferGS3(int n, String string, char[] cArray, String string2, int n2, String[] stringArray, short[] sArray) {
        String string3 = "AddMembersToRemoveZoneMembersBufferGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "zoneName = " + string2 + ". numMembers = " + n2);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "ZoneMembers: ");
            if (stringArray.length == sArray.length) {
                int n3 = 0;
                while (n3 < stringArray.length) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, String.valueOf(stringArray[n3]) + " , " + sArray[n3]);
                    ++n3;
                }
            }
        }
        char[][] cArray2 = new char[stringArray.length][this.getCapabilities(string).getMaxNameLength()];
        int n4 = 0;
        while (n4 < stringArray.length) {
            char[] cArray3 = new char[this.getCapabilities(string).getMaxNameLength()];
            cArray3 = stringArray[n4].toCharArray();
            int n5 = 0;
            while (n5 < stringArray[n4].length()) {
                cArray2[n4][n5] = cArray3[n5];
                ++n5;
            }
            cArray2[n4][n5] = '\u0000';
            ++n4;
        }
        int n6 = InbandZoneControl.AddMembersToRemoveZoneMembersBuffer(n, cArray, string2, n2, cArray2, sArray);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        return n6;
    }

    private int RemoveMembersFromBufferGS3(int n, char[] cArray, int n2, String string) {
        int n3;
        String string2 = "RemoveMembersFromBufferGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "bufferIndex " + n2);
        }
        if ((n3 = InbandZoneControl.RemoveMembersFromBuffer(n, cArray, n2, string)) != 0) {
            n3 = this.getGS3Err(n3) + 40000;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n3;
    }

    private int isCNTRZMWorkaroundNeededGS3(int n) {
        int n2;
        String string = "isCNTRZMWorkaroundNeededGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if ((n2 = InbandZoneControl.isCNTRZMWorkaroundNeeded(n)) == 1 || n2 == 0) {
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return n2;
        }
        return 81111;
    }

    protected int activateTransactionNative(int n) {
        String string = "activateTransactionNative";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return 15500;
    }

    public boolean shutdown() {
        return true;
    }
}

