/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.net.DatagramPacket;
import org.eclipse.aperi.snmp.SimpleCallback;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.Snmp_callback;
import org.eclipse.aperi.snmp.utils.Queue;
import org.eclipse.aperi.snmp.utils.Timer;

class PendingResponse {
    protected int retries;
    protected int timeout;
    protected SnmpSession session;
    protected int reqID;
    protected DatagramPacket pack;
    protected Timer timer;
    protected int correlator;
    protected long sendTime;
    protected Queue rspQ;
    protected Object callback;
    protected Object user_data;
    protected boolean isUserPacket;
    protected Object pdu;

    protected PendingResponse(SnmpSession snmpSession, int n, int n2, int n3, DatagramPacket datagramPacket, int n4, boolean bl, Queue queue, Object object, Object object2) {
        this.session = snmpSession;
        this.reqID = n;
        this.retries = n2;
        this.timeout = n3;
        this.pack = datagramPacket;
        this.correlator = n4;
        this.sendTime = System.currentTimeMillis();
        this.rspQ = queue;
        this.callback = object;
        this.user_data = object2;
        this.isUserPacket = bl;
    }

    protected void handleResponse(SnmpPDU snmpPDU) {
        if (snmpPDU.errorStatus == 100) {
            this.session.timeoutReceived();
        } else {
            this.session.dataReceived();
        }
        if (this.rspQ != null) {
            this.rspQ.enqueue(snmpPDU);
        } else {
            try {
                if (this.callback instanceof Snmp_callback) {
                    ((Snmp_callback)this.callback).handle_response(0, snmpPDU, this.session, this.user_data);
                } else {
                    ((SimpleCallback)this.callback).handle_response(snmpPDU, this.user_data);
                }
            }
            catch (Exception exception) {
                System.out.println("PendingReponse:Exception in callback:" + exception.toString());
                exception.printStackTrace();
            }
        }
    }
}

