/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.snmp.PendingResponse;
import org.eclipse.aperi.snmp.RequestId;
import org.eclipse.aperi.snmp.SessionInfoCommString;
import org.eclipse.aperi.snmp.SnmpAsn1;
import org.eclipse.aperi.snmp.SnmpBERlength;
import org.eclipse.aperi.snmp.SnmpEncodeException;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpSocketException;
import org.eclipse.aperi.snmp.SnmpUnknownHostException;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.SnmpV2PDU;
import org.eclipse.aperi.snmp.data.Hex;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.toobighandler;
import org.eclipse.aperi.snmp.utils.Queue;
import org.eclipse.aperi.snmp.utils.Timer;
import org.eclipse.aperi.snmp.utils.TimerService;
import org.eclipse.aperi.snmp.utils.Wakeable;

class SnmpSocket
extends Thread
implements Wakeable {
    private static DatagramSocket sock;
    private boolean started = false;
    private static boolean running;
    private static SnmpSocket socket;
    private static Hashtable hosts;
    protected int useCount = 0;
    private Hashtable broadcastSessions = null;

    static {
        socket = null;
        hosts = new Hashtable();
    }

    protected SnmpSocket(InetAddress inetAddress) throws SnmpSocketException {
        running = false;
        try {
            sock = SnmpV1API.localHost == null ? new DatagramSocket() : new DatagramSocket(SnmpV1API.localPort, InetAddress.getByName(SnmpV1API.localHost));
            sock.setSoTimeout(Integer.MAX_VALUE);
        }
        catch (Exception exception) {
            sock = null;
            this.started = false;
            exception.printStackTrace();
        }
        this.broadcastSessions = new Hashtable();
    }

    protected boolean isReady() {
        return this.started;
    }

    protected InetAddress getIpAddress() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void run() {
        var1_1 = null;
        this.setName("SnmpReceive");
        if (SnmpSocket.sock == null) {
            return;
        }
        var2_2 = new byte[32768];
        this.started = true;
        SnmpSocket.running = true;
        var3_3 = this;
        synchronized (var3_3) {
            this.notifyAll();
            // MONITOREXIT @DISABLED, blocks:[0, 10] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
            if (true) ** GOTO lbl150
        }
        do {
            block50: {
                var3_3 = new DatagramPacket(var2_2, var2_2.length);
                try {
                    SnmpSocket.sock.receive((DatagramPacket)var3_3);
                    if (SnmpV1API.isTracing()) {
                        SnmpV1API.trace("received on socket");
                    }
                    if ((var4_4 = var3_3.getData())[0] != 0) {
                        block49: {
                            var5_5 = var3_3.getAddress().getHostAddress();
                            var1_1 = (Hashtable)SnmpSocket.hosts.get(var5_5);
                            var6_6 = false;
                            if (var1_1 == null && (var1_1 = this.getBroadcastMessage(var7_8 = SnmpAsn1.getMessageId(var4_4))) != null) {
                                var6_6 = true;
                            }
                            if (var1_1 == null) {
                                var7_7 = null;
                                try {
                                    var7_7 = var5_5 != null ? "No pending queue for host " + var5_5.toString() : "Packet received - returned null for getHostAddress()";
                                    if (var4_4 != null) {
                                        var8_9 = new byte[var3_3.getLength()];
                                        System.arraycopy(var4_4, 0, var8_9, 0, var8_9.length);
                                        var9_12 /* !! */  = new OctetString(var8_9);
                                        var7_7 = String.valueOf(var7_7) + "\npacket was: " + var9_12 /* !! */ ;
                                    }
                                }
                                catch (Throwable var8_10) {
                                    var8_10.printStackTrace();
                                }
                                if (!SnmpV1API.isTracing()) continue;
                                SnmpV1API.trace((String)var7_7);
                                continue;
                            }
                            var7_7 = null;
                            var8_11 = 0;
                            var9_12 /* !! */  = null;
                            try {
                                if (var4_4[0] != 48) {
                                    if (!SnmpV1API.isTracing()) continue;
                                    SnmpV1API.trace(Hex.toString(var4_4, 0, var3_3.getLength()));
                                    continue;
                                }
                                var10_13 = SnmpBERlength.size(var4_4, 1);
                                var8_11 = var4_4[1 + var10_13 + 1] == 1 ? var4_4[1 + var10_13 + 2] : SnmpAsn1.decode_int(var4_4, 1 + var10_13);
                                if (var8_11 == 0) {
                                    var7_7 = SnmpAsn1.decodePDU(var4_4, var3_3.getLength());
                                    break block49;
                                }
                                if (var8_11 == 1) {
                                    var7_7 = SnmpAsn1.decodeV2PDU(var4_4, var3_3.getLength());
                                    break block49;
                                }
                                if (var8_11 == 3) {
                                    var9_12 /* !! */  = new Integer(SnmpAsn1.getMessageId(var4_4));
                                    if (SnmpV1API.isTracing()) {
                                        SnmpV1API.trace("SnmpSocket: looking up v3 message: MessageId is " + SnmpAsn1.getMessageId(var4_4));
                                    }
                                    var11_17 = null;
                                    var12_20 = this;
                                    synchronized (var12_20) {
                                        var11_17 = (PendingResponse)var1_1.get(var9_12 /* !! */ );
                                    }
                                    if (var11_17 != null) {
                                        try {
                                            var7_7 = var11_17.session.decodeMessage(var4_4, var3_3.getLength());
                                            if (var7_7.operation == 7 && var11_17.isUserPacket) {
                                                continue;
                                            }
                                        }
                                        catch (Exception v2) {
                                            var7_7 = var11_17.session.makePDU();
                                            var7_7.errorStatus = 103;
                                        }
                                        if (!SnmpV1API.isTracing()) break block49;
                                        SnmpV1API.trace("SnmpSocket: made PDU");
                                        break block49;
                                    }
                                    if (!SnmpV1API.isTracing()) break block49;
                                    SnmpV1API.trace("SnmpSocket: pend was null - no message decoded");
                                    break block49;
                                }
                                throw new Exception();
                            }
                            catch (Exception v3) {
                                try {
                                    if (SnmpV1API.isTracing()) {
                                        SnmpV1API.trace("Received some kind of bad response.\nLength of response is:" + var3_3.getLength());
                                    }
                                    var10_14 = new byte[var3_3.getLength()];
                                    System.arraycopy(var3_3, 0, var10_14, 0, var10_14.length);
                                    var11_18 = new OctetString(var10_14);
                                    if (!SnmpV1API.isTracing()) continue;
                                    SnmpV1API.trace("Unable to decode the following PDU: " + var11_18);
                                }
                                catch (Exception var10_15) {
                                    System.out.println("Received some kind of bad response which could not not be dumped.");
                                    var10_15.printStackTrace();
                                }
                                continue;
                            }
                        }
                        var10_16 = null;
                        if (var7_7 != null) {
                            if (var8_11 != 3) {
                                var9_12 /* !! */  = new Integer(var7_7.requestId);
                            }
                            var11_17 = this;
                            synchronized (var11_17) {
                                var10_16 = var6_6 != false ? (PendingResponse)var1_1.get(var9_12 /* !! */ ) : (PendingResponse)var1_1.remove(var9_12 /* !! */ );
                            }
                        }
                        if (var10_16 != null) {
                            if (!var6_6) {
                                TimerService.cancelWakeUp(var10_16.timer);
                            }
                            if (var7_7.errorStatus == 1 && var7_7.varBindList.size() >= 2) {
                                if (SnmpV1API.isTracing()) {
                                    SnmpV1API.trace("SnmpSocket:Too Big handler invoked: " + var7_7.toString());
                                }
                                new toobighandler(var10_16).start();
                            } else {
                                var11_19 = (int)(System.currentTimeMillis() - var10_16.sendTime);
                                var10_16.session.stats.incrReceives(var11_19, var7_7.varBindListSize());
                                SnmpV1API.getSnmpStats().incrReceives(var11_19, var7_7.varBindListSize());
                                var7_7.correlator = var10_16.correlator;
                                if (SnmpV1API.isTracing()) {
                                    SnmpV1API.trace("<== Response from " + var10_16.session.currentHostname + " received by " + Thread.currentThread() + "\n" + var7_7);
                                }
                                if (SnmpV1API.isTracing()) {
                                    SnmpV1API.trace("SnmpSocket:calling handleResponse with PDU");
                                }
                                var10_16.handleResponse((SnmpPDU)var7_7);
                            }
                        }
                        break block50;
                    }
                    if (var4_4[0] != 0) break block50;
                    var5_5 = this;
                    synchronized (var5_5) {
                        SnmpSocket.running = false;
                        SnmpSocket.sock.close();
                    }
                }
                catch (InterruptedIOException v6) {
                }
                catch (IOException v7) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Throwable v8) {}
                }
            }
            var3_3 = null;
lbl150:
            // 10 sources

        } while (SnmpSocket.running);
    }

    protected static synchronized void closeSocket() {
        running = false;
        sock.close();
        socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized SnmpSocket getSocket(String string) throws SnmpUnknownHostException, SnmpSocketException {
        Object object;
        if (socket == null) {
            socket = new SnmpSocket(null);
            try {
                object = socket;
                synchronized (object) {
                    socket.setDaemon(true);
                    socket.start();
                    socket.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            object = socket;
            synchronized (object) {
                if (!running) {
                    try {
                        socket.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        try {
            object = InetAddress.getByName(string).getHostAddress();
            if (hosts.get(object) == null) {
                hosts.put(object, new Hashtable());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return socket;
    }

    public synchronized void addUser() {
    }

    public synchronized void removeUser() {
    }

    public synchronized boolean inUse() {
        return true;
    }

    Hashtable getBroadcastMessage(int n) {
        Hashtable hashtable = null;
        hashtable = (Hashtable)this.broadcastSessions.get(new Integer(n));
        return hashtable;
    }

    protected DatagramPacket encodeThePDU(SnmpSession snmpSession, SnmpPDU snmpPDU, boolean bl) {
        DatagramPacket datagramPacket = null;
        if (snmpSession.securityInfo instanceof SessionInfoCommString) {
            snmpPDU.communityString = snmpPDU.operation != 3 ? ((SessionInfoCommString)snmpSession.securityInfo).getCommunityNameOctet : ((SessionInfoCommString)snmpSession.securityInfo).setCommunityNameOctet;
        }
        if (running) {
            snmpPDU.requestId = bl ? RequestId.newPollId() : RequestId.newRequestId();
            try {
                if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace("encoding.... " + snmpPDU.toString() + " ---- " + snmpSession.securityInfo.toString());
                }
                byte[] byArray = null;
                switch (snmpPDU.version) {
                    case 0: {
                        byArray = SnmpAsn1.encode(snmpPDU, snmpSession.securityInfo);
                        break;
                    }
                    case 1: {
                        byArray = SnmpAsn1.encodeV2PDU((SnmpV2PDU)snmpPDU, snmpSession.securityInfo);
                        break;
                    }
                    default: {
                        SnmpV1API.trace("Invalid PDU version encountered - " + snmpPDU.toString());
                    }
                }
                datagramPacket = new DatagramPacket(byArray, byArray.length, snmpSession.getInetAddress(), snmpSession.remotePort);
            }
            catch (SnmpEncodeException snmpEncodeException) {
                SnmpV1API.trace("Encode error encountered:" + snmpEncodeException.toString());
                snmpEncodeException.printStackTrace();
            }
        }
        return datagramPacket;
    }

    protected boolean send(SnmpSession snmpSession, SnmpPDU snmpPDU, Queue queue, Object object, Object object2, boolean bl) {
        return this.send(snmpSession, snmpPDU, true, queue, object, object2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean send(SnmpSession snmpSession, SnmpPDU snmpPDU, boolean bl, Queue queue, Object object, Object object2, boolean bl2) {
        Object object3;
        if (snmpSession.closed && SnmpV1API.isTracing()) {
            SnmpV1API.trace("Closed session - " + snmpSession + ":" + snmpPDU);
        }
        Hashtable hashtable = null;
        PendingResponse pendingResponse = new PendingResponse(snmpSession, 0, snmpSession.retries, snmpSession.timeout, null, snmpPDU.correlator, bl, queue, object, object2);
        DatagramPacket datagramPacket = null;
        Timer timer = null;
        boolean bl3 = true;
        SnmpPDU snmpPDU2 = null;
        if (snmpSession.transmit_state == 1) {
            snmpPDU2 = pendingResponse.session.makePDU();
            snmpPDU2.errorStatus = 100;
        } else if (snmpSession.isSwitching() && !bl2) {
            snmpPDU2 = pendingResponse.session.makePDU();
            snmpPDU2.errorStatus = 100;
        } else {
            datagramPacket = this.encodeThePDU(snmpSession, snmpPDU, false);
            if (datagramPacket != null && running && !snmpSession.closed) {
                pendingResponse.pack = datagramPacket;
                pendingResponse.reqID = snmpPDU.getCorrelatorValue();
                object3 = new Integer(pendingResponse.reqID);
                if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace("SnmpSocket: saving away a message: RequestId is " + snmpPDU.requestId);
                }
                SnmpSocket snmpSocket = this;
                synchronized (snmpSocket) {
                    hashtable = (Hashtable)hosts.get(snmpSession.getIpAddress());
                    hashtable.put(object3, pendingResponse);
                    if (snmpSession.isBroadcast) {
                        this.broadcastSessions.put(object3, pendingResponse);
                    }
                    pendingResponse.timer = timer = TimerService.scheduleWakeUp(snmpSession.timeout, this, pendingResponse);
                }
                try {
                    if (SnmpV1API.isTracing()) {
                        SnmpV1API.trace("Sending on socket");
                    }
                    sock.send(datagramPacket);
                    pendingResponse.session.stats.incrSends(snmpPDU.varBindListSize());
                    pendingResponse.session.stats.setLastUsed(pendingResponse.sendTime);
                    SnmpV1API.getSnmpStats().incrSends(snmpPDU.varBindListSize());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (exception instanceof IOException || exception instanceof SnmpEncodeException) {
                        // empty if block
                    }
                    SnmpSocket snmpSocket2 = this;
                    synchronized (snmpSocket2) {
                        hashtable.remove(object3);
                        TimerService.cancelWakeUp(timer);
                    }
                    bl3 = false;
                    snmpPDU2 = pendingResponse.session.makePDU();
                    snmpPDU2.errorStatus = 101;
                }
            } else {
                bl3 = false;
                snmpPDU2 = pendingResponse.session.makePDU();
                snmpPDU2.errorStatus = 102;
            }
        }
        if (snmpPDU2 == null) {
            if (SnmpV1API.isTracing()) {
                SnmpV1API.trace("==> Sent request to " + snmpSession.currentHostname + " by " + Thread.currentThread() + "\n" + snmpPDU);
            }
        } else {
            snmpPDU2.requestId = snmpPDU.requestId;
            snmpPDU2.operation = 2;
            snmpPDU2.correlator = snmpPDU.correlator;
            if (SnmpV1API.isTracing()) {
                object3 = "send error";
                if (snmpPDU2.errorStatus == 102) {
                    object3 = "closed session";
                } else if (snmpSession.transmit_state == 1) {
                    object3 = "timeoout without transmit to clear messages";
                }
                SnmpV1API.trace("Send failed to " + snmpSession.currentHostname + " by " + Thread.currentThread() + " due to " + (String)object3 + "\n" + snmpPDU);
            }
            pendingResponse.handleResponse(snmpPDU2);
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean send(SnmpSession snmpSession, SnmpPDU snmpPDU, DatagramPacket datagramPacket, Queue queue, Object object, Object object2) {
        Object object3;
        Hashtable hashtable = null;
        PendingResponse pendingResponse = new PendingResponse(snmpSession, 0, snmpSession.retries, snmpSession.timeout, null, snmpPDU.correlator, true, queue, object, object2);
        Timer timer = null;
        boolean bl = true;
        SnmpPDU snmpPDU2 = null;
        int n = RequestId.newPollId();
        if (snmpSession.transmit_state == 1) {
            snmpPDU2 = pendingResponse.session.makePDU();
            snmpPDU2.errorStatus = 100;
        } else if (snmpSession.isSwitching()) {
            snmpPDU2 = pendingResponse.session.makePDU();
            snmpPDU2.errorStatus = 100;
        } else {
            pendingResponse.pack = datagramPacket;
            pendingResponse.reqID = n;
            snmpPDU.requestId = n;
            if (datagramPacket != null && running && !snmpSession.closed) {
                object3 = datagramPacket.getData();
                int n2 = snmpPDU.requestIdPos;
                object3[n2] = (byte)(n >> 24 & 0xFF);
                object3[n2 + 1] = (byte)(n >> 16 & 0xFF);
                object3[n2 + 2] = (byte)(n >> 8 & 0xFF);
                object3[n2 + 3] = (byte)(n & 0xFF);
                Integer n3 = new Integer(snmpPDU.getCorrelatorValue());
                SnmpSocket snmpSocket = this;
                synchronized (snmpSocket) {
                    hashtable = (Hashtable)hosts.get(snmpSession.getIpAddress());
                    hashtable.put(n3, pendingResponse);
                    pendingResponse.timer = timer = TimerService.scheduleWakeUp(snmpSession.timeout, this, pendingResponse);
                }
                try {
                    sock.send(datagramPacket);
                    pendingResponse.session.stats.incrSends(snmpPDU.varBindListSize());
                    SnmpV1API.getSnmpStats().incrSends(snmpPDU.varBindListSize());
                }
                catch (IOException iOException) {
                    snmpSocket = this;
                    synchronized (snmpSocket) {
                        hashtable.remove(n3);
                        TimerService.cancelWakeUp(timer);
                    }
                    bl = false;
                    snmpPDU2 = pendingResponse.session.makePDU();
                    snmpPDU2.errorStatus = 101;
                }
            } else {
                bl = false;
                snmpPDU2 = pendingResponse.session.makePDU();
                snmpPDU2.errorStatus = 102;
            }
        }
        if (snmpPDU2 == null) {
            if (SnmpV1API.isTracing()) {
                SnmpV1API.trace("==> Sent request to " + snmpSession.currentHostname + " by " + Thread.currentThread() + "\n" + snmpPDU);
            }
        } else {
            snmpPDU2.requestId = n;
            snmpPDU2.operation = 2;
            snmpPDU2.correlator = snmpPDU.correlator;
            if (SnmpV1API.isTracing()) {
                object3 = "send error";
                if (snmpPDU2.errorStatus == 102) {
                    object3 = "closed session";
                } else if (snmpSession.transmit_state == 1) {
                    object3 = "timeoout without transmit to clear messages";
                }
                SnmpV1API.trace("Send failed to " + snmpSession.currentHostname + " by " + Thread.currentThread() + " due to " + (String)object3 + "\n" + snmpPDU);
            }
            pendingResponse.handleResponse(snmpPDU2);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp(Object object) {
        Hashtable hashtable = null;
        PendingResponse pendingResponse = (PendingResponse)object;
        Timer timer = null;
        boolean bl = false;
        boolean bl2 = false;
        Integer n = new Integer(pendingResponse.reqID);
        Object object2 = this;
        synchronized (object2) {
            hashtable = (Hashtable)hosts.get(pendingResponse.session.getIpAddress());
            if (hashtable.containsKey(n)) {
                bl = true;
                --pendingResponse.retries;
                if (pendingResponse.retries < 0 || pendingResponse.session.isBroadcast) {
                    hashtable.remove(n);
                } else {
                    bl2 = true;
                    pendingResponse.timeout += pendingResponse.timeout;
                    pendingResponse.timer = timer = TimerService.scheduleWakeUp(pendingResponse.timeout, this, pendingResponse);
                }
            }
        }
        if (bl2) {
            try {
                object2 = null;
                object2 = pendingResponse.pack != null ? pendingResponse.pack : this.encodeThePDU(pendingResponse.session, (SnmpPDU)pendingResponse.pdu, false);
                sock.send((DatagramPacket)object2);
                pendingResponse.session.stats.incrRetries();
                SnmpV1API.getSnmpStats().incrRetries();
            }
            catch (IOException iOException) {
                object2 = this;
                synchronized (object2) {
                    hashtable.remove(n);
                    TimerService.cancelWakeUp(timer);
                }
                pendingResponse.retries = -1;
            }
        }
        if (bl) {
            if (pendingResponse.retries < 0) {
                object2 = pendingResponse.session.makePDU();
                ((SnmpPDU)object2).errorStatus = 100;
                ((SnmpPDU)object2).operation = 2;
                ((SnmpPDU)object2).requestId = pendingResponse.reqID;
                ((SnmpPDU)object2).correlator = pendingResponse.correlator;
                int n2 = (int)(System.currentTimeMillis() - pendingResponse.sendTime);
                pendingResponse.session.stats.incrTimeouts();
                pendingResponse.session.stats.incrReceives(n2, 0);
                SnmpV1API.getSnmpStats().incrTimeouts();
                SnmpV1API.getSnmpStats().incrReceives(n2, 0);
                if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace("<== Response " + pendingResponse.reqID + " from " + pendingResponse.session.currentHostname + " timed out by " + Thread.currentThread());
                }
                pendingResponse.handleResponse((SnmpPDU)object2);
            } else if (SnmpV1API.isTracing()) {
                SnmpV1API.trace("<== Response " + pendingResponse.reqID + " from " + pendingResponse.session.currentHostname + " remaining retries = " + pendingResponse.retries + " out of " + pendingResponse.session.retries + ", timeout = " + pendingResponse.timeout / 2 + ", by " + Thread.currentThread());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closedSession(SnmpSession snmpSession) {
        Hashtable hashtable = (Hashtable)hosts.get(snmpSession.getIpAddress());
        while (hashtable.size() > 0) {
            Hashtable hashtable2 = (Hashtable)hashtable.clone();
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                PendingResponse pendingResponse;
                Integer n = (Integer)enumeration.nextElement();
                Object object = this;
                synchronized (object) {
                    pendingResponse = (PendingResponse)hashtable.get(n);
                    if (pendingResponse != null && pendingResponse.session == snmpSession) {
                        hashtable.remove(n);
                    } else {
                        pendingResponse = null;
                    }
                }
                if (pendingResponse == null) continue;
                object = pendingResponse.session.makePDU();
                ((SnmpPDU)object).errorStatus = 102;
                ((SnmpPDU)object).requestId = pendingResponse.reqID;
                ((SnmpPDU)object).operation = 2;
                ((SnmpPDU)object).correlator = pendingResponse.correlator;
                pendingResponse.handleResponse((SnmpPDU)object);
            }
        }
    }

    protected int getLocalPort() {
        int n = 0;
        if (sock != null) {
            n = sock.getLocalPort();
        }
        return n;
    }
}

