/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.data;

public class Hex {
    private static final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] >> 4 & 0xF;
            int n3 = byArray[n] & 0xF;
            stringBuffer.append(hexchars[n2]);
            stringBuffer.append(hexchars[n3]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String toString(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        while (n2 < byArray.length) {
            int n3 = byArray[n2] >> 4 & 0xF;
            int n4 = byArray[n2] & 0xF;
            stringBuffer.append(hexchars[n3]);
            stringBuffer.append(hexchars[n4]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String toString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            int n5 = byArray[n4] >> 4 & 0xF;
            int n6 = byArray[n4] & 0xF;
            stringBuffer.append(hexchars[n5]);
            stringBuffer.append(hexchars[n6]);
            ++n4;
        }
        return stringBuffer.toString();
    }

    public static String toUnsignedDec(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n + n2;
        long l = 0L;
        int n4 = n;
        while (n4 < n3) {
            l = l << 8 | (long)(byArray[n4] & 0xFF);
            ++n4;
        }
        stringBuffer.append(Long.toString(l));
        return stringBuffer.toString();
    }

    public static String toString(byte[] byArray, int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = n + n2;
        switch (n3) {
            case 16: {
                stringBuffer.append(Hex.toString(byArray, n, n2));
                break;
            }
            case 10: {
                long l = byArray[n] >= 0 ? 0 : -1;
                int n5 = n;
                while (n5 < n4) {
                    l = l << 8 | (long)(byArray[n5] & 0xFF);
                    ++n5;
                }
                stringBuffer.append(Long.toString(l));
                break;
            }
            case 8: {
                long l = byArray[n] >= 0 ? 0 : -1;
                int n6 = n;
                while (n6 < n4) {
                    l = l << 8 | (long)(byArray[n6] & 0xFF);
                    ++n6;
                }
                stringBuffer.append(Long.toOctalString(l));
                break;
            }
            case 2: {
                long l = byArray[n] >= 0 ? 0 : -1;
                int n7 = n;
                while (n7 < n4) {
                    l = l << 8 | (long)(byArray[n7] & 0xFF);
                    ++n7;
                }
                stringBuffer.append(Long.toBinaryString(l));
                break;
            }
            default: {
                System.out.println("Error: Unknown radix passed to Hex.toString(); valid radix values are 16, 10, 8, and 2");
            }
        }
        return stringBuffer.toString();
    }

    public static String toString(byte by) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = by >> 4 & 0xF;
        int n2 = by & 0xF;
        stringBuffer.append(hexchars[n]);
        stringBuffer.append(hexchars[n2]);
        return stringBuffer.toString();
    }
}

