/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.OdiAdapter;
import org.eclipse.birt.data.engine.executor.cache.SmartCacheRequest;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.odi.IResultObjectEvent;

class RowResultSet
implements IRowResultSet {
    private List eventList;
    private OdiAdapter odiAdpater;
    private IResultClass resultClass;
    private int maxRows;
    private int currIndex;
    private boolean distinctValueFlag;
    private IResultObject lastResultObject;
    static final /* synthetic */ boolean $assertionsDisabled;

    RowResultSet(SmartCacheRequest smartCacheRequest) {
        this.eventList = smartCacheRequest.getEventList();
        this.odiAdpater = smartCacheRequest.getOdiAdapter();
        this.resultClass = smartCacheRequest.getResultClass();
        this.maxRows = smartCacheRequest.getMaxRow();
        if (this.maxRows <= 0) {
            this.maxRows = Integer.MAX_VALUE;
        }
        this.distinctValueFlag = smartCacheRequest.getDistinctValueFlag();
    }

    public IResultClass getMetaData() {
        return this.resultClass;
    }

    public IResultObject next() throws DataException {
        if (this.currIndex >= this.maxRows) {
            return null;
        }
        IResultObject odaObject = null;
        while ((odaObject = this.odiAdpater.fetch()) != null) {
            if (!this.processFetchEvent(odaObject, this.currIndex) || this.distinctValueFlag && this.isDuplicatedObject(odaObject)) continue;
            ++this.currIndex;
            break;
        }
        return odaObject;
    }

    private boolean processFetchEvent(IResultObject resultObject, int currentIndex) throws DataException {
        if (!$assertionsDisabled && resultObject == null) {
            throw new AssertionError();
        }
        if (this.eventList != null) {
            int size = this.eventList.size();
            for (int i = 0; i < size; ++i) {
                IResultObjectEvent onFetchEvent = (IResultObjectEvent)this.eventList.get(i);
                if (onFetchEvent.process(resultObject, currentIndex)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isDuplicatedObject(IResultObject currRowObject) {
        if (currRowObject.equals(this.lastResultObject)) {
            return true;
        }
        this.lastResultObject = currRowObject;
        return false;
    }

    static {
        $assertionsDisabled = !RowResultSet.class.desiredAssertionStatus();
    }
}

