/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

class SizeOfUtil {
    private static final int INTEGER_SIZE = 16;
    private static final int DOUBLE_SIZE = 16;
    private static final int DATE_SIZE = 24;
    private static final int TIME_SIZE = 24;
    private static int BIGDECIMAL_SIZE;
    private static int TIMESTAMP_SIZE;
    private int fieldCount = 0;
    private boolean[] isfixedSize = null;
    private int[] fieldSize = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    SizeOfUtil(IResultClass resultClass) throws DataException {
        this.fieldCount = resultClass.getFieldCount();
        this.isfixedSize = new boolean[resultClass.getFieldCount()];
        this.fieldSize = new int[resultClass.getFieldCount()];
        for (int i = 1; i <= resultClass.getFieldCount(); ++i) {
            if (SizeOfUtil.isFixedSizeClass(resultClass.getFieldValueClass(i))) {
                this.fieldSize[i - 1] = SizeOfUtil.sizeOf(resultClass.getFieldValueClass(i));
                this.isfixedSize[i - 1] = true;
                continue;
            }
            this.isfixedSize[i - 1] = false;
        }
    }

    private static boolean isFixedSizeClass(Class objectClass) {
        return objectClass.equals(Integer.class) || objectClass.equals(Double.class) || objectClass.equals(BigDecimal.class) || objectClass.equals(Date.class) || objectClass.equals(Time.class) || objectClass.equals(Timestamp.class);
    }

    private static int sizeOf(Class objectClass) {
        if (objectClass.equals(Integer.class)) {
            return 16;
        }
        if (objectClass.equals(Double.class)) {
            return 16;
        }
        if (objectClass.equals(BigDecimal.class)) {
            return BIGDECIMAL_SIZE;
        }
        if (objectClass.equals(Date.class)) {
            return 24;
        }
        if (objectClass.equals(Time.class)) {
            return 24;
        }
        if (objectClass.equals(Timestamp.class)) {
            return TIMESTAMP_SIZE;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return 0;
    }

    int sizeOf(IResultObject resultObject) throws DataException {
        int returnValue = 0;
        for (int i = 1; i <= this.fieldCount; ++i) {
            if (!this.isfixedSize[i - 1]) {
                returnValue += SizeOfUtil.sizeOf(resultObject.getResultClass().getFieldValueClass(i), resultObject.getFieldValue(i));
                continue;
            }
            if (resultObject.getFieldValue(i) == null) continue;
            returnValue += this.fieldSize[i - 1];
        }
        int fieldsSize = 16 + (4 + this.fieldCount * 4 - 1) / 8 * 8;
        return returnValue += 16 + (4 + fieldsSize - 1) / 8 * 8;
    }

    private static int sizeOf(Class objectClass, Object object) {
        if (object == null) {
            return 0;
        }
        if (objectClass.equals(String.class)) {
            int strLen = ((String)object).length();
            return 40 + (strLen + 1) / 4 * 8;
        }
        if (objectClass.equals([B.class)) {
            int byteLen = ((byte[])object).length;
            return 16 + (4 + byteLen - 1) / 8 * 8;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return 0;
    }

    static {
        $assertionsDisabled = !SizeOfUtil.class.desiredAssertionStatus();
        BIGDECIMAL_SIZE = 80;
        TIMESTAMP_SIZE = 24;
        if (System.getProperty("java.version").startsWith("1.5")) {
            BIGDECIMAL_SIZE = 96;
            TIMESTAMP_SIZE = 32;
        }
    }
}

