/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.pass;

import java.util.ArrayList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.pass.ComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.pass.PassUtil;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IResultClass;

class ComputedColumnCalculator {
    private ResultSetPopulator populator;
    private ComputedColumnsState iccState;
    private ComputedColumnHelper computedColumnHelper;
    private DataEngineSession session;

    private ComputedColumnCalculator(ResultSetPopulator populator, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, DataEngineSession session) {
        this.populator = populator;
        this.iccState = iccState;
        this.computedColumnHelper = computedColumnHelper;
        this.session = session;
    }

    static void populateComputedColumns(ResultSetPopulator populator, OdiResultSetWrapper odaResultSet, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, DataEngineSession session) throws DataException {
        new ComputedColumnCalculator(populator, iccState, computedColumnHelper, session).doPopulate(odaResultSet.getWrappedOdiResultSet() instanceof ICustomDataSet);
    }

    private void doPopulate(boolean isCustomDataSet) throws DataException {
        while (this.needMoreExpressionProcessOnComputedColumns()) {
            this.makeAPassToComputedColumn(isCustomDataSet);
        }
    }

    private boolean needMoreExpressionProcessOnComputedColumns() {
        if (this.iccState == null) {
            return false;
        }
        for (int i = 0; i < this.iccState.getCount(); ++i) {
            if (this.iccState.isValueAvailable(i)) continue;
            return true;
        }
        return false;
    }

    private void makeAPassToComputedColumn(boolean isCustomDataSet) throws DataException {
        if (isCustomDataSet) {
            this.populator.setResultSetMetadata(ComputedColumnCalculator.rebuildCustomedResultClass(this.populator.getResultSetMetadata(), false));
        }
        this.populateComputedColumns();
        if (isCustomDataSet) {
            this.populator.setResultSetMetadata(ComputedColumnCalculator.rebuildCustomedResultClass(this.populator.getResultSetMetadata(), true));
        }
        PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), true, this.session);
    }

    private static IResultClass rebuildCustomedResultClass(IResultClass meta, boolean returnToOriginalValue) throws DataException {
        ArrayList<ResultFieldMetadata> projectedColumns = new ArrayList<ResultFieldMetadata>();
        for (int i = 1; i <= meta.getFieldCount(); ++i) {
            projectedColumns.add(new ResultFieldMetadata(0, meta.getFieldName(i), meta.getFieldLabel(i), meta.getFieldValueClass(i), meta.getFieldNativeTypeName(i), returnToOriginalValue ? true : PassUtil.isTemporaryResultSetComputedColumn(meta.getFieldName(i))));
        }
        return new ResultClass(projectedColumns);
    }

    private void populateComputedColumns() throws DataException {
        this.calculateAggregation();
        int startValue = this.iccState.getLastAccessedComputedColumnIndex() + 1;
        this.computedColumnHelper.getComputedColumnList().clear();
        for (int i = startValue; i < this.iccState.getCount() && this.iccState.isValueAvailable(i); ++i) {
            this.computedColumnHelper.getComputedColumnList().add(this.iccState.getComputedColumn(i));
            this.iccState.setLastAccessedComputedColumnId(i);
        }
        this.computedColumnHelper.setRePrepare(true);
    }

    private void calculateAggregation() throws DataException {
        this.populator.getExpressionProcessor().setResultIterator(this.populator.getResultIterator());
        this.populator.getExpressionProcessor().evaluateMultiPassExprOnCmp(this.iccState, true);
    }
}

