/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.expression.BytecodeExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ComplexExpression;

public final class AggregateExpression
extends BytecodeExpression {
    private IAggregation aggregation;
    private int groupLevel;
    private List arguments;
    private int m_id;
    static final /* synthetic */ boolean $assertionsDisabled;

    AggregateExpression(IAggregation aggregation) {
        logger.entering(AggregateExpression.class.getName(), "AggregateExpression");
        this.aggregation = aggregation;
        this.arguments = new ArrayList();
        this.groupLevel = -1;
        logger.exiting(AggregateExpression.class.getName(), "AggregateExpression");
    }

    public IAggregation getAggregation() {
        return this.aggregation;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof AggregateExpression)) {
            return false;
        }
        AggregateExpression expr2 = (AggregateExpression)other;
        if (!this.aggregation.getName().equals(expr2.getAggregation().getName())) {
            return false;
        }
        if (this.groupLevel != expr2.getGroupLevel()) {
            return false;
        }
        if (this.getCalculationLevel() != expr2.getCalculationLevel()) {
            return false;
        }
        if (this.arguments.size() != expr2.getArguments().size()) {
            return false;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (this.arguments.get(i).equals(expr2.getArguments().get(i))) continue;
            return false;
        }
        return true;
    }

    public List getArguments() {
        return this.arguments;
    }

    void addArgument(CompiledExpression expr) {
        if (!$assertionsDisabled && expr == null) {
            throw new AssertionError();
        }
        this.arguments.add(expr);
    }

    public int getType() {
        return 2;
    }

    public void setRegId(int id) {
        this.m_id = id;
    }

    public int getRegId() {
        return this.m_id;
    }

    public int getCalculationLevel() {
        if (!this.isNestedAggregation()) {
            return 0;
        }
        int result = this.groupLevel;
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (!(this.arguments.get(i) instanceof BytecodeExpression)) continue;
            int level = ((BytecodeExpression)this.arguments.get(i)).getGroupLevel();
            if (level > result) {
                result = level;
            }
            if (level != 0) continue;
            return 0;
        }
        return result;
    }

    public void setGroupLevel(int groupLevel) {
        this.groupLevel = groupLevel;
    }

    public int getGroupLevel() {
        return this.groupLevel;
    }

    public boolean isNestedAggregation() {
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                if (this.arguments.get(i) instanceof AggregateExpression) {
                    return true;
                }
                if (!(this.arguments.get(i) instanceof ComplexExpression) || !this.hasAggregationInComplexExpression((ComplexExpression)this.arguments.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAggregationInComplexExpression(ComplexExpression expr) {
        Iterator it;
        Collection collection = expr.getSubExpressions();
        if (collection != null && (it = collection.iterator()).hasNext()) {
            Object o = it.next();
            if (o instanceof AggregateExpression) {
                return true;
            }
            if (o instanceof ComplexExpression && this.hasAggregationInComplexExpression((ComplexExpression)o)) {
                return true;
            }
        }
        return false;
    }

    static {
        $assertionsDisabled = !AggregateExpression.class.desiredAssertionStatus();
    }
}

