/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.odi.FilterUtil;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.odi.IResultObjectEvent;

public class FilterByRow
implements IResultObjectEvent {
    public static final int DATASET_FILTER = 1;
    public static final int QUERY_FILTER = 2;
    public static final int ALL_ROW_FILTER = 3;
    public static final int NO_FILTER = 4;
    public static final int GROUP_FILTER = 5;
    private DataSetRuntime dataSet;
    private List currentFilters;
    private List dataSetFilters;
    private List queryFilters;
    private List groupFilters;
    private List allFilters;
    private int currentWorkingFilters;
    protected static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    FilterByRow(List dataSetFilters, List queryFilters, List groupFilters, DataSetRuntime dataSet) throws DataException {
        this.isLegal(dataSetFilters);
        this.isLegal(queryFilters);
        this.dataSet = dataSet;
        this.dataSetFilters = FilterUtil.sortFilters(dataSetFilters);
        this.queryFilters = FilterUtil.sortFilters(queryFilters);
        this.groupFilters = groupFilters;
        this.allFilters = this.getAllFilters(dataSetFilters, queryFilters);
        this.currentWorkingFilters = 3;
        logger.log(Level.FINER, "FilterByRow starts up");
    }

    private List getAllFilters(List dataSetFilters, List queryFilters) {
        ArrayList temp = new ArrayList();
        temp.addAll(dataSetFilters);
        temp.addAll(queryFilters);
        return temp;
    }

    public void setWorkingFilterSet(int filterSetType) throws DataException {
        this.validateFilterType(filterSetType);
        this.currentWorkingFilters = filterSetType;
    }

    public int getWorkingFilterSet() throws DataException {
        return this.currentWorkingFilters;
    }

    public void restoreWorkingFilterSet() {
        this.currentWorkingFilters = 3;
    }

    public boolean isFilterSetExist(int filterSetType) throws DataException {
        this.validateFilterType(filterSetType);
        if (1 == filterSetType) {
            return this.dataSetFilters.size() > 0;
        }
        if (2 == filterSetType) {
            return this.queryFilters.size() > 0;
        }
        if (5 == filterSetType) {
            return this.groupFilters.size() > 0;
        }
        return this.allFilters.size() > 0;
    }

    private void isLegal(List filters) throws DataException {
    }

    public boolean process(IResultObject row, int rowIndex) throws DataException {
        logger.entering(FilterByRow.class.getName(), "process");
        boolean isAccepted = true;
        this.currentFilters = this.getFilterList(this.currentWorkingFilters);
        Iterator filterIt = this.currentFilters.iterator();
        this.dataSet.setRowObject(row, false);
        this.dataSet.setCurrentRowIndex(rowIndex);
        while (filterIt.hasNext()) {
            IFilterDefinition filter = (IFilterDefinition)filterIt.next();
            IBaseExpression expr = filter.getExpression();
            Object result = null;
            try {
                result = ExprEvaluateUtil.evaluateRawExpression2(expr, this.dataSet.getScriptScope());
            }
            catch (BirtException e2) {
                DataException dataEx = DataException.wrap(e2);
                Object info = null;
                info = expr instanceof IConditionalExpression ? ((IConditionalExpression)expr).getExpression().getText() : expr;
                throw new DataException("data.engine.BadFilterDefn", (Throwable)((Object)dataEx), info);
            }
            if (result == null) {
                Object info = null;
                info = expr instanceof IScriptExpression ? ((IScriptExpression)expr).getText() : expr;
                throw new DataException("data.engine.BadFilterExpr", info);
            }
            try {
                if (DataTypeUtil.toBoolean((Object)result).booleanValue()) continue;
                isAccepted = false;
                break;
            }
            catch (BirtException e) {
                DataException e1 = new DataException("data.engine.DataConversionError", e);
                logger.logp(Level.FINE, FilterByRow.class.getName(), "process", "An error is thrown by DataTypeUtil.", (Throwable)((Object)e1));
                throw e1;
            }
        }
        return isAccepted;
    }

    public List getFilterList() throws DataException {
        return this.getFilterList(this.currentWorkingFilters);
    }

    public List getFilterList(int filterSetType) throws DataException {
        this.validateFilterType(filterSetType);
        if (1 == filterSetType) {
            return this.dataSetFilters;
        }
        if (2 == filterSetType) {
            return this.queryFilters;
        }
        if (5 == filterSetType) {
            return this.groupFilters;
        }
        if (3 == filterSetType) {
            return this.allFilters;
        }
        return new ArrayList();
    }

    private void validateFilterType(int filterSetType) {
        if (filterSetType != 4 && filterSetType != 1 && filterSetType != 3 && filterSetType != 2 && filterSetType != 5 && !$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    static {
        $assertionsDisabled = !FilterByRow.class.desiredAssertionStatus();
        logger = Logger.getLogger(FilterByRow.class.getName());
    }
}

