/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import com.ibm.icu.text.SimpleDateFormat;
import java.sql.Blob;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IInputParameterBinding;
import org.eclipse.birt.data.engine.api.IParameterDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.IQueryService;
import org.eclipse.birt.data.engine.impl.PreparedOdaDSQuery;
import org.eclipse.birt.data.engine.odaconsumer.ParameterHint;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

class ParameterUtil {
    private IQueryService outerResults;
    private DataSetRuntime dsRT;
    private IQueryDefinition queryDefn;
    private Scriptable scope;
    private Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    ParameterUtil(IQueryService outerResults, DataSetRuntime dsRT, IQueryDefinition queryDefn, Scriptable scope) {
        this.outerResults = outerResults;
        this.dsRT = dsRT;
        this.queryDefn = queryDefn;
        this.scope = scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection resolveDataSetParameters(boolean evaluateValue) throws DataException {
        List paramDefns = this.dsRT.getParameters();
        int nParams = paramDefns == null ? 0 : paramDefns.size();
        ParameterHint[] paramHints = new ParameterHint[nParams];
        boolean[] bindingResolved = new boolean[nParams];
        for (int i = 0; i < nParams; ++i) {
            IParameterDefinition paramDefn = (IParameterDefinition)paramDefns.get(i);
            paramHints[i] = this.createParameterHint(paramDefn, paramDefn.getDefaultInputValue());
            bindingResolved[i] = false;
            if (!paramDefn.isInputMode() || paramDefn.getName() == null) continue;
            Object paramValue = DataSetRuntime.UNSET_VALUE;
            try {
                paramValue = this.dsRT.getInputParameterValue(paramDefn.getName());
            }
            catch (BirtException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                throw DataException.wrap(e);
            }
            if (paramValue == DataSetRuntime.UNSET_VALUE) continue;
            String paramValueStr = this.getParameterValueString(paramHints[i].getDataType(), paramValue);
            paramHints[i].setDefaultInputValue(paramValueStr);
            bindingResolved[i] = true;
        }
        Context cx = null;
        if (evaluateValue) {
            cx = Context.enter();
        }
        try {
            this.resolveParameterBindings(this.queryDefn.getInputParamBindings(), paramHints, bindingResolved, cx);
            this.resolveParameterBindings(this.dsRT.getInputParamBindings(), paramHints, bindingResolved, cx);
        }
        finally {
            if (cx != null) {
                Context.exit();
            }
        }
        return Arrays.asList(paramHints);
    }

    private void resolveParameterBindings(Collection bindings, ParameterHint[] paramHints, boolean[] bindingResolved, Context cx) throws DataException {
        if (bindings == null) {
            return;
        }
        Iterator it = bindings.iterator();
        while (it.hasNext()) {
            this.resolveParameterBinding((IInputParameterBinding)it.next(), paramHints, bindingResolved, cx);
        }
    }

    private void resolveParameterBinding(IInputParameterBinding binding, ParameterHint[] paramHints, boolean[] bindingResolved, Context cx) throws DataException {
        int i = this.findParameterHint(paramHints, binding.getPosition(), binding.getName());
        if (i < 0) {
            if (this.logger != null) {
                this.logger.warning("Ignored binding defined for non-exising data set parameter: name=" + binding.getName() + ", position=" + binding.getPosition());
            }
        } else if (!bindingResolved[i]) {
            IBaseExpression value = cx != null ? this.evaluateInputParameterValue(this.scope, cx, binding) : binding.getExpr();
            String valueStr = this.getParameterValueString(paramHints[i].getDataType(), value);
            paramHints[i].setDefaultInputValue(valueStr);
            bindingResolved[i] = true;
            if (cx != null && paramHints[i].isInputMode() && paramHints[i].getName() != null) {
                try {
                    this.dsRT.setInputParameterValue(paramHints[i].getName(), value);
                }
                catch (BirtException e) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    throw DataException.wrap(e);
                }
            }
        }
    }

    private int findParameterHint(ParameterHint[] hints, int position, String name) {
        for (int i = 0; i < hints.length; ++i) {
            ParameterHint paramHint = hints[i];
            if (!(position <= 0 ? paramHint.getName().equalsIgnoreCase(name) : paramHint.getPosition() == position)) continue;
            return i;
        }
        return -1;
    }

    private Object evaluateInputParameterValue(Scriptable scope, Context cx, IInputParameterBinding iParamBind) throws DataException {
        Object evaluateResult = null;
        Scriptable evaluateScope = scope;
        if (this.outerResults != null) {
            try {
                evaluateResult = ExprEvaluateUtil.evaluateRawExpression2(iParamBind.getExpr(), this.outerResults.getQueryScope());
            }
            catch (BirtException e) {
                DataException dataEx = new DataException("data.engine.UnexpectedError", e);
                if (this.logger != null) {
                    this.logger.logp(Level.FINE, PreparedOdaDSQuery.class.getName(), "getMergedParameters", "Error occurs in IQueryResults.getResultIterator()", e);
                }
                throw dataEx;
            }
        }
        if (evaluateResult == null) {
            evaluateResult = ScriptEvalUtil.evalExpr(iParamBind.getExpr(), cx, evaluateScope, "ParamBinding(" + iParamBind.getName() + ")", 0);
        }
        if (evaluateResult == null) {
            throw new DataException("data.engine.NullDefaultInParamValue");
        }
        return evaluateResult;
    }

    private String getParameterValueString(Class paramType, Object paramValue) throws DataException {
        if (paramValue instanceof String) {
            return (String)paramValue;
        }
        try {
            paramValue = DataTypeUtil.convert((Object)paramValue, (Class)paramType);
            if (paramValue instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                return sdf.format((Date)paramValue);
            }
            return DataTypeUtil.toString((Object)paramValue);
        }
        catch (BirtException e) {
            throw new DataException("data.engine.DataConversionError", e);
        }
    }

    private ParameterHint createParameterHint(IParameterDefinition paramDefn, Object paramValue) throws DataException {
        Class dataTypeClass;
        ParameterHint parameterHint = new ParameterHint(paramDefn.getName(), paramDefn.isInputMode(), paramDefn.isOutputMode());
        if (paramDefn.getPosition() > 0) {
            parameterHint.setPosition(paramDefn.getPosition());
        }
        if ((dataTypeClass = DataType.getClass((int)paramDefn.getType())) == DataType.AnyType.class || dataTypeClass == Boolean.class || dataTypeClass == Blob.class) {
            dataTypeClass = String.class;
        }
        parameterHint.setDataType(dataTypeClass);
        parameterHint.setNativeDataType(paramDefn.getNativeType());
        parameterHint.setIsInputOptional(paramDefn.isInputOptional());
        if (parameterHint.isInputMode()) {
            parameterHint.setDefaultInputValue(this.getParameterValueString(dataTypeClass, paramValue));
        }
        parameterHint.setIsNullable(paramDefn.isNullable());
        return parameterHint;
    }

    static {
        $assertionsDisabled = !ParameterUtil.class.desiredAssertionStatus();
    }
}

