/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.ExprManager;
import org.eclipse.birt.data.engine.impl.GroupBindingColumn;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.IQueryService;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.impl.document.IRDSave;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDUtil;
import org.eclipse.birt.data.engine.impl.document.StreamWrapper;
import org.eclipse.birt.data.engine.script.JSDummyRowObject;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class PreparedDummyQuery
implements IPreparedQuery {
    private DataEngineContext context;
    private ExprManager exprManager;
    private Scriptable sharedScope;
    private IQueryDefinition queryDefn;
    private ISubqueryDefinition subQueryDefn;
    private String subQueryName;
    private int subQueryIndex;
    private Map subQueryMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    PreparedDummyQuery(DataEngineContext context, IQueryDefinition queryDefn, Scriptable sharedScope) {
        this.queryDefn = queryDefn;
        this.init(context, queryDefn, sharedScope);
    }

    PreparedDummyQuery(DataEngineContext context, ISubqueryDefinition subQueryDefn, Scriptable sharedScope) {
        this.subQueryDefn = subQueryDefn;
        this.init(context, subQueryDefn, sharedScope);
    }

    void init(DataEngineContext context, IBaseQueryDefinition queryDefn, Scriptable sharedScope) {
        if (!$assertionsDisabled && queryDefn == null) {
            throw new AssertionError();
        }
        this.context = context;
        this.sharedScope = sharedScope;
        this.exprManager = new ExprManager();
        this.exprManager.addBindingExpr(null, queryDefn.getResultSetExpressions(), 0);
    }

    public IQueryDefinition getReportQueryDefn() {
        return this.queryDefn;
    }

    public Collection getParameterMetaData() throws BirtException {
        return null;
    }

    public IQueryResults execute(Scriptable queryScope) throws BirtException {
        return this.execute(null, queryScope);
    }

    public IQueryResults execute(IQueryResults outerResults, Scriptable queryScope) throws BirtException {
        return this.executeQuery(queryScope, null);
    }

    IQueryResults executeQuery(Scriptable queryScope, Scriptable parentScope) throws BirtException {
        this.processSubQuery();
        return new QueryResults(this, this.exprManager, this.getScope(queryScope), parentScope);
    }

    private void processSubQuery() {
        IBaseQueryDefinition queryDefn2 = null;
        queryDefn2 = this.queryDefn != null ? this.queryDefn : this.subQueryDefn;
        this.subQueryMap = new HashMap();
        Collection subQueryDefns = queryDefn2.getSubqueries();
        if (subQueryDefns != null) {
            Iterator it = subQueryDefns.iterator();
            while (it.hasNext()) {
                ISubqueryDefinition subQueryDefn = (ISubqueryDefinition)it.next();
                this.subQueryMap.put(subQueryDefn.getName(), subQueryDefn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Scriptable getScope(Scriptable queryScope) {
        Scriptable topScope = null;
        topScope = queryScope != null ? queryScope : this.sharedScope;
        Scriptable executionScope = null;
        Context cx = Context.enter();
        try {
            executionScope = cx.newObject(topScope);
            executionScope.setParentScope(topScope);
            executionScope.setPrototype(this.sharedScope);
        }
        finally {
            Context.exit();
        }
        return executionScope;
    }

    private IResultIterator execSubQuery(String parentQueryResultID, String name, Scriptable scope, Scriptable parentScope) throws BirtException {
        Object ob = this.subQueryMap.get(name);
        if (ob == null) {
            return null;
        }
        PreparedDummyQuery preparedQuery = new PreparedDummyQuery(this.context, (ISubqueryDefinition)ob, scope);
        preparedQuery.subQueryName = name;
        preparedQuery.subQueryIndex = 0;
        QueryResults queryResults = (QueryResults)preparedQuery.executeQuery(scope, parentScope);
        queryResults.setID(parentQueryResultID);
        return queryResults.getResultIterator();
    }

    static {
        $assertionsDisabled = !PreparedDummyQuery.class.desiredAssertionStatus();
    }

    private class DummyCachedResult
    extends CachedResultSet {
        private DummyCachedResult() {
        }

        public void doSave(StreamWrapper streamWrapper, boolean isSubQuery) throws DataException {
            try {
                if (streamWrapper.getStreamForResultClass() != null) {
                    IOUtil.writeInt((OutputStream)streamWrapper.getStreamForResultClass(), (int)0);
                }
                if (streamWrapper.getStreamForDataSet() != null) {
                    IOUtil.writeInt((OutputStream)streamWrapper.getStreamForDataSet(), (int)0);
                }
                IOUtil.writeInt((OutputStream)streamWrapper.getStreamForGroupInfo(), (int)0);
            }
            catch (IOException e) {
                throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Class");
            }
        }
    }

    private class RDSaveUtil {
        private DataEngineContext context;
        private String queryResultID;
        private IBaseQueryDefinition queryDefn;
        private IRDSave rdSave;
        private boolean isBasicSaved;

        RDSaveUtil(DataEngineContext context, IBaseQueryDefinition queryDefn, String queryResultID) {
            this.context = context;
            this.queryDefn = queryDefn;
            this.queryResultID = queryResultID;
        }

        void doSaveExpr(Map valueMap) throws DataException {
            if (!this.needsSaveToDoc()) {
                return;
            }
            if (!this.isBasicSaved) {
                int[] subQueryInfo;
                int groupLevel;
                this.isBasicSaved = true;
                if (PreparedDummyQuery.this.subQueryName == null) {
                    groupLevel = -1;
                    subQueryInfo = null;
                } else {
                    groupLevel = 1;
                    subQueryInfo = new int[]{0, 1};
                }
                this.getRdSave().saveResultIterator(new DummyCachedResult(), groupLevel, subQueryInfo);
            }
            this.getRdSave().saveExprValue(0, valueMap);
        }

        void doSaveFinish() throws DataException {
            if (!this.needsSaveToDoc()) {
                return;
            }
            if (!this.isBasicSaved) {
                this.isBasicSaved = true;
                this.getRdSave().saveResultIterator(new DummyCachedResult(), -1, new int[]{0, 1});
            }
            this.getRdSave().saveFinish(0);
        }

        void doSaveStart() throws DataException {
            if (!this.needsSaveToDoc()) {
                return;
            }
            this.getRdSave().saveStart();
        }

        private boolean needsSaveToDoc() {
            return this.context != null && this.context.getMode() == 1;
        }

        private IRDSave getRdSave() throws DataException {
            if (this.rdSave == null) {
                this.rdSave = RDUtil.newSave(this.context, this.queryDefn != null ? this.queryDefn : PreparedDummyQuery.this.subQueryDefn, 1, new QueryResultInfo(this.queryResultID, PreparedDummyQuery.this.subQueryName, PreparedDummyQuery.this.subQueryIndex));
            }
            return this.rdSave;
        }
    }

    private class ResultIterator
    implements IResultIterator {
        private QueryResults queryResults;
        private ExprManager exprManager;
        private Scriptable queryScope;
        private Scriptable jsDummyRowObject;
        private RDSaveUtil rdSaveUtil;
        private Map exprValueMap;
        private static final int NOT_START = 0;
        private static final int IN_ROW = 1;
        private static final int ENDED = 2;
        private int openStatus = 0;

        private void checkOpened() throws BirtException {
            if (this.openStatus != 1) {
                throw new DataException("data.engine.resultIteratorNotOpen");
            }
        }

        private ResultIterator(QueryResults queryResults, ExprManager exprManager, Scriptable queryScope, Scriptable parentScope) throws DataException {
            this.queryResults = queryResults;
            this.exprManager = exprManager;
            this.queryScope = queryScope;
            this.jsDummyRowObject = new JSDummyRowObject(exprManager, queryScope, parentScope);
            queryScope.put("row", queryScope, (Object)this.jsDummyRowObject);
            this.getRdSaveUtil().doSaveStart();
        }

        private Scriptable getJSDummyRowObject() {
            return this.jsDummyRowObject;
        }

        public IQueryResults getQueryResults() {
            return this.queryResults;
        }

        public Scriptable getScope() {
            return this.queryScope;
        }

        public IResultMetaData getResultMetaData() throws BirtException {
            return new ResultMetaData(new ResultClass(new ArrayList()));
        }

        public boolean next() throws BirtException {
            if (this.openStatus == 0) {
                this.openStatus = 1;
                return true;
            }
            if (this.openStatus == 1) {
                this.openStatus = 2;
                return false;
            }
            throw new DataException("data.engine.resultIteratorClosed");
        }

        public int getRowId() throws BirtException {
            return this.getRowIndex();
        }

        public int getRowIndex() throws BirtException {
            this.checkOpened();
            return 0;
        }

        public void moveTo(int rowIndex) throws BirtException {
            this.checkOpened();
            if (rowIndex > 0) {
                throw new DataException("data.engine.invalidRowIndex", new Integer(rowIndex));
            }
        }

        public Object getValue(String name) throws BirtException {
            this.checkOpened();
            if (this.exprManager.getExpr(name) == null) {
                throw new DataException("data.engine.InvalidBoundColumnName", name);
            }
            if (this.exprValueMap == null) {
                this.exprValueMap = new HashMap();
                HashMap<String, Object> realValueMap = new HashMap<String, Object>();
                Map exprMap = this.getBindingMap(this.exprManager.getBindingExprs());
                Iterator it = exprMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String exprName = (String)entry.getKey();
                    IBaseExpression baseExpr = (IBaseExpression)entry.getValue();
                    Object exprValue = ExprEvaluateUtil.evaluateRawExpression(baseExpr, this.queryScope);
                    this.exprValueMap.put(exprName, exprValue);
                    if (exprValue instanceof BirtException) continue;
                    realValueMap.put(exprName, exprValue);
                }
                this.getRdSaveUtil().doSaveExpr(this.exprValueMap);
            }
            return this.exprValueMap.get(name);
        }

        private Map getBindingMap(List manualBindingExprs) {
            HashMap<String, IBaseExpression> exprMap = new HashMap<String, IBaseExpression>();
            int size = manualBindingExprs.size();
            GroupBindingColumn[] groupBindingColumns = new GroupBindingColumn[size];
            Iterator itr = manualBindingExprs.iterator();
            while (itr.hasNext()) {
                GroupBindingColumn temp;
                groupBindingColumns[temp.getGroupLevel()] = temp = (GroupBindingColumn)itr.next();
            }
            for (int i = 0; i < size; ++i) {
                itr = groupBindingColumns[i].getColumnNames().iterator();
                while (itr.hasNext()) {
                    String exprName = (String)itr.next();
                    IBaseExpression baseExpr = groupBindingColumns[i].getExpression(exprName);
                    exprMap.put(exprName, baseExpr);
                }
            }
            return exprMap;
        }

        public Boolean getBoolean(String name) throws BirtException {
            return DataTypeUtil.toBoolean((Object)this.getValue(name));
        }

        public Integer getInteger(String name) throws BirtException {
            return DataTypeUtil.toInteger((Object)this.getValue(name));
        }

        public Double getDouble(String name) throws BirtException {
            return DataTypeUtil.toDouble((Object)this.getValue(name));
        }

        public String getString(String name) throws BirtException {
            return DataTypeUtil.toString((Object)this.getValue(name));
        }

        public BigDecimal getBigDecimal(String name) throws BirtException {
            return DataTypeUtil.toBigDecimal((Object)this.getValue(name));
        }

        public Date getDate(String name) throws BirtException {
            return DataTypeUtil.toDate((Object)this.getValue(name));
        }

        public Blob getBlob(String name) throws BirtException {
            return DataTypeUtil.toBlob((Object)this.getValue(name));
        }

        public byte[] getBytes(String name) throws BirtException {
            return DataTypeUtil.toBytes((Object)this.getValue(name));
        }

        public void skipToEnd(int groupLevel) throws BirtException {
            this.checkOpened();
            if (groupLevel > 0) {
                throw new DataException("data.engine.InvalidGroupLevel", new Integer(groupLevel));
            }
        }

        public int getStartingGroupLevel() throws BirtException {
            this.checkOpened();
            return 0;
        }

        public int getEndingGroupLevel() throws BirtException {
            this.checkOpened();
            return 0;
        }

        public IResultIterator getSecondaryIterator(String subQueryName, Scriptable scope) throws BirtException {
            this.checkOpened();
            return this.queryResults.preparedQuery.execSubQuery(this.getQueryResultsID(), subQueryName, scope != null ? scope : this.queryScope, this.jsDummyRowObject);
        }

        private String getQueryResultsID() {
            if (PreparedDummyQuery.this.subQueryName == null) {
                return this.queryResults.getID();
            }
            return this.queryResults.getID() + "/" + PreparedDummyQuery.this.subQueryName + "/" + PreparedDummyQuery.this.subQueryIndex;
        }

        public void close() throws BirtException {
            this.openStatus = 2;
            this.getRdSaveUtil().doSaveFinish();
        }

        public boolean findGroup(Object[] groupKeyValues) throws BirtException {
            this.checkOpened();
            return false;
        }

        private RDSaveUtil getRdSaveUtil() {
            if (this.rdSaveUtil == null) {
                this.rdSaveUtil = new RDSaveUtil(PreparedDummyQuery.this.context, PreparedDummyQuery.this.queryDefn, this.queryResults.getID());
            }
            return this.rdSaveUtil;
        }
    }

    private class QueryResults
    implements IQueryResults,
    IQueryService {
        private PreparedDummyQuery preparedQuery;
        private ExprManager exprManager;
        private Scriptable queryScope;
        private Scriptable parentScope;
        private ResultIterator resultIterator;
        private String queryResultID;
        private boolean isClosed;

        private QueryResults(PreparedDummyQuery preparedQuery, ExprManager exprManager, Scriptable queryScope, Scriptable parentScope) {
            this.preparedQuery = preparedQuery;
            this.exprManager = exprManager;
            this.queryScope = queryScope;
            this.parentScope = parentScope;
            this.isClosed = false;
        }

        public String getID() {
            if (this.queryResultID == null) {
                this.queryResultID = QueryResultIDUtil.nextID();
            }
            return this.queryResultID;
        }

        private void setID(String queryResultID) {
            this.queryResultID = queryResultID;
        }

        public IPreparedQuery getPreparedQuery() {
            return this.preparedQuery;
        }

        public IResultMetaData getResultMetaData() throws BirtException {
            return null;
        }

        public IResultIterator getResultIterator() throws BirtException {
            if (this.resultIterator == null) {
                this.resultIterator = new ResultIterator(this, this.exprManager, this.queryScope, this.parentScope);
            }
            return this.resultIterator;
        }

        public void close() throws BirtException {
            this.isClosed = true;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public int getNestedLevel() {
            return 0;
        }

        public Scriptable getQueryScope() {
            return this.queryScope;
        }

        public IExecutorHelper getExecutorHelper() throws DataException {
            return new IExecutorHelper(){

                public IExecutorHelper getParent() {
                    return null;
                }

                public Scriptable getJSRowObject() {
                    return resultIterator.getJSDummyRowObject();
                }
            };
        }

        public DataSetRuntime[] getDataSetRuntime(int nestedCount) {
            return null;
        }
    }
}

