/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Collection;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;
import org.eclipse.birt.data.engine.impl.IPreparedQueryService;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateTable;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDGroupUtil;
import org.eclipse.birt.data.engine.impl.document.RDLoadUtil;
import org.eclipse.birt.data.engine.impl.document.StreamManager;
import org.eclipse.birt.data.engine.impl.document.SubQueryIndexUtil;
import org.eclipse.birt.data.engine.impl.document.viewing.CachedSubExprResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.JSIVRowObject;
import org.eclipse.birt.data.engine.impl.document.viewing.NewInstanceHelper;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class PreparedIVSubQuery
extends PreparedDataSourceQuery
implements IPreparedQueryService {
    private String subQueryName;
    private String basedQueryResultID;
    private Scriptable sharedScope;
    private DataEngineContext dataEngineContext;
    private DataEngineSession session;
    private int parentIndex;
    private SubQueryIndexUtil subQueryManager;
    private int groupLevel;

    PreparedIVSubQuery(DataEngineImpl dataEngine, Scriptable scope, IQueryDefinition queryDefn, String basedQueryResultID, ISubqueryDefinition subQueryDefn, int groupLevel, int parentIndex, SubQueryIndexUtil subQueryManager) throws DataException {
        super(dataEngine, subQueryDefn, queryDefn, null, null);
        this.dataEngineContext = dataEngine.getContext();
        this.session = dataEngine.getSession();
        this.basedQueryResultID = basedQueryResultID;
        this.subQueryName = subQueryDefn.getName();
        this.parentIndex = parentIndex;
        this.sharedScope = scope;
        this.subQueryManager = subQueryManager;
        this.groupLevel = groupLevel;
    }

    public int getGroupLevel() {
        return this.groupLevel;
    }

    public Collection getParameterMetaData() throws BirtException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueryExecutor newExecutor() {
        Scriptable queryScope;
        Context cx = Context.enter();
        try {
            queryScope = cx.newObject(this.sharedScope);
            queryScope.setParentScope(this.sharedScope);
            queryScope.setPrototype(this.sharedScope);
        }
        finally {
            Context.exit();
        }
        return new IVExecutor(queryScope);
    }

    private class IVExecutor
    extends QueryExecutor {
        private Scriptable queryScope;
        private JSIVRowObject ivRowObject;

        public IVExecutor(Scriptable queryScope) {
            super(queryScope, PreparedIVSubQuery.this.queryDefn, new AggregateTable(), PreparedIVSubQuery.this.session);
            this.queryScope = queryScope;
        }

        protected IDataSource createOdiDataSource() throws DataException {
            return NewInstanceHelper.newDataSource();
        }

        protected DataSourceRuntime findDataSource() throws DataException {
            return NewInstanceHelper.newDataSourceRuntime(this.queryScope);
        }

        protected DataSetRuntime newDataSetRuntime() throws DataException {
            return new DataSetRuntime(this, NewInstanceHelper.newDataSetDesign(), this){
                private final /* synthetic */ IVExecutor this$1;
                {
                    this.this$1 = this$1;
                    super(x0, x1);
                }

                public Scriptable getScriptScope() {
                    return IVExecutor.access$100(this.this$1);
                }
            };
        }

        protected IQuery createOdiQuery() throws DataException {
            return NewInstanceHelper.newOdiQuery();
        }

        protected void populateOdiQuery() {
        }

        public Scriptable getQueryScope() {
            return this.queryScope;
        }

        protected IResultIterator executeOdiQuery(IEventHandler eventHandler) throws DataException {
            StreamManager streamManager = new StreamManager(PreparedIVSubQuery.this.dataEngineContext, new QueryResultInfo(PreparedIVSubQuery.this.basedQueryResultID, PreparedIVSubQuery.this.subQueryName, PreparedIVSubQuery.this.subQueryManager.getOldGroupInstanceIndex(PreparedIVSubQuery.this.parentIndex)));
            RDGroupUtil rdGroupUtil = RDLoadUtil.loadGroupUtil(streamManager, 2, 0);
            CachedSubExprResultSet resultIterator = new CachedSubExprResultSet(streamManager, PreparedIVSubQuery.this.subQueryManager, PreparedIVSubQuery.this.parentIndex, rdGroupUtil, PreparedIVSubQuery.this.session);
            this.ivRowObject = new JSIVRowObject();
            this.queryScope.put("row", this.queryScope, (Object)this.ivRowObject);
            this.ivRowObject.setResultSetIterator(resultIterator);
            return resultIterator;
        }

        static /* synthetic */ Scriptable access$100(IVExecutor x0) {
            return x0.queryScope;
        }
    }
}

