/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseTransform;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ExpressionCompiler;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.ExprManager;
import org.eclipse.birt.data.engine.impl.IPreparedQueryService;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedSubquery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.impl.QueryResults;
import org.eclipse.birt.data.engine.impl.ServiceForQueryResults;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateRegistry;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateTable;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

final class PreparedQuery {
    private IBaseQueryDefinition baseQueryDefn;
    private DataEngineContext dataEngineContext;
    private DataEngineSession session;
    private ExpressionCompiler expressionCompiler;
    private IPreparedQueryService queryService;
    private AggregateTable aggrTable;
    private Map appContext;
    private HashMap subQueryMap;
    private HashMap subQueryDefnMap;
    private static Logger logger;
    private ExprManager exprManager;
    static final /* synthetic */ boolean $assertionsDisabled;

    PreparedQuery(DataEngineSession session, DataEngineContext deContext, IBaseQueryDefinition queryDefn, IPreparedQueryService queryService, Map appContext) throws DataException {
        logger.logp(Level.FINE, PreparedQuery.class.getName(), "PreparedQuery", "PreparedQuery starts up.");
        if (!$assertionsDisabled && queryDefn == null) {
            throw new AssertionError();
        }
        this.expressionCompiler = new ExpressionCompiler();
        this.expressionCompiler.setDataSetMode(false);
        this.dataEngineContext = deContext;
        this.session = session;
        this.baseQueryDefn = queryDefn;
        this.queryService = queryService;
        this.appContext = appContext;
        this.exprManager = new ExprManager();
        this.subQueryMap = new HashMap();
        this.subQueryDefnMap = new HashMap();
        this.aggrTable = new AggregateTable(this.session.getSharedScope(), queryDefn.getGroups());
        logger.fine("Start to prepare a PreparedQuery.");
        this.prepare();
        logger.fine("Finished preparing the PreparedQuery.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare() throws DataException {
        Context cx = Context.enter();
        try {
            if (this.baseQueryDefn.getResultSetExpressions() != null && this.baseQueryDefn.getResultSetExpressions().size() > 0) {
                this.expressionCompiler.setDataSetMode(false);
            }
            List groups = this.baseQueryDefn.getGroups();
            HashSet<String> groupNameSet = new HashSet<String>();
            for (int i = 0; i < groups.size(); ++i) {
                IGroupDefinition group = (IGroupDefinition)groups.get(i);
                if (group.getName() == null || group.getName().trim().length() == 0) continue;
                for (int j = 0; j < groups.size(); ++j) {
                    if (!group.getName().equals(((IGroupDefinition)groups.get(j)).getName() == null ? "" : ((IGroupDefinition)groups.get(j)).getName()) || j == i) continue;
                    throw new DataException("data.engine.DuplicateGroupName");
                }
                groupNameSet.add(group.getName());
            }
            Map map = this.baseQueryDefn.getResultSetExpressions();
            if (map != null) {
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    IBaseExpression icbe = (IBaseExpression)map.get(key);
                    if (icbe.getGroupName().equals("Total.OVERALL") || groupNameSet.contains(icbe.getGroupName())) continue;
                    throw new DataException("data.engine.GroupNotExist", new Object[]{icbe.getGroupName(), key});
                }
            }
            for (int i = 0; i <= groups.size(); ++i) {
                this.prepareGroup(this.baseQueryDefn, i, cx);
            }
        }
        finally {
            Context.exit();
        }
    }

    private void prepareGroup(IBaseQueryDefinition baseQuery, int groupLevel, Context cx) throws DataException {
        IBaseTransform trans = baseQuery;
        String groupName = "Total.OVERALL";
        if (groupLevel != 0) {
            IGroupDefinition igd = (IGroupDefinition)trans.getGroups().get(groupLevel - 1);
            trans = igd;
            groupName = igd.getName();
        }
        ArrayList<IBaseExpression> exprCol = new ArrayList<IBaseExpression>();
        HashMap resultSetExpressions = new HashMap();
        Map map = baseQuery.getResultSetExpressions();
        if (map != null) {
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                IBaseExpression icbe = (IBaseExpression)map.get(key);
                if (!icbe.getGroupName().equals(groupName)) continue;
                exprCol.add(icbe);
                resultSetExpressions.put(key, icbe);
            }
        }
        this.prepareExpressions(exprCol, groupLevel, false, true, cx);
        String key = null;
        if (trans instanceof IGroupDefinition) {
            IGroupDefinition gd = (IGroupDefinition)trans;
            key = gd.getKeyColumn() != null ? gd.getKeyColumn() : gd.getKeyExpression();
        }
        this.exprManager.addBindingExpr(key, resultSetExpressions, groupLevel);
        Collection subQueries = trans.getSubqueries();
        Iterator subIt = subQueries.iterator();
        while (subIt.hasNext()) {
            ISubqueryDefinition subquery = (ISubqueryDefinition)subIt.next();
            PreparedSubquery pq = new PreparedSubquery(this.session, this.dataEngineContext, subquery, this.queryService, groupLevel);
            this.subQueryMap.put(subquery.getName(), pq);
            this.subQueryDefnMap.put(subquery.getName(), new Object[]{subquery, new Integer(groupLevel)});
        }
    }

    private void prepareExpressions(Collection expressions, int groupLevel, boolean afterGroup, boolean isDetailedRow, Context cx) throws DataException {
        if (expressions == null) {
            return;
        }
        AggregateRegistry reg = this.aggrTable.getAggrRegistry(groupLevel, -1, isDetailedRow, cx);
        Iterator it = expressions.iterator();
        while (it.hasNext()) {
            this.prepareExpression((IBaseExpression)it.next(), groupLevel, cx, reg);
        }
    }

    private void prepareExpression(IBaseExpression expr, int groupLevel, Context cx, AggregateRegistry reg) {
        ExpressionCompiler compiler = this.expressionCompiler;
        if (expr instanceof IScriptExpression) {
            String exprText = ((IScriptExpression)expr).getText();
            CompiledExpression handle = compiler.compile(exprText, reg, cx);
            expr.setHandle(handle);
        } else if (expr instanceof IConditionalExpression) {
            IConditionalExpression ce = (IConditionalExpression)expr;
            ce = this.transformConditionalExpression(ce);
            this.prepareExpression(ce.getExpression(), groupLevel, cx, reg);
            if (ce.getOperand1() != null) {
                this.prepareExpression(ce.getOperand1(), groupLevel, cx, reg);
            }
            if (ce.getOperand2() != null) {
                this.prepareExpression(ce.getOperand2(), groupLevel, cx, reg);
            }
            expr.setHandle(ce);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    private IConditionalExpression transformConditionalExpression(IConditionalExpression ce) {
        String prefix = null;
        switch (ce.getOperator()) {
            case 14: {
                prefix = "Total.isTopN";
                break;
            }
            case 16: {
                prefix = "Total.isTopNPercent";
                break;
            }
            case 15: {
                prefix = "Total.isBottomN";
                break;
            }
            case 17: {
                prefix = "Total.isBottomNPercent";
            }
        }
        if (prefix != null) {
            ce = new ConditionalExpression(prefix + "(" + ce.getExpression().getText() + "," + ce.getOperand1().getText() + ")", 11);
        }
        return ce;
    }

    QueryResults doPrepare(IQueryResults outerResults, Scriptable scope, QueryExecutor executor, PreparedDataSourceQuery dataSourceQuery) throws DataException {
        if (this.baseQueryDefn == null) {
            DataException e = new DataException("data.engine.PreparedQueryClosed");
            logger.logp(Level.WARNING, PreparedQuery.class.getName(), "doPrepare", "PreparedQuery instance is closed.", (Throwable)((Object)e));
            throw e;
        }
        executor.setAppContext(this.appContext);
        logger.finer("Start to prepare the execution.");
        executor.prepareExecution(outerResults, scope);
        logger.finer("Finish preparing the execution.");
        return new QueryResults(new ServiceForQueryResults(this.dataEngineContext, executor.getQueryScope(), executor.getNestedLevel() + 1, dataSourceQuery, this.queryService, executor, this.baseQueryDefn, this.exprManager));
    }

    ISubqueryDefinition getSubQueryDefn(String subQueryName) {
        return (ISubqueryDefinition)((Object[])this.subQueryDefnMap.get(subQueryName))[0];
    }

    int getSubQueryLevel(String subQueryName) {
        return (Integer)((Object[])this.subQueryDefnMap.get(subQueryName))[1];
    }

    QueryResults execSubquery(IResultIterator iterator, String subQueryName, Scriptable subScope) throws DataException {
        if (!$assertionsDisabled && subQueryName == null) {
            throw new AssertionError();
        }
        PreparedSubquery subquery = (PreparedSubquery)this.subQueryMap.get(subQueryName);
        if (subquery == null) {
            DataException e = new DataException("data.engine.NoSubQueryName", subQueryName);
            logger.logp(Level.FINE, PreparedQuery.class.getName(), "execSubquery", "Subquery name not found", (Throwable)((Object)e));
            throw e;
        }
        return subquery.execute(iterator, subScope);
    }

    void close() {
        this.baseQueryDefn = null;
        this.aggrTable = null;
        this.subQueryMap = null;
        logger.logp(Level.FINER, PreparedQuery.class.getName(), "close", "Prepared query closed");
    }

    Scriptable getSharedScope() {
        return this.session.getSharedScope();
    }

    IBaseQueryDefinition getBaseQueryDefn() {
        return this.baseQueryDefn;
    }

    AggregateTable getAggrTable() {
        return this.aggrTable;
    }

    static {
        $assertionsDisabled = !PreparedQuery.class.desiredAssertionStatus();
        logger = Logger.getLogger(DataEngineImpl.class.getName());
    }
}

