/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.QueryResults;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class ResultMetaData
implements IResultMetaData {
    IResultClass m_odiResultClass;
    protected static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ResultMetaData(IResultClass odiResultClass) {
        if (!$assertionsDisabled && odiResultClass == null) {
            throw new AssertionError();
        }
        this.m_odiResultClass = odiResultClass;
        logger.logp(Level.FINER, QueryResults.class.getName(), "QueryResults", "QueryResults starts up");
    }

    public int getColumnCount() {
        logger.logp(Level.FINE, QueryResults.class.getName(), "getColumnCount", "");
        return this.m_odiResultClass.getFieldCount();
    }

    public String getColumnName(int index) throws DataException {
        logger.logp(Level.FINE, QueryResults.class.getName(), "getColumnName", "the column name at the specified index", new Integer(index));
        return this.m_odiResultClass.getFieldName(index);
    }

    public String getColumnAlias(int index) throws DataException {
        logger.logp(Level.FINE, QueryResults.class.getName(), "getColumnAlias", "the column alias at the specified index", new Integer(index));
        return this.m_odiResultClass.getFieldAlias(index);
    }

    public int getColumnType(int index) throws DataException {
        logger.logp(Level.FINE, QueryResults.class.getName(), "getColumnType", "the data type of the column at the specified index", new Integer(index));
        Class odiDataType = this.m_odiResultClass.getFieldValueClass(index);
        return DataTypeUtil.toApiDataType((Class)odiDataType);
    }

    public String getColumnTypeName(int index) throws DataException {
        logger.logp(Level.FINE, QueryResults.class.getName(), "getColumnTypeName", "the Data Engine data type name of the column at the specified index", new Integer(index));
        return DataType.getName((int)this.getColumnType(index));
    }

    public String getColumnNativeTypeName(int index) throws DataException {
        logger.logp(Level.FINE, QueryResults.class.getName(), "getColumnNativeTypeName", "the data provider specific data type name of the specified column", new Integer(index));
        return this.m_odiResultClass.getFieldNativeTypeName(index);
    }

    public String getColumnLabel(int index) throws DataException {
        logger.logp(Level.FINE, QueryResults.class.getName(), "getColumnLabel", "the label or display name of the column at the specified index", new Integer(index));
        return this.m_odiResultClass.getFieldLabel(index);
    }

    public boolean isComputedColumn(int index) throws DataException {
        logger.logp(Level.FINE, QueryResults.class.getName(), "isComputedColumn", "whether the specified projected column is defined as a computed column", new Integer(index));
        return this.m_odiResultClass.isCustomField(index);
    }

    static {
        $assertionsDisabled = !ResultMetaData.class.desiredAssertionStatus();
        logger = Logger.getLogger(ResultMetaData.class.getName());
    }
}

