/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.Hashtable;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.Driver;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;

class DriverManager {
    private static DriverManager sm_driverManager;
    private Hashtable m_loadedDrivers;
    private static final String sm_className;
    private static LogHelper sm_logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    private DriverManager() {
    }

    static DriverManager getInstance() {
        if (sm_driverManager == null) {
            sm_driverManager = new DriverManager();
        }
        return sm_driverManager;
    }

    static void releaseInstance() {
        sm_driverManager = null;
        sm_logger = null;
    }

    private static LogHelper getLogger() {
        if (sm_logger == null) {
            sm_logger = LogHelper.getInstance("org.eclipse.birt.data.engine.odaconsumer");
        }
        return sm_logger;
    }

    IDriver getDriverHelper(String dataSourceElementId) throws DataException {
        String methodName = "getDriverHelper";
        DriverManager.getLogger().entering(sm_className, "getDriverHelper", dataSourceElementId);
        Driver driver = this.getDriver(dataSourceElementId);
        IDriver ret = driver.getDriverHelper();
        DriverManager.getLogger().exiting(sm_className, "getDriverHelper", ret);
        return ret;
    }

    String getExtensionDataSourceId(String dataSourceElementId) throws DataException {
        String methodName = "getExtensionDataSourceId";
        DriverManager.getLogger().entering(sm_className, "getExtensionDataSourceId", dataSourceElementId);
        Driver driver = this.getDriver(dataSourceElementId);
        ExtensionManifest config = driver.getDriverExtensionConfig();
        String ret = config.getDataSourceElementID();
        DriverManager.getLogger().exiting(sm_className, "getExtensionDataSourceId", ret);
        return ret;
    }

    void setDriverLogConfiguration(String dataSourceElementId) {
        String methodName = "setDriverLogConfiguration";
        if (DriverManager.getLogger().isLoggingEnterExitLevel()) {
            DriverManager.getLogger().entering(sm_className, "setDriverLogConfiguration", new Object[]{dataSourceElementId});
        }
        if (!$assertionsDisabled && dataSourceElementId == null) {
            throw new AssertionError();
        }
        Driver driver = this.getDriver(dataSourceElementId);
        if (!$assertionsDisabled && driver == null) {
            throw new AssertionError();
        }
        driver.setLogConfiguration();
        DriverManager.getLogger().exiting(sm_className, "setDriverLogConfiguration");
    }

    private Driver getDriver(String dataSourceElementId) {
        if (!($assertionsDisabled || dataSourceElementId != null && dataSourceElementId.length() != 0)) {
            throw new AssertionError();
        }
        Driver driver = (Driver)this.getLoadedDrivers().get(dataSourceElementId);
        if (driver == null) {
            driver = new Driver(dataSourceElementId);
            this.getLoadedDrivers().put(dataSourceElementId, driver);
        }
        return driver;
    }

    Hashtable getLoadedDrivers() {
        if (this.m_loadedDrivers == null) {
            this.m_loadedDrivers = new Hashtable();
        }
        return this.m_loadedDrivers;
    }

    static {
        $assertionsDisabled = !DriverManager.class.desiredAssertionStatus();
        sm_driverManager = null;
        sm_className = DriverManager.class.getName();
    }
}

