/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.install;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.SoftwareVersion;

public class AlterFileList {
    private static final String PREFIX = "AlterVersion";
    private static final String SUFFIX = ".sql";

    public static String[] getFiles(SoftwareVersion softwareVersion, String string) throws GeneralException {
        File file = new File(string);
        if (!file.isDirectory() || !file.canRead()) {
            throw new GeneralException("No valid sql directory");
        }
        Object[] objectArray = file.listFiles(new SQLFileNameFilter());
        if (objectArray == null | objectArray.length == 0) {
            return null;
        }
        Arrays.sort(objectArray);
        int n = 0;
        if (softwareVersion != null) {
            int n2 = SoftwareVersion.encode((int)softwareVersion.svVendor, (int)softwareVersion.svVersion, (int)softwareVersion.svRelease, (int)softwareVersion.svModification, (int)softwareVersion.svSubModification);
            while (n < objectArray.length) {
                int n3 = AlterFileList.getFileVRM(((File)objectArray[n]).getName());
                if (n3 > n2) break;
                ++n;
            }
        }
        if (n >= objectArray.length) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n < objectArray.length) {
            arrayList.add(((File)objectArray[n]).getName());
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static int getFileVRM(String string) {
        String string2 = string.substring(PREFIX.length(), string.indexOf(46));
        return Integer.parseInt(string2);
    }

    private static class SQLFileNameFilter
    implements FilenameFilter {
        private SQLFileNameFilter() {
        }

        public boolean accept(File file, String string) {
            boolean bl = false;
            try {
                if (string.startsWith(AlterFileList.PREFIX) && string.endsWith(AlterFileList.SUFFIX)) {
                    AlterFileList.getFileVRM(string);
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            return bl;
        }
    }
}

