/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.SQLException;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.CreatorNameQueryable;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class EditableObjectProxy {
    public static final String DUPLICATE_MSG_ID = "SRV0096E";
    private RepositoryAccessor accessor;
    private CreateHeader createHeader;
    private String objectType;

    public EditableObjectProxy(RepositoryAccessor repositoryAccessor, CreateHeader createHeader, String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.EditableObjectProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"EditableObjectProxy", (String)"pAccessor, pCreateHeader, pObjectType");
        }
        this.accessor = repositoryAccessor;
        this.createHeader = createHeader;
        this.objectType = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.EditableObjectProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"EditableObjectProxy");
        }
    }

    public void initSelect(String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.EditableObjectProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initSelect", (String)"additionalColumns");
        }
        StringBuffer stringBuffer = new StringBuffer(120);
        stringBuffer.append("SELECT creator, name, description, last_modified");
        if (string != null) {
            stringBuffer.append(", ");
            stringBuffer.append(string);
        }
        stringBuffer.append(" FROM ");
        stringBuffer.append(this.accessor.tableName);
        stringBuffer.append(" WHERE ");
        stringBuffer.append(((CreatorNameQueryable)((Object)this.accessor)).getIDColumnName());
        stringBuffer.append(" = ");
        stringBuffer.append(Integer.toString(this.createHeader.ID));
        this.accessor.selectStmt = this.accessor.prepareStmt(stringBuffer.toString());
        this.accessor.stmtPhase = 3;
        try {
            this.accessor.resultSet = this.accessor.selectStmt.executeQuery();
            this.accessor.stmtPhase = 2;
            if (this.accessor.resultSet.next()) {
                this.accessor.stmtPhase = 1;
                this.accessor.colIndex = 1;
                this.createHeader.creator = this.accessor.getString(this.accessor.resultSet);
                this.createHeader.setName(this.accessor.getString(this.accessor.resultSet));
                this.createHeader.setDescription(this.accessor.getString(this.accessor.resultSet));
                this.createHeader.lastModified = this.accessor.getLong(this.accessor.resultSet);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.EditableObjectProxy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"initSelect", (Throwable)sQLException);
            }
            this.accessor.stmtType = 0;
            this.accessor.sqlError(sQLException);
        }
        if (this.accessor.stmtPhase == 2) {
            String string2;
            this.accessor.closeSelect();
            if (this.createHeader.creator == null) {
                string2 = Integer.toString(this.createHeader.ID);
            } else {
                stringBuffer.setLength(0);
                stringBuffer.append(this.createHeader.creator);
                stringBuffer.append('.');
                stringBuffer.append(this.createHeader.getName());
                string2 = stringBuffer.toString();
            }
            Object[] objectArray = new Object[]{this.objectType, string2};
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.EditableObjectProxy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"initSelect");
            }
            throw new GeneralException(MessageLog.getMessage((String)"SRV0199E", (Object[])objectArray));
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.EditableObjectProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initSelect");
        }
    }

    public void initInsert(String string) throws GeneralException {
        int n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.EditableObjectProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initInsert", (String)"additionalColumns");
        }
        if (string == null) {
            n = 0;
        } else {
            n = 1;
            int n2 = 0;
            while ((n2 = string.indexOf(44, n2)) > 0) {
                ++n;
                ++n2;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(140);
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(this.accessor.tableName);
        stringBuffer.append(" (creator, name, description, last_modified, last_mod_user, ");
        stringBuffer.append(((CreatorNameQueryable)((Object)this.accessor)).getIDColumnName());
        if (string != null) {
            stringBuffer.append(", ");
            stringBuffer.append(string);
        }
        stringBuffer.append(") VALUES (?,?,?,?,?,?");
        while (n > 0) {
            stringBuffer.append(",?");
            --n;
        }
        stringBuffer.append(')');
        try {
            this.createHeader.lastModified = SQLUtil.getTimestamp(this.accessor.dbc).getTime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.EditableObjectProxy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"initInsert", (Throwable)exception);
            }
            return;
        }
        this.accessor.insertStmt = this.accessor.prepareStmt(stringBuffer.toString());
        this.accessor.stmtPhase = 0;
        this.accessor.colIndex = 1;
        this.accessor.stmtType = 1;
        try {
            this.accessor.setString(this.accessor.insertStmt, this.createHeader.creator);
            this.accessor.setString(this.accessor.insertStmt, this.createHeader.getTrueName());
            this.accessor.setString(this.accessor.insertStmt, this.createHeader.getTrueDescription());
            this.accessor.setLong(this.accessor.insertStmt, this.createHeader.lastModified);
            this.accessor.setString(this.accessor.insertStmt, this.createHeader.lastModUser);
            this.accessor.setInt(this.accessor.insertStmt, this.createHeader.ID);
            this.accessor.stmtPhase = 3;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.EditableObjectProxy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"initInsert", (Throwable)sQLException);
            }
            this.accessor.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.EditableObjectProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initInsert");
        }
    }

    public void finishInsert() throws GeneralException {
        this.finishInsert(false);
    }

    public void finishInsert(boolean bl) throws GeneralException {
        block15: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.EditableObjectProxy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"finishInsert", (String)"ignoreDuplicateKeyError");
            }
            this.accessor.stmtPhase = 3;
            try {
                this.accessor.insertStmt.executeUpdate();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.EditableObjectProxy");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"finishInsert", (Throwable)sQLException);
                }
                if (!SQLUtil.isDuplicateKeyViolation(sQLException)) {
                    this.accessor.sqlError(sQLException);
                }
                if (bl) break block15;
                String string = String.valueOf(this.createHeader.creator) + "." + this.createHeader.getName();
                Object[] objectArray = new Object[]{this.objectType, string};
                string = MessageLog.getMessage((String)DUPLICATE_MSG_ID, (Object[])objectArray);
                this.accessor.cleanup();
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.EditableObjectProxy");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"finishInsert");
                }
                throw new GeneralException(string);
            }
        }
        this.accessor.closeInsert();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.EditableObjectProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"finishInsert");
        }
    }

    public void deleteByID(int n, String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.EditableObjectProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByID", (String)"id, idColumnName");
        }
        StringBuffer stringBuffer = new StringBuffer(120);
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(this.accessor.tableName);
        stringBuffer.append(" WHERE ");
        stringBuffer.append(string);
        stringBuffer.append(" = ");
        stringBuffer.append(Integer.toString(n));
        this.accessor.deleteStmt = this.accessor.prepareStmt(stringBuffer.toString());
        try {
            this.accessor.executeUpdate(this.accessor.deleteStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.EditableObjectProxy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteByID", (Throwable)sQLException);
            }
            this.accessor.stmtType = 3;
            this.accessor.sqlError(sQLException);
        }
        this.accessor.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.EditableObjectProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByID");
        }
    }
}

