/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.HasID;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class SQLUtil {
    public static final int RESOURCE_ID = 1;
    public static final int RUN_NUMBER_ID = 2;
    public static final int SCHEDULE_ID = 3;
    public static final int JOB_ID = 4;
    public static final int CALENDAR_ID = 5;
    public static final int ALERT_LOG_ID = 6;
    public static final int SUCCESS = 0;
    public static final int DUPLICATE = 4;
    public static final int NOOP = 8;
    public static final int ERROR = 16;
    public static final int ROW_NOT_FOUND = 100;
    public static final String SQLSTATE_ROW_NOT_FOUND = "2000";
    public static final byte UNKNOWN = 0;
    public static final byte ORACLE = 1;
    public static final byte MSSQL = 2;
    public static final byte INTERBASE = 3;
    public static final byte SYBASE = 4;
    public static final byte DB2_UDB = 5;
    public static final byte CLOUDSCAPE = 6;
    public static final byte DERBY = 7;
    public static byte repositoryType;
    public static boolean inetDriver;
    public static boolean sortOrderNotASCII;
    private static final int MAX_ORACLE_IN = 999;
    private static String mssqlSortOrderQuery;
    private static final String UPDATE_IDENTIFIER_SQL = "update t_identifier set identifier = identifier + ? where id_type = ?";
    private static final String SELECT_IDENTIFIER_SQL = "select identifier from t_identifier where id_type = ?";
    private static final int[] BINARY_SORT_ORDERS;
    private static Class[] SH_INT_PARAM;
    private static Object[] SH_ZERO_ARG;
    private static Object[] SH_ONE_ARG;

    static {
        inetDriver = false;
        sortOrderNotASCII = false;
        mssqlSortOrderQuery = "select attribute_value from master.dbo.spt_server_info where attribute_id = 18";
        BINARY_SORT_ORDERS = new int[]{30, 40, 50, 80, 104, 112, 128, 136, 144, 152, 192, 194, 196, 204};
        SH_INT_PARAM = new Class[]{Integer.TYPE};
        SH_ZERO_ARG = new Object[]{new Integer(0)};
        SH_ONE_ARG = new Object[]{new Integer(1)};
    }

    public static void logSQLException(String string, SQLException sQLException, Object[] objectArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"logSQLException", (String)"msgID, e, args");
        }
        String string2 = SQLUtil.getSQLExceptionMsg(string, sQLException, objectArray);
        MessageLog.getThreadLog().println(string2);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"logSQLException");
        }
    }

    public static String getSQLExceptionMsg(String string, SQLException sQLException, Object[] objectArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getSQLExceptionMsg", (String)"msgID, e, args");
        }
        StringBuffer stringBuffer = new StringBuffer(320);
        stringBuffer.append(MessageLog.getMessage((String)string, (Object[])objectArray));
        stringBuffer.append('\n');
        stringBuffer.append("                         ");
        SQLUtil.appendSQLException(sQLException, stringBuffer);
        String string2 = stringBuffer.toString();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getSQLExceptionMsg", (Object)string2);
        }
        return string2;
    }

    public static void appendInClause(StringBuffer stringBuffer, String string, int[] nArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendInClause", (String)"buffer, colName, idArray");
        }
        SQLUtil.appendInClause(stringBuffer, string, nArray, true, false);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendInClause");
        }
    }

    public static void appendInClause(StringBuffer stringBuffer, String string, int[] nArray, boolean bl, boolean bl2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendInClause", (String)"buffer, colName, idArray, isInList, appendAnd");
        }
        SQLUtil.appendInClause(stringBuffer, string, nArray, bl, bl2, false);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendInClause");
        }
    }

    public static void appendInClause(StringBuffer stringBuffer, String string, int[] nArray, boolean bl, boolean bl2, boolean bl3) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendInClause", (String)"buffer, colName, idArray, isInList, appendAnd, quoteIt");
        }
        if (nArray != null && nArray.length > 0) {
            if (bl2) {
                stringBuffer.append(" and");
            }
            stringBuffer.append(' ');
            if (!bl) {
                stringBuffer.append("not ");
            }
            stringBuffer.append('(');
            if (nArray.length < 999 || !SQLUtil.isOracle()) {
                SQLUtil.appendPiece(stringBuffer, string, nArray, 0, nArray.length, bl3);
            } else {
                int n = 0;
                while (n < nArray.length) {
                    int n2;
                    if (n > 0) {
                        stringBuffer.append(" or ");
                    }
                    if ((n2 = n + 999) > nArray.length) {
                        n2 = nArray.length;
                    }
                    SQLUtil.appendPiece(stringBuffer, string, nArray, n, n2, bl3);
                    n = n2;
                }
            }
            stringBuffer.append(')');
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendInClause");
        }
    }

    private static void appendPiece(StringBuffer stringBuffer, String string, int[] nArray, int n, int n2, boolean bl) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendPiece", (String)"buffer, colName, idArray, start, end, quoteIt");
        }
        stringBuffer.append(string);
        stringBuffer.append(" in (");
        int n3 = n2;
        while (n3 > n) {
            --n3;
            if (bl) {
                stringBuffer.append("'");
            }
            stringBuffer.append(nArray[n3]);
            if (bl) {
                stringBuffer.append("'");
            }
            stringBuffer.append(',');
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        stringBuffer.append(')');
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendPiece");
        }
    }

    public static void appendInClause(StringBuffer stringBuffer, HasID hasID) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendInClause", (String)"buf, element");
        }
        stringBuffer.append(" in ");
        int n = 40;
        while (hasID != null) {
            stringBuffer.append((char)n);
            stringBuffer.append(hasID.getID());
            n = 44;
            hasID = (HasID)hasID.getNext();
        }
        stringBuffer.append(')');
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendInClause");
        }
    }

    public static boolean getBoolean(ResultSet resultSet, int n) throws SQLException {
        return resultSet.getByte(n) % 2 == 1;
    }

    public static void setBoolean(PreparedStatement preparedStatement, int n, boolean bl) throws SQLException {
        SQLUtil.setByte(preparedStatement, n, bl ? (byte)1 : 0);
    }

    public static boolean isNullString(String string) {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"isNullString", (String)"s");
        }
        boolean bl2 = bl = string == null || string.length() == 0 || string.length() == 1 && string.charAt(0) == ' ';
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isNullString", (boolean)bl);
        }
        return bl;
    }

    public static void setByte(PreparedStatement preparedStatement, int n, byte by) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setByte", (String)"prep, i, value");
        }
        if (repositoryType == 4) {
            byte by2 = by;
            String string = String.valueOf(by2);
            preparedStatement.setString(n, string);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"setByte");
            }
            return;
        }
        preparedStatement.setByte(n, by);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setByte");
        }
    }

    public static byte getByte(ResultSet resultSet, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getByte", (String)"rs, i");
        }
        if (repositoryType == 4) {
            String string = resultSet.getString(n);
            byte by = (byte)Integer.parseInt(string);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getByte", (byte)by);
            }
            return by;
        }
        byte by = resultSet.getByte(n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getByte", (byte)by);
        }
        return by;
    }

    public static void setBytes(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setBytes", (String)"prep, i, value");
        }
        if (repositoryType == 4) {
            byte[] byArray2 = new byte[byArray.length + 1];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray2[byArray.length] = 1;
            preparedStatement.setBytes(n, byArray2);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"setBytes");
            }
            return;
        }
        preparedStatement.setBytes(n, byArray);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setBytes");
        }
    }

    public static byte[] getBytes(ResultSet resultSet, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getBytes", (String)"rs, i");
        }
        byte[] byArray = resultSet.getBytes(n);
        if (repositoryType == 4 && byArray.length > 1 && byArray[byArray.length - 1] == 1) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length - 1);
            byte[] byArray3 = byArray2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getBytes", (Object)byArray3);
            }
            return byArray3;
        }
        byte[] byArray4 = byArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getBytes", (Object)byArray4);
        }
        return byArray4;
    }

    public static boolean isDuplicateKeyViolation(SQLException sQLException) {
        String string = sQLException.getSQLState();
        return string != null && string.length() == 5 && string.charAt(0) == '2' && string.charAt(1) == '3';
    }

    public static boolean isRowNotFound(SQLException sQLException) {
        String string = sQLException.getSQLState();
        return string != null && string.equals(SQLSTATE_ROW_NOT_FOUND);
    }

    public static boolean isDeadlock(SQLException sQLException) {
        int n = sQLException.getErrorCode();
        String string = sQLException.getSQLState();
        return repositoryType == 2 && n == 1205 || repositoryType == 7 && string != null && string.equals("40001") || repositoryType == 5 && n == -911 || repositoryType == 1 && n == 60;
    }

    public static String generateAliasedDelete(String string, String string2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"generateAliasedDelete", (String)"tableName, alias");
        }
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("DELETE ");
        if (repositoryType == 2 || repositoryType == 4) {
            stringBuffer.append(string);
            stringBuffer.append(" FROM ");
            stringBuffer.append(string);
            stringBuffer.append(" AS ");
        } else {
            stringBuffer.append("FROM ");
            stringBuffer.append(string);
            stringBuffer.append(' ');
        }
        stringBuffer.append(string2);
        String string3 = stringBuffer.toString();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"generateAliasedDelete", (Object)string3);
        }
        return string3;
    }

    public static byte[] makeCaseBitmask(String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"makeCaseBitmask", (String)"s");
        }
        int n = string.length();
        byte[] byArray = new byte[n + 7 >> 3];
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if ((n4 & 7) != 0) {
                n3 = (byte)(n3 << 1);
            } else {
                n3 = 1;
                ++n2;
            }
            if (Character.isUpperCase(string.charAt(n4))) {
                int n5 = n2;
                byArray[n5] = (byte)(byArray[n5] | n3);
            }
            ++n4;
        }
        byte[] byArray2 = byArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"makeCaseBitmask", (Object)byArray2);
        }
        return byArray2;
    }

    public static void errorCleanup(Connection connection, Statement statement) {
        block12: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"errorCleanup", (String)"dbConnection, stmt");
            }
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block12;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"errorCleanup", (Throwable)sQLException);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"errorCleanup");
        }
    }

    public static short closeResources(ResultSet resultSet) {
        short s = 0;
        if (resultSet != null) {
            try {
                resultSet.getStatement().close();
                resultSet.close();
            }
            catch (SQLException sQLException) {
                s = 1;
            }
        }
        return s;
    }

    public static int getIdentifier(int n, int n2, Connection connection) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getIdentifier", (String)"idType, idCount, dbConnection");
        }
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        int n3 = 3;
        while (true) {
            try {
                if (preparedStatement == null) {
                    preparedStatement = connection.prepareStatement(UPDATE_IDENTIFIER_SQL);
                }
                preparedStatement.setInt(1, n2);
                preparedStatement.setInt(2, n);
                int n4 = preparedStatement.executeUpdate();
                if (n4 <= 0) {
                    MessageLog.logMessage((String)"GEN0102E", (Object)new Integer(n));
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"getIdentifier");
                    }
                    throw new SQLException();
                }
                if (statement == null) {
                    statement = connection.prepareStatement(SELECT_IDENTIFIER_SQL);
                }
                statement.setInt(1, n);
                ResultSet resultSet = statement.executeQuery();
                resultSet.next();
                int n5 = resultSet.getInt(1);
                connection.commit();
                statement.close();
                preparedStatement.close();
                int n6 = n5 - n2;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getIdentifier", (int)n6);
                }
                return n6;
            }
            catch (SQLException sQLException) {
                block28: {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"getIdentifier", (Throwable)sQLException);
                    }
                    if (SQLUtil.isDeadlock(sQLException) && --n3 >= 0) {
                        try {
                            Thread.sleep(2000L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {}
                        break block28;
                        continue;
                    }
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException2) {}
                SQLUtil.logSQLException("GEN0103E", sQLException, new Object[]{new Integer(n)});
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getIdentifier");
                }
                throw sQLException;
            }
            break;
        }
    }

    public static void parseSortOrderRow(String string) throws IOException {
        int n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"parseSortOrderRow", (String)"row");
        }
        StringReader stringReader = new StringReader(string);
        StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(33, 60);
        streamTokenizer.wordChars(62, Integer.MAX_VALUE);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.slashStarComments(false);
        streamTokenizer.slashSlashComments(false);
        streamTokenizer.lowerCaseMode(false);
        boolean bl = false;
        String string2 = null;
        boolean bl2 = false;
        while (!bl2 && (n = streamTokenizer.nextToken()) != -1) {
            if (n != -3) {
                if (string2 == null) continue;
                bl = true;
                continue;
            }
            if (!bl) {
                string2 = streamTokenizer.sval;
                continue;
            }
            if (string2.equals("sort_order_num")) {
                bl2 = true;
                continue;
            }
            string2 = null;
            bl = false;
        }
        if (bl2) {
            int n2;
            block16: {
                n2 = -1;
                try {
                    n2 = Integer.parseInt(streamTokenizer.sval);
                }
                catch (NumberFormatException numberFormatException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block16;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"parseSortOrderRow", (Throwable)numberFormatException);
                }
            }
            int n3 = Arrays.binarySearch(BINARY_SORT_ORDERS, n2);
            if (n3 >= 0) {
                sortOrderNotASCII = false;
            }
        }
        ((Reader)stringReader).close();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"parseSortOrderRow");
        }
    }

    public static void handleMSSQL(Connection connection) {
        Statement statement;
        block44: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"handleMSSQL", (String)"dbc");
            }
            sortOrderNotASCII = true;
            statement = null;
            try {
                statement = connection.createStatement();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"handleMSSQL", (Throwable)sQLException);
                }
                MessageLog.logException((String)"SRV0131E", (Exception)sQLException);
            }
            if (statement == null) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"handleMSSQL");
                }
                return;
            }
            ResultSet resultSet = null;
            try {
                resultSet = statement.executeQuery(mssqlSortOrderQuery);
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"handleMSSQL", (Throwable)sQLException);
                }
                MessageLog.logException((String)"SRV0132E", (Exception)sQLException);
            }
            if (resultSet != null) {
                boolean bl = false;
                boolean bl2 = false;
                try {
                    bl2 = resultSet.next();
                    bl = true;
                }
                catch (SQLException sQLException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"handleMSSQL", (Throwable)sQLException);
                    }
                    MessageLog.logException((String)"SRV0135E", (Exception)sQLException);
                }
                if (!bl2) {
                    if (bl) {
                        MessageLog.logMessage((String)"SRV0134E");
                    }
                } else {
                    String string = null;
                    try {
                        string = resultSet.getString(1);
                    }
                    catch (SQLException sQLException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"handleMSSQL", (Throwable)sQLException);
                        }
                        MessageLog.logException((String)"SRV0136E", (Exception)sQLException);
                    }
                    if (string != null) {
                        try {
                            SQLUtil.parseSortOrderRow(string);
                        }
                        catch (IOException iOException) {
                            Class<?> clazz;
                            if (!TraceLogger.enableTrace) break block44;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"handleMSSQL", (Throwable)iOException);
                        }
                    }
                }
            }
        }
        try {
            statement.close();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"handleMSSQL", (Throwable)sQLException);
            }
            MessageLog.logException((String)"SRV0133E", (Exception)sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handleMSSQL");
        }
    }

    public static void setRepositoryType(String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setRepositoryType", (String)"jdbcDriver");
        }
        if (string.startsWith("oracle")) {
            repositoryType = 1;
        } else if (string.startsWith("com.inet.") || string.startsWith("com.microsoft.") || string.startsWith("com.ddtek.")) {
            repositoryType = (byte)2;
        } else if (string.startsWith("org.apache.derby")) {
            repositoryType = (byte)7;
        } else if (string.startsWith("interbase")) {
            repositoryType = (byte)3;
        } else if (string.startsWith("com.sybase.")) {
            repositoryType = (byte)4;
        } else if (string.startsWith("com.ibm.db2.jcc.DB2Driver") || string.startsWith("COM.ibm")) {
            repositoryType = (byte)5;
        } else if (string.startsWith("com.ibm.db2j")) {
            repositoryType = (byte)6;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setRepositoryType");
        }
    }

    public static boolean isMSSQL() {
        return repositoryType == 2;
    }

    public static boolean isINET(String string) {
        inetDriver = string.startsWith("com.inet.");
        return inetDriver;
    }

    public static boolean isInterBase() {
        return repositoryType == 3;
    }

    public static boolean isOracle() {
        return repositoryType == 1;
    }

    public static boolean isSybase() {
        return repositoryType == 4;
    }

    public static boolean isUDB() {
        return repositoryType == 5;
    }

    public static boolean isCloudscape() {
        return repositoryType == 6;
    }

    public static boolean isDerby() {
        return repositoryType == 7;
    }

    public static boolean mightBeCaseInsensitive() {
        return repositoryType == 2 || repositoryType == 4;
    }

    private static void appendSQLException(SQLException sQLException, StringBuffer stringBuffer) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendSQLException", (String)"e, result");
        }
        while (sQLException != null) {
            String string = sQLException.getSQLState();
            if (string == null) {
                string = "";
            }
            stringBuffer.append("SQLSTATE: ");
            stringBuffer.append(string);
            stringBuffer.append(", Vendor error code: ");
            stringBuffer.append(sQLException.getErrorCode());
            stringBuffer.append('\n');
            String string2 = sQLException.getMessage();
            if (string2 != null) {
                stringBuffer.append("                         ");
                stringBuffer.append(string2);
                stringBuffer.append('\n');
            }
            sQLException = sQLException.getNextException();
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendSQLException");
        }
    }

    public static GeneralException getGeneralException(String string, SQLException sQLException, Object[] objectArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getGeneralException", (String)"msgID, e, args");
        }
        StringBuffer stringBuffer = new StringBuffer(320);
        SQLUtil.appendSQLException(sQLException, stringBuffer);
        GeneralException generalException = new GeneralException(string, objectArray, stringBuffer.toString());
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getGeneralException", (Object)((Object)generalException));
        }
        return generalException;
    }

    public static void setHoldability(Connection connection, boolean bl) {
        block11: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"setHoldability", (String)"dbc, hold");
            }
            Object[] objectArray = null;
            if (SQLUtil.isCloudscape()) {
                objectArray = bl ? SH_ONE_ARG : SH_ZERO_ARG;
                try {
                    Method method = connection.getClass().getMethod("setHoldability", SH_INT_PARAM);
                    method.invoke((Object)connection, objectArray);
                }
                catch (Exception exception) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block11;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"setHoldability", (Throwable)exception);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.SQLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setHoldability");
        }
    }

    public static Timestamp getTimestamp(Connection connection) throws SQLException {
        return CurrentTime.getTimestamp();
    }
}

