/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.TStorm.common.CompHist;
import org.eclipse.aperi.TStorm.common.SpaceHistory;
import org.eclipse.aperi.TStorm.common.UpTimeReport;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.Group2ResSqlUtil;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptUserSpace;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;

public class RptUpTime
extends StorageRepositoryAccessor
implements GuiDataProvider {
    private Timestamp tsNull = new Timestamp(0L);
    private Timestamp tsStart = new Timestamp(0L);
    private Timestamp tsEnd = new Timestamp(0L);
    private static final int REPLACE = 0;
    private static final int DISCARD = 1;
    private static final int KEEP = 2;
    int groupID = Integer.MIN_VALUE;
    UpTimeReport resultList;
    private int totalRows;
    GuiReportReq grr;
    private static final String SELECT_CLAUSE = "select h.monitor_start, h.monitor_end, h.down_time, h.power_cycles, h.statistic_type, h.computer_id";
    private static final String SELECT_DISTINCT_CLAUSE = "select distinct h.monitor_start, h.monitor_end, h.down_time, h.power_cycles, h.statistic_type, h.computer_id";
    private static final String FROM_CLAUSE = " from t_stat_comp_hist h";
    private static final String COMP_GROUP_JOIN = " h.computer_id = gr.resource_id and gr.group_id = g.group_id";
    private static final String DOMAIN_JOIN = " h.computer_id = c.computer_id and c.domain_id = d.domain_id";
    private static final String SELECT_HIST_GRAPH = "select computer_id, monitor_end, statistic_type, down_time, monitor_start from t_stat_comp_hist";
    private static final String COMPUTER_COL = "computer_id";
    private static final int MILLIS_PER_SECOND = 1000;

    public RptUpTime(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"RptUpTime", (String)"dbc");
        }
        this.tableName = "t_stat_comp_hist";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"RptUpTime");
        }
    }

    public Serializable getReportData(GuiReportReq guiReportReq) throws GeneralException {
        UpTimeReport upTimeReport;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getReportData", (String)"grr");
        }
        this.grr = guiReportReq;
        if (guiReportReq.histSubtype > 0) {
            Serializable serializable = this.getHistoryGraphData(guiReportReq);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getReportData", (Object)serializable);
            }
            return serializable;
        }
        UpTimeReport upTimeReport2 = new UpTimeReport();
        UpTimeReport upTimeReport3 = null;
        this.totalRows = 0;
        int n = -1;
        String string = this.buildReportQuery();
        try {
            this.selectStmt = this.prepareStmt(string);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setTimestamp(this.selectStmt, 86400000L, this.tsNull);
            if (guiReportReq.startTime > 0L) {
                this.setTimestamp(this.selectStmt, guiReportReq.startTime, this.tsStart);
                this.setTimestamp(this.selectStmt, guiReportReq.endTime, this.tsEnd);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.fetch(upTimeReport2)) {
                if (n != upTimeReport2.chComputerID) {
                    if (upTimeReport3 == null) {
                        upTimeReport3 = new UpTimeReport();
                    } else {
                        this.aggregate(upTimeReport3);
                    }
                    n = upTimeReport2.chComputerID;
                    upTimeReport = upTimeReport2;
                    upTimeReport2 = upTimeReport3;
                    upTimeReport3 = upTimeReport;
                    continue;
                }
                int n2 = this.analyzeRow(upTimeReport2, upTimeReport3);
                switch (n2) {
                    case 2: {
                        this.aggregate(upTimeReport3);
                    }
                    case 0: {
                        UpTimeReport upTimeReport4 = upTimeReport2;
                        upTimeReport2 = upTimeReport3;
                        upTimeReport3 = upTimeReport4;
                    }
                }
            }
            if (upTimeReport3 != null) {
                this.aggregate(upTimeReport3);
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getReportData", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (guiReportReq.columnFilters != null) {
            this.applyFilter(new ReportFilter(guiReportReq, upTimeReport2));
        }
        if (guiReportReq.isBatchReport && (guiReportReq.reportSubtype == 12 || guiReportReq.reportSubtype == 28)) {
            this.getComputerNames(this.resultList);
        }
        upTimeReport = this.packItUp((CompHist)this.resultList);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getReportData", (Object)upTimeReport);
        }
        return upTimeReport;
    }

    private String buildReportQuery() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"buildReportQuery", (String)"");
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        switch (this.grr.reportSubtype) {
            case 12: 
            case 28: {
                stringBuffer.append(SELECT_CLAUSE);
                stringBuffer.append(FROM_CLAUSE);
                this.appendWhereClause(stringBuffer, null, "h.computer_id", true);
                this.appendOrderByClause(stringBuffer, null);
                break;
            }
            case 13: 
            case 82: {
                stringBuffer.append(SELECT_DISTINCT_CLAUSE);
                stringBuffer.append(", g.group_id, g.creator, g.name");
                stringBuffer.append(FROM_CLAUSE);
                stringBuffer.append(", t_group g, t_view_group2res gr ");
                this.appendWhereClause(stringBuffer, COMP_GROUP_JOIN, "g.group_id", false);
                if (this.grr.reportSubtype == 13) {
                    stringBuffer.append(" and g.group_type <> 99");
                } else {
                    stringBuffer.append(" and g.group_type = 99");
                }
                Group2ResSqlUtil.appendG2RWhere(stringBuffer, this.grr.selectedResources, this.grr.isResourceInList, true, this.grr.reportSubtype, "gr");
                this.appendOrderByClause(stringBuffer, "g.group_id");
                break;
            }
            case 14: {
                stringBuffer.append(SELECT_CLAUSE);
                stringBuffer.append(", d.domain_id, d.name");
                stringBuffer.append(FROM_CLAUSE);
                stringBuffer.append(", t_stat_computer c, t_res_domain d");
                this.appendWhereClause(stringBuffer, DOMAIN_JOIN, "d.domain_id", true);
                this.appendOrderByClause(stringBuffer, "d.domain_id");
                break;
            }
            default: {
                stringBuffer.append(SELECT_CLAUSE);
                stringBuffer.append(FROM_CLAUSE);
                this.appendWhereClause(stringBuffer, null, null, true);
                this.appendOrderByClause(stringBuffer, null);
            }
        }
        String string = stringBuffer.toString();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"buildReportQuery", (Object)string);
        }
        return string;
    }

    private void appendWhereClause(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendWhereClause", (String)"buffer, joinCondition, inColumn, useInClause");
        }
        stringBuffer.append(" where h.monitor_start > ?");
        if (this.grr.startTime > 0L) {
            stringBuffer.append(" and h.monitor_start >= ? and h.monitor_end <= ? ");
        }
        if (string != null) {
            stringBuffer.append(" and ");
            stringBuffer.append(string);
        }
        if (bl) {
            SQLUtil.appendInClause(stringBuffer, string2, this.grr.selectedResources, this.grr.isResourceInList, true);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendWhereClause");
        }
    }

    private void appendOrderByClause(StringBuffer stringBuffer, String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendOrderByClause", (String)"buffer, colName");
        }
        stringBuffer.append(" order by ");
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(',');
        }
        stringBuffer.append(" h.computer_id, monitor_start, monitor_end");
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendOrderByClause");
        }
    }

    private boolean fetch(UpTimeReport upTimeReport) throws SQLException {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetch", (String)"cr");
        }
        if (bl = this.resultSet.next()) {
            this.colIndex = 1;
            upTimeReport.chMonitorStart = this.getTimestamp(this.resultSet);
            upTimeReport.chMonitorEnd = this.getTimestamp(this.resultSet);
            upTimeReport.chDownTime = this.getInt(this.resultSet);
            upTimeReport.chPowerCycles = this.getInt(this.resultSet);
            upTimeReport.chStatisticType = this.getByte(this.resultSet);
            upTimeReport.chComputerID = this.getInt(this.resultSet);
            long l = upTimeReport.chMonitorEnd - upTimeReport.chMonitorStart;
            upTimeReport.crUpTime = (l /= 1000L) - (long)upTimeReport.chDownTime;
            if (this.grr.reportSubtype == 12 || this.grr.reportSubtype == 28) {
                upTimeReport.crID = upTimeReport.chComputerID;
            } else if (this.grr.reportSubtype != 15) {
                upTimeReport.crID = this.getInt(this.resultSet);
                upTimeReport.crName1 = this.getString(this.resultSet);
                if (this.grr.reportSubtype == 13 || this.grr.reportSubtype == 82) {
                    upTimeReport.setCrName2(this.getString(this.resultSet));
                }
            }
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetch", (boolean)bl2);
        }
        return bl2;
    }

    private int analyzeRow(UpTimeReport upTimeReport, UpTimeReport upTimeReport2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"analyzeRow", (String)"currentRow, lastRow");
        }
        if (this.grr.reportSubtype == 28) {
            int n = 2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"analyzeRow", (int)n);
            }
            return n;
        }
        if (upTimeReport.chMonitorStart >= upTimeReport2.chMonitorEnd) {
            int n = 2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"analyzeRow", (int)n);
            }
            return n;
        }
        if (this.grr.reportSubtype == 13 && this.groupID != upTimeReport.crID) {
            int n = 2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"analyzeRow", (int)n);
            }
            return n;
        }
        if (upTimeReport.chMonitorStart == upTimeReport2.chMonitorStart) {
            if (upTimeReport.chStatisticType == upTimeReport2.chStatisticType) {
                int n = 0;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"analyzeRow", (int)n);
                }
                return n;
            }
        } else if (upTimeReport.chMonitorEnd <= upTimeReport2.chMonitorEnd && upTimeReport.chMonitorStart <= this.grr.startTime) {
            int n = 0;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"analyzeRow", (int)n);
            }
            return n;
        }
        int n = 1;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"analyzeRow", (int)n);
        }
        return n;
    }

    private void aggregate(UpTimeReport upTimeReport) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"aggregate", (String)"row");
        }
        if (this.groupID != upTimeReport.crID) {
            UpTimeReport upTimeReport2 = (UpTimeReport)upTimeReport.clone();
            upTimeReport2.chNext = this.resultList;
            this.resultList = upTimeReport2;
            ++this.totalRows;
            if (this.grr.reportSubtype != 28) {
                this.groupID = upTimeReport.crID;
            }
        } else {
            if (this.resultList.chMonitorStart > upTimeReport.chMonitorStart) {
                this.resultList.chMonitorStart = upTimeReport.chMonitorStart;
            }
            if (this.resultList.chMonitorEnd < upTimeReport.chMonitorEnd) {
                this.resultList.chMonitorEnd = upTimeReport.chMonitorEnd;
            }
            this.resultList.chDownTime += upTimeReport.chDownTime;
            this.resultList.crUpTime += upTimeReport.crUpTime;
            this.resultList.chPowerCycles += upTimeReport.chPowerCycles;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"aggregate");
        }
    }

    private void applyFilter(ReportFilter reportFilter) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"applyFilter", (String)"filter");
        }
        UpTimeReport upTimeReport = this.resultList;
        UpTimeReport upTimeReport2 = null;
        this.resultList = null;
        this.totalRows = 0;
        while (upTimeReport != null) {
            UpTimeReport upTimeReport3 = upTimeReport;
            upTimeReport = (UpTimeReport)upTimeReport3.chNext;
            upTimeReport3.chNext = null;
            UpTimeReport upTimeReport4 = (UpTimeReport)upTimeReport3.clone();
            if (this.grr.reportSubtype == 12 || this.grr.reportSubtype == 28) {
                this.getComputerNames(upTimeReport4);
            }
            if (!reportFilter.isSelected(upTimeReport4)) continue;
            if (this.resultList == null) {
                this.resultList = upTimeReport3;
            } else {
                upTimeReport2.chNext = upTimeReport3;
            }
            upTimeReport2 = upTimeReport3;
            ++this.totalRows;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"applyFilter");
        }
    }

    private void getComputerNames(UpTimeReport upTimeReport) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getComputerNames", (String)"node");
        }
        AgentManager agentManager = Server.getAgentManager();
        while (upTimeReport != null) {
            upTimeReport.crName1 = agentManager.getAgentName(upTimeReport.crID);
            upTimeReport = (UpTimeReport)upTimeReport.chNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getComputerNames");
        }
    }

    private UpTimeReport[] packItUp(CompHist compHist) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"packItUp", (String)"head");
        }
        UpTimeReport[] upTimeReportArray = new UpTimeReport[this.totalRows];
        this.totalRows = 0;
        while (compHist != null) {
            CompHist compHist2 = compHist.chNext;
            compHist.chNext = null;
            upTimeReportArray[this.totalRows] = (UpTimeReport)compHist;
            ++this.totalRows;
            compHist = compHist2;
        }
        UpTimeReport[] upTimeReportArray2 = upTimeReportArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"packItUp", (Object)upTimeReportArray2);
        }
        return upTimeReportArray2;
    }

    public Serializable getHistoryGraphData(GuiReportReq guiReportReq) throws GeneralException {
        SpaceHistory spaceHistory;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getHistoryGraphData", (String)"grr");
        }
        SpaceHistory spaceHistory2 = null;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(SELECT_HIST_GRAPH);
        stringBuffer.append(" where statistic_type in ('");
        stringBuffer.append(guiReportReq.histType);
        stringBuffer.append('\'');
        if (guiReportReq.histType != 0) {
            stringBuffer.append(",'");
            stringBuffer.append(guiReportReq.histType + 2);
            stringBuffer.append('\'');
        }
        stringBuffer.append(") and");
        if (guiReportReq.startTime > 0L) {
            stringBuffer.append(" monitor_end between ? and ? and");
        }
        SQLUtil.appendInClause(stringBuffer, COMPUTER_COL, guiReportReq.selectedResources);
        try {
            this.selectStmt = this.prepareStmt(stringBuffer.toString());
            if (guiReportReq.startTime > 0L) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setTimestamp(this.selectStmt, guiReportReq.startTime, this.tsStart);
                this.setTimestamp(this.selectStmt, guiReportReq.endTime, this.tsEnd);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            spaceHistory = new SpaceHistory();
            while (this.resultSet.next()) {
                this.colIndex = 1;
                spaceHistory.shLegendID1 = this.getInt(this.resultSet);
                spaceHistory.shLegendID2 = Integer.MIN_VALUE;
                spaceHistory.shStatisticTime = this.getTimestamp(this.resultSet);
                this.getByte(this.resultSet);
                int n2 = this.getInt(this.resultSet);
                long l = this.getTimestamp(this.resultSet);
                int n3 = (int)((spaceHistory.shStatisticTime - l) / 1000L);
                spaceHistory.shFileCount = (int)((double)n3 / (double)(n3 + n2) * 100.0);
                spaceHistory.shNext = spaceHistory2;
                spaceHistory2 = spaceHistory;
                spaceHistory = new SpaceHistory();
                ++n;
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getHistoryGraphData", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        spaceHistory = RptUserSpace.packUpHistory(spaceHistory2, n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptUpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getHistoryGraphData", (Object)spaceHistory);
        }
        return spaceHistory;
    }
}

