/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.aperi.TStorm.common.AlertHeader;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.CreatorNameListProxy;
import org.eclipse.aperi.repository.CreatorNameQueryable;
import org.eclipse.aperi.repository.EditableObjectProxy;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.table.TAlertEmail;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.xmsg.MessageLog;

public class TAlertDefinition
extends RepositoryAccessor
implements CreatorNameQueryable {
    private static final AlertDefinition[] ARRAY_TYPE = new AlertDefinition[0];
    public static final String ID_COLUMN_NAME = "alert_id";
    TAlertEmail emailAccessor;
    private static final String SELECT_CLAUSE = "select alert_id, creator, name, enabled, product_id, alert_type, condition, threshold_type, threshold_value, snmp_trap, tec_event, os_log, os_log_severity, syslog_facility, email, notify_on_login, script_computer_id, script_name, dbms_type";
    private static final String SELECT_BY_RESOURCE = " from t_alert_definition a, t_res_attribute r where attribute_type = ? and exclude = '0' and attribute_id = alert_id and ((resource_type = ? and resource_id = ?) or (resource_type = ? and resource_id = ?) or (resource_type = ? and resource_id = ?) or resource_type = " + Short.toString((short)13) + ")" + " and not exists" + " (select 1 from t_res_attribute where exclude = '1'" + " and (resource_type = ? and resource_id = ?)" + " and attribute_type = ? and attribute_id = r.attribute_id)" + " and enabled = '1'" + " order by alert_id";
    private static final String SELECT_THRESHOLD_BY_ID = "select threshold_value from t_alert_definition where alert_id = ?";
    private static final String COLUMNS = "enabled, product_id, alert_type, condition, threshold_type, threshold_value, snmp_trap, tec_event, os_log, os_log_severity, syslog_facility, email, notify_on_login, script_computer_id, script_name, dbms_type";

    public TAlertDefinition(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TAlertDefinition", (String)"dbc");
        }
        this.tableName = "t_alert_definition";
        this.emailAccessor = new TAlertEmail(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TAlertDefinition");
        }
    }

    public void prepSelectByID(boolean bl, boolean bl2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSelectByID", (String)"allCols, enabledOnly");
        }
        StringBuffer stringBuffer = new StringBuffer(240);
        stringBuffer.append(SELECT_CLAUSE);
        if (bl) {
            stringBuffer.append(", description, last_modified");
        }
        stringBuffer.append(" from t_alert_definition where alert_id = ?");
        if (bl2) {
            stringBuffer.append(" and enabled = '1'");
        }
        this.emailAccessor.prepSelectByID();
        this.selectStmt = this.prepareStmt(stringBuffer.toString());
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSelectByID");
        }
    }

    public AlertDefinition getByID(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getByID", (String)"alertID");
        }
        AlertDefinition alertDefinition = this.getByID(null, n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getByID", (Object)alertDefinition);
        }
        return alertDefinition;
    }

    public void getByID(AlertHeader alertHeader) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getByID", (String)"header");
        }
        this.prepSelectByID(true, false);
        alertHeader.alert = this.getByID(alertHeader, alertHeader.ID);
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getByID");
        }
    }

    private AlertDefinition getByID(AlertHeader alertHeader, int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getByID", (String)"header, alertID");
        }
        AlertDefinition alertDefinition = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.resultSet.next()) {
                alertDefinition = this.fetch(alertHeader);
            }
            this.resultSet.close();
            if (alertDefinition != null && alertDefinition.aldEmail) {
                this.emailAccessor.getAlertEmail(alertDefinition);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getByID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getByID", (Throwable)generalException);
            }
            this.cleanup();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getByID");
            }
            throw generalException;
        }
        AlertDefinition alertDefinition2 = alertDefinition;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getByID", alertDefinition2);
        }
        return alertDefinition2;
    }

    private AlertDefinition fetch(AlertHeader alertHeader) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetch", (String)"header");
        }
        AlertDefinition alertDefinition = new AlertDefinition();
        this.stmtPhase = 1;
        this.colIndex = 1;
        alertDefinition.aldAlertID = this.getInt(this.resultSet);
        alertDefinition.aldCreator = this.getString(this.resultSet);
        alertDefinition.setAldName(this.getString(this.resultSet));
        alertDefinition.aldEnabled = this.getBoolean(this.resultSet);
        alertDefinition.aldProductID = this.getShort(this.resultSet);
        alertDefinition.aldType = this.getShort(this.resultSet);
        alertDefinition.aldCondition = this.getShort(this.resultSet);
        alertDefinition.aldThresholdType = (byte)(this.getString(this.resultSet).charAt(0) - 48);
        alertDefinition.aldThresholdValue = this.getInt(this.resultSet);
        alertDefinition.aldSnmpTrap = this.getBoolean(this.resultSet);
        alertDefinition.aldTecEvent = this.getBoolean(this.resultSet);
        alertDefinition.aldOsLog = this.getBoolean(this.resultSet);
        alertDefinition.aldOsLogSeverity = this.getByte(this.resultSet);
        alertDefinition.aldSyslogFacility = this.getByte(this.resultSet);
        alertDefinition.aldEmail = this.getBoolean(this.resultSet);
        alertDefinition.aldNotifyOnLogin = this.getString(this.resultSet);
        alertDefinition.aldScriptComputerID = this.getInt(this.resultSet);
        alertDefinition.aldScriptName = this.getString(this.resultSet);
        alertDefinition.aldDbmsType = this.getByte(this.resultSet);
        if (alertHeader != null) {
            alertHeader.setDescription(this.getString(this.resultSet));
            alertHeader.lastModified = this.getLong(this.resultSet);
            alertHeader.creator = alertDefinition.aldCreator;
            alertHeader.setName(alertDefinition.getAldName());
            alertHeader.enabled = alertDefinition.aldEnabled;
        }
        AlertDefinition alertDefinition2 = alertDefinition;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetch", (Object)alertDefinition2);
        }
        return alertDefinition2;
    }

    public AlertDefinition[] getByResource(short s, int n, short s2, int n2, short s3, int n3, short s4) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getByResource", (String)"resourceType, resourceID, groupType, groupID, clusterGroupType, clusterGroupID, alertType");
        }
        ArrayList<AlertDefinition> arrayList = new ArrayList<AlertDefinition>();
        AlertDefinition[] alertDefinitionArray = null;
        this.emailAccessor.prepSelectByID();
        this.selectStmt = this.prepareStmt(SELECT_CLAUSE + SELECT_BY_RESOURCE);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setShort(this.selectStmt, s4);
            this.setShort(this.selectStmt, s);
            this.setInt(this.selectStmt, n);
            this.setShort(this.selectStmt, s2);
            this.setInt(this.selectStmt, n2);
            this.setShort(this.selectStmt, s3);
            this.setInt(this.selectStmt, n3);
            this.setShort(this.selectStmt, s);
            this.setInt(this.selectStmt, n);
            this.setShort(this.selectStmt, s4);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            int n4 = -1;
            while (this.resultSet.next()) {
                AlertDefinition alertDefinition = this.fetch(null);
                if (alertDefinition.aldAlertID == n4) continue;
                if (alertDefinition.aldEmail) {
                    this.emailAccessor.getAlertEmail(alertDefinition);
                }
                arrayList.add(alertDefinition);
                n4 = alertDefinition.aldAlertID;
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getByResource", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getByResource", (Throwable)generalException);
            }
            this.cleanup();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getByResource");
            }
            throw generalException;
        }
        if (!arrayList.isEmpty()) {
            alertDefinitionArray = arrayList.toArray(ARRAY_TYPE);
        }
        AlertDefinition[] alertDefinitionArray2 = alertDefinitionArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getByResource", (Object)alertDefinitionArray2);
        }
        return alertDefinitionArray2;
    }

    public void insert(CreateHeader createHeader, AlertDefinition alertDefinition) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"header, alert");
        }
        String string = createHeader instanceof ScheduleHeader ? ResourceTypeManager.getName((short)((ScheduleHeader)createHeader).jobType) : MessageLog.getMessageNoID((String)"STS0109L");
        alertDefinition.aldAlertID = createHeader.ID;
        alertDefinition.aldEnabled = createHeader.enabled;
        if (alertDefinition.aldEmail) {
            alertDefinition.aldEmailDef.aleAlertID = createHeader.ID;
            this.emailAccessor.insert(alertDefinition.aldEmailDef);
        }
        EditableObjectProxy editableObjectProxy = new EditableObjectProxy(this, createHeader, string);
        editableObjectProxy.initInsert(COLUMNS);
        try {
            this.setBoolean(this.insertStmt, alertDefinition.aldEnabled);
            this.setShort(this.insertStmt, alertDefinition.aldProductID);
            this.setShort(this.insertStmt, alertDefinition.aldType);
            this.setShort(this.insertStmt, alertDefinition.aldCondition);
            this.setString(this.insertStmt, Character.toString((char)(alertDefinition.aldThresholdType + 48)));
            this.setInt(this.insertStmt, alertDefinition.aldThresholdValue);
            this.setBoolean(this.insertStmt, alertDefinition.aldSnmpTrap);
            this.setBoolean(this.insertStmt, alertDefinition.aldTecEvent);
            this.setBoolean(this.insertStmt, alertDefinition.aldOsLog);
            this.setByte(this.insertStmt, alertDefinition.aldOsLogSeverity);
            this.setByte(this.insertStmt, alertDefinition.aldSyslogFacility);
            this.setBoolean(this.insertStmt, alertDefinition.aldEmail);
            this.setString(this.insertStmt, alertDefinition.aldNotifyOnLogin);
            this.setInt(this.insertStmt, alertDefinition.aldScriptComputerID);
            this.setString(this.insertStmt, alertDefinition.aldScriptName);
            this.setByte(this.insertStmt, alertDefinition.aldDbmsType);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        editableObjectProxy.finishInsert();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }

    public void deleteByID(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByID", (String)"alertID");
        }
        String string = MessageLog.getMessageNoID((String)"STS0109L");
        this.emailAccessor.deleteByID(n, string);
        EditableObjectProxy editableObjectProxy = new EditableObjectProxy(this, null, string);
        editableObjectProxy.deleteByID(n, ID_COLUMN_NAME);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByID");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeSelect() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"closeSelect", (String)"");
        }
        try {
            super.closeSelect();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.emailAccessor.closeSelect();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.emailAccessor.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeSelect");
        }
    }

    public void cleanup() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"cleanup", (String)"");
        }
        super.cleanup();
        this.emailAccessor.cleanup();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"cleanup");
        }
    }

    public NameList selectNames(GuiListReq guiListReq) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectNames", (String)"requestData");
        }
        CreatorNameListProxy creatorNameListProxy = new CreatorNameListProxy(this, guiListReq);
        NameList nameList = creatorNameListProxy.select();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectNames", (Object)nameList);
        }
        return nameList;
    }

    public String getIDColumnName() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getIDColumnName", (String)"");
        }
        String string = ID_COLUMN_NAME;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getIDColumnName", (Object)string);
        }
        return string;
    }

    public void appendWhereClause(GuiListReq guiListReq, StringBuffer stringBuffer) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendWhereClause", (String)"requestData, buf");
        }
        stringBuffer.append(" WHERE alert_type = ");
        stringBuffer.append(Short.toString(guiListReq.resourceType));
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendWhereClause");
        }
    }

    public void addQualifiers(GuiListReq guiListReq, NameList nameList) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addQualifiers", (String)"requestData, element");
        }
        nameList.nlID2 = guiListReq.resourceType;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addQualifiers");
        }
    }

    public AlertDefinition[] getByResource(short s, int n, short s2, int n2, short s3) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getByResource", (String)"resourceType, resourceID, groupType, groupID, alertType");
        }
        ArrayList<AlertDefinition> arrayList = new ArrayList<AlertDefinition>();
        AlertDefinition[] alertDefinitionArray = null;
        this.emailAccessor.prepSelectByID();
        this.selectStmt = this.prepareStmt(SELECT_CLAUSE + SELECT_BY_RESOURCE);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setShort(this.selectStmt, s3);
            this.setShort(this.selectStmt, s);
            this.setInt(this.selectStmt, n);
            this.setShort(this.selectStmt, s2);
            this.setInt(this.selectStmt, n2);
            this.setShort(this.selectStmt, s);
            this.setInt(this.selectStmt, n);
            this.setShort(this.selectStmt, s3);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            int n3 = -1;
            while (this.resultSet.next()) {
                AlertDefinition alertDefinition = this.fetch(null);
                if (alertDefinition.aldAlertID == n3) continue;
                if (alertDefinition.aldEmail) {
                    this.emailAccessor.getAlertEmail(alertDefinition);
                }
                arrayList.add(alertDefinition);
                n3 = alertDefinition.aldAlertID;
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getByResource", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getByResource", (Throwable)generalException);
            }
            this.cleanup();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getByResource");
            }
            throw generalException;
        }
        if (!arrayList.isEmpty()) {
            alertDefinitionArray = arrayList.toArray(ARRAY_TYPE);
        }
        AlertDefinition[] alertDefinitionArray2 = alertDefinitionArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getByResource", (Object)alertDefinitionArray2);
        }
        return alertDefinitionArray2;
    }

    public void prepGetThresholdByID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepGetThresholdByID", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_THRESHOLD_BY_ID);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepGetThresholdByID");
        }
    }

    public long getThresholdByID(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getThresholdByID", (String)"alertID");
        }
        long l = 0L;
        this.execQueryByID(n);
        if (this.nextResult()) {
            try {
                this.getPhase();
                l = this.getLong(this.resultSet);
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getThresholdByID", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        this.closeResultSet();
        long l2 = l;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getThresholdByID", (long)l2);
        }
        return l2;
    }
}

