/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.NasFilesystem;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.repository.table.TStatComputer;

public class TFoundFilesystem
extends StorageRepositoryAccessor {
    public static final String TABLE_NAME = "t_found_filesystem";
    public static final String ID_COLUMN = "filesystem_id";
    private static final String SELECT_BY_COMPUTER_AND_SCANNER = "select filesystem_id, mount_point from t_found_filesystem where computer_id = ? and scanning_comp_id = ?";
    private static final String SELECT_BY_MOUNT_POINT = "select filesystem_id, scanning_comp_id from t_found_filesystem where computer_id = ? and mount_point = ?";
    private static final String SELECT_MISSING = "select f.filesystem_id, s.scan_time, s.removed_time from t_found_filesystem f, t_res_share s where f.filesystem_id = s.resource_id and s.computer_id = ? and f.computer_id = ? and s.scan_time <> ? and s.resource_type = 68";
    private static final String SELECT_SCANNING_COMPID = "select distinct scanning_comp_id from t_found_filesystem where computer_id = ? and scanning_comp_id > 0";
    private static final String SELECT_NAS_FILESYSTEMS = "select f.computer_id, f.filesystem_id, f.mount_point, f.scanning_comp_id, d.domain_id from t_found_filesystem f, t_res_domain d, t_res_share s where f.filesystem_id = s.resource_id and s.resource_type = 68 and s.computer_id = d.domain_id union all select computer_id, filesystem_id, mount_point, scanning_comp_id, -1 from t_found_filesystem where filesystem_id not in (select resource_id from t_res_share, t_res_domain where computer_id = domain_id and resource_type = 68) order by 1";
    private static final String SELECT_FAKE_FILESYSTEMS = "select filesystem_id, mount_point, scanning_comp_id from t_found_filesystem where computer_id = ? and scanning_comp_id > 0 and non_root = '1'";
    private static final String UPDATE_SCANNING_AGENT = "update t_found_filesystem set scanning_comp_id = ? where filesystem_id = ?";
    private static final String INSERT = "insert into t_found_filesystem (filesystem_id, computer_id, scanning_comp_id, mount_point, non_root) values (?,?,0,?,?)";

    public TFoundFilesystem(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TFoundFilesystem", (String)"dbc");
        }
        this.tableName = TABLE_NAME;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TFoundFilesystem");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getIDs(Computer computer) throws GeneralException {
        boolean bl;
        int n;
        block22: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"getIDs", (String)"computer");
            }
            RepositoryAccessor repositoryAccessor = null;
            n = 0;
            bl = false;
            try {
                try {
                    this.selectStmt = this.prepareStmt(SELECT_BY_MOUNT_POINT);
                    LogicalDisk logicalDisk = computer.cmpLogicalDisk;
                    while (logicalDisk != null) {
                        Filesystem filesystem = logicalDisk.ldFilesystem;
                        if (filesystem != null && filesystem.fsID <= 0) {
                            this.setPhase();
                            this.setInt(this.selectStmt, computer.cmpID);
                            this.setString(this.selectStmt, filesystem.fsMountPoint);
                            this.stmtPhase = 3;
                            this.resultSet = this.selectStmt.executeQuery();
                            this.getPhase();
                            if (this.nextResult()) {
                                filesystem.fsID = this.getInt(this.resultSet);
                            } else {
                                filesystem.fsNewFilesystem = true;
                                bl = true;
                                filesystem.fsComputerID = computer.cmpID;
                                if (repositoryAccessor == null) {
                                    repositoryAccessor = new TResFS(this.dbc);
                                    ((TResFS)repositoryAccessor).prepSelectByMountPoint();
                                }
                                ((TResFS)repositoryAccessor).getByMountPoint(filesystem);
                            }
                            if (filesystem.fsID <= 0) {
                                ++n;
                            }
                            this.closeResultSet();
                        }
                        logicalDisk = logicalDisk.ldNext;
                    }
                }
                catch (SQLException sQLException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"getIDs", (Throwable)sQLException);
                    }
                    this.stmtType = 0;
                    this.sqlError(sQLException);
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (repositoryAccessor != null) {
                    repositoryAccessor.cleanup();
                }
                this.cleanup();
                throw throwable;
            }
            {
                Object var7_11 = null;
                if (repositoryAccessor == null) break block22;
            }
            repositoryAccessor.cleanup();
        }
        this.cleanup();
        if (n > 0) {
            this.allocIDs(computer, n);
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getIDs", (boolean)bl2);
        }
        return bl2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getIDsForProbe(Computer computer) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getIDsForProbe", (String)"computer");
        }
        int n = 0;
        boolean bl = false;
        try {
            try {
                this.selectStmt = this.prepareStmt(SELECT_BY_MOUNT_POINT);
                LogicalDisk logicalDisk = computer.cmpLogicalDisk;
                while (logicalDisk != null) {
                    Filesystem filesystem = logicalDisk.ldFilesystem;
                    if (filesystem != null && filesystem.fsID <= 0) {
                        this.setPhase();
                        this.setInt(this.selectStmt, computer.cmpID);
                        this.setString(this.selectStmt, filesystem.fsMountPoint);
                        this.stmtPhase = 3;
                        this.resultSet = this.selectStmt.executeQuery();
                        this.getPhase();
                        if (this.nextResult()) {
                            filesystem.fsID = this.getInt(this.resultSet);
                            filesystem.fsScanningCompID = this.getInt(this.resultSet);
                            if (filesystem.fsScanningCompID > 0) {
                                bl = true;
                            }
                        } else {
                            ++n;
                        }
                        this.closeResultSet();
                    }
                    logicalDisk = logicalDisk.ldNext;
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getIDsForProbe", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.cleanup();
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        this.cleanup();
        if (n > 0) {
            this.allocIDs(computer, n);
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getIDsForProbe", (boolean)bl2);
        }
        return bl2;
    }

    private void allocIDs(Computer computer, int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"allocIDs", (String)"computer, newFsCount");
        }
        int n2 = TFoundFilesystem.getIdentifier(1, n, this.dbc);
        LogicalDisk logicalDisk = computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            Filesystem filesystem = logicalDisk.ldFilesystem;
            if (filesystem != null && filesystem.fsID <= 0) {
                filesystem.fsID = n2++;
            }
            logicalDisk = logicalDisk.ldNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"allocIDs");
        }
    }

    public Share getMissingFilesystems(int n, int n2, long l) throws GeneralException {
        Share share;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getMissingFilesystems", (String)"shareID, filerCompID, discoveryTime");
        }
        Share share2 = null;
        this.selectStmt = this.prepareStmt(SELECT_MISSING);
        try {
            this.setPhase();
            this.setInt(this.selectStmt, n);
            this.setInt(this.selectStmt, n2);
            this.setTimestamp(this.selectStmt, l);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                this.getPhase();
                share = new Share();
                share.shComputerID = n;
                share.shResourceID = this.getInt(this.resultSet);
                share.shResourceType = (short)68;
                share.shScanTime = this.getTimestamp(this.resultSet);
                share.shRemovedTime = this.getTimestamp(this.resultSet);
                share.shNext = share2;
                share2 = share;
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getMissingFilesystems", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        share = share2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getMissingFilesystems", share);
        }
        return share;
    }

    public void prepGetScanningAgent() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_SCANNING_COMPID);
    }

    public boolean getScanningAgent(MutableInteger mutableInteger) throws GeneralException {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getScanningAgent", (String)"resultID");
        }
        if (bl = this.nextResult()) {
            try {
                this.getPhase();
                mutableInteger.value = this.getInt(this.resultSet);
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getScanningAgent", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        } else {
            this.closeResultSet();
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getScanningAgent", (boolean)bl2);
        }
        return bl2;
    }

    public LinkedInteger getAllScanningAgents(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getAllScanningAgents", (String)"filerID");
        }
        LinkedInteger linkedInteger = null;
        this.execQueryByID(n);
        while (this.nextResult()) {
            try {
                LinkedInteger linkedInteger2 = new LinkedInteger();
                this.getPhase();
                linkedInteger2.value = this.getInt(this.resultSet);
                linkedInteger2.next = linkedInteger;
                linkedInteger = linkedInteger2;
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getAllScanningAgents", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        this.closeResultSet();
        LinkedInteger linkedInteger3 = linkedInteger;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getAllScanningAgents", linkedInteger3);
        }
        return linkedInteger3;
    }

    public void getFilerProbeFS(NasFiler nasFiler, int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getFilerProbeFS", (String)"filerList, agentID");
        }
        this.selectStmt = this.prepareStmt(SELECT_BY_COMPUTER_AND_SCANNER);
        try {
            NasFiler nasFiler2 = nasFiler;
            while (nasFiler2 != null) {
                if (!Constants.supportsFullProbe((short)nasFiler2.nfOSType)) {
                    this.setPhase();
                    this.setInt(this.selectStmt, nasFiler2.nfComputerID);
                    this.setInt(this.selectStmt, n);
                    this.resultSet = this.selectStmt.executeQuery();
                    while (this.nextResult()) {
                        Filesystem filesystem = new Filesystem();
                        this.getPhase();
                        filesystem.fsID = this.getInt(this.resultSet);
                        filesystem.fsMountPoint = this.getString(this.resultSet);
                        filesystem.fsNext = nasFiler2.nfFilesystems;
                        nasFiler2.nfFilesystems = filesystem;
                    }
                    this.closeResultSet();
                }
                nasFiler2 = nasFiler2.nfNext;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getFilerProbeFS", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getFilerProbeFS");
        }
    }

    public void getFakeFilesystems(NasFiler nasFiler) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getFakeFilesystems", (String)"filer");
        }
        this.selectStmt = this.prepareStmt(SELECT_FAKE_FILESYSTEMS);
        try {
            while (nasFiler != null) {
                if (!Constants.supportsFullProbe((short)nasFiler.nfOSType) || nasFiler.nfOSType == 8) {
                    nasFiler = nasFiler.nfNext;
                    continue;
                }
                this.setPhase();
                this.setInt(this.selectStmt, nasFiler.nfComputerID);
                this.resultSet = this.selectStmt.executeQuery();
                while (this.nextResult()) {
                    Filesystem filesystem = new Filesystem();
                    this.getPhase();
                    filesystem.fsID = this.getInt(this.resultSet);
                    filesystem.fsMountPoint = this.getString(this.resultSet);
                    filesystem.fsScanningCompID = this.getInt(this.resultSet);
                    filesystem.fsType = (short)16;
                    filesystem.fsNext = nasFiler.nfFilesystems;
                    nasFiler.nfFilesystems = filesystem;
                }
                this.closeResultSet();
                nasFiler = nasFiler.nfNext;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getFakeFilesystems", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getFakeFilesystems");
        }
    }

    public NasFilesystem[] getNasFilesystems() throws GeneralException {
        NasFilesystem nasFilesystem;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getNasFilesystems", (String)"");
        }
        NasFilesystem nasFilesystem2 = null;
        NasFilesystem nasFilesystem3 = null;
        boolean bl = true;
        try {
            this.staticStmt = this.createStatement();
            this.resultSet = this.staticStmt.executeQuery(SELECT_NAS_FILESYSTEMS);
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                int n = this.getInt(this.resultSet);
                if (!bl) continue;
                nasFilesystem = new NasFilesystem();
                nasFilesystem.nflComputerID = n;
                nasFilesystem.nflFsID = this.getInt(this.resultSet);
                nasFilesystem.nflFsName = this.getString(this.resultSet);
                nasFilesystem.nflAgentID = this.getInt(this.resultSet);
                int n2 = this.getInt(this.resultSet);
                nasFilesystem.nflSeenFromWindows = n2 > 0;
                if (nasFilesystem3 != null) {
                    nasFilesystem3.nflNext = nasFilesystem;
                } else {
                    nasFilesystem2 = nasFilesystem;
                }
                nasFilesystem3 = nasFilesystem;
            }
            this.closeStaticStmt();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getNasFilesystems", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        NameList nameList = new TStatComputer(this.dbc).selectComputersAndDomains();
        while (nameList != null) {
            nasFilesystem = nasFilesystem2;
            while (nasFilesystem != null) {
                if (nasFilesystem.nflComputerID == nameList.nlID) {
                    nasFilesystem.nflDomainName = nameList.nlName;
                }
                nasFilesystem = nasFilesystem.nflNext;
            }
            nameList = nameList.nlNext;
        }
        NasFilesystem[] nasFilesystemArray = (NasFilesystem[])Packer.pack(nasFilesystem2);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getNasFilesystems", (Object)nasFilesystemArray);
        }
        return nasFilesystemArray;
    }

    public void prepUpdateScanAgent() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_SCANNING_AGENT);
    }

    public void updateScanningAgent(NasFilesystem nasFilesystem) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateScanningAgent", (String)"fsList");
        }
        try {
            NasFilesystem nasFilesystem2 = nasFilesystem;
            while (nasFilesystem2 != null) {
                this.setPhase();
                this.setInt(this.updateStmt, nasFilesystem2.nflAgentID);
                this.setInt(this.updateStmt, nasFilesystem2.nflFsID);
                this.executeUpdate(this.updateStmt);
                nasFilesystem2 = nasFilesystem2.nflNext;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateScanningAgent", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateScanningAgent");
        }
    }

    public void prepInsert() throws GeneralException {
        this.insertStmt = this.prepareStmt(INSERT);
    }

    public void insert(Computer computer, Filesystem filesystem) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"computer, filesystem");
        }
        try {
            this.setPhase();
            this.setInt(this.insertStmt, filesystem.fsID);
            this.setInt(this.insertStmt, computer.cmpID);
            this.setString(this.insertStmt, filesystem.fsMountPoint);
            this.setBoolean(this.insertStmt, filesystem.fsType == 16);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundFilesystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }
}

