/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResDiskArray;

public class TResController
extends StorageRepositoryAccessor {
    public TResComputer cmpAccessor = null;
    private boolean isStorageSubsystem = false;
    private static final String FETCH_BY_COMPUTER = "select controller_id, computer_id, instance_number, bus_number, wwn, driver_name, driver_description, target, controller_type, loop, adapter_pair, array from t_res_controller where computer_id = ?";
    private static final String FETCH_BY_SS = "select disk_group_id, subsystem_id, disk_group_number, width, -1, tag, description, raid_level, loop, da_pair_id, array from t_res_disk_group where subsystem_id = ?";
    private static final String FETCH_CTRLR_NAME_BY_STOREXT = "select C.name from t_res_disk_group C  where C.disk_group_id in (select E.controller_id from t_res_ext_ctrlr E where E.storext_id = ?) order by C.name";
    private static final String ORDER_BY_CLAUSE = " order by driver_name desc, instance_number desc, bus_number desc";
    private static final String DG_ORDER_BY_CLAUSE = " order by name desc, width desc";
    private static final String INSERT = "insert into t_res_controller (computer_id, controller_id, instance_number, bus_number, wwn, wwn_str, driver_name, driver_description, target, controller_type, loop, adapter_pair, array) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_DG = "insert into t_res_disk_group (subsystem_id, disk_group_id, width, name, description raid_level, loop, device_adapter1, array) values (?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE = "update t_res_controller set driver_description = ?, target = ?, controller_type = ?, wwn = ?, wwn_str = ?, loop = ?, adapter_pair = ?, array = ? where computer_id = ? and controller_id = ?";
    private static final String UPDATE_DG = "update t_res_disk_group set description = ?, raid_level = ?, loop = ?, device_adapter1 = ?, array = ? where subsystem_id = ? and disk_group_id = ?";
    private static final String DELETE_BY_ID = "delete from t_res_controller where computer_id = ? and controller_id=?";
    private static final String DELETE_BY_DG_ID = "delete from t_res_disk_group where subsystem_id = ? and disk_group_id=?";
    private static final String DELETE_BY_COMPUTER = "delete from t_res_controller where and computer_id = ?";
    private static final String DELETE_DG_BY_COMPUTER = "delete from t_res_disk_group where and subsystem_id = ?";

    public TResController(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TResController", (String)"dbc");
        }
        this.tableName = "t_res_controller";
        this.cmpAccessor = new TResComputer(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TResController");
        }
    }

    public Controller getControllers(int n, short s) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getControllers", (String)"computerID, qualifier");
        }
        Controller controller = null;
        this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(n);
        StringBuffer stringBuffer = new StringBuffer(400);
        if (!this.isStorageSubsystem) {
            stringBuffer.append(FETCH_BY_COMPUTER);
            if (s != 0) {
                stringBuffer.append(" and controller_type ");
                if (s > 0) {
                    stringBuffer.append("= ");
                } else {
                    stringBuffer.append("<> ");
                }
                stringBuffer.append(8);
            }
            stringBuffer.append(ORDER_BY_CLAUSE);
        } else {
            stringBuffer.append(FETCH_BY_SS);
            stringBuffer.append(DG_ORDER_BY_CLAUSE);
        }
        String string = stringBuffer.toString();
        stringBuffer = null;
        try {
            this.selectStmt = this.prepareStmt(string);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                Controller controller2 = new Controller();
                this.fetchController(controller2);
                controller2.ctlrNext = controller;
                controller = controller2;
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getControllers", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        Controller controller3 = controller;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getControllers", controller3);
        }
        return controller3;
    }

    public Controller getControllers(int n) throws GeneralException {
        return this.getControllers(n, (short)0);
    }

    private void fetchController(Controller controller) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchController", (String)"ctlr");
        }
        this.colIndex = 1;
        controller.ctlrID = this.getInt(this.resultSet);
        controller.ctlrComputerID = this.getInt(this.resultSet);
        controller.ctlrInstance = this.getShort(this.resultSet);
        if (this.isStorageSubsystem) {
            this.getShort(this.resultSet);
            TResDiskArray tResDiskArray = new TResDiskArray(this.dbc);
            controller.ctlrBusNumber = (short)tResDiskArray.getNumOfDiskGroupDisks(controller.ctlrID);
        } else {
            controller.ctlrBusNumber = this.getShort(this.resultSet);
        }
        controller.ctlrHBAPortWWN = this.getLong(this.resultSet);
        controller.ctlrDriverName = this.getString(this.resultSet);
        controller.ctlrDriverDescription = this.getString(this.resultSet);
        if (this.isStorageSubsystem) {
            controller.ctlrTarget = this.getDiskGroupRAIDLevel(this.getString(this.resultSet));
            controller.ctlrType = (short)7;
        } else {
            controller.ctlrTarget = this.getShort(this.resultSet);
            controller.ctlrType = this.getShort(this.resultSet);
        }
        controller.ctlrLoop = this.getString(this.resultSet);
        controller.ctlrAdapterPair = this.isStorageSubsystem ? new Integer(this.getInt(this.resultSet)).toString() : this.getString(this.resultSet);
        controller.ctlrArray = this.getString(this.resultSet);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchController");
        }
    }

    public String getControllerNames(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getControllerNames", (String)"rankID");
        }
        StringBuffer stringBuffer = new StringBuffer(20);
        StringBuffer stringBuffer2 = new StringBuffer(400);
        stringBuffer2.append(FETCH_CTRLR_NAME_BY_STOREXT);
        String string = stringBuffer2.toString();
        stringBuffer2 = null;
        try {
            this.selectStmt = this.prepareStmt(string);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            if (this.nextResult()) {
                this.colIndex = 1;
                stringBuffer.append(this.getString(this.resultSet));
            }
            while (this.nextResult()) {
                this.colIndex = 1;
                stringBuffer.append(new String(", "));
                stringBuffer.append(this.getString(this.resultSet));
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getControllerNames", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        String string2 = stringBuffer.toString();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getControllerNames", (Object)string2);
        }
        return string2;
    }

    public void insertControllers(int n, Controller controller) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insertControllers", (String)"ctlrList");
        }
        int n2 = 0;
        String string = "";
        try {
            Controller controller2 = controller;
            while (controller2 != null) {
                ++n2;
                controller2 = controller2.ctlrNext;
            }
            int n3 = TResController.getIdentifier(1, n2, this.dbc);
            this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(n);
            this.insertStmt = this.isStorageSubsystem ? this.prepareStmt(INSERT_DG) : this.prepareStmt(INSERT);
            controller2 = controller;
            while (controller2 != null) {
                controller2.ctlrID = n3++;
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.insertStmt, controller2.ctlrComputerID);
                this.setInt(this.insertStmt, controller2.ctlrID);
                if (!this.isStorageSubsystem) {
                    this.setShort(this.insertStmt, controller2.ctlrInstance);
                }
                this.setShort(this.insertStmt, controller2.ctlrBusNumber);
                if (!this.isStorageSubsystem) {
                    if (controller2.ctlrHBAPortWWN != 0L) {
                        string = Long.toHexString(controller2.ctlrHBAPortWWN);
                        string = string.toUpperCase();
                    } else {
                        string = "0";
                    }
                    this.setLong(this.insertStmt, controller2.ctlrHBAPortWWN);
                    this.setString(this.insertStmt, string);
                }
                this.setString(this.insertStmt, controller2.ctlrDriverName);
                this.setString(this.insertStmt, controller2.ctlrDriverDescription);
                this.setShort(this.insertStmt, controller2.ctlrTarget);
                if (!this.isStorageSubsystem) {
                    this.setShort(this.insertStmt, controller2.ctlrType);
                }
                this.setString(this.insertStmt, controller2.ctlrLoop);
                this.setString(this.insertStmt, controller2.ctlrAdapterPair);
                this.setString(this.insertStmt, controller2.ctlrArray);
                this.executeUpdate(this.insertStmt);
                this.dbc.commit();
                controller2 = controller2.ctlrNext;
            }
            this.closeInsert();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insertControllers", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertControllers");
        }
    }

    private short getDiskGroupRAIDLevel(String string) {
        int n = 11;
        if ("raid5".equalsIgnoreCase(string)) {
            n = 0;
        } else if ("raid10".equalsIgnoreCase(string)) {
            n = 1;
        } else if ("jbod".equalsIgnoreCase(string)) {
            n = 2;
        } else if ("raid0".equalsIgnoreCase(string)) {
            n = 3;
        } else if ("raid1".equalsIgnoreCase(string)) {
            n = 4;
        } else if ("raid2".equalsIgnoreCase(string)) {
            n = 5;
        } else if ("raid3".equalsIgnoreCase(string)) {
            n = 6;
        } else if ("raid4".equalsIgnoreCase(string)) {
            n = 7;
        } else if ("raid6".equalsIgnoreCase(string)) {
            n = 8;
        } else if ("raid51".equalsIgnoreCase(string)) {
            n = 9;
        } else if ("raid15".equalsIgnoreCase(string)) {
            n = 9;
        }
        return (short)n;
    }

    public void updateControllers(int n, Controller controller) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateControllers", (String)"ctlrList");
        }
        String string = "";
        this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(n);
        this.updateStmt = this.isStorageSubsystem ? this.prepareStmt(UPDATE_DG) : this.prepareStmt(UPDATE);
        try {
            Controller controller2 = controller;
            while (controller2 != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setString(this.updateStmt, controller2.ctlrDriverDescription);
                this.setShort(this.updateStmt, controller2.ctlrTarget);
                if (!this.isStorageSubsystem) {
                    if (controller2.ctlrHBAPortWWN != 0L) {
                        string = Long.toHexString(controller2.ctlrHBAPortWWN);
                        string = string.toUpperCase();
                    } else {
                        string = "0";
                    }
                    this.setShort(this.updateStmt, controller2.ctlrType);
                    this.setLong(this.updateStmt, controller2.ctlrHBAPortWWN);
                    this.setString(this.updateStmt, string);
                }
                this.setString(this.updateStmt, controller2.ctlrLoop);
                this.setString(this.updateStmt, controller2.ctlrAdapterPair);
                this.setString(this.updateStmt, controller2.ctlrArray);
                this.setInt(this.updateStmt, controller2.ctlrComputerID);
                this.setInt(this.updateStmt, controller2.ctlrID);
                this.executeUpdate(this.updateStmt);
                this.dbc.commit();
                controller2 = controller2.ctlrNext;
            }
            this.closeUpdate();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateControllers", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateControllers");
        }
    }

    public void deleteControllers(int n, Controller controller) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteControllers", (String)"ctlrList");
        }
        try {
            this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(n);
            this.deleteStmt = this.isStorageSubsystem ? this.prepareStmt(DELETE_BY_DG_ID) : this.prepareStmt(DELETE_BY_ID);
            Controller controller2 = controller;
            while (controller2 != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.deleteStmt, controller2.ctlrComputerID);
                this.setInt(this.deleteStmt, controller2.ctlrID);
                this.executeUpdate(this.deleteStmt);
                this.dbc.commit();
                controller2 = controller2.ctlrNext;
            }
            this.closeDelete();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteControllers", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteControllers");
        }
    }
}

