/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.EntityWWPN;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;

public class TResEntityWWPN
extends StorageRepositoryAccessor {
    private static final String INSERT = "insert into t_res_entity_wwpn (entity_id, entity_type, wwpn, swwpn) values (?,?,?,?)";
    private static final String DELETE_BY_ENTITY_ID = "delete from t_res_entity_wwpn where entity_id = ?";
    private static final String DELETE_BY_ENTITY_ID_AND_WWPN = "delete from t_res_entity_wwpn where entity_id = ? and wwpn = ?";
    private static final String DELETE_BY_ENTITY_ID_AND_TYPE = "delete from t_res_entity_wwpn where entity_id = ? and entity_type = ?";
    private static final String SELECT = "select entity_type, swwpn from t_res_entity_wwpn where entity_id = ?";
    private static final String SELECT_BY_ENTITY_ID = "select entity_id, entity_type, wwpn, swwpn from t_res_entity_wwpn where entity_id = ?";
    private static final String SELECT_ENTITY_ID_BY_WWPN = "select entity_id from t_res_entity_wwpn where entity_type = ? and swwpn = ?";

    public TResEntityWWPN(Connection connection) {
        super(connection);
        this.tableName = "t_res_entity_wwpn";
    }

    public void deleteByEntity_ID(int n) throws GeneralException {
        block10: {
            String string = DELETE_BY_ENTITY_ID;
            this.deleteStmt = this.prepareStmt(string);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResEntityWWPN");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"deleteByEntity_ID", (String)"entityID");
            }
            try {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.deleteStmt, n);
                this.stmtPhase = 3;
                this.executeUpdate(this.deleteStmt);
            }
            catch (SQLException sQLException) {
                Class<?> clazz;
                this.stmtType = 3;
                this.sqlError(sQLException);
                if (!TraceLogger.enableTrace) break block10;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResEntityWWPN");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteByEntity_ID", (Throwable)sQLException);
            }
        }
        this.commit();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResEntityWWPN");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByEntity_ID");
        }
    }

    public void insert(int n, byte by, String string) throws GeneralException {
        block12: {
            long l = 0L;
            String string2 = string != null && string.length() > 32 ? new String(string.substring(32)) : new String(string);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"entityID, entity_type, wwpn");
            }
            try {
                l = Long.parseLong(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                this.stmtType = 1;
            }
            try {
                this.insertStmt = this.prepareStmt(INSERT);
                this.setPhase();
                this.setInt(this.insertStmt, n);
                this.setByte(this.insertStmt, by);
                this.setLong(this.insertStmt, l);
                this.setString(this.insertStmt, string2);
                this.executeUpdate(this.insertStmt);
            }
            catch (SQLException sQLException) {
                Class<?> clazz;
                this.stmtType = 1;
                this.sqlError(sQLException);
                if (!TraceLogger.enableTrace) break block12;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResEntityWWPN");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
            }
        }
        this.closeInsert();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResEntityWWPN");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }

    public EntityWWPN getEntityWWPNs(int n) throws GeneralException {
        EntityWWPN entityWWPN = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getEntityWWPNs", (String)"entityID");
        }
        try {
            this.selectStmt = this.prepareStmt(SELECT);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                EntityWWPN entityWWPN2 = new EntityWWPN();
                entityWWPN2.entityID = n;
                this.fetchEntityWWPN(entityWWPN2, this.resultSet);
                entityWWPN2.entityWWPNNext = entityWWPN;
                entityWWPN = entityWWPN2;
            }
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResEntityWWPN");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getEntityWWPNs", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeSelect();
        EntityWWPN entityWWPN3 = entityWWPN;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResEntityWWPN");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getEntityWWPNs", entityWWPN3);
        }
        return entityWWPN3;
    }

    public int fetchEntityWWPN(EntityWWPN entityWWPN, ResultSet resultSet) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchEntityWWPN", (String)"wwpn, rs");
        }
        this.colIndex = 1;
        entityWWPN.entity_type = this.getByte(resultSet);
        entityWWPN.sWWPN = this.getString(resultSet);
        int n = this.colIndex;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchEntityWWPN", (int)n);
        }
        return n;
    }

    public int getEntityIdByWWPN(byte by, String string) throws GeneralException {
        String string2 = string != null && string.length() > 32 ? new String(string.substring(32)) : new String(string);
        int n = -1;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getEntityIdByWWPN", (String)"entityID");
        }
        try {
            this.selectStmt = this.prepareStmt(SELECT_ENTITY_ID_BY_WWPN);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setByte(this.selectStmt, by);
            this.setString(this.selectStmt, string2);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                n = this.getInt(this.resultSet);
            }
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResEntityWWPN");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getEntityIdByWWPN", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeSelect();
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResEntityWWPN");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getEntityIdByWWPN", (int)n2);
        }
        return n2;
    }
}

