/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResComputer;

public class TResLogicalDisk
extends StorageRepositoryAccessor {
    PreparedStatement selectMirrorsStmt;
    private boolean useSetShort = false;
    private boolean isSV = false;
    public static final String CAPACITY_COLUMN = "capacity";
    public static final String ID_COLUMN = "logical_disk_id";
    public static final String SV_ID_COLUMN = "svid";
    public static final String COLUMNS = " logical_disk_id, parent_logdisk_id, logical_disk_type, capacity, use_count, mirror_count, is_swap, snap_source_id, is_vcmdb, replication_mode, not_exposed, overhead, volgroup_id, lun_identity, ssraidl, storage_type";
    public static final String SV_COLUMNS = " v.svid, v.pool_id, v.logical_disk_type, v.capacity,  v.use_count, v.mirror_count, v.is_swap, v.snap_source_id,  v.is_vcmdb, v.replication_mode, v.not_exposed, v.overhead,  v.pool_id, v.lun_identity, -1, v.format, v.display_name, v.name,  v.package_redundancy, v.data_redundancy, v.is_assigned,  cimv.device_id ";
    private static final String FETCH_ALL = "select logical_disk_id, parent_logdisk_id, logical_disk_type, capacity, use_count, mirror_count, is_swap, snap_source_id, is_vcmdb, replication_mode, not_exposed, overhead, volgroup_id, lun_identity, ssraidl, storage_type from t_res_logical_disk";
    private static final String FETCH_ALL_SV = "select  v.svid, v.pool_id, v.logical_disk_type, v.capacity,  v.use_count, v.mirror_count, v.is_swap, v.snap_source_id,  v.is_vcmdb, v.replication_mode, v.not_exposed, v.overhead,  v.pool_id, v.lun_identity, -1, v.format, v.display_name, v.name,  v.package_redundancy, v.data_redundancy, v.is_assigned,  cimv.device_id  from t_res_storage_volume v, t_res_cimkey_volume cimv ";
    private static final String BY_ID = " where logical_disk_id = ?";
    private static final String BY_SV_ID = " where svid = ?  and  v.svid = cimv.volume_id ";
    private static final String BY_PARENT = " where parent_logdisk_id = ? order by logical_disk_id";
    private static final String SELECT_BY_COMPUTERID1 = "select f.logical_disk_id, f.mount_point, f.filesystem_id, ''  from t_res_filesystem f where f.computer_id = ? ";
    private static final String SELECT_BY_COMPUTERID2 = "union all select l.logical_disk_id, s.path, -1, s.name  from t_res_share s, t_res_logical_disk l where s.computer_id = ?   and s.resource_type = 11   and s.resource_id = l.logical_disk_id   and l.parent_logdisk_id = -1   and l.logical_disk_id not in  (select logical_disk_id from t_res_filesystem ff  where ff.computer_id = ?) ";
    private static final String SELECT_BY_SS_COMPUTERID = " select distinct  l.svid, l.display_name, -1, l.name, cimv.device_id  from  t_res_storage_volume l, t_res_cimkey_volume cimv  where subsystem_id = ? and l.svid = cimv.volume_id ";
    private static final String BY_VOLGROUP_CLAUSE1 = " and   ( (f.logical_disk_id in           (select logical_disk_id from t_res_logical_disk z             where z.volgroup_id = ?))       or (f.logical_disk_id in           (select parent_logdisk_id from t_res_logical_disk z             where z.volgroup_id = ?)  )) ";
    private static final String BY_VOLGROUP_CLAUSE2 = " and l.volgroup_id = ? ";
    private static final String BY_SP_CLAUSE = " and l.pool_id = ? ";
    private static final String BY_COMPUTERID_ORDER = " order by 2, 3 desc";
    private static final String SELECT_BY_SVC_SS_DISKID = " select distinct vdisk.svid, vdisk.display_name, -1, vdisk.name, cimv.device_id\tfrom t_res_storage_volume vdisk,      t_res_storage_pool mdiskgrp,      t_res_storage_extent mdisk,      t_res_cimkey_volume cimv\twhere vdisk.pool_id = mdiskgrp.pool_id and   mdiskgrp.pool_id = mdisk.pool_id and   vdisk.svid = cimv.volume_id  and   mdisk.storage_extent_id = ?";
    private static final String SELECT_BY_SS_DISKID = " (select distinct sv.svid, sv.display_name, -1, sv.name, cimv.device_id from \tt_res_storage_volume sv,       t_res_volume2extent vte,       t_res_physicalvolume2extent pvte,       t_res_cimkey_volume cimv where sv.svid = vte.volume_id and   vte.storage_extent_id = pvte.storage_extent_id and   sv.svid = cimv.volume_id and   pvte.physical_volume_id = ?) UNION (select sv.svid, sv.display_name, -1, sv.name, sv.name  from t_res_chunk c, t_res_storage_volume sv  where c.disk_id = ?  and c.logical_disk_id = sv.svid and c.disk_id not in      (select physical_volume_id       from t_res_physicalvolume2extent      where physical_volume_id = ?)      ) order by 2 ";
    private static final String ORDER_BY_DISPLAY_NAME = " order by 2";
    private static final String SELECT_BY_DISKID = "select distinct f.logical_disk_id, f.mount_point, f.filesystem_id, ''  from t_res_chunk c, t_res_filesystem f where c.disk_id = ? and c.logical_disk_id = f.logical_disk_id union all  select distinct f.logical_disk_id, f.mount_point, f.filesystem_id, '' from t_res_chunk c, t_res_filesystem f, t_res_aggregate ag where c.disk_id = ? and c.collection_id = ag.collection_id and ag.logical_disk_id = f.logical_disk_id union all  select distinct f.logical_disk_id, f.mount_point, f.filesystem_id, ''  from t_res_chunk c, t_res_filesystem f, t_res_logical_disk l where c.disk_id = ?   and c.logical_disk_id = l.logical_disk_id    and l.parent_logdisk_id > 0    and l.parent_logdisk_id = f.logical_disk_id union all select distinct c.logical_disk_id, s.path, -1, s.name  from t_res_chunk c, t_res_share s, t_res_logical_disk l where c.disk_id = ?   and c.logical_disk_id = s.resource_id   and c.logical_disk_id = l.logical_disk_id   and l.parent_logdisk_id = -1   and l.logical_disk_id not in  (select logical_disk_id from t_res_filesystem) union all select distinct l.parent_logdisk_id, s.path, -1, s.name  from t_res_chunk c, t_res_share s, t_res_logical_disk l where c.disk_id = ?   and c.logical_disk_id = l.logical_disk_id   and l.parent_logdisk_id = s.resource_id   and l.parent_logdisk_id <> -1   and l.parent_logdisk_id not in  (select logical_disk_id from t_res_filesystem) order by 3, 2 desc";
    private static final String SELECT_LUN_HOST_PATHS = "select distinct c.host_name, c.os_type, a.path  from  t_res_host c  , t_res_dev_access a  , t_res_physical_volume pv  , t_res_view_ssluncmp ssluncmp  where ssluncmp.svid = ?  and ssluncmp.computer_id = c.computer_id  and ssluncmp.physical_volume_id = a.device_id ";
    private static final String INSERT = "insert into t_res_logical_disk (logical_disk_id, parent_logdisk_id, logical_disk_type, capacity, use_count, mirror_count, is_swap, snap_source_id, is_vcmdb, replication_mode, not_exposed, overhead, volgroup_id, lun_identity, ssraidl, storage_type) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_SV = "insert into t_res_storage_volume (svid,  logical_disk_type, capacity, use_count, mirror_count, is_swap, snap_source_id, is_vcmdb, replication_mode, not_exposed, overhead, pool_id, lun_identity, ssraidl, storage_type) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String DELETE_BY_ID = "delete from t_res_logical_disk where logical_disk_id = ? or parent_logdisk_id = ?";
    private static final String DELETE_BY_SVID = "delete from t_res_storage_volume where svid = ?";
    private static final String UPDATE_USE_COUNT = "update t_res_logical_disk set use_count = ? where logical_disk_id = ?";
    private static final String UPDATE_SV_USE_COUNT = "update t_res_storage_volume set use_count = ? where svid = ?";
    private static final String UPDATE_ATTRIBUTES = "update t_res_logical_disk set use_count = ?, snap_source_id = ?, is_vcmdb = ?, replication_mode = ?, not_exposed = ?, volgroup_id = ?, ssraidl = ?, storage_type = ? where logical_disk_id = ?";
    private static final String UPDATE_SV_ATTRIBUTES = "update t_res_storage_volume set use_count = ?, snap_source_id = ?, is_vcmdb = ?, replication_mode = ?, not_exposed = ?, pool_id = ?, ssraidl = ?, storage_type = ? where svid = ?";
    private static final String SELECT_USE_COUNT = "select use_count from t_res_logical_disk where logical_disk_id = ?";
    private static final String SELECT_SV_CAPACITY = "select capacity from t_res_storage_volume where svid = ?";
    private static final String UPDATE_LUN_IDENTITY = "update t_res_storage_volume set lun_identity = ? where svid = ?";
    private static final String SELECT_SS_TYPE_FOR_LOGICAL_DISK = "select ss.os_type from t_res_storage_volume sv, t_res_storage_subsystem ss where sv.subsystem_id = ss.subsystem_id and svid = ?";
    private static final String SELECT_SS_LUNS = "select svid, vdisk_type, capacity from t_res_storage_volume where pool_id = ?";
    private static final String UPDATE_SVID_TYPE = "update t_res_storage_volume set logical_disk_type = ? where svid = ?";
    private static final String UPDATE_SS_SVID_TYPE = "update t_res_storage_volume set logical_disk_type = ? where subsystem_id = ?";
    private static final String GET_MDISKS_FOR_VDISK = " select storage_extent_id, total_num_extents from  t_res_storage_volume vol, t_res_volume2extent vte where vol.svid = vte.volume_id and vol.svid = ?";
    private static final String DELETE_AGGREGATE_BY_LD = "delete from t_res_aggregate where logical_disk_id = ";
    private static final String DELETE_FLEX_CHUNK_COLLECTION = "delete from t_res_chunk_cllctn where logical_disk_id = -1 and collection_id not in (select collection_id from t_res_aggregate)";
    private static final String DELETE_FLEX_CHUNK = "delete from t_res_chunk where logical_disk_id = -1 and collection_id not in (select collection_id from t_res_aggregate)";

    public TResLogicalDisk(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TResLogicalDisk", (String)"dbc");
        }
        this.tableName = "t_res_logical_disk";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TResLogicalDisk");
        }
    }

    public void prepSelectByID() throws GeneralException {
        this.selectStmt = this.prepareStmt("select logical_disk_id, parent_logdisk_id, logical_disk_type, capacity, use_count, mirror_count, is_swap, snap_source_id, is_vcmdb, replication_mode, not_exposed, overhead, volgroup_id, lun_identity, ssraidl, storage_type from t_res_logical_disk where logical_disk_id = ?");
    }

    public void prepSelectBySVID() throws GeneralException {
        this.selectStmt = this.prepareStmt("select  v.svid, v.pool_id, v.logical_disk_type, v.capacity,  v.use_count, v.mirror_count, v.is_swap, v.snap_source_id,  v.is_vcmdb, v.replication_mode, v.not_exposed, v.overhead,  v.pool_id, v.lun_identity, -1, v.format, v.display_name, v.name,  v.package_redundancy, v.data_redundancy, v.is_assigned,  cimv.device_id  from t_res_storage_volume v, t_res_cimkey_volume cimv  where svid = ?  and  v.svid = cimv.volume_id ");
    }

    public Share selectHostPaths(LogicalDisk logicalDisk) throws GeneralException {
        Share share;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectHostPaths", (String)"ld");
        }
        try {
            this.selectStmt = this.prepareStmt(SELECT_LUN_HOST_PATHS);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, logicalDisk.ldID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectHostPaths", (Throwable)sQLException);
            }
            this.stmtPhase = 3;
            this.sqlError(sQLException);
        }
        Share share2 = null;
        this.stmtPhase = 1;
        while (this.nextResult()) {
            this.getPhase();
            try {
                share = new Share();
                share.shComputerName = this.getString(this.resultSet);
                share.shResourceType = this.getShort(this.resultSet);
                share.shPath = this.getString(this.resultSet);
                share.shNext = share2;
                share2 = share;
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"selectHostPaths", (Throwable)sQLException);
                }
                this.sqlError(sQLException);
            }
        }
        this.closeSelect();
        this.closeResultSet();
        share = share2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectHostPaths", (Object)share);
        }
        return share;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short getSSTypeForLogicalDisk(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"isStorageSubsystemLogicalDisk", (String)"id");
        }
        this.selectStmt = this.prepareStmt(SELECT_SS_TYPE_FOR_LOGICAL_DISK);
        short s = -1;
        try {
            try {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, n);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                if (this.nextResult()) {
                    s = this.resultSet.getShort(1);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"isStorageSubsystemLogicalDisk", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.closeResultSet();
            this.closeSelect();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.closeResultSet();
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isStorageSubsystemLogicalDisk", (short)s);
        }
        return s;
    }

    public boolean getLogicalDisk(LogicalDisk logicalDisk, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getLogicalDisk", (String)"ld");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, logicalDisk.ldID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (!this.nextResult()) {
                boolean bl2 = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getLogicalDisk", (boolean)bl2);
                }
                return bl2;
            }
            this.stmtPhase = 1;
            this.fetchLogicalDisk(logicalDisk, this.resultSet, bl);
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getLogicalDisk", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        boolean bl3 = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getLogicalDisk", (boolean)bl3);
        }
        return bl3;
    }

    public int fetchLogicalDisk(LogicalDisk logicalDisk, ResultSet resultSet, boolean bl) throws SQLException {
        int n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchLogicalDisk", (String)"ld, rs");
        }
        String string = "";
        this.colIndex = 1;
        logicalDisk.ldID = this.getInt(resultSet);
        logicalDisk.ldParentLogicalDiskID = this.getInt(resultSet);
        string = this.getString(resultSet);
        logicalDisk.ldType = string == null ? (byte)0 : ((string = string.trim()).compareTo("T") == 0 ? (byte)11 : (string.compareTo("F") == 0 ? (byte)12 : (byte)Integer.parseInt(string)));
        logicalDisk.ldCapacity = this.getLong(resultSet);
        logicalDisk.ldUseCount = this.getShort(resultSet);
        logicalDisk.ldMirrorCount = this.getByte(resultSet);
        logicalDisk.ldIsSwap = this.getBoolean(resultSet);
        logicalDisk.ldSnapSourceID = this.getInt(resultSet);
        boolean bl2 = this.getBoolean(resultSet);
        byte by = this.getByte(resultSet);
        boolean bl3 = this.getBoolean(resultSet);
        logicalDisk.setFlags((short)by, bl2, bl3);
        logicalDisk.ldOverhead = this.getLong(resultSet);
        logicalDisk.ldVolgroupID = this.getInt(resultSet);
        logicalDisk.lun_identity = this.getByte(resultSet);
        logicalDisk.ldRaid = this.getInt(resultSet);
        logicalDisk.ldStorageType = this.getShort(resultSet);
        if (bl) {
            logicalDisk.ldStorageType = logicalDisk.ldStorageType == -1 ? (short)0 : logicalDisk.ldStorageType;
            logicalDisk.ldPath = this.getString(resultSet);
            logicalDisk.ldName = this.getString(resultSet);
            int n2 = 11;
            n = this.getShort(resultSet);
            short s = this.getShort(resultSet);
            if (s == 1 && n == 0) {
                n2 = 3;
            } else if (s == 1 && n == 1) {
                n2 = 0;
            } else if (s > 1 && n == 1) {
                n2 = 1;
            } else if (s > 1 && n > 1) {
                n2 = 9;
            } else if (s == 1 && n > 1) {
                n2 = 8;
            }
            logicalDisk.ldRaid = n2;
            short s2 = this.getShort(resultSet);
            boolean bl4 = true;
            if (s2 > 0) {
                bl4 = false;
            }
            logicalDisk.setFlags((short)by, bl2, bl4);
            logicalDisk.ldDeviceId = this.getString(resultSet);
        }
        n = this.colIndex;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchLogicalDisk", (int)n);
        }
        return n;
    }

    public NameList getLDlist(int n, int n2, int n3) throws GeneralException {
        StringBuffer stringBuffer;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getLDlist", (String)"computerID, diskID, volgroupID");
        }
        NameList nameList = null;
        boolean bl = false;
        TResComputer tResComputer = new TResComputer(this.dbc);
        short s = tResComputer.getStorageSubsystemType(n);
        boolean bl2 = s >= 0;
        try {
            int n4;
            stringBuffer = new StringBuffer(200);
            if (n2 < 1) {
                n4 = n;
                if (!bl2) {
                    stringBuffer.append(SELECT_BY_COMPUTERID1);
                    if (n3 > 0) {
                        stringBuffer.append(BY_VOLGROUP_CLAUSE1);
                    }
                    stringBuffer.append(SELECT_BY_COMPUTERID2);
                    if (n3 > 0) {
                        stringBuffer.append(BY_VOLGROUP_CLAUSE2);
                    }
                    stringBuffer.append(BY_COMPUTERID_ORDER);
                    this.selectStmt = this.prepareStmt(stringBuffer.toString());
                    this.stmtPhase = 0;
                    this.colIndex = 1;
                    this.setInt(this.selectStmt, n4);
                    if (n3 > 0) {
                        this.setInt(this.selectStmt, n3);
                        this.setInt(this.selectStmt, n3);
                    }
                    this.setInt(this.selectStmt, n4);
                    this.setInt(this.selectStmt, n4);
                    if (n3 > 0) {
                        this.setInt(this.selectStmt, n3);
                    }
                } else {
                    stringBuffer.append(SELECT_BY_SS_COMPUTERID);
                    if (n3 > 0) {
                        stringBuffer.append(BY_SP_CLAUSE);
                    }
                    stringBuffer.append(BY_COMPUTERID_ORDER);
                    this.selectStmt = this.prepareStmt(stringBuffer.toString());
                    this.stmtPhase = 0;
                    this.colIndex = 1;
                    this.setInt(this.selectStmt, n4);
                    if (n3 > 0) {
                        this.setInt(this.selectStmt, n3);
                    }
                }
            } else {
                n4 = n2;
                if (!bl2) {
                    this.selectStmt = this.prepareStmt(SELECT_BY_DISKID);
                    this.stmtPhase = 0;
                    this.colIndex = 1;
                    this.setInt(this.selectStmt, n4);
                    this.setInt(this.selectStmt, n4);
                    this.setInt(this.selectStmt, n4);
                    this.setInt(this.selectStmt, n4);
                    this.setInt(this.selectStmt, n4);
                } else {
                    if (s == 21) {
                        stringBuffer.append(SELECT_BY_SVC_SS_DISKID);
                    } else {
                        stringBuffer.append(SELECT_BY_SS_DISKID);
                        bl = true;
                    }
                    if (!bl) {
                        stringBuffer.append(ORDER_BY_DISPLAY_NAME);
                    }
                    this.selectStmt = this.prepareStmt(stringBuffer.toString());
                    this.stmtPhase = 0;
                    this.colIndex = 1;
                    this.setInt(this.selectStmt, n4);
                    if (bl) {
                        this.setInt(this.selectStmt, n4);
                        this.setInt(this.selectStmt, n4);
                    }
                }
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                NameList nameList2 = new NameList();
                this.colIndex = 1;
                nameList2.nlID = this.getInt(this.resultSet);
                nameList2.nlName = this.getString(this.resultSet);
                nameList2.nlID2 = this.getInt(this.resultSet);
                nameList2.nlName2 = this.getString(this.resultSet);
                if (bl2) {
                    String string = this.getString(this.resultSet);
                    if (Constants.hasLunWWN((short)s)) {
                        nameList2.nlName2 = nameList2.nlName;
                        nameList2.nlName = string;
                    }
                }
                nameList2.nlNext = nameList;
                nameList = nameList2;
            }
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getLDlist", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        stringBuffer = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getLDlist", (Object)stringBuffer);
        }
        return stringBuffer;
    }

    public void getMirrors(LogicalDisk logicalDisk, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getMirrors", (String)"ld");
        }
        this.selectStmt = this.prepareStmt("select logical_disk_id, parent_logdisk_id, logical_disk_type, capacity, use_count, mirror_count, is_swap, snap_source_id, is_vcmdb, replication_mode, not_exposed, overhead, volgroup_id, lun_identity, ssraidl, storage_type from t_res_logical_disk where parent_logdisk_id = ? order by logical_disk_id");
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, logicalDisk.ldID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                logicalDisk.ldNextMirror = new LogicalDisk();
                this.fetchLogicalDisk(logicalDisk.ldNextMirror, this.resultSet, bl);
                logicalDisk = logicalDisk.ldNextMirror;
            }
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getMirrors", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getMirrors");
        }
    }

    public void prepInsert() throws GeneralException {
        this.insertStmt = this.prepareStmt(INSERT);
        this.useSetShort = false;
        if (SQLUtil.isSybase()) {
            try {
                String string = "select mirror_count from t_res_logical_disk";
                Statement statement = this.dbc.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnType(1);
                if (n == 5 || n == 4) {
                    this.useSetShort = true;
                }
            }
            catch (SQLException sQLException) {
                this.sqlError(sQLException);
            }
        }
    }

    public void prepInsertSV() throws GeneralException {
        this.insertStmt = this.prepareStmt(INSERT_SV);
        this.isSV = true;
    }

    public void insertLogicalDisks(LogicalDisk logicalDisk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insertLogicalDisks", (String)"ldList");
        }
        try {
            LogicalDisk logicalDisk2 = logicalDisk;
            while (logicalDisk2 != null) {
                this.insert(logicalDisk2);
                this.dbc.commit();
                logicalDisk2 = logicalDisk2.ldNextMirror;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insertLogicalDisks", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertLogicalDisks");
        }
    }

    private void insert(LogicalDisk logicalDisk) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"ld");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.insertStmt, logicalDisk.ldID);
        if (!this.isSV) {
            this.setInt(this.insertStmt, logicalDisk.ldParentLogicalDiskID);
        }
        if (logicalDisk.ldType == 11) {
            this.setString(this.insertStmt, "T");
        } else if (logicalDisk.ldType == 12) {
            this.setString(this.insertStmt, "F");
        } else {
            this.setByte(this.insertStmt, logicalDisk.ldType);
        }
        this.setLong(this.insertStmt, logicalDisk.ldCapacity);
        this.setShort(this.insertStmt, logicalDisk.ldUseCount);
        if (this.useSetShort) {
            this.setShort(this.insertStmt, logicalDisk.ldMirrorCount);
        } else {
            this.setByte(this.insertStmt, logicalDisk.ldMirrorCount);
        }
        this.setBoolean(this.insertStmt, logicalDisk.ldIsSwap);
        this.setInt(this.insertStmt, logicalDisk.ldSnapSourceID);
        this.setBoolean(this.insertStmt, logicalDisk.isVCMDB());
        this.setByte(this.insertStmt, logicalDisk.getReplicationMode());
        this.setBoolean(this.insertStmt, logicalDisk.notExposed());
        this.setLong(this.insertStmt, logicalDisk.ldOverhead);
        this.setInt(this.insertStmt, logicalDisk.ldVolgroupID);
        this.setByte(this.insertStmt, logicalDisk.lun_identity);
        this.setInt(this.insertStmt, logicalDisk.ldRaid);
        this.setShort(this.insertStmt, logicalDisk.ldStorageType);
        this.executeUpdate(this.insertStmt);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }

    public void prepUpdateUseCount() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_USE_COUNT);
    }

    public void prepUpdateSVUseCount() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_SV_USE_COUNT);
    }

    public void updateUseCount(LogicalDisk logicalDisk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateUseCount", (String)"lDisk");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setShort(this.updateStmt, logicalDisk.ldUseCount);
            this.setInt(this.updateStmt, logicalDisk.ldID);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateUseCount", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateUseCount");
        }
    }

    public void prepUpdateAttributes() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_ATTRIBUTES);
    }

    public void prepUpdateSVAttributes() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_SV_ATTRIBUTES);
    }

    public void updateAttributes(LogicalDisk logicalDisk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateAttributes", (String)"lDisk");
        }
        this.setPhase();
        try {
            this.setShort(this.updateStmt, logicalDisk.ldUseCount);
            this.setInt(this.updateStmt, logicalDisk.ldSnapSourceID);
            this.setBoolean(this.updateStmt, logicalDisk.isVCMDB());
            this.setByte(this.updateStmt, logicalDisk.getReplicationMode());
            this.setBoolean(this.updateStmt, logicalDisk.notExposed());
            this.setInt(this.updateStmt, logicalDisk.ldVolgroupID);
            this.setInt(this.updateStmt, logicalDisk.ldRaid);
            this.setShort(this.updateStmt, logicalDisk.ldStorageType);
            this.setInt(this.updateStmt, logicalDisk.ldID);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateAttributes", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateAttributes");
        }
    }

    public void prepUpdateLUNIdentity() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_LUN_IDENTITY);
    }

    public int updateLUNIdentity(int n, byte by) throws GeneralException {
        int n2 = 0;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateLUNIdentity", (String)"lvID, lunIdentity");
        }
        this.setPhase();
        try {
            this.setByte(this.updateStmt, by);
            this.setInt(this.updateStmt, n);
            n2 = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            n2 = -1;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateLUNIdentity", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateLUNIdentity");
        }
        return n2;
    }

    public void prepDeleteLogicalDisk() throws GeneralException {
        this.deleteStmt = this.prepareStmt(DELETE_BY_ID);
    }

    public void prepDeleteSV() throws GeneralException {
        this.deleteStmt = this.prepareStmt(DELETE_BY_SVID);
    }

    public void deleteLogicalDisk(LogicalDisk logicalDisk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteLogicalDisk", (String)"lDisk");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, logicalDisk.ldID);
            this.setInt(this.deleteStmt, logicalDisk.ldID);
            this.executeUpdate(this.deleteStmt);
            if (logicalDisk.ldType == 12) {
                PreparedStatement preparedStatement = this.prepareStmt(DELETE_AGGREGATE_BY_LD + logicalDisk.ldID);
                this.executeUpdate(preparedStatement);
                preparedStatement = this.prepareStmt(DELETE_FLEX_CHUNK_COLLECTION);
                this.executeUpdate(preparedStatement);
                preparedStatement = this.prepareStmt(DELETE_FLEX_CHUNK);
                this.executeUpdate(preparedStatement);
            }
            this.dbc.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteLogicalDisk", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteLogicalDisk");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getUseCount(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getUseCount", (String)"logicalDiskID");
        }
        int n2 = -1;
        try {
            try {
                this.selectStmt = this.prepareStmt(SELECT_USE_COUNT);
                this.setPhase();
                this.setInt(this.selectStmt, n);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.getPhase();
                if (this.nextResult()) {
                    n2 = this.getInt(this.resultSet);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getUseCount", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeResultSet();
            this.closeSelect();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        this.closeResultSet();
        this.closeSelect();
        int n3 = n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getUseCount", (int)n3);
        }
        return n3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getSVCapacity(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getSVCapacity", (String)"logicalDiskID");
        }
        long l = 0L;
        try {
            try {
                this.selectStmt = this.prepareStmt(SELECT_SV_CAPACITY);
                this.setPhase();
                this.setInt(this.selectStmt, n);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.getPhase();
                if (this.nextResult()) {
                    l = this.getLong(this.resultSet);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getSVCapacity", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.closeResultSet();
            this.closeSelect();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.closeResultSet();
        this.closeSelect();
        long l2 = l;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getSVCCapacity", (long)l2);
        }
        return l2;
    }

    public ResultSet getLUNs(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getLUNs", (String)"pool_id");
        }
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.dbc.prepareStatement(SELECT_SS_LUNS);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getLUNs", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getLUNs", (Object)resultSet);
        }
        return resultSet;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLogicalDiskType(int n, byte by) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setLogicalDiskType", (String)"svid, ld_type");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                preparedStatement = this.dbc.prepareStatement(UPDATE_SVID_TYPE);
                preparedStatement.setByte(1, by);
                preparedStatement.setInt(2, n);
                preparedStatement.executeUpdate();
                this.dbc.commit();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"setLogicalDiskType", (Throwable)sQLException);
                }
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Class<?> clazz;
            Object var6_7 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setLogicalDiskType");
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException sQLException) {}
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
        try {}
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk").getName(), (String)"setLogicalDiskType");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSSLogicalDiskType(int n, byte by) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setLogicalDiskType", (String)"ssid,ld_type");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                preparedStatement = this.dbc.prepareStatement(UPDATE_SS_SVID_TYPE);
                preparedStatement.setByte(1, by);
                preparedStatement.setInt(2, n);
                preparedStatement.executeUpdate();
                this.dbc.commit();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"setLogicalDiskType", (Throwable)sQLException);
                }
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Class<?> clazz;
            Object var6_7 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setLogicalDiskType");
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException sQLException) {}
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
        try {}
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk").getName(), (String)"setLogicalDiskType");
    }

    public byte getSVCLogicalDiskType(short s) {
        int n = -1;
        n = s == 0 ? 0 : (s == 1 ? 1 : (s == 2 ? 10 : (s == 3 ? 9 : 7)));
        return (byte)n;
    }

    public ResultSet getSVCMDisksForVDisk(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getSVCMDisksForVDisk", (String)"volume_id");
        }
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.dbc.prepareStatement(GET_MDISKS_FOR_VDISK);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getSVCMDisksForVDisk", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getSVCMDisksForVDisk", (Object)resultSet);
        }
        return resultSet;
    }
}

