/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.aperi.TStorm.common.CuStatDef;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.SSummaryHist;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.xmsg.MessageLog;

public class TStatSpaceHist
extends StorageRepositoryAccessor {
    PreparedStatement selectUniqueStmt;
    SSummaryHist histBuffer;
    boolean filesystemHistory;
    private static final String FETCH_UNIQUE_SPACE_HIST = "select file_count, total_size from t_stat_space_hist where statistic_time = ? and statistic_type = ? and filesystem_id = ? and statistic_id = ?";
    private static final String FETCH_SPACE_ACCUMULATORS = "select filesystem_id, statistic_time, statistic_type, accum_count, statistic_id, file_count, total_size from t_stat_space_hist where statistic_type = ? and statistic_time <> ? and accum_count > 0";
    private static final String INSERT_SPACE_HIST = "insert into t_stat_space_hist (statistic_time, file_count, accum_count, total_size, statistic_type, filesystem_id, statistic_id) values (?,?,?,?,?,?,?)";
    private static final String INCREMENT_SPACE_ACCUMULATORS = "update t_stat_space_hist set file_count = (file_count + ?), total_size = (total_size + ?), accum_count = (accum_count + 1) where statistic_type = ? and filesystem_id = ? and statistic_id = ?";
    private static final String RESET_SPACE_ACCUMULATORS = "update t_stat_space_hist set total_size = 0, file_count = 0, accum_count = 0, statistic_time = ? where statistic_type = ? and filesystem_id = ? and statistic_id = ?";
    private static final String AGE_OFF_SPACE_HIST = "delete from t_stat_space_hist where statistic_time < ? and statistic_type = ? and filesystem_id = ? and statistic_id = ?";
    private static final String DELETE_SPACE_HIST_BY_FS = "delete from t_stat_space_hist where filesystem_id = ?";
    private static final String DELETE_SPACE_HIST_BY_STAT = "delete from t_stat_space_hist where statistic_id = ?";
    private static final String FETCH_UNIQUE_FS_HIST = "select file_count, capacity, free_space from t_stat_fs_hist where statistic_time = ? and statistic_type = ? and filesystem_id = ?";
    private static final String FETCH_FS_ACCUMULATORS = "select filesystem_id, statistic_time, statistic_type, accum_count, product_id, file_count, capacity, free_space, used_space from t_stat_fs_hist where statistic_type = ? and statistic_time <> ? and accum_count > 0";
    private static final String FETCH_MAX_FS_TIMESTAMP = "select max(statistic_time) from t_stat_fs_hist where filesystem_id = ? and statistic_type = ?";
    private static final String INSERT_FS_HIST = "insert into t_stat_fs_hist (statistic_time, file_count, accum_count, capacity, free_space, used_space, statistic_type, filesystem_id, product_id) values (?,?,?,?,?,?,?,?,?)";
    private static final String INCREMENT_FS_ACCUMULATORS = "update t_stat_fs_hist set file_count = (file_count + ?), capacity = (capacity + ?), free_space = (free_space + ?), used_space = (used_space + ?), accum_count = (accum_count + 1) where statistic_type = ? and filesystem_id = ? and product_id = ?";
    private static final String RESET_FS_ACCUMULATORS = "update t_stat_fs_hist set capacity = 0, free_space = 0, used_space = 0, file_count =0, accum_count = 0, statistic_time = ? where statistic_type = ? and filesystem_id = ? and product_id = ?";
    private static final String AGE_OFF_FS_HIST = "delete from t_stat_fs_hist where statistic_time < ? and statistic_type = ? and filesystem_id = ? and product_id = ?";
    private static final String DELETE_FS_HIST_BY_FS = "delete from t_stat_fs_hist where filesystem_id = ?";

    public TStatSpaceHist(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TStatSpaceHist", (String)"dbc");
        }
        this.tableName = "t_stat_space_hist";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TStatSpaceHist");
        }
    }

    public void prepSpaceHistSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSpaceHistSave", (String)"");
        }
        this.tableName = "t_stat_space_hist";
        this.insertStmt = this.prepareStmt(INSERT_SPACE_HIST);
        this.updateStmt = this.prepareStmt(INCREMENT_SPACE_ACCUMULATORS);
        this.deleteStmt = this.prepareStmt(AGE_OFF_SPACE_HIST);
        this.filesystemHistory = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSpaceHistSave");
        }
    }

    public void prepFSHistSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepFSHistSave", (String)"");
        }
        this.tableName = "t_stat_fs_hist";
        this.insertStmt = this.prepareStmt(INSERT_FS_HIST);
        this.updateStmt = this.prepareStmt(INCREMENT_FS_ACCUMULATORS);
        this.deleteStmt = this.prepareStmt(AGE_OFF_FS_HIST);
        this.filesystemHistory = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepFSHistSave");
        }
    }

    public void closeHistSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"closeHistSave", (String)"");
        }
        this.closeInsert();
        this.closeUpdate();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeHistSave");
        }
    }

    public void saveHist(CuStatDef cuStatDef, SSummaryHist sSummaryHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveHist", (String)"statDef, hist");
        }
        try {
            if (cuStatDef.sdDailyRetention > 0) {
                sSummaryHist.sumType = 0;
                this.insertHist(sSummaryHist);
                this.dbc.commit();
            }
            if (cuStatDef.sdWeeklyRetention > 0) {
                sSummaryHist.sumType = (byte)3;
                this.updateHist(sSummaryHist);
            }
            if (cuStatDef.sdMonthlyRetention > 0) {
                sSummaryHist.sumType = (byte)4;
                this.updateHist(sSummaryHist);
            }
            this.ageHist(cuStatDef, sSummaryHist);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"saveHist", (Throwable)sQLException);
            }
            MessageLog.logMessage((String)"STS0025E");
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveHist");
        }
    }

    public void insertHist(SSummaryHist sSummaryHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insertHist", (String)"hist");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setTimestamp(this.insertStmt, sSummaryHist.sumScanTime);
            this.setLong(this.insertStmt, sSummaryHist.sumFileCount);
            this.setShort(this.insertStmt, sSummaryHist.sumAccumCount);
            this.setLong(this.insertStmt, sSummaryHist.sumTotalSize);
            if (this.filesystemHistory) {
                this.setLong(this.insertStmt, sSummaryHist.sumFreeSpace);
                this.setLong(this.insertStmt, sSummaryHist.sumUsedSpace);
            }
            this.setIDs(this.insertStmt, sSummaryHist);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insertHist", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertHist");
        }
    }

    private void updateHist(SSummaryHist sSummaryHist) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateHist", (String)"hist");
        }
        this.stmtType = 2;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setLong(this.updateStmt, sSummaryHist.sumFileCount);
        this.setLong(this.updateStmt, sSummaryHist.sumTotalSize);
        if (this.filesystemHistory) {
            this.setLong(this.updateStmt, sSummaryHist.sumFreeSpace);
            this.setLong(this.updateStmt, sSummaryHist.sumUsedSpace);
        }
        this.setIDs(this.updateStmt, sSummaryHist);
        int n = this.executeUpdate(this.updateStmt);
        if (n != 1) {
            sSummaryHist.sumAccumCount = 1;
            this.insertHist(sSummaryHist);
        }
        this.dbc.commit();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateHist");
        }
    }

    private void setIDs(PreparedStatement preparedStatement, SSummaryHist sSummaryHist) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setIDs", (String)"pStmt, hist");
        }
        this.setByte(preparedStatement, sSummaryHist.sumType);
        this.setInt(preparedStatement, sSummaryHist.sumFilesystemID);
        this.setInt(preparedStatement, sSummaryHist.sumStatisticID);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setIDs");
        }
    }

    private void ageHist(CuStatDef cuStatDef, SSummaryHist sSummaryHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"ageHist", (String)"statDef, hist");
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = new Date(sSummaryHist.sumScanTime);
        try {
            if (cuStatDef.sdDailyRetention != 0) {
                sSummaryHist.sumType = 0;
                this.ageOff(gregorianCalendar, date, sSummaryHist, cuStatDef.sdDailyRetention, 5);
            }
            if (cuStatDef.sdWeeklyRetention != 0) {
                sSummaryHist.sumType = 1;
                this.ageOff(gregorianCalendar, date, sSummaryHist, cuStatDef.sdWeeklyRetention * 7, 5);
            }
            if (cuStatDef.sdMonthlyRetention != 0) {
                sSummaryHist.sumType = (byte)2;
                this.ageOff(gregorianCalendar, date, sSummaryHist, cuStatDef.sdMonthlyRetention, 2);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"ageHist", (Throwable)sQLException);
            }
            this.stmtType = 3;
            MessageLog.logMessage((String)"STS0027E");
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ageHist");
        }
    }

    private void ageOff(Calendar calendar, Date date, SSummaryHist sSummaryHist, int n, int n2) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"ageOff", (String)"calendar, scanTime, hist, retention, calendarUnit");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        calendar.setTime(date);
        calendar.add(n2, -n);
        this.setTimestamp(this.deleteStmt, calendar.getTime().getTime());
        this.setIDs(this.deleteStmt, sSummaryHist);
        this.executeUpdate(this.deleteStmt);
        this.dbc.commit();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ageOff");
        }
    }

    public void deleteSpaceHist(Filesystem filesystem) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteSpaceHist", (String)"fsList");
        }
        this.tableName = "t_stat_space_hist";
        this.deleteStats(DELETE_SPACE_HIST_BY_FS, filesystem);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteSpaceHist");
        }
    }

    public void deleteFSHist(Filesystem filesystem) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteFSHist", (String)"fsList");
        }
        this.tableName = "t_stat_fs_hist";
        this.deleteStats(DELETE_FS_HIST_BY_FS, filesystem);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteFSHist");
        }
    }

    public void deleteSpaceHist(CuStatDef cuStatDef) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteSpaceHist", (String)"statList");
        }
        this.tableName = "t_stat_space_hist";
        this.deleteStats(DELETE_SPACE_HIST_BY_STAT, cuStatDef);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteSpaceHist");
        }
    }

    public void prepSpaceAverages() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSpaceAverages", (String)"");
        }
        this.tableName = "t_stat_space_hist";
        this.selectStmt = this.prepareStmt(FETCH_SPACE_ACCUMULATORS);
        this.insertStmt = this.prepareStmt(INSERT_SPACE_HIST);
        this.updateStmt = this.prepareStmt(RESET_SPACE_ACCUMULATORS);
        this.filesystemHistory = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSpaceAverages");
        }
    }

    public void prepFSAverages() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepFSAverages", (String)"");
        }
        this.tableName = "t_stat_fs_hist";
        this.selectStmt = this.prepareStmt(FETCH_FS_ACCUMULATORS);
        this.insertStmt = this.prepareStmt(INSERT_FS_HIST);
        this.updateStmt = this.prepareStmt(RESET_FS_ACCUMULATORS);
        this.filesystemHistory = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepFSAverages");
        }
    }

    public void closeAverages() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"closeAverages", (String)"");
        }
        this.closeSelect();
        this.closeInsert();
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeAverages");
        }
    }

    public void execSelect(SSummaryHist sSummaryHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"execSelect", (String)"hist");
        }
        try {
            this.closeResultSet();
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setByte(this.selectStmt, sSummaryHist.sumType);
            this.setTimestamp(this.selectStmt, sSummaryHist.sumScanTime);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"execSelect", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"execSelect");
        }
    }

    public boolean fetchAccumulator(SSummaryHist sSummaryHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchAccumulator", (String)"hist");
        }
        try {
            boolean bl = this.fetchRow(sSummaryHist);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"fetchAccumulator", (boolean)bl);
            }
            return bl;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"fetchAccumulator", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"fetchAccumulator", (boolean)bl);
            }
            return bl;
        }
    }

    private boolean fetchRow(SSummaryHist sSummaryHist) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchRow", (String)"hist");
        }
        if (!this.nextResult()) {
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"fetchRow", (boolean)bl);
            }
            return bl;
        }
        this.stmtPhase = 1;
        this.colIndex = 1;
        sSummaryHist.sumFilesystemID = this.getInt(this.resultSet);
        sSummaryHist.sumScanTime = this.getTimestamp(this.resultSet);
        sSummaryHist.sumType = this.getByte(this.resultSet);
        sSummaryHist.sumAccumCount = this.getShort(this.resultSet);
        sSummaryHist.sumStatisticID = this.getInt(this.resultSet);
        this.getSpaceUsage(this.resultSet, sSummaryHist);
        boolean bl = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchRow", (boolean)bl);
        }
        return bl;
    }

    private void getSpaceUsage(ResultSet resultSet, SSummaryHist sSummaryHist) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getSpaceUsage", (String)"results, hist");
        }
        sSummaryHist.sumFileCount = this.getLong(resultSet);
        sSummaryHist.sumTotalSize = this.getLong(resultSet);
        if (this.filesystemHistory) {
            sSummaryHist.sumFreeSpace = this.getLong(resultSet);
            sSummaryHist.sumUsedSpace = this.getLong(resultSet);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getSpaceUsage");
        }
    }

    public boolean fetchUnique(SSummaryHist sSummaryHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchUnique", (String)"hist");
        }
        boolean bl = false;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setTimestamp(this.selectUniqueStmt, sSummaryHist.sumScanTime);
            this.setIDs(this.selectUniqueStmt, sSummaryHist);
            this.stmtPhase = 3;
            ResultSet resultSet = this.selectUniqueStmt.executeQuery();
            bl = this.nextResult(resultSet);
            if (bl) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                this.getSpaceUsage(resultSet, sSummaryHist);
            }
            this.closeResultSet(resultSet);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"fetchUnique", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchUnique", (boolean)bl2);
        }
        return bl2;
    }

    public void resetAccumulator(SSummaryHist sSummaryHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"resetAccumulator", (String)"hist");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setTimestamp(this.updateStmt, sSummaryHist.sumScanTime);
            this.setIDs(this.updateStmt, sSummaryHist);
            this.executeUpdate(this.updateStmt);
            this.dbc.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"resetAccumulator", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"resetAccumulator");
        }
    }

    public long getMaxFsHistTime(int n, byte by) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getMaxFsHistTime", (String)"filesystemID, statisticType");
        }
        this.tableName = "t_stat_fs_hist";
        long l = 0L;
        this.selectStmt = this.prepareStmt(FETCH_MAX_FS_TIMESTAMP);
        try {
            this.setPhase();
            this.setInt(this.selectStmt, n);
            this.setByte(this.selectStmt, by);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.getPhase();
            if (this.resultSet.next()) {
                l = this.getTimestamp(this.resultSet);
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getMaxFsHistTime", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        long l2 = l;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getMaxFsHistTime", (long)l2);
        }
        return l2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeSelect() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"closeSelect", (String)"");
        }
        super.closeSelect();
        if (this.selectUniqueStmt != null) {
            try {
                this.closeStmt(this.selectUniqueStmt, STMT_TYPE[0]);
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                this.selectUniqueStmt = null;
                throw throwable;
            }
            {
                Object var1_3 = null;
                this.selectUniqueStmt = null;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatSpaceHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeSelect");
        }
    }
}

