/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.scheduler;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.scheduler.InternalIntervalNode;
import org.eclipse.aperi.scheduler.SchCommon;
import org.eclipse.aperi.scheduler.SchIntervalNode;
import org.eclipse.aperi.scheduler.SchRunNode;
import org.eclipse.aperi.scheduler.SchScheduleNode;
import org.eclipse.aperi.scheduler.ScheduleInterval;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.scheduler.ScheduleRunning;
import org.eclipse.aperi.scheduler.ScheduleSubmitted;
import org.eclipse.aperi.server.RequestManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.svp.SchedulerSvp;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScheduleBuild
extends TSThread {
    private static ScheduleInterval intervalRoutine;
    Connection connection;
    PreparedStatement runNumberStmt;
    PreparedStatement insertStmt;
    PreparedStatement insertJobStmt;
    PreparedStatement updateStmt;
    PreparedStatement deleteRunStmt;
    PreparedStatement deleteJobStmt;
    PreparedStatement selectJobStmt = null;
    ResultSet selectResults;
    PrintWriter logWriter;
    ScheduleRunning runningRoutine;
    ScheduleSubmitted submittedRoutine;
    SchScheduleNode scheduleHdr;
    SchScheduleNode scheduleStack;
    SchRunNode runStack;
    long addMillis;
    long maxMillis;
    long currentMillis;
    int scheduleCount;
    int runCount;
    int CIDindex;
    int TZindex;
    int currentRunNumber = 1;
    int highRunNumber = 0;
    Object[] args = new Object[]{"update", "t_schedule", "ScheduleBuild.run"};
    Object[] args2 = new Object[]{"update", "t_runs", "ScheduleBuild.deleteSchedule"};
    Object[] args3 = new Object[]{"update", "t_runs", "ScheduleBuild.addRestart"};
    Object[] args4 = new Object[4];
    Object[] args5 = new Object[]{"select", "t_run_jobs", "ScheduleBuild.initRestart"};
    Object[] args6 = new Object[]{"select", "t_run_jobs", "ScheduleBuild.finishScheduleNode"};

    public ScheduleBuild(ThreadGroup threadGroup, String string) {
        super(threadGroup, string);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"ScheduleBuild", (String)"group, name");
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ScheduleBuild");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block40: {
            block39: {
                if (TraceLogger.enableTrace) {
                    try {
                        v0 = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                    }
                    catch (ClassNotFoundException v1) {
                        throw new NoClassDefFoundError(v1.getMessage());
                    }
                    TraceLogger.entry((String)v0.getName(), (String)"run", (String)"");
                }
                this.logWriter = MessageLog.getThreadLog();
                MessageLog.setThreadLog((PrintWriter)this.logWriter);
                Server.getServiceManager().awaitInitialization();
                this.connection = Server.getConnection();
                if (this.connection != null) break block39;
                MessageLog.logMessage((String)"JSS0006E", (Object[])this.args);
                SchCommon.stopped = true;
                break block40;
            }
            ScheduleBuild.intervalRoutine = new ScheduleInterval();
            ScheduleBuild.intervalRoutine.init(this);
            if (SchCommon.stopped) break block40;
            this.runningRoutine = SchCommon.runningRoutine;
            this.submittedRoutine = SchCommon.submittedRoutine;
            this.addMillis = SchCommon.millisAdvanced + 50L;
            this.initRestart();
            try {
                this.runNumberStmt = this.connection.prepareStatement("update t_schedule set    high_run_number = ? where  schedule_id = ?");
                this.args[1] = "t_runs";
                this.updateStmt = this.connection.prepareStatement("update t_runs set    successful_jobs = ?, finish_time = ?, status = ? where  schedule_id = ? and run_number = ?");
                this.args[0] = "insert";
                this.insertStmt = this.connection.prepareStatement("insert into   t_runs (time_stamp, schedule_id, run_number, number_jobs) values (?,?,?,?)");
                this.args[1] = "t_run_jobs";
                this.insertJobStmt = this.connection.prepareStatement("insert into t_run_jobs (time_stamp, schedule_id, sid_run_number, computer_id, job_run_number, submit_status, submit_millis) values (?,?,?,?,?,-2,?)");
                this.args[0] = "delete";
                this.args[1] = "t_runs";
                this.deleteRunStmt = this.connection.prepareStatement("delete from   t_runs where  schedule_id = ? and run_number < ?");
                this.args[1] = "t_run_jobs";
                this.deleteJobStmt = this.connection.prepareStatement("delete from   t_run_jobs where  schedule_id = ? and sid_run_number < ?");
            }
            catch (SQLException var2_1) {
                if (TraceLogger.enableTrace) {
                    try {
                        v2 = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                    }
                    catch (ClassNotFoundException v3) {
                        throw new NoClassDefFoundError(v3.getMessage());
                    }
                    TraceLogger.exception((String)v2.getName(), (String)"run", (Throwable)var2_1);
                }
                var3_7 = SQLUtil.getSQLExceptionMsg("JSS0007E", var2_1, this.args);
                this.logWriter.println(var3_7);
                SchCommon.stopped = true;
            }
            this.args[1] = "t_schedule";
            this.args[2] = "ScheduleBuild.insertRows";
            SchedulerSvp.requestManagerRoutine = new RequestManager("org.eclipse.aperi.server.data.schedulerHandler", SchedulerSvp.serviceQueue, SchedulerSvp.threadGroup, "SchedulerJobCompletion", 5, SchCommon.completeThreads / 2, SchCommon.completeThreads, 15);
            if (!SchedulerSvp.requestManagerRoutine.initialize()) {
                SchCommon.stopped = true;
            }
            SchCommon.autoRestart = false;
            if (!SchCommon.stopped || SchCommon.shutDown) ** GOTO lbl115
            if (TraceLogger.enableTrace) {
                try {
                    v4 = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                }
                catch (ClassNotFoundException v5) {
                    throw new NoClassDefFoundError(v5.getMessage());
                }
                TraceLogger.exit((String)v4.getName(), (String)"run");
            }
            throw new RuntimeException(MessageLog.getMessage((String)"JSS0002E", null));
lbl-1000:
            // 1 sources

            {
                try {
                    this.maxMillis = SQLUtil.getTimestamp(this.connection).getTime() + this.addMillis;
                }
                catch (Exception var2_2) {
                    var2_2.printStackTrace();
                    if (TraceLogger.enableTrace) {
                        try {
                            v6 = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                        }
                        catch (ClassNotFoundException v7) {
                            throw new NoClassDefFoundError(v7.getMessage());
                        }
                        TraceLogger.exception((String)v6.getName(), (String)"run", (Throwable)var2_2);
                    }
                    return;
                }
                var1_8 = ScheduleBuild.intervalRoutine.getNext(this.maxMillis);
                while (var1_8 == null && !SchCommon.stopped) {
                    block38: {
                        try {
                            ScheduleBuild.sleep((long)1000L);
                        }
                        catch (InterruptedException var2_4) {
                            if (!TraceLogger.enableTrace) break block38;
                            try {
                                v8 = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                            }
                            catch (ClassNotFoundException v9) {
                                throw new NoClassDefFoundError(v9.getMessage());
                            }
                            TraceLogger.exception((String)v8.getName(), (String)"run", (Throwable)var2_4);
                        }
                    }
                    try {
                        this.maxMillis = SQLUtil.getTimestamp(this.connection).getTime() + this.addMillis;
                    }
                    catch (Exception var2_5) {
                        var2_5.printStackTrace();
                        if (TraceLogger.enableTrace) {
                            try {
                                v10 = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                            }
                            catch (ClassNotFoundException v11) {
                                throw new NoClassDefFoundError(v11.getMessage());
                            }
                            TraceLogger.exception((String)v10.getName(), (String)"run", (Throwable)var2_5);
                        }
                        return;
                    }
                    var1_8 = ScheduleBuild.intervalRoutine.getNext(this.maxMillis);
                }
                if (SchCommon.stopped) continue;
                var2_6 = ScheduleQueue.isInternal(var1_8.SID) != false ? true : this.insertRows(var1_8);
                if (var2_6) {
                    this.submit(var1_8);
                    continue;
                }
                this.args4[0] = Integer.toString(var1_8.runNumber);
                this.args4[1] = ResourceTypeManager.getJobName((short)var1_8.jobType);
                this.args4[2] = String.valueOf(var1_8.creator) + "." + var1_8.getName();
                MessageLog.logMessage((String)"JSS0014E", (Object[])this.args4);
lbl115:
                // 4 sources

                ** while (!SchCommon.stopped)
            }
        }
        if (SchCommon.bounceNeeded) {
            SchedulerSvp.bounce();
        } else {
            if (!SchCommon.shutDown) {
                if (TraceLogger.enableTrace) {
                    try {
                        v12 = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                    }
                    catch (ClassNotFoundException v13) {
                        throw new NoClassDefFoundError(v13.getMessage());
                    }
                    TraceLogger.exit((String)v12.getName(), (String)"run");
                }
                throw new RuntimeException(MessageLog.getMessageNoTS((String)"JSS0078E"));
            }
            this.close();
        }
        if (TraceLogger.enableTrace) {
            try {
                v14 = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException v15) {
                throw new NoClassDefFoundError(v15.getMessage());
            }
            TraceLogger.exit((String)v14.getName(), (String)"run");
        }
    }

    public synchronized SchScheduleNode addSchedule(SchIntervalNode schIntervalNode) {
        Object object;
        SchScheduleNode schScheduleNode;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addSchedule", (String)"interval");
        }
        ++schIntervalNode.highRunNumber;
        if (this.scheduleStack == null) {
            schScheduleNode = new SchScheduleNode();
        } else {
            schScheduleNode = this.scheduleStack;
            this.scheduleStack = this.scheduleStack.next;
            --this.scheduleCount;
        }
        if (this.scheduleHdr != null) {
            this.scheduleHdr.prev = schScheduleNode;
        }
        schScheduleNode.next = this.scheduleHdr;
        this.scheduleHdr = schScheduleNode;
        schScheduleNode.pingList = schIntervalNode.pingList;
        schScheduleNode.SID = schIntervalNode.SID;
        schScheduleNode.creator = schIntervalNode.creator;
        schScheduleNode.setName(schIntervalNode.getTrueName());
        schScheduleNode.jobType = schIntervalNode.jobType;
        schScheduleNode.arguments = schIntervalNode.arguments;
        schScheduleNode.alertID = schIntervalNode.alertID;
        schScheduleNode.scriptName = schIntervalNode.scriptName;
        schScheduleNode.runNumber = schIntervalNode.highRunNumber;
        schScheduleNode.jobData = schIntervalNode.jobData;
        schScheduleNode.alertLogID = schIntervalNode.alertLogID;
        if (schIntervalNode instanceof InternalIntervalNode) {
            object = (InternalIntervalNode)schIntervalNode;
            schScheduleNode.request = ((InternalIntervalNode)object).request;
        }
        this.CIDindex = 0;
        while (this.CIDindex < schIntervalNode.CIDarray.length) {
            SchRunNode schRunNode;
            if (this.runStack == null) {
                schRunNode = new SchRunNode();
            } else {
                schRunNode = this.runStack;
                this.runStack = this.runStack.next;
                --this.runCount;
            }
            schRunNode.next = schScheduleNode.runHdr;
            schScheduleNode.runHdr = schRunNode;
            schRunNode.back = schScheduleNode;
            schRunNode.CID = schIntervalNode.CIDarray[this.CIDindex];
            schRunNode.globalJob = schIntervalNode.timezoneType == 2;
            if (schIntervalNode.runNow) {
                schRunNode.submitMillis = 0L;
            } else if (schIntervalNode.TZarray == null) {
                schRunNode.submitMillis = schIntervalNode.submitMillis;
            } else {
                this.TZindex = schIntervalNode.CIDTZarray[this.CIDindex];
                schRunNode.submitMillis = schIntervalNode.submitMillisArray[this.TZindex];
            }
            ++schScheduleNode.numberRuns;
            ++this.CIDindex;
        }
        object = schScheduleNode;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addSchedule", (Object)object);
        }
        return object;
    }

    public void initRestart() {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"initRestart", (Throwable)sQLException);
            }
            if (SchedulerSvp.connectBad(this.connection)) {
                SchCommon.stopped = true;
                SchCommon.bounceNeeded = true;
            }
            String string = SQLUtil.getSQLExceptionMsg("JSS0019E", sQLException, this.args5);
            this.logWriter.println(string);
            return;
        }
        try {
            String string = "select computer_id, job_run_number, submit_millis,       schedule_id, sid_run_number from  t_run_jobs where submit_status  = -2 order by schedule_id, sid_run_number";
            int n = -777;
            int n2 = -777;
            SchScheduleNode schScheduleNode = new SchScheduleNode();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                SchRunNode schRunNode = new SchRunNode();
                schRunNode.CID = resultSet.getInt(1);
                schRunNode.runNumber = resultSet.getInt(2);
                schRunNode.submitMillis = resultSet.getLong(3);
                schRunNode.rowInserted = true;
                schRunNode.logFileName = " ";
                int n3 = resultSet.getInt(4);
                int n4 = resultSet.getInt(5);
                if (n3 != n || n4 != n2) {
                    n = n3;
                    n2 = n4;
                    this.finishScheduleNode(schScheduleNode);
                    schScheduleNode = this.getScheduleNode(n3, n4);
                }
                if (schScheduleNode == null) continue;
                schRunNode.next = schScheduleNode.runHdr;
                schScheduleNode.runHdr = schRunNode;
                schRunNode.back = schScheduleNode;
            }
            this.finishScheduleNode(schScheduleNode);
            schScheduleNode = this.scheduleHdr;
            while (schScheduleNode != null) {
                this.submit(schScheduleNode);
                schScheduleNode = schScheduleNode.next;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"initRestart", (Throwable)sQLException);
            }
            if (SchedulerSvp.connectBad(this.connection)) {
                SchCommon.stopped = true;
                SchCommon.bounceNeeded = true;
            }
            String string = SQLUtil.getSQLExceptionMsg("JSS0010E", sQLException, this.args5);
            this.logWriter.println(string);
            return;
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {}
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {}
        try {
            if (this.selectResults != null) {
                this.selectResults.close();
            }
        }
        catch (SQLException sQLException) {}
        try {
            if (this.selectJobStmt != null) {
                this.selectJobStmt.close();
            }
        }
        catch (SQLException sQLException) {}
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initRestart");
        }
    }

    private void finishScheduleNode(SchScheduleNode schScheduleNode) {
        if (schScheduleNode != null) {
            try {
                this.selectJobStmt = this.connection.prepareStatement("select return_code from  t_run_jobs where schedule_id = ? and   sid_run_number = ? and   submit_status <> -2");
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"finishScheduleNode", (Throwable)sQLException);
                }
                if (SchedulerSvp.connectBad(this.connection)) {
                    SchCommon.stopped = true;
                    SchCommon.bounceNeeded = true;
                }
                String string = SQLUtil.getSQLExceptionMsg("JSS0007E", sQLException, this.args6);
                this.logWriter.println(string);
                return;
            }
            try {
                this.selectJobStmt.setInt(1, schScheduleNode.SID);
                this.selectJobStmt.setInt(2, schScheduleNode.runNumber);
                this.selectResults = this.selectJobStmt.executeQuery();
                while (this.selectResults.next()) {
                    int n = this.selectResults.getInt(1);
                    if (n <= 4) {
                        ++schScheduleNode.successfulRuns;
                        if (n != 0) {
                            schScheduleNode.anyWarnings = true;
                        }
                    }
                    ++schScheduleNode.completedRuns;
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"finishScheduleNode", (Throwable)sQLException);
                }
                if (SchedulerSvp.connectBad(this.connection)) {
                    SchCommon.stopped = true;
                    SchCommon.bounceNeeded = true;
                }
                String string = SQLUtil.getSQLExceptionMsg("JSS0010E", sQLException, this.args6);
                this.logWriter.println(string);
                return;
            }
            int n = 0;
            SchRunNode schRunNode = schScheduleNode.runHdr;
            while (schRunNode != null) {
                ++n;
                schRunNode = schRunNode.next;
            }
            schScheduleNode.numberRuns = schScheduleNode.completedRuns + n;
        }
    }

    public static SchIntervalNode getSchInterval(int n) {
        return intervalRoutine.getIntervalNode(n);
    }

    private SchScheduleNode getScheduleNode(int n, int n2) {
        SchScheduleNode schScheduleNode;
        SchIntervalNode schIntervalNode = intervalRoutine.getIntervalNode(n);
        if (schIntervalNode == null) {
            schScheduleNode = null;
            MessageLog.logMessage((String)"JSS0020E", (Object)Integer.toString(n));
        } else {
            schScheduleNode = new SchScheduleNode();
            if (this.scheduleHdr != null) {
                this.scheduleHdr.prev = schScheduleNode;
            }
            schScheduleNode.next = this.scheduleHdr;
            this.scheduleHdr = schScheduleNode;
            schScheduleNode.pingList = schIntervalNode.pingList;
            schScheduleNode.SID = schIntervalNode.SID;
            schScheduleNode.creator = schIntervalNode.creator;
            schScheduleNode.setName(schIntervalNode.getTrueName());
            schScheduleNode.arguments = schIntervalNode.arguments;
            schScheduleNode.jobData = schIntervalNode.jobData;
            schScheduleNode.jobType = schIntervalNode.jobType;
            schScheduleNode.alertID = schIntervalNode.alertID;
            schScheduleNode.alertLogID = schIntervalNode.alertLogID;
            schScheduleNode.scriptName = schIntervalNode.scriptName;
            schScheduleNode.runNumber = n2;
            if (schIntervalNode instanceof InternalIntervalNode) {
                InternalIntervalNode internalIntervalNode = (InternalIntervalNode)schIntervalNode;
                schScheduleNode.request = internalIntervalNode.request;
            }
        }
        return schScheduleNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRestart(int n) {
        SchScheduleNode schScheduleNode;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addRestart", (String)"runNumber");
        }
        ResultSet resultSet = null;
        Statement statement = null;
        boolean bl = true;
        ScheduleBuild scheduleBuild = this;
        synchronized (scheduleBuild) {
            block55: {
                block54: {
                    String string;
                    String string2;
                    SchRunNode schRunNode = this.runningRoutine.getRun(n);
                    if (schRunNode != null) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz.getName(), (String)"addRestart");
                        }
                        return;
                    }
                    if (this.scheduleStack == null) {
                        schScheduleNode = new SchScheduleNode();
                    } else {
                        schScheduleNode = this.scheduleStack;
                        this.scheduleStack = this.scheduleStack.next;
                        --this.scheduleCount;
                    }
                    if (this.scheduleHdr != null) {
                        this.scheduleHdr.prev = schScheduleNode;
                    }
                    schScheduleNode.next = this.scheduleHdr;
                    this.scheduleHdr = schScheduleNode;
                    try {
                        statement = this.connection.createStatement();
                    }
                    catch (SQLException sQLException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"addRestart", (Throwable)sQLException);
                        }
                        if (SchedulerSvp.connectBad(this.connection)) {
                            SchCommon.stopped = true;
                            SchCommon.bounceNeeded = true;
                        }
                        string2 = SQLUtil.getSQLExceptionMsg("JSS0019E", sQLException, this.args3);
                        this.logWriter.println(string2);
                        bl = false;
                    }
                    if (bl) {
                        this.args3[1] = "t_run_jobs";
                        try {
                            string = "select a.schedule_id, a.sid_run_number, a.computer_id,                                     a.job_run_number, a.submit_status, a.return_code                             from   t_run_jobs a, t_run_jobs b                                                   where (b.job_run_number = " + Integer.toString(n) + ") and                        (a.schedule_id    = b.schedule_id) and                                              (a.sid_run_number = b.sid_run_number)";
                            resultSet = statement.executeQuery(string);
                            while (resultSet.next()) {
                                schScheduleNode.SID = resultSet.getInt(1);
                                schScheduleNode.runNumber = resultSet.getInt(2);
                                if (this.runStack == null) {
                                    schRunNode = new SchRunNode();
                                } else {
                                    schRunNode = this.runStack;
                                    this.runStack = this.runStack.next;
                                    --this.runCount;
                                }
                                schRunNode.next = schScheduleNode.runHdr;
                                schScheduleNode.runHdr = schRunNode;
                                schRunNode.back = schScheduleNode;
                                schRunNode.CID = resultSet.getInt(3);
                                schRunNode.runNumber = resultSet.getInt(4);
                                int n2 = resultSet.getInt(5);
                                schRunNode.returnCode = resultSet.getInt(6);
                                schRunNode.rowInserted = true;
                                ++schScheduleNode.numberRuns;
                                if (n2 == -1) {
                                    SchCommon.runningRoutine.addRun(schRunNode);
                                    continue;
                                }
                                ++schScheduleNode.completedRuns;
                                if (schRunNode.returnCode > 4) continue;
                                ++schScheduleNode.successfulRuns;
                            }
                        }
                        catch (SQLException sQLException) {
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.exception((String)clazz.getName(), (String)"addRestart", (Throwable)sQLException);
                            }
                            if (SchedulerSvp.connectBad(this.connection)) {
                                SchCommon.stopped = true;
                                SchCommon.bounceNeeded = true;
                            }
                            string2 = SQLUtil.getSQLExceptionMsg("JSS0010E", sQLException, this.args3);
                            this.logWriter.println(string2);
                            bl = false;
                        }
                    }
                    if (bl) {
                        this.args3[1] = "t_runs";
                        try {
                            int n3;
                            string = "select number_jobs                                                                  from   t_runs                                                                       where  schedule_id = " + Integer.toString(schScheduleNode.SID);
                            resultSet = statement.executeQuery(string);
                            if (resultSet.next() && (n3 = resultSet.getInt(1)) != schScheduleNode.numberRuns) {
                                schScheduleNode.completedRuns += n3 - schScheduleNode.numberRuns;
                                schScheduleNode.numberRuns = n3;
                            }
                        }
                        catch (SQLException sQLException) {
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.exception((String)clazz.getName(), (String)"addRestart", (Throwable)sQLException);
                            }
                            if (SchedulerSvp.connectBad(this.connection)) {
                                SchCommon.stopped = true;
                                SchCommon.bounceNeeded = true;
                            }
                            string2 = SQLUtil.getSQLExceptionMsg("JSS0010E", sQLException, this.args3);
                            this.logWriter.println(string2);
                        }
                    }
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        Class<?> clazz;
                        if (!TraceLogger.enableTrace) break block54;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"addRestart", (Throwable)sQLException);
                    }
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block55;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"addRestart", (Throwable)sQLException);
                }
            }
        }
        if (bl) {
            SchIntervalNode schIntervalNode = SchCommon.intervalRoutine.getIntervalNode(schScheduleNode.SID);
            if (schIntervalNode == null) {
                MessageLog.logMessage((String)"JSS0020E", (Object)Integer.toString(schScheduleNode.SID));
            } else {
                schScheduleNode.creator = schIntervalNode.creator;
                schScheduleNode.setName(schIntervalNode.getTrueName());
                schScheduleNode.jobType = schIntervalNode.jobType;
                schScheduleNode.alertID = schIntervalNode.alertID;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addRestart");
        }
    }

    private boolean insertRows(SchScheduleNode schScheduleNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insertRows", (String)"schedulePtr");
        }
        boolean bl = true;
        this.args[1] = "t_schedule";
        try {
            this.runNumberStmt.setInt(1, schScheduleNode.runNumber);
            this.runNumberStmt.setInt(2, schScheduleNode.SID);
            this.runNumberStmt.executeUpdate();
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insertRows", (Throwable)sQLException);
            }
            if (SchedulerSvp.connectBad(this.connection)) {
                SchCommon.stopped = true;
                SchCommon.bounceNeeded = true;
            }
            String string = SQLUtil.getSQLExceptionMsg("JSS0009E", sQLException, this.args);
            this.logWriter.println(string);
            bl = false;
        }
        if (bl) {
            String string;
            this.args[1] = "t_runs";
            SchRunNode schRunNode = schScheduleNode.runHdr;
            while (schRunNode != null) {
                if (this.currentRunNumber > this.highRunNumber) {
                    try {
                        this.currentRunNumber = SQLUtil.getIdentifier(2, SchCommon.IDsToGet, this.connection);
                    }
                    catch (SQLException sQLException) {
                        if (SchedulerSvp.connectBad(this.connection)) {
                            SchCommon.bounceNeeded = true;
                        }
                        MessageLog.logMessage((String)"JSS0023E", (Object)"ScheduleBuild.insertRows");
                        SchCommon.stopped = true;
                        this.currentRunNumber = -2;
                    }
                    this.highRunNumber = this.currentRunNumber + SchCommon.IDsToGet - 1;
                }
                ++this.currentRunNumber;
                schRunNode.runNumber = schRunNode.runNumber;
                try {
                    this.insertJobStmt.setLong(1, SQLUtil.getTimestamp(this.connection).getTime());
                    this.insertJobStmt.setInt(2, schScheduleNode.SID);
                    this.insertJobStmt.setInt(3, schScheduleNode.runNumber);
                    this.insertJobStmt.setInt(4, schRunNode.CID);
                    this.insertJobStmt.setInt(5, schRunNode.runNumber);
                    this.insertJobStmt.setLong(6, schRunNode.submitMillis);
                    this.insertJobStmt.executeUpdate();
                    schRunNode.rowInserted = true;
                }
                catch (SQLException sQLException) {
                    if (SchedulerSvp.connectBad(this.connection)) {
                        SchCommon.stopped = true;
                        SchCommon.bounceNeeded = true;
                    }
                    string = SQLUtil.getSQLExceptionMsg("JSS0008E", sQLException, this.args);
                    this.logWriter.println(string);
                    bl = false;
                }
                schRunNode = schRunNode.next;
            }
            if (bl) {
                this.args[1] = "t_runs";
                try {
                    this.currentMillis = SQLUtil.getTimestamp(this.connection).getTime();
                    this.insertStmt.setLong(1, this.currentMillis);
                    this.insertStmt.setInt(2, schScheduleNode.SID);
                    this.insertStmt.setInt(3, schScheduleNode.runNumber);
                    this.insertStmt.setInt(4, schScheduleNode.numberRuns);
                    this.insertStmt.executeUpdate();
                    this.connection.commit();
                }
                catch (SQLException sQLException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"insertRows", (Throwable)sQLException);
                    }
                    if (SchedulerSvp.connectBad(this.connection)) {
                        SchCommon.stopped = true;
                        SchCommon.bounceNeeded = true;
                    }
                    string = SQLUtil.getSQLExceptionMsg("JSS0008E", sQLException, this.args);
                    this.logWriter.println(string);
                    bl = false;
                }
            }
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertRows", (boolean)bl2);
        }
        return bl2;
    }

    private void submit(SchScheduleNode schScheduleNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"submit", (String)"schedulePtr");
        }
        SchRunNode schRunNode = null;
        SchRunNode schRunNode2 = schScheduleNode.runHdr;
        while (schRunNode2 != null) {
            schRunNode2.submitNext = schRunNode2.next;
            schRunNode2.submitPrev = schRunNode;
            schRunNode = schRunNode2;
            schRunNode2 = schRunNode2.next;
        }
        this.submittedRoutine.addRunNodes(schScheduleNode.runHdr);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"submit");
        }
    }

    public synchronized void deleteSchedule(SchScheduleNode schScheduleNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteSchedule", (String)"schedulePtr");
        }
        if (!ScheduleQueue.isInternal(schScheduleNode.SID)) {
            String string;
            try {
                this.updateStmt.setInt(1, schScheduleNode.successfulRuns);
                this.updateStmt.setLong(2, SQLUtil.getTimestamp(this.connection).getTime());
                SQLUtil.setByte(this.updateStmt, 3, (byte)schScheduleNode.state);
                this.updateStmt.setInt(4, schScheduleNode.SID);
                this.updateStmt.setInt(5, schScheduleNode.runNumber);
                this.updateStmt.executeUpdate();
                this.connection.commit();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"deleteSchedule", (Throwable)sQLException);
                }
                if (SchedulerSvp.connectBad(this.connection)) {
                    SchCommon.stopped = true;
                    SchCommon.bounceNeeded = true;
                }
                String string2 = SQLUtil.getSQLExceptionMsg("JSS0009E", sQLException, this.args2);
                this.logWriter.println(string2);
                this.args4[0] = Integer.toString(schScheduleNode.runNumber);
                this.args4[1] = ResourceTypeManager.getJobName((short)schScheduleNode.jobType);
                this.args4[2] = String.valueOf(schScheduleNode.creator) + "." + schScheduleNode.getName();
                switch (schScheduleNode.state) {
                    case 1: {
                        string = "JSS0016L";
                        break;
                    }
                    case 3: {
                        string = "JSS2000L";
                        break;
                    }
                    default: {
                        string = "JSS0017L";
                    }
                }
                this.args4[3] = MessageLog.getMessageNoID((String)string, null);
                MessageLog.logMessage((String)"JSS0015E", (Object[])this.args4);
            }
            int n = Server.getSettings().csRetainCopies;
            int n2 = schScheduleNode.runNumber - n + 1;
            try {
                this.deleteRunStmt.setInt(1, schScheduleNode.SID);
                this.deleteRunStmt.setInt(2, n2);
                this.deleteRunStmt.executeUpdate();
                this.connection.commit();
                this.deleteJobStmt.setInt(1, schScheduleNode.SID);
                this.deleteJobStmt.setInt(2, n2);
                this.deleteJobStmt.executeUpdate();
                this.connection.commit();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"deleteSchedule", (Throwable)sQLException);
                }
                if (SchedulerSvp.connectBad(this.connection)) {
                    SchCommon.stopped = true;
                    SchCommon.bounceNeeded = true;
                }
                this.args4[1] = ResourceTypeManager.getJobName((short)schScheduleNode.jobType);
                this.args4[2] = String.valueOf(schScheduleNode.creator) + "." + schScheduleNode.getName();
                string = SQLUtil.getSQLExceptionMsg("JSS0027E", sQLException, this.args4);
                this.logWriter.println(string);
            }
        }
        SchRunNode schRunNode = schScheduleNode.runHdr;
        while (schRunNode != null) {
            SchRunNode schRunNode2 = schRunNode.next;
            schRunNode.clear();
            if (this.runCount < 300) {
                schRunNode.next = this.runStack;
                this.runStack = schRunNode;
                ++this.runCount;
            }
            schRunNode = schRunNode2;
        }
        SchScheduleNode schScheduleNode2 = schScheduleNode.prev;
        SchScheduleNode schScheduleNode3 = schScheduleNode.next;
        if (schScheduleNode2 == null) {
            this.scheduleHdr = schScheduleNode3;
        } else {
            schScheduleNode2.next = schScheduleNode3;
        }
        if (schScheduleNode3 != null) {
            schScheduleNode3.prev = schScheduleNode2;
        }
        schScheduleNode.clear();
        if (this.scheduleCount < 30) {
            schScheduleNode.next = this.scheduleStack;
            this.scheduleStack = schScheduleNode;
            ++this.scheduleCount;
        }
        schScheduleNode = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteSchedule");
        }
    }

    public synchronized void displaySchedules() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"displaySchedules", (String)"");
        }
        SchScheduleNode schScheduleNode = this.scheduleHdr;
        while (schScheduleNode != null) {
            String string = "schedule " + schScheduleNode.getName();
            MessageLog.logMessage((String)"JSS0018E", (Object)string);
            schScheduleNode = schScheduleNode.next;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"displaySchedules");
        }
    }

    private void close() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"close", (String)"");
        }
        if (this.runNumberStmt != null) {
            block27: {
                try {
                    this.runNumberStmt.close();
                }
                catch (SQLException sQLException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block27;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"close", (Throwable)sQLException);
                }
            }
            this.runNumberStmt = null;
        }
        if (this.insertStmt != null) {
            block28: {
                try {
                    this.insertStmt.close();
                }
                catch (SQLException sQLException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block28;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"close", (Throwable)sQLException);
                }
            }
            this.insertStmt = null;
        }
        if (this.insertJobStmt != null) {
            block29: {
                try {
                    this.insertJobStmt.close();
                }
                catch (SQLException sQLException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block29;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"close", (Throwable)sQLException);
                }
            }
            this.insertJobStmt = null;
        }
        if (this.updateStmt != null) {
            block30: {
                try {
                    this.updateStmt.close();
                }
                catch (SQLException sQLException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block30;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"close", (Throwable)sQLException);
                }
            }
            this.updateStmt = null;
        }
        if (this.connection != null) {
            Server.returnConnection(this.connection);
            this.connection = null;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"close");
        }
    }

    public void finalize() throws Throwable {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"finalize", (String)"");
        }
        this.close();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleBuild");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"finalize");
        }
    }
}

